#include <config.h>
#include <stdio.h>
#include <math.h>
#include <limits.h>
#include <mjpeg_types.h>

#include "global.h"
#include "fastintfns.h"


static int scale_quant( pict_data_s *picture, double quant )
{
	int iquant;
	
	if ( picture->q_scale_type  )
	{
		iquant = (int) floor(quant+0.5);
		/* clip mquant to legal (linear) range */
		if (iquant<1) iquant = 1;
		if (iquant>112) iquant = 112;
		iquant = non_linear_mquant_table[map_non_linear_mquant[iquant]];
	}
	else
	{
		/* clip mquant to legal (linear) range */
		iquant = (int)floor(quant+0.5);
		if (iquant<2) iquant = 2;
		if (iquant>62) iquant = 62;
		iquant = (iquant/2)*2; // Must be *even*
	}
	return iquant;
}

static double prev_stress_factor = 0.0;

#include <assert.h>
int rc_calc_mquant( pict_data_s *picture)
{
	long long bytediff;
	long long threshold;
	double stress_factor, curQuant = 1;
	long long greedyFactor, greedyFactor2;
	long long inbytecnt, outbytecnt;
	int mquant = 0;
	
	
	switch(picture->pict_type)
	{
		case I_TYPE: curQuant = lastIquant; break;
		case P_TYPE: curQuant = lastPquant; break;
		case B_TYPE: curQuant = lastBquant; break;
	}
	
	//curQuant = picture->quantiser;
	
	// ------------------- stress_factor update ------------------
	inbytecnt = picture->bitcount >> 3;
	outbytecnt = bitcount() >> 3;
	
	greedyFactor = origm2vsize / 100;
	greedyFactor2 = origm2vsize / 50;
	
	bytediff = outbytecnt - (inbytecnt / opt_fact_x);
			
	if (inbytecnt < greedyFactor2) threshold = inbytecnt >> 1;
	else if (origm2vsize - inbytecnt < greedyFactor2) threshold = (origm2vsize - inbytecnt) >> 1;
	else threshold = greedyFactor;

	if (threshold < 1024) threshold = 1024;
	
	stress_factor = (float)(bytediff + (threshold >> 1)) / (float)(threshold << 1);
	if (stress_factor > 1.0f)		stress_factor = 1.0f;
	else if (stress_factor < 0.0f)	stress_factor = 0.0f;
	// ------------------- stress_factor update ------------------
	

	// ------------------- ctl_quant update ------------------
	ctl_quant += (stress_factor - 0.5) / 100.0;
	ctl_quant += (stress_factor - prev_stress_factor) * 10.0;
	
	if (ctl_quant < 0.1) ctl_quant = 0.1;
	else if (ctl_quant > 10.0) ctl_quant = 10.0;
	
	prev_stress_factor = stress_factor;
	// ------------------- ctl_quant update ------------------
	
	
	mquant = scale_quant(picture, curQuant * (ctl_quant + 40.0*stress_factor) / 3.0);
	
	/*fprintf(stderr, "orig_quant: %7.3f "
					"ctl_quant: %7.3f "
					"20*stress_factor: %7.3f "
					"fact: %7.3f "
					"threshold: %7.3f "
					"stress_factor: %7.3f "
					"bytediff: %7.3f "
					"trying_quant: %3d\n",
					picture->quantiser,
					ctl_quant,
					20.0*stress_factor,
					(ctl_quant + 40*stress_factor) / 3.0,
					(float)threshold,
					stress_factor,
					(float)bytediff,
					mquant);*/
	
	return mquant;
}



