/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.memory.lru;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.memory.AbstractMemoryCache;
import org.apache.commons.jcs3.engine.memory.lru.LRUMemoryCache;
import org.apache.commons.jcs3.engine.memory.util.MemoryElementDescriptor;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class LHMLRUMemoryCache<K, V>
extends AbstractMemoryCache<K, V> {
    private static final Log log = LogManager.getLog(LRUMemoryCache.class);

    @Override
    public void initialize(CompositeCache<K, V> hub) {
        super.initialize(hub);
        log.info("initialized LHMLRUMemoryCache for {0}", this::getCacheName);
    }

    @Override
    public Map<K, MemoryElementDescriptor<K, V>> createMap() {
        return Collections.synchronizedMap(new LHMSpooler());
    }

    @Override
    public void update(ICacheElement<K, V> ce) throws IOException {
        this.putCnt.incrementAndGet();
        this.map.put(ce.getKey(), new MemoryElementDescriptor<K, V>(ce));
    }

    @Override
    protected void lockedGetElement(MemoryElementDescriptor<K, V> me) {
    }

    @Override
    protected void lockedRemoveElement(MemoryElementDescriptor<K, V> me) {
    }

    @Override
    protected void lockedRemoveAll() {
    }

    @Override
    public IStats getStatistics() {
        IStats stats = super.getStatistics();
        stats.setTypeName("LHMLRU Memory Cache");
        return stats;
    }

    public void dumpCacheEntries() {
        this.dumpMap();
    }

    @Override
    public int freeElements(int numberToFree) throws IOException {
        return 0;
    }

    protected class LHMSpooler
    extends LinkedHashMap<K, MemoryElementDescriptor<K, V>> {
        private static final long serialVersionUID = -1255907868906762484L;

        public LHMSpooler() {
            super((int)((double)LHMLRUMemoryCache.this.getCacheAttributes().getMaxObjects() * 0.5), 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, MemoryElementDescriptor<K, V>> eldest) {
            ICacheElement element = eldest.getValue().getCacheElement();
            if (this.size() <= LHMLRUMemoryCache.this.getCacheAttributes().getMaxObjects()) {
                return false;
            }
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> LHMLRUMemoryCache.this.getCacheAttributes().getMaxObjects();
            supplierArray[1] = element::getKey;
            log.debug("LHMLRU max size: {0}. Spooling element, key: {1}", supplierArray);
            LHMLRUMemoryCache.this.waterfal(element);
            log.debug("LHMLRU size: {0}", () -> LHMLRUMemoryCache.this.map.size());
            return true;
        }
    }
}

