RCS_ID("$Id: FFInfoPanel.m 555 2006-08-20 14:11:18Z ravemax $")

#import "FFInfoPanel.h"
#import "FFApplication.h"

@implementation FFLevelWindow

- (void)setLevel:(int)newLevel {
	// runModalForWindow always sets the level to NSModalPanelWindowLevel
	// but this means that the window doesn't show up in fullscreen mode.
	// So we just ignore it.
}

- (void)realSetLevel:(int)newLevel {
	[super setLevel:newLevel];
}

@end

@implementation FFInfoPanel

static FFInfoPanel* panelInstance = nil;

- (id)init {
	self = [super init];
	if (self)
		[NSBundle loadNibNamed:@"InfoPanel" owner:self];
	return self;
}

+ (FFInfoPanel*)instance {
	if (panelInstance == nil)
		panelInstance = [[FFInfoPanel alloc] init];
	
	return panelInstance;
}


- (void)_stopAndHideWithCode:(int)code {
	[m_win orderOut:self];	
	[NSApp stopModalWithCode:code];
	[NSApp setForwardAll:FALSE];
}

- (IBAction)okClicked:(id)sender {
	[self _stopAndHideWithCode:NSOKButton];
}

- (IBAction)cancelClicked:(id)sender {
	[self _stopAndHideWithCode:NSCancelButton];
}

- (NSString*)_inputValue {
	return [m_inputField stringValue];
}

- (int)_runInFullscreen:(BOOL)fullscreen
			  withTitle:(NSString*)title message:(NSString*)msg
			  showInput:(BOOL)showInput
			   okButton:(NSString*)okBtn andCancelButton:(NSString*)cancelBtn {

	
	[NSApp setForwardAll:TRUE];
	
	// Textfields
	[m_title setStringValue:title];
	[m_message setStringValue:msg];

	if (showInput) {
		[m_inputField setHidden:FALSE];
		[m_inputField setStringValue:@""];
		[m_win setInitialFirstResponder:m_inputField];
	} else {
		[m_inputField setHidden:TRUE];
		[m_win setInitialFirstResponder:m_okBtn];		
	}
	// Buttons
	[m_okBtn setTitle:okBtn];
	if (cancelBtn == nil)
		[m_cancelBtn setHidden:TRUE];
	else {
		[m_cancelBtn setHidden:FALSE];
		[m_cancelBtn setTitle:cancelBtn];
	}
	
	// The window
	if (fullscreen) {
		[m_win realSetLevel:(NSScreenSaverWindowLevel-1)];
		[m_win setAlphaValue:0.9f];
		[m_win setOpaque:FALSE];
	} else {
		[m_win realSetLevel:NSModalPanelWindowLevel];
		[m_win setAlphaValue:1.0f];
		[m_win setOpaque:TRUE];
	}	
	[m_win center];
		
	return [NSApp runModalForWindow:m_win];
}

+ (int)runInFullscreen:(BOOL)fullscreen
			 withTitle:(NSString*)title message:(NSString*)msg
			  okButton:(NSString*)okBtn andCancelButton:(NSString*)cancelBtn {

	return [[self instance] _runInFullscreen:fullscreen 
								   withTitle:title message:msg
								   showInput:FALSE
									okButton:okBtn andCancelButton:cancelBtn];
}

+ (int)runInFullscreen:(BOOL)fullscreen
			 withTitle:(NSString*)title message:(NSString*)msg
		   andOkButton:(NSString*)okBtn {

	return [[self instance] _runInFullscreen:fullscreen 
								   withTitle:title message:msg
								   showInput:FALSE
									okButton:okBtn andCancelButton:nil];
}

+ (NSString*)runWithInputInFullscreen:(BOOL)fullscreen
							withTitle:(NSString*)title message:(NSString*)msg
							 okButton:(NSString*)okBtn andCancelButton:(NSString*)cancelBtn {


	FFInfoPanel* pi = [self instance];
	int	ret = [pi _runInFullscreen:fullscreen 
						 withTitle:title message:msg
						 showInput:TRUE
						  okButton:okBtn andCancelButton:cancelBtn];
	
	if (ret == NSOKButton)
		return [pi _inputValue];
	return @"";
}

@end
