// $Id: FFImageWindow.h 488 2005-09-25 15:11:21Z ravemax $
// Snapping code based on "Snapping Window" code by  Matt Gemmell.
// It was optimized to be less annoying & that it works w/ multiple monitors

#import <sys/time.h>

typedef enum {
	SIDE_LEFT	= 0,
	SIDE_RIGHT,
	SIDE_BOTTOM,
	SIDE_TOP,
	
	NUM_SIDES
} FFSnapSide;

typedef enum {
	REFRESH_NEVER = 0,
	REFRESH_ALWAYS,
	REFRESH_ONLY_WHEN_RESIZED
} FFRefresh;

@interface FFImageWindow : NSWindow {
	NSNotificationCenter*   m_nc;
	NSSize					m_prevViewSize;
	NSSize					m_prevFrameSize;
	BOOL					m_prevKeepARatio;
	
	float					m_snapTolerance;
	BOOL					m_alreadySnapping;
	BOOL					m_snapAllowed[NUM_SIDES];
	BOOL					m_staySnapped[NUM_SIDES];
	struct timeval			m_timeOnSnap[NUM_SIDES];
}

// Only to be called by the subclasses
- (id)initWithContentRect:(NSRect)rect andStyleMask:(unsigned int)style;

- (void)adjustViewSize:(NSSize)size minWidth:(float)minWd 
			   refresh:(FFRefresh)refresh
	   keepAspectRatio:(BOOL)aratio andCenter:(BOOL)center;

// To be implemented by the subclasses
- (void)adjustViewSize:(NSSize)size refresh:(FFRefresh)refresh
	   keepAspectRatio:(BOOL)aratio andCenter:(BOOL)center;

- (float)widgetHeight;

@end
