RCS_ID("$Id: FFFullscreenWindow.m 557 2006-08-20 14:12:11Z ravemax $")

#import "FFFullscreenWindow.h"
#import <ApplicationServices/ApplicationServices.h>
#import <Carbon/Carbon.h>
#import "FFImageList.h"
#import "NSWindow_Additions.h"

@implementation FFFullscreenWindow

- (id)initWithWindow:(NSWindow*)win andView:(NSView*)view 
		disableAutoShowMenuBar:(BOOL)dautoShow {

	self = [super initWithContentRect:[[win screen] frame]
							styleMask:NSBorderlessWindowMask 
							  backing:NSBackingStoreBuffered defer:FALSE];
	if (self) {
		// Hide the dock & menubar (show automatically) if on a screen w/ the menubar
		if ([self isPrimaryScreen])
			SetSystemUIMode(kUIModeAllHidden, dautoShow ? 0 : kUIOptionAutoShowMenuBar);
		
		[self setReleasedWhenClosed:TRUE];
		[self setContentView:view];
		[self setLevel:(NSModalPanelWindowLevel+1)];
	}

	return self;
}

- (void)close {
	// Disable this kinda "kiosk" mode - if hidden
	if (!IsMenuBarVisible())
		SetSystemUIMode(kUIModeNormal, 0);
	
	[super close];
}

- (BOOL)canBecomeKeyWindow { return TRUE; }

@end
