// $Id: FFToolTip.h 495 2005-09-26 16:15:17Z ravemax $

#import <stdarg.h>

#define MAX_TOOLTIP_LINES	5

typedef struct _FFToolTipLine {
	NSString*	text; // retained
	NSPoint		origin;
} FFToolTipLine;

@interface FFToolTipView : NSView {
	id				m_delegate; // weak
	NSColor*		m_bgCol;
	NSDictionary*	m_textAttribs;
	NSLock*			m_lineLock;
	int				m_numLines;
	FFToolTipLine	m_lines[MAX_TOOLTIP_LINES];
	NSBezierPath*	m_bgPath;
}

- (id)initWithFrame:(NSRect)frameRect andDelegate:(id)delegate;
- (void)setLines:(va_list)vaLines;

@end

#pragma mark -

@interface FFToolTip : NSObject {
	NSWindow*		m_win;
	FFToolTipView*	m_view;
}

- (id)initWithDelegate:(id)delegate;
// The location is the center of the tooltip
// Terminate the variable list with nil. Bug in stdarg?
- (void)showWithLinesAtLocation:(NSPoint)location, ...;
- (void)hide;

@end

#pragma mark -

@interface NSObject (FFToolTipDelegate)

- (void)toolTipClicked;

@end
