// $Id: FFPrefsController.h 429 2005-06-09 15:42:12Z ravemax $

#import "FFPreferences.h"

@class FFInputEventOVNode, FFInputEventSheet;

// The class
@interface FFPrefsController : NSObject {
	IBOutlet NSWindow*			m_window;
	IBOutlet FFInputEventSheet*	m_inputEventSheet;
	
	#define NUM_OF_PREF_VIEWS 5
	IBOutlet NSView*			m_viewGeneral;
	IBOutlet NSView*			m_viewImageList;
	IBOutlet NSView*			m_viewPanning;
	IBOutlet NSView*			m_viewInput;
	IBOutlet NSView*			m_viewAdvanced;
		
	IBOutlet NSButton*			m_generalSaveOpts;
	IBOutlet NSTextField*		m_generalZoomFactor;
	IBOutlet NSButton*			m_generalBorderlessWin;
	IBOutlet NSPopUpButton*		m_generalWinLevel;
	IBOutlet NSButton*			m_generalWinBackgroundAuto; 
	IBOutlet NSColorWell*		m_generalWinBackgroundCol;
	IBOutlet NSSlider*			m_generalSlideshowTime;
	IBOutlet NSTextField*		m_generalSlideshowTimeText;
	IBOutlet NSButton*			m_generalKeepMouseHidden;
	IBOutlet NSPopUpButton*		m_generalDoublePageAligment;
	IBOutlet NSTextField*		m_generalMagLensWidthText;
	IBOutlet NSTextField*		m_generalMagLensHeightText;
	IBOutlet NSPopUpButton*		m_listWrap;
	IBOutlet NSTextField*		m_listDirRoot;
	IBOutlet NSButton*			m_listTrashDelete;
	IBOutlet NSButton*			m_listWinHiddenOnStartup;
	IBOutlet NSTextField*		m_listThumbWidthText;
	IBOutlet NSTextField*		m_listThumbHeightText;
	IBOutlet NSButton*			m_panHoldCtrl;
	IBOutlet NSButton*			m_panRelative;
	IBOutlet NSStepper*			m_panNormalShift;
	IBOutlet NSTextField*		m_panNormalShiftText;
	IBOutlet NSStepper*			m_panAcceleratedShift;
	IBOutlet NSTextField*		m_panAcceleratedShiftText;
	IBOutlet NSStepper*			m_panWheelSpeedup;
	IBOutlet NSTextField*		m_panWheelSpeedUpText;
	IBOutlet NSOutlineView*		m_inputEventsOV;
	IBOutlet NSStepper*			m_advRingBufSize;
	IBOutlet NSTextField*		m_advRingBufSizeText;
	IBOutlet NSStepper*			m_advFetchDistance;
	IBOutlet NSTextField*		m_advFetchDistanceText;
	
	NSNotificationCenter*		m_nc;
	FFPreferences*				m_prefs;
	NSToolbar*					m_toolbar;
	NSDictionary*				m_toolbarItems;
	NSArray*					m_toolbarIdents; // Required to keep my order
	
	NSColor*					m_inputOVBgCols[4][2]; // [level][n%2]
	FFInputEventOVNode*			m_inputOVRootNode;
}

+ (FFPrefsController*)showWithExitingController:(FFPrefsController*)controller 
								 andPreferences:(FFPreferences*)prefs;

- (IBAction)saveOptsToggled:(id)sender;
- (IBAction)ringBufSizeModified:(id)sender;
- (IBAction)fetchDistanceModified:(id)sender;
- (IBAction)slideshowTimeModified:(id)sender;
- (IBAction)relativePanningToggled:(id)sender;
- (IBAction)controlPanningToggled:(id)sender;
- (IBAction)borderlessWindowToggled:(id)sender;
- (IBAction)windowLevelModified:(id)sender;
- (IBAction)windowBackgroundAutoToggled:(id)sender;
- (IBAction)windowBackgroundColorModified:(id)sender;
- (IBAction)doublePageAlignmentModified:(id)sender;
- (IBAction)listWrapModified:(id)sender;
- (IBAction)trashDeleteToggled:(id)sender;
- (IBAction)changeDirectoryRoot:(id)sender;
- (IBAction)wheelSpeedupModified:(id)sender;
- (IBAction)normalShiftModified:(id)sender;
- (IBAction)acceleratedShiftModified:(id)sender;
- (IBAction)keepMouseHiddenToggled:(id)sender;
- (IBAction)listWinHiddenToggled:(id)sender;
- (IBAction)addInputEvent:(id)sender;
- (IBAction)removeInputEvent:(id)sender;
- (IBAction)changeInputEvent:(id)sender;
- (IBAction)collapseInputEvents:(id)sender;
- (IBAction)expandInputEvents:(id)sender;

// [Internal] Forward declaration
- (void)_addInputEvent;
- (void)_removeInputEvent;
- (void)_changeInputEvent;
- (void)_setNewContentView:(NSView*)view withLabel:(NSString*)label;

@end
