RCS_ID("$Id: FFInputEventOVNode.m 407 2005-06-08 20:33:42Z ravemax $")

#import "FFInputEventOVNode.h"
#import "FFInputEvent.h"

@implementation FFInputEventOVNode

- (id)initWithTitle:(NSString*)title backgroundColor:(NSColor*)col 
		  andAction:(FFMenuAction)action hasSubnodes:(BOOL)hasSubnodes {
	self = [super init];
	if (self != nil) {
		m_title			= [title retain];
		m_bgColor		= col; // weak
		m_action		= action;
		m_subnodes		= hasSubnodes ? [[NSMutableArray alloc] init] : nil;
		m_superNode		= nil; // changed on "addSubnode:"
		m_event			= nil;
		m_eventAsString	= nil;
	}
	return self;
}

+ (FFInputEventOVNode*)nodeWithTitle:(NSString*)title 
				  andBackgroundColor:(NSColor*)col {
	return [[[self alloc] initWithTitle:title backgroundColor:col andAction:NO_MENU_ACTION
							hasSubnodes:TRUE] autorelease];
}

+ (FFInputEventOVNode*)nodeWithTitle:(NSString*)title 
					 backgroundColor:(NSColor*)col 
						   andAction:(FFMenuAction)action {
	return [[[self alloc] initWithTitle:title backgroundColor:col andAction:action
							hasSubnodes:FALSE] autorelease];
}

- (void)dealloc {
	[m_title release];
	if (m_subnodes != nil)
	[m_subnodes release];
	if (m_eventAsString != nil)
		[m_eventAsString release];
	
	[super dealloc];
}

#pragma mark -
#pragma mark Setters

- (void)setEvent:(FFInputEvent*)event {
	m_event			= event; // weak
	m_eventAsString	= [[event asString] retain];
	m_action		= [event action];
}

- (void)setSuperNode:(FFInputEventOVNode*)node {
	m_superNode	= node;
}

- (void)resetEvent {
	m_event			= nil;
	if (m_eventAsString != nil)
		[m_eventAsString release];
	m_eventAsString	= nil;
}

- (void)setTitle:(NSString*)title {
	[m_title release];
	m_title = [title retain];
}

#pragma mark -
#pragma mark Getters

- (NSString*)title									{ return m_title; }
- (FFInputEvent*)event								{ return m_event; }
- (NSString*)eventAsString							{ return m_eventAsString; }
- (FFInputEventOVNode*)superNode					{ return m_superNode; }
- (NSColor*)backgroundColor							{ return m_bgColor; }
- (FFMenuAction)action								{ return m_action; }

#pragma mark -
#pragma mark Subnodes read access

- (BOOL)hasSubnodes	{ 
	return (m_subnodes != nil); 
}

- (int)numberOfSubnodes	{
	NSAssert(m_subnodes != nil, @"Not an expandable node");
	return [m_subnodes count]; 
}

- (FFInputEventOVNode*)subnodeAtIndex:(int)index { 
	NSAssert(m_subnodes != nil, @"Not an expandable node");	
	return [m_subnodes objectAtIndex:index];
}

- (NSEnumerator*)subnodeEnumerator { 
	NSAssert(m_subnodes != nil, @"Not an expandable node");	
	return [m_subnodes objectEnumerator];
}

- (int)numberOfSubnodesWithEventAndAction:(FFMenuAction)action {
	int					num = 0;
	NSEnumerator*		en	= [self subnodeEnumerator];
	FFInputEventOVNode*	node;
	
	while (node = [en nextObject])
		if (([node event] != nil) && ([node action] == action))
			num++;

	return num;
}

- (int)numberOfSubnodesWithEventAndTitle:(NSString*)title {
	int					num = 0;
	NSEnumerator*		en	= [self subnodeEnumerator];
	FFInputEventOVNode*	node;
	
	while (node = [en nextObject])
		if (([node event] != nil) && ([node title] == title))
			num++;
	
	return num;
}

- (unsigned)indexOfNode:(FFInputEventOVNode*)node {
	NSAssert(m_subnodes != nil, @"Not an expandable node");	
	return [m_subnodes indexOfObject:node];
}

- (FFInputEventOVNode*)previousNode {
	return [[self superNode] subnodeAtIndex:([[self superNode] indexOfNode:self] - 1)];
}

#pragma mark -
#pragma mark Modifying the subnodes

- (void)addSubnode:(FFInputEventOVNode*)node {
	NSAssert(m_subnodes != nil, @"Not an expandable node");	
	[m_subnodes addObject:node];
	[node setSuperNode:self];
}

- (void)_insertNode:(FFInputEventOVNode*)nnode afterNode:(FFInputEventOVNode*)anode {
	[m_subnodes insertObject:nnode atIndex:([m_subnodes indexOfObject:anode]+1)];
	[nnode setSuperNode:self];
}

- (void)insertNodeAfterThisNode:(FFInputEventOVNode*)node {
	NSAssert(m_superNode != nil, @"No super node");
	[m_superNode _insertNode:node afterNode:self];
}

- (void)removeSubnode:(FFInputEventOVNode*)node {
	unsigned			nodeIdx;
	FFInputEventOVNode*	nextNode;
	
	NSAssert(m_subnodes != nil, @"Not an expandable node");	
	
	// Copy the title if this node is the first w/ this action	
	nodeIdx = [m_subnodes indexOfObject:node];
	if (nodeIdx+1 < [m_subnodes count]) {
		if ((nodeIdx == 0) || 
			([(FFInputEventOVNode*)[m_subnodes objectAtIndex:(nodeIdx-1)] action] != [node action])) {
			nextNode = [m_subnodes objectAtIndex:(nodeIdx+1)];
			if ([node action] == [nextNode action])
				[nextNode setTitle:[node title]];
		}
	}
	
	[m_subnodes removeObject:node];
}

@end
