// $Id: FFGL.h 495 2005-09-26 16:15:17Z ravemax $

#ifndef __FF_GL_H__
#define __FF_GL_H__

#import <OpenGL/gl.h>
#import <OpenGL/glu.h>

// The GL error code macro
#ifdef FF_DEBUG_MODE
	extern int lastGLError;
	#define GL(CMD) \
		CMD; \
		lastGLError = glGetError(); \
		if (lastGLError != GL_NO_ERROR) \
			FFLOG(1, @"glError: %s in %s at %d", gluErrorString(lastGLError), __FILE__, __LINE__)
#else
	#define GL(CMD) CMD
#endif

// Pixel pipeline mutex (= lock)
// semget/semop would also do the trick
extern NSLock* GLPixelPipelineLock;

// Creation and deletion of the lock
static inline void createGLPixelPipelineLock() {	
	if (GLPixelPipelineLock == nil)
		GLPixelPipelineLock = [[NSLock alloc] init];
}

static inline void deleteGLPixelPipelineLock() {
	if (GLPixelPipelineLock != nil) {
		[GLPixelPipelineLock release];
		GLPixelPipelineLock = nil;
	}
}

// Accessing the lock
static inline void lockGLPixelPipeline() {
	[GLPixelPipelineLock lock];
}

static inline void unlockGLPixelPipeline() {
	[GLPixelPipelineLock unlock];
}

#endif __FF_GL_H__
