RCS_ID("$Id: FFShadowRectImage.m 495 2005-09-26 16:15:17Z ravemax $")

#import "FFShadowRectImage.h"

@implementation FFShadowRectImage

// A few constants
#define SHADOW_WIDTH	8
#define BORDER_WIDTH	1
#define PADDING			(SHADOW_WIDTH + BORDER_WIDTH)
#define SHADOW_COLOR	[NSColor colorWithDeviceWhite:0.0 alpha:(float)2/3]
#define BORDER_COLOR	[NSColor selectedControlColor]

- (id)initWithWidth:(float)wd andHeight:(float)ht {
	// Set member variables
	padding	= PADDING;
	width	= wd + 2*PADDING;
	height	= ht + 2*PADDING;
		
	// Create the image
	self = [super initWithSize:NSMakeSize(width, height)];
	if (self != nil) {
		[self lockFocus];

		// 1. Set the shadow
		NSShadow* rshadow = [[NSShadow alloc] init];
		[rshadow setShadowColor:SHADOW_COLOR];
		[rshadow setShadowBlurRadius:SHADOW_WIDTH];
		[rshadow setShadowOffset:NSMakeSize(0, 0)];
		[rshadow set];
		
		// 2. Create the rectangle
		[[NSColor selectedControlColor] set];
		NSRectFill(NSMakeRect(SHADOW_WIDTH, SHADOW_WIDTH,
							  wd + BORDER_WIDTH*2, ht + BORDER_WIDTH*2));
		
		// 3. Cut out the "inner" rectangle
		[rshadow release];
		[[NSColor clearColor] set];
		NSRectFill(NSMakeRect(padding, padding, wd, ht));

		// 4. Easier access
		m_bitmapRep = [[NSBitmapImageRep alloc] initWithFocusedViewRect:
			NSMakeRect(0.0f, 0.0f, width, height)];	
		dataRGBA = [m_bitmapRep bitmapData];
		
		[self unlockFocus];
	}
	
	return self;
}

- (void)dealloc {
	[m_bitmapRep release];
	[super dealloc];
}

@end
