RCS_ID("$Id: FFDockIcon.m 599 2006-09-30 19:14:33Z ravemax $")

#import "FFDockIcon.h"
#import "FFImageList.h"

@implementation FFDockIcon

#define TEXT_Y_POS				18.0f
#define TEXT_X_MIDDLE			104.0f
#define TEXT_STANDARD_FONT_NAME	@"MarkerFelt-Wide"
#define TEXT_STANDARD_FONT_SIZE	21.0f
#define TEXT_ALT_FONT_NAME		@"Geneva"
#define TEXT_ALT_FONT_SIZE		19.0f

- (id)init {
	self = [super init];
	if (self) {
		m_size			= NSMakeSize(128.0, 128.0);
		m_appImg		= [[NSImage imageNamed:@"NSApplicationIcon"] retain];
		m_badgeImg		= [[NSImage imageNamed:@"dockicon_badge_large"] retain];
		[m_badgeImg setScalesWhenResized: TRUE];
		[[[m_badgeImg representations] objectAtIndex: 0] setSize:m_size];

		m_appImgOrigin		= NSMakePoint(0.0, 0.0);
		m_badgeImgOrigin	= NSMakePoint(0.0, 0.0);
		
		m_textFont = [[NSDictionary alloc] initWithObjectsAndKeys:
			// Fallback font
			([[NSFontManager sharedFontManager] fontNamed:TEXT_STANDARD_FONT_NAME hasTraits:0] ?
			 [NSFont fontWithName:TEXT_STANDARD_FONT_NAME size:TEXT_STANDARD_FONT_SIZE] : 
			 [NSFont fontWithName:TEXT_ALT_FONT_NAME size:TEXT_ALT_FONT_SIZE]), NSFontAttributeName,
			
			[NSColor darkGrayColor], NSForegroundColorAttributeName,
			nil];
		
		// The imagelist notifications
		NSNotificationCenter* nc = [NSNotificationCenter defaultCenter];
		[nc addObserver:self selector:@selector(imageListChange:)
				   name:ImageListChangedNotification object:nil];
		[nc addObserver:self selector:@selector(imageListChange:)
				   name:NewImageSelectedNotification object:nil];
		[nc addObserver:self selector:@selector(imageListChange:)
				   name:ImageListRearrangedNotification object:nil];
	}
	return self;
}

- (void)dealloc {
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	
	[m_appImg release];
	[m_badgeImg release];
	[m_textFont release];
	
	[super dealloc];
}

- (void)_updateWithText:(NSString*)text {
	NSImage* img = [[NSImage alloc] initWithSize:m_size];
	[img lockFocus];
	
	[m_appImg compositeToPoint: m_appImgOrigin operation:NSCompositeCopy];
	
	if (text != nil) {
		NSSize  sz = [text sizeWithAttributes:m_textFont];
		NSPoint tp;
		tp.y = TEXT_Y_POS;
		tp.x= (TEXT_X_MIDDLE - sz.width) / 2.0 + 1.0;
		//app image + icon
		[m_badgeImg compositeToPoint: m_badgeImgOrigin operation:NSCompositeSourceOver];
		[text drawAtPoint:tp withAttributes:m_textFont];
	}
	
	[img unlockFocus];	
	[NSApp setApplicationIconImage:[img autorelease]];
}

- (void)imageListChange:(NSNotification*)not {
	FFImageList*	list = [not object];

	if ([list numberOfImages] == 0)
		[self _updateWithText:nil];
	else
		[self _updateWithText:[NSString stringWithFormat:@"%d/%u", 
			[list selectedImageIndex]+1, [list numberOfImages]]];
}

- (void)setIconWithoutBadge {
	[self _updateWithText:nil];
}

@end
