RCS_ID("$Id: FFSmartFolder.m 495 2005-09-26 16:15:17Z ravemax $")
//	The Cocoa query syntax is incompatible to the Finder one. Carbon works.

#import "FFSmartFolder.h"


@implementation FFSmartFolder

static NSString* SmartFolderFilenameExtension = @"savedSearch";

- (id)initWithSavedSearch:(NSString*)filename {
	self = [super init];
	if (self != nil) {
		// Read the raw query
		NSDictionary* finderSearch = [NSDictionary dictionaryWithContentsOfFile:filename];
		if (finderSearch == nil)
			return nil;
		
		m_rawQuery = [finderSearch objectForKey:@"RawQuery"];
		if (m_rawQuery == nil)
			return nil;
		[m_rawQuery retain];
		
		// Get the search scope (= root folder(s))
		m_scopePaths = [[[finderSearch objectForKey:@"SearchCriteria"]
								objectForKey:@"FXScopeArrayOfPaths"] retain];
		
		m_folderName = [[filename lastPathComponent] retain];
	}
	return self;
}

- (void)dealloc {
	[m_folderName release];
	[m_rawQuery release];
	[m_scopePaths release];
	[super dealloc];
}

- (NSArray*)contents {
	// Create a Carbon MetaData query & set the scope
	MDQueryRef query = MDQueryCreate(kCFAllocatorDefault, (CFStringRef)m_rawQuery, NULL, NULL);
	if (query == nil)
		return [NSArray array];
	
	MDQuerySetSearchScope(query, (CFArrayRef)m_scopePaths, 0);
	
	// Search...
	if (!MDQueryExecute(query,  kMDQuerySynchronous)) {
		FFLOG(8, @"MDQueryExecute failed");
		CFRelease(query);		
		return [NSArray array];
	}
	
	// No updates
	MDQueryStop(query); 
	
	// Get all the filepaths
	CFIndex			i, cnt		= MDQueryGetResultCount(query);
	NSMutableArray*	filepaths	= [[NSMutableArray alloc] initWithCapacity:cnt];
	
	for (i = 0; i < cnt; i++) {
		MDItemRef	item = MDQueryGetResultAtIndex(query, i);
		CFStringRef	path = MDItemCopyAttribute(item, kMDItemPath);

		if (!CFStringHasSuffix(path, (CFStringRef)m_folderName)) // Prevent smart folder recursion
			[filepaths addObject:(NSString*)path];
		
		CFRelease(path);
	}

	CFRelease(query);
	return [filepaths autorelease];
}

+ (BOOL)isSmartFolderExtension:(NSString*)ext {
	return [ext isEqualToString:SmartFolderFilenameExtension];
}

@end
