RCS_ID("$Id: FFImageList_Thumbs.m 475 2005-09-25 14:53:25Z ravemax $")

#import "FFImageList_Thumbs.h"
#import "FFImageFile.h"
#import "FFThumbView.h"
#import "FFImageLoader.h"
#import "FFImageListController.h"

// Notifications (send)
NSString*	SingleThumbLoadedNotification = @"sthumb_loaded";

@implementation FFImageList (Thumbs)

#pragma mark -
#pragma mark Loading

- (void)_thumbnailLoaderThread:(id)_unused {
	NSAutoreleasePool*	pool;
	int					idx = 0;
	NSEnumerator*		en;
	FFImageFile*		ifile;
	FFThumb*			tb;
	NSImage*			timg;
	GLuint				owd, oht, depth;
	BOOL				ret;
	NSString*			fn;
	
	pool = [[NSAutoreleasePool alloc] init];

	// Loading started
	[m_nc postNotificationName:StartProgressNotification object:nil];
	
	// Load the thumbs
	en	= [m_list objectEnumerator];
	while (!m_abortThumbLoader && (ifile = [en nextObject])) {
		tb = [ifile thumb];
		if (THUMB_NOT_LOADED(tb)) {
			fn	= [self fullPathOfImageFile:ifile];
			if (fn == nil)
				ret = FALSE;
			else
				ret = loadThumbnail(fn, m_thumbWidth, m_thumbHeight,
									&timg, &owd, &oht, &depth);
			
			if (m_abortThumbLoader)
				break;

			if (ret) {				
				tb->img		= timg;
				tb->name	= [[[ifile displayName] string] retain];
				tb->desc	= [[NSString alloc] initWithFormat:@"%u x %u, %u bit",
								owd, oht, depth];
				
				[m_nc postNotificationName:SingleThumbLoadedNotification object:
					[NSNumber numberWithUnsignedInt:(unsigned)tb]];
			}
		}
		idx++;
	}
	
	// No more loading
	[m_nc postNotificationName:StopProgressNotification object:nil];
	
	[pool release];
	[m_thumbLock unlock];
	[NSThread exit];
}

- (void)loadThumbs:(BOOL)abortLoading {
	// Abort a current loader thread if there is any
	m_abortThumbLoader = TRUE;
	[m_thumbLock lock]; // wait
	m_abortThumbLoader = FALSE;
	
	if (!abortLoading)
		[NSThread detachNewThreadSelector:@selector(_thumbnailLoaderThread:)
								 toTarget:self withObject:nil];
	else
		[m_thumbLock unlock];
}

#define THUMB_INFO(INDEX, ELEMENT) \
	FFThumb* tb = [[m_list objectAtIndex:INDEX] thumb]; \
	if (THUMB_NOT_LOADED(tb)) \
		return @""; \
	return tb->ELEMENT

- (NSString*)thumbNameAtIndex:(unsigned)index {
	THUMB_INFO(index, name);
}

- (NSString*)thumbDescriptionAtIndex:(unsigned)index {
	THUMB_INFO(index, desc);
}

#pragma mark -
#pragma mark Thumbview datasource

- (unsigned)numberOfThumbsInThumbView:(FFThumbView*)tv {
	return [m_list count];
}

- (FFThumb*)thumbView:(FFThumbView*)tv thumbAtIndex:(unsigned)index {
	return [[m_list objectAtIndex:index] thumb];
}

@end
