// $Id: FFImageList.h 565 2006-08-20 14:18:19Z ravemax $

#import <FFArchive/FFArchive.h>

// Notification (sends)
extern NSString*	ImageListChangedNotification;
extern NSString*	NewImageSelectedNotification;
extern NSString*	SlideshowStartedNotification;
extern NSString*	SlideshowStoppedNotification;
extern NSString*	ImageListRearrangedNotification;

// Notification (receives)
extern NSString*	SelectPreviousImageNotification;
extern NSString*	SelectNextImageNotification;
extern NSString*	SelectFirstImageNotification;
extern NSString*	SelectLastImageNotification;
extern NSString*	SelectSpecifiedImageNotification;
extern NSString*	RemoveCurrentImageNotification;
extern NSString*	StopSlideshowNotificaton;

// Constants for drag'n'drop in the table
extern NSString*	ImageListDragType;

// Types and extensions
extern NSMutableDictionary*	KnownFileTypes;
extern NSMutableArray*		KnownFileExtensions;
extern NSString*			ImageListFileExtension;

// Order
typedef enum {
	IMGLIST_USER_ASC = 0,
	IMGLIST_USER_DESC,
	IMGLIST_NUMERIC_ASC,
	IMGLIST_NUMERIC_DESC,
	IMGLIST_ALPHA_ASC,
	IMGLIST_ALPHA_DESC,
	IMGLIST_PATH_ASC,
	IMGLIST_PATH_DESC,
	IMGLIST_DATE_ASC,
	IMGLIST_DATE_DESC,
	IMGLIST_FILESIZE_ASC,
	IMGLIST_FILESIZE_DESC,
	
	IMGLIST_NUM_ORDER
} FFImageListSortOrder;

// Extern classes
@class FFPreferences, FFOptions, FFRecentList, FFImageFile, FFDirNode;

// Class
@interface FFImageList : NSObject <FFArchiveHelper> {
	FFPreferences*			m_prefs;
	FFOptions*				m_opts;
	FFRecentList*			m_recentList;
	NSFileManager*			m_fm;
	NSNotificationCenter*   m_nc;
	NSMutableArray*			m_list;
	int						m_selInc, m_selDec;
	int						m_selectedImage;	
	NSMutableArray*			m_archiveFilesInTemp;
	NSTimer*				m_slideshowTimer;
	FFImageListSortOrder	m_sortOrder;
	
	NSString*	m_filterString;
	
	// Actually in FFImageList_Thumbs
	NSLock*	m_thumbLock;
	BOOL	m_abortThumbLoader;
	int		m_thumbWidth, m_thumbHeight;
}

- (id)initWithPreferences:(FFPreferences*)prefs options:(FFOptions*)opts
			andRecentList:(FFRecentList*)rlist;
- (void)cleanUp;

// Manipulation of the list
- (void)addFiles:(NSArray*)files tillLevel:(int)level 
		restoreSelectionIfPossible:(BOOL)resSel;
- (void)clear;
- (void)removeInIndexSet:(NSIndexSet*)iset;
- (void)removeFilesWithPrefix:(NSString*)prefix;
- (void)replace:(FFDirNode*)dir onlyImages:(BOOL)onlyImgs;
- (void)replaceWithImageList:(NSString*)filename restoreSelection:(BOOL)resSel;

// Storage
- (BOOL)save:(NSString*)filename;
- (BOOL)addImageList:(NSString*)filename restoreSelection:(BOOL)resSel
		 addToRecent:(BOOL)recent postNotifications:(BOOL)postNot;

// Information and values of the list
- (unsigned)numberOfImages;
- (NSAttributedString*)displayNameAtIndex:(unsigned)index;
- (NSString*)fullPathOfImageFile:(FFImageFile*)imf;
- (NSString*)fullPathAtIndex:(unsigned)index;
- (BOOL)filteredAtIndex:(unsigned)index;
- (unsigned)fileIndexAtIndex:(unsigned)index;
- (NSString*)fileNameAtIndex:(unsigned)index;
- (NSString*)extensionAtIndex:(unsigned)index;

// Image selection
- (int)selectedImageIndex;
- (NSAttributedString*)displayNameOfSelectedImage;
- (NSAttributedString*)displayNameOfNextImage; // nil if selected = last image
- (void)setSelectionDecrementer:(int)dec;
- (BOOL)selectPreviousImage;
- (void)setSelectionIncrementer:(int)inc;
- (BOOL)selectNextImage;
- (BOOL)selectFirstImage;
- (BOOL)selectLastImage;
- (BOOL)selectImageAtIndex:(unsigned)index;
- (BOOL)removeCurrentImage;

// Slideshow
- (BOOL)slideshowIsRunning;
- (void)startSlideshowWithInterval:(NSTimeInterval)interval endless:(BOOL)endless;
- (void)stopSlideshow;

// Sorting/rearranging
- (BOOL)isUserSortOrder;
- (BOOL)sort:(FFImageListSortOrder)order;
- (void)moveImagesWithIndexes:(NSArray*)imgIndexes toIndex:(int)index;
- (BOOL)shuffle;

// Filtering
- (BOOL)filter:(NSString*)text;

// Misc
- (void)revealInFinder;
- (BOOL)removeAndTrashCurrentImage;
- (BOOL)copyImageAtIndex:(unsigned)index toDirectory:(NSString*)directory;
+ (NSString*)fileExtension;
+ (BOOL)isArchiveExtension:(NSString*)ext;
+ (BOOL)isImageExtension:(NSString*)ext;
- (BOOL)isWritableContainerOfImageAtIndex:(int)index;
- (BOOL)useImageAtIndexAsFinderIcon:(int)index;

@end
