// $Id: FFImageFile.h 473 2005-09-25 14:52:06Z ravemax $

#import "FFThumbView.h"

@class FFArchive;

typedef enum {
	IMG_NORMAL_FILE = 0,
	IMG_PART_OF_ARCHIVE,

	NUM_IMAGE_FILE_TYPES
} FFImageFileType;

#define FILE_INDEX_UNDEFINED 0

@interface FFImageFile : NSObject {
	NSString*			m_fullPath;
	FFImageFileType		m_fileType;
	NSAttributedString*	m_displayName;
	FFArchive*			m_archive;
	unsigned			m_fileIndex;
	unsigned			m_userSortIndex;
	unsigned long		m_fileSize;
	NSDate*				m_date;
	BOOL				m_filtered;
	FFThumb				m_thumb;
}

// init
+ (FFImageFile*)normalFile:(NSString*)fullPath;
+ (FFImageFile*)file:(NSString*)fullPath fromArchive:(FFArchive*)archive
		withFileSize:(unsigned long)fsize andDate:(NSDate*)date;

// Storage
- (NSDictionary*)asDictRelativeToPath:(NSString*)path;
+ (FFImageFileType)typeFromDict:(NSDictionary*)dict;
+ (NSString*)absolutFullpathFromDict:(NSDictionary*)dict relativeToPath:(NSString*)path;	
+ (FFImageFile*)normalFileFromDict:(NSDictionary*)dict relativeToPath:(NSString*)path;
+ (FFImageFile*)fileFromDict:(NSDictionary*)dict fromArchive:(FFArchive*)archive;

// getter
- (NSString*)fullPath;
- (FFArchive*)archive;
- (FFImageFileType)fileType;
- (NSAttributedString*)displayName;
- (unsigned)fileIndex;
- (unsigned)userSortIndex;
- (unsigned long)fileSize;
- (NSDate*)date;
- (BOOL)filtered;
- (FFThumb*)thumb;

// Setter
- (void)setUserSortIndex:(unsigned)idx;
- (void)setFiltered:(BOOL)filtered;

// comparators (for sorting)
- (NSComparisonResult)compareFileIndexAsc:(FFImageFile*)other;
- (NSComparisonResult)compareFileIndexDesc:(FFImageFile*)other;
- (NSComparisonResult)compareNumericAsc:(FFImageFile*)other;
- (NSComparisonResult)compareNumericDesc:(FFImageFile*)other;
- (NSComparisonResult)compareAlphaAsc:(FFImageFile*)other;
- (NSComparisonResult)compareAlphaDesc:(FFImageFile*)other;
- (NSComparisonResult)comparePathAsc:(FFImageFile*)other;
- (NSComparisonResult)comparePathDesc:(FFImageFile*)other;
- (NSComparisonResult)compareDateAsc:(FFImageFile*)other;
- (NSComparisonResult)compareDateDesc:(FFImageFile*)other;
- (NSComparisonResult)compareFileSizeAsc:(FFImageFile*)other;
- (NSComparisonResult)compareFileSizeDesc:(FFImageFile*)other;

@end
