RCS_ID("$Id: NSBezierPath_Additions.m 495 2005-09-26 16:15:17Z ravemax $")

// Rounded rectangle code from:http://www.cocoadev.com/index.pl?RoundedRectangles)

#import "NSBezierPath_Additions.h"

@implementation NSBezierPath (Additions)

+ (NSBezierPath*)roundedRectangleWithWidth:(float)wd height:(float)ht
							 andEdgeRadius:(float)radius {
	NSBezierPath*	path;
	float			irad, ifac;

	path	= [NSBezierPath bezierPath];
	irad	= MIN(radius, 0.5f * MIN(wd, ht));
	ifac	= irad * 2;
	
	NSRect rect = NSMakeRect(irad, irad, wd - ifac, ht - ifac);
	
	[path appendBezierPathWithArcWithCenter:NSMakePoint(NSMinX(rect), NSMinY(rect)) radius:irad startAngle:180.0 endAngle:270.0];
	[path appendBezierPathWithArcWithCenter:NSMakePoint(NSMaxX(rect), NSMinY(rect)) radius:irad startAngle:270.0 endAngle:360.0];
	[path appendBezierPathWithArcWithCenter:NSMakePoint(NSMaxX(rect), NSMaxY(rect)) radius:irad startAngle:  0.0 endAngle: 90.0];
	[path appendBezierPathWithArcWithCenter:NSMakePoint(NSMinX(rect), NSMaxY(rect)) radius:irad startAngle: 90.0 endAngle:180.0];
	[path closePath];
	
	return path;
}

@end
