/*
 * Copyright (C) 2003  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "scanner_map.h"

#include "scanners.h"

ScannerMap::ScannerMap()
{
  scanner_map["java"] = &java_scanner_lex;
  scanner_map["cpp"] = &cpp_scanner_lex;
  scanner_map["c"] = &cpp_scanner_lex;
  scanner_map["C"] = &cpp_scanner_lex;
  scanner_map["cc"] = &cpp_scanner_lex;
  scanner_map["h"] = &cpp_scanner_lex;
  scanner_map["hh"] = &cpp_scanner_lex;
  scanner_map["H"] = &cpp_scanner_lex;
  scanner_map["hpp"] = &cpp_scanner_lex;
  scanner_map["javascript"] = &javascript_scanner_lex;
  scanner_map["js"] = &javascript_scanner_lex;
  scanner_map["prolog"] = &prolog_scanner_lex;
  scanner_map["pl"] = &prolog_scanner_lex;
  scanner_map["perl"] = &perl_scanner_lex;
  scanner_map["pm"] = &perl_scanner_lex;
  scanner_map["php3"] = &php3_scanner_lex;
  scanner_map["php"] = &php3_scanner_lex;
  scanner_map["python"] = &python_scanner_lex;
  scanner_map["py"] = &python_scanner_lex;
  scanner_map["ruby"] = &ruby_scanner_lex;
  scanner_map["rb"] = &ruby_scanner_lex;
  scanner_map["flex"] = &flex_scanner_lex;
  scanner_map["lex"] = &flex_scanner_lex;
  scanner_map["l"] = &flex_scanner_lex;
  scanner_map["ll"] = &flex_scanner_lex;
  scanner_map["changelog"] = &changelog_scanner_lex;
  scanner_map["lua"] = &lua_scanner_lex;
  scanner_map["ml"] = &caml_scanner_lex;
  scanner_map["caml"] = &caml_scanner_lex;
  scanner_map["sml"] = &sml_scanner_lex;
}

bool
ScannerMap::invoke_scanner(const string &s)
{
  if (scanner_map.find (s) == scanner_map.end ())
    return false;

  (*(scanner_map[s]))();
  return true;
}
