/*
 * Copyright (C) 1999, 2000, 2001  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
  Class List ( first element is dummy )
*/

#include <iostream.h>
#include <stdlib.h>

#ifndef LIST
#define LIST

template <class TYPE>
struct ListNode
{
  TYPE elem ;
  ListNode<TYPE> *next ;

  ListNode() : next( 0 ) {}
  ListNode( TYPE e, ListNode<TYPE> *n ) : elem( e ), next( n ) {}

  ListNode<TYPE> * Next() { return next ; }
  TYPE & Elem() { return elem ; } 
} ;


template <class TYPE>
class List
{
	ListNode<TYPE> *first ;
	ListNode<TYPE> *last ;

	void Clear() ;

public:
	unsigned length ;

	List() ;
	List( const List<TYPE> & l ) ;
	~List() ;

	ListNode<TYPE> * First() { return first->next ; }
	void AddToBack( TYPE el ) ;
	void AddToFront( TYPE el ) ; 
	void Add( TYPE el ) { AddToBack( el ) ; }
	void OwnsNothing() ; // notify to the list that it does not own elems
	int Empty() { return first == last ; } 
	void Flush() ; // empty the list but do not destroy it
	TYPE ExtractFromFront() ;
        void Append( List<TYPE> & l ) ; // Append without copying
        void Append( List<TYPE> *l ) ; // the same
	void AppendDeep( List<TYPE> l ) ; // Append by copying
	unsigned Length() { return length ; }
	void Copy( List<TYPE> & source ) ; 
	void Detach( ListNode<TYPE> * l ) ;
	void Check( ListNode<TYPE> * l ) ; // allocation succedeed?
} ;


template <class TYPE>
List<TYPE>::List()
{
	first = new ListNode<TYPE> ;
	Check( first ) ;
	last = first ;
	length = 0 ;
}

template <class TYPE>
List<TYPE>::List( const List<TYPE> & l )
{
	ListNode<TYPE> * tmp ;

	first = new ListNode<TYPE> ;
	Check( first ) ;
	last = first ;
	length = 0 ;

	tmp = l.first->next ;

	while( tmp )
	{
		AddToBack( tmp->elem ) ;
		tmp = tmp->next ;
	}
}

template <class TYPE>
void List<TYPE>::Copy( List<TYPE> & source )
{
	ListNode<TYPE> * tmp ;

	tmp = source.First() ;

	while( tmp )
	{
		AddToBack( tmp->elem ) ;
		tmp = tmp->next ;
	}
}

template <class TYPE>
void List<TYPE>::Clear()
{
	ListNode<TYPE> *l1 ;
	ListNode<TYPE> *l2 ;

	l1 = first ;
	while ( l1 )
	{
		l2 = l1->next ;
		delete l1 ;
		l1 = l2 ;
	}
}

template <class TYPE>
void List<TYPE>::Flush()
{
	ListNode<TYPE> *l1 ;
	ListNode<TYPE> *l2 ;

	l1 = first->next ;
        // the list is emptied but not deleted, so the first dummy
        // element must be left.

	while ( l1 )
	{
		l2 = l1->next ;
		delete l1 ;
		l1 = l2 ;
	}
	OwnsNothing() ;
}

template <class TYPE>
List<TYPE>::~List()
{
	Clear() ;
}

template <class TYPE>
void List<TYPE>::AddToBack( TYPE el )
{
	ListNode<TYPE> *tmp ;
	tmp = new ListNode<TYPE>( el, 0 ) ;
	Check( tmp ) ;
	last->next = tmp ;
	last = last->next ;
	length++ ;
}

template <class TYPE>
void List<TYPE>::AddToFront( TYPE el )
{
	ListNode<TYPE> *tmp ;
	tmp = new ListNode<TYPE>( el, 0 ) ;
	Check( tmp ) ;
	if( ! tmp )
	{
		cerr << "Allocation failed!" << endl ;
		abort() ;
	}
	tmp->next = first->next ;
	if ( first == last ) last = tmp ;
	first->next = tmp ;
	length++ ;
}

template <class TYPE>
TYPE List<TYPE>::ExtractFromFront()
{
	TYPE RetValue ;
	ListNode<TYPE> * tmp ;

	RetValue = first->next->elem ;
	tmp = first->next->next ;
	delete first->next ;
	first->next = tmp ;
	length-- ;
	if ( ! tmp ) last = first ;     // the queue is empty
	return RetValue ;
}

template<class TYPE>
void List<TYPE>::Append( List<TYPE> * l )
{
  if ( l )
    Append( *l ) ;
}

template <class TYPE>
void List<TYPE>::Append( List<TYPE> & l )
{
        if( ! l.Empty() )
	  {
                last->next = l.first->next ;
                last = l.last ;
                length += l.Length() ;
	  }
}

template <class TYPE>
void List<TYPE>::AppendDeep( List<TYPE> l )
{
  if (!Empty()) {
    last->next=l.first;  last=l.last; 
    length+=l.length;
    l.first=l.last=NULL; // to avoid destruction of elements
  } else {
    first=l.first;  last=l.last; 
    length=l.length;
    l.first=l.last=NULL;
  }
}

// the list does not own its elements anymore: someone else does
template <class TYPE>
void List<TYPE>::OwnsNothing()
{
	last = first ;
	first->next = 0 ;
	length = 0 ;
}

// l is the pointer to the node before the one we want to delete:
// i.e. we want to deallocate the node pointed by l->next
template <class TYPE>
void List<TYPE>::Detach( ListNode<TYPE> * l )
{
	ListNode<TYPE> * tmp ;

	if( l->next == last )
		last = l ;

	tmp = l->next->next ;
	delete l->next ;
	l->next = tmp ;
	length-- ;
}

// check the dynamic allocation
template <class TYPE>
void List<TYPE>::Check( ListNode<TYPE> * l )
{
	if( ! l )
	{
		cout << "List could not allocate a node : " << endl ;
		cout << "MEMORY EXHAUSTED !" << endl ;
		abort() ;
	}
}


#endif
