/* -*-c-*- ---------------- mixgtk_device.c :
 * actual types for mixgtk devices
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: <01/03/05 01:13:40 jose>
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */


#define _GNU_SOURCE 1

#include <stdio.h>
#include <mixlib/xmix_device.h>
#include "mixgtk_device.h"

/* device container */
static GtkNotebook *container_ = NULL;
/* virtual machine */
static mix_vm_t *vm_ = NULL;

/* a mixgtk device */
struct mixgtk_device_t
{
  mix_device_t device;
  char *buffer;
  size_t buffer_len;
  GtkText *widget;
  gint pos;
};

/* callbacks for output devices */
static gboolean
write_out_ (mix_device_t *dev, const mix_word_t *block)
{
  struct mixgtk_device_t *gtkdev;
  
  if (!((DEF_DEV_VTABLE_->write) (dev, block))) return FALSE;
  gtkdev = (struct mixgtk_device_t *) dev;
  if (gtkdev->buffer_len > 0)
    {
      gtk_text_insert (gtkdev->widget, NULL, NULL, NULL,
		       gtkdev->buffer, gtkdev->buffer_len);
      rewind (mix_io_to_FILE (gtkdev->device.file));
      gtk_notebook_set_page (container_, gtkdev->pos);
      gtk_widget_draw (GTK_WIDGET (container_), NULL);
    }
  return TRUE;
}

static mix_device_vtable_t MIXGTK_OUT_VTABLE_;

/* create a new mixgtk device */
static struct mixgtk_device_t *
mixgtk_device_new_ (mix_device_type_t type)
{
  struct mixgtk_device_t *dev = NULL;

  g_return_val_if_fail (type < mix_dev_INVALID, NULL);

  if (MODES_[type] == mix_dev_CHAR && FMODES_[type] == mix_io_WRITE)
    {
      FILE *f;
      dev = g_new (struct mixgtk_device_t, 1);
      f = open_memstream (&(dev->buffer), &(dev->buffer_len));
      g_assert (f);
      dev->device.file = mix_io_new (f);
      dev->device.type = type;
      dev->device.vtable = &MIXGTK_OUT_VTABLE_;
      dev->widget = (GtkText *)gtk_text_new (NULL, NULL);
      g_assert (dev->widget);
      gtk_text_set_editable (dev->widget, FALSE);
    }
  return dev;
}

/* connect a device */
static void
mixgtk_device_connect_ (struct mixgtk_device_t *dev)
{
  static gint last_pos = 0;
  GtkWidget *label = gtk_label_new (DEF_NAMES_[dev->device.type]);
  GtkWidget *box = gtk_hbox_new (0, 0);
  GtkWidget *scroll = gtk_vscrollbar_new (dev->widget->vadj);
  g_assert (label);
  g_assert (box);
  gtk_box_pack_start (GTK_BOX (box), GTK_WIDGET (dev->widget),
		      TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (box), scroll, FALSE, FALSE, 0);
  dev->pos = last_pos++;
  gtk_notebook_insert_page (container_, box, label, dev->pos);
  gtk_widget_show (box);
  gtk_widget_show (label);
  gtk_widget_show (scroll);
  gtk_widget_show (GTK_WIDGET (dev->widget));
  gtk_widget_draw (GTK_WIDGET (container_), NULL);
  (void) mix_vm_connect_device (vm_, (mix_device_t *)dev);
}

/* init default devices */
gboolean
mixgtk_device_init (GtkNotebook *container, mix_vm_t *vm)
{
  static mix_device_type_t def_types[] = {
    mix_dev_CONSOLE, mix_dev_PRINTER, mix_dev_PAPER_TAPE, mix_dev_INVALID
  };
  
  gint k = 0;
				     
  g_return_val_if_fail (container != NULL, FALSE);
  g_return_val_if_fail (vm != NULL, FALSE);
  container_ = container;
  vm_ = vm;

  /* remove dummy page from container */
  gtk_notebook_remove_page (container_, 0);

  /* initialise vtables */
  MIXGTK_OUT_VTABLE_.write = write_out_;
  MIXGTK_OUT_VTABLE_.read = DEF_DEV_VTABLE_->read;
  MIXGTK_OUT_VTABLE_.ioc = DEF_DEV_VTABLE_->ioc;
  MIXGTK_OUT_VTABLE_.busy = DEF_DEV_VTABLE_->busy;
  
  /* connect default devices */
  while (def_types[k] != mix_dev_INVALID)
    {
      struct mixgtk_device_t *dev = mixgtk_device_new_ (def_types[k]);
      if (dev != NULL)
	  mixgtk_device_connect_ (dev);
      ++k;
    }

  /* set to first page */
  gtk_notebook_set_page (container_, 0);
  
  return TRUE;
}

/* connect a new (file-based) device */
gboolean
mixgtk_device_connect (mix_device_type_t type, const gchar *name);
