/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.Library;
import gnu.jel.TestingUtils;
import gnu.jel.tests.VariableProvider;

public class IntegralErrorTest
extends TestingUtils {
    Library lib;

    public IntegralErrorTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        Class[] staticLib = new Class[2];
        staticLib[0] = Class.forName("java.lang.Math");
        VariableProvider tvp = new VariableProvider();
        staticLib[1] = tvp.getClass();
        Class[] dotAllowedOn = new Class[]{Class.forName("java.lang.String")};
        this.lib = new Library(staticLib, null, dotAllowedOn, null, null);
        this.lib.markStateDependent("random", null);
    }

    @Override
    public void tearDown() throws Exception {
    }

    public void testErr1() throws Exception {
        IntegralErrorTest.simError("", null, this.lib, 0, null);
    }

    public void testErr2() throws Exception {
        IntegralErrorTest.simError(" ", null, this.lib, 1, null);
    }

    public void testErr3() throws Exception {
        IntegralErrorTest.simError("tru", null, this.lib, 1, null);
    }

    public void testErr4() throws Exception {
        IntegralErrorTest.simError("1=", null, this.lib, 2, null);
    }

    public void testErr5() throws Exception {
        IntegralErrorTest.simError("1=", null, this.lib, 2, null);
    }

    public void testErr6() throws Exception {
        IntegralErrorTest.simError("1=2", null, this.lib, 3, null);
    }

    public void testErr7() throws Exception {
        IntegralErrorTest.simError("1.0-+1.0", null, this.lib, 6, null);
    }

    public void testErr8() throws Exception {
        IntegralErrorTest.simError("1.0&1.0", null, this.lib, 4, null);
    }

    public void testErr9() throws Exception {
        IntegralErrorTest.simError("-", null, this.lib, 1, null);
    }

    public void testErr10() throws Exception {
        IntegralErrorTest.simError("0x56+0xXX", null, this.lib, 8, null);
    }

    public void testErr11() throws Exception {
        IntegralErrorTest.simError("Sin(x)", null, this.lib, 5, null);
    }

    public void testErr12() throws Exception {
        IntegralErrorTest.simError("Sin(6)", null, this.lib, 1, null);
    }

    public void testErr13() throws Exception {
        IntegralErrorTest.simError("sin(' ')", null, this.lib, 1, null);
    }

    public void testErr14() throws Exception {
        IntegralErrorTest.simError("1+sin(1,6)", null, this.lib, 3, null);
    }

    public void testErr15() throws Exception {
        IntegralErrorTest.simError("2147483649L+2147483649", null, this.lib, 22, null);
    }

    public void testErr16() throws Exception {
        IntegralErrorTest.simError("01234567+08+5", null, this.lib, 12, null);
    }

    public void testErr17() throws Exception {
        IntegralErrorTest.simError("0.5+0#4", null, this.lib, 6, null);
    }

    public void testErr18() throws Exception {
        IntegralErrorTest.simError("0.5+1", Integer.TYPE, this.lib, 5, null);
    }

    public void testErr19() throws Exception {
        IntegralErrorTest.simError("0.5+(floatp)0.4D", null, this.lib, 6, null);
    }

    public void testErr20() throws Exception {
        IntegralErrorTest.simError("0.5+(boolean)0.4D", null, this.lib, 6, null);
    }

    public void testErr21() throws Exception {
        IntegralErrorTest.simError("23?1:2", null, this.lib, 3, null);
    }

    public void testErr22() throws Exception {
        IntegralErrorTest.simError("true?\" \":' '", null, this.lib, 5, null);
    }

    public void testErr23() throws Exception {
        IntegralErrorTest.simError("true?\" \":makeDoubleObject(1.0)", null, this.lib, 5, null);
    }
}

