#include "my_throw.h"

#include "CBaseTypeFactory.h"

#include "GIFTExceptions.h"
#include "CAlgorithm.h"
#include "CQInvertedFile.h"
#include "CQParallel.h"
#include "CQMultiple.h"
#ifdef __GIFT_BAYESIAN__
#include "CIFQuickAndDirtyHunter.h"
#endif
#include "CQHierarchy.h"

#ifdef __GIFT_WITH_PERL__
#include "CQPerl.h"
#endif

//These are files which belong to yet unpublished worked
#ifdef __GIFT_UNPUBLISHED_WORK__
#include "CQIFFerDeLance.h"
#endif

#include "CAccessorCollection.h"

CQuery* CBaseTypeFactory::makeQuery(const string & inBaseType, 
				    CAccessorCollection & inAccessorCollection,
				    CAlgorithm & inAlgorithm){
  if(inBaseType=="inverted_file"){
    return(new CQInvertedFile(inAccessorCollection,
			      inAlgorithm));
  }
#ifdef __GIFT_BAYESIAN__
  if(inBaseType=="bayesian"){
    return(new CIFQuickAndDirtyHunter(inAccessorCollection,
				      inAlgorithm));
  }
#endif
#ifdef __GIFT_WITH_PERL__
  if(inBaseType=="perl"){
    return(new CQPerl(inAccessorCollection,
		      inAlgorithm));
  }
#endif
//   if(inBaseType=="parallel"){
//     return(new CQParallel(inAccessorCollection,
// 			  inAlgorithm));
//   }
  if(inBaseType=="multiple"){
    return(new CQMultiple(inAccessorCollection,
			  inAlgorithm));
  }
#ifdef __GIFT_UNPUBLISHED_WORK__
  if(inBaseType=="fer_de_lance"){
    return(new CQIFFerDeLance(inAccessorCollection,
			      inAlgorithm));
  }
#endif
  if(inBaseType=="hierarchy"){
    return(new CQHierarchy(inAccessorCollection,
			   inAlgorithm));
  }
  my_throw(VEWrongBaseType(inBaseType.c_str()));
}
