/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;

public class ImmutableArrayList<E>
extends ArrayList<E> {
    private static final ImmutableArrayList<?> EMPTY = new ImmutableArrayList<Object>(new Object[0]);

    public static <T> ImmutableArrayList<T> of(Collection<? extends T> c) {
        if (c.isEmpty()) {
            return EMPTY;
        }
        return new ImmutableArrayList<T>(c);
    }

    public static <T> ImmutableArrayList<T> of(T ... elems) {
        if (elems.length == 0) {
            return EMPTY;
        }
        return new ImmutableArrayList<T>(elems);
    }

    private ImmutableArrayList(Collection<? extends E> c) {
        super(c.size());
        super.addAll(c);
        if (this.size() != c.size()) {
            throw new ConcurrentModificationException();
        }
    }

    private ImmutableArrayList(E ... a) {
        super(a.length);
        for (E e : a) {
            super.add(e);
        }
        assert (this.size() == a.length);
    }

    public ImmutableArrayList(E[] a, int fromIndex, int toIndex) {
        super(toIndex - fromIndex);
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > a.length) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            super.add(a[i]);
        }
        assert (this.size() == toIndex - fromIndex);
    }

    public ImmutableArrayList<E> with(E[] a) {
        int l;
        if (a == null) {
            return this;
        }
        for (l = a.length; l > 0 && a[l - 1] == null; --l) {
        }
        if (l == this.size()) {
            int i;
            for (i = 0; i < this.size() && a[i] == this.get(i); ++i) {
            }
            if (i == l) {
                return this;
            }
        }
        return new ImmutableArrayList<E>(a, 0, l);
    }

    @Override
    public void trimToSize() {
    }

    @Override
    public void ensureCapacity(int minCapacity) {
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }
}

