/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.IconParameters;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CompileVerilogStruct {
    private List<VModule> allModules;
    private int errorCount;
    private ErrorLogger errorLogger;
    private boolean hasParentLogger;
    private boolean verbose;
    private boolean hasErrors;
    private VModule curModule;
    private List<TokenList> tList;
    private int tokenIndex;
    private static final int MODE_UNKNOWN = 0;
    private static final int MODE_IN = 1;
    private static final int MODE_OUT = 2;
    private static final int MODE_INOUT = 3;

    public CompileVerilogStruct(File f2, boolean verbose, ErrorLogger logger) {
        this.verbose = verbose;
        try {
            String line;
            InputStreamReader is = new InputStreamReader(new FileInputStream(f2));
            LineNumberReader lineReader = new LineNumberReader(is);
            ArrayList<String> stringList = new ArrayList<String>();
            while ((line = lineReader.readLine()) != null) {
                stringList.add(line);
            }
            String[] strings = new String[stringList.size()];
            for (int i = 0; i < stringList.size(); ++i) {
                strings[i] = (String)stringList.get(i);
            }
            this.processVerilog(strings, logger);
        }
        catch (IOException e) {
            System.out.println("Error reading file: " + e.getMessage());
            this.hasErrors = true;
            return;
        }
    }

    public CompileVerilogStruct(Cell verilogCell, boolean verbose) {
        this.verbose = verbose;
        String[] strings = verilogCell.getTextViewContents();
        if (strings == null) {
            System.out.println("Cell " + verilogCell.describe(true) + " has no text in it");
            return;
        }
        this.processVerilog(strings, null);
    }

    public CompileVerilogStruct(String[] strings, boolean verbose) {
        this.verbose = verbose;
        this.processVerilog(strings, null);
    }

    public boolean hadErrors() {
        return this.hasErrors;
    }

    public List<VModule> getModules() {
        return this.allModules;
    }

    private void processVerilog(String[] strings, ErrorLogger logger) {
        if (this.verbose) {
            Job.getUserInterface().startProgressDialog("Compiling Verilog", null);
            Job.getUserInterface().setProgressNote("Scanning...");
        }
        this.allModules = new ArrayList<VModule>();
        this.tList = new ArrayList<TokenList>();
        this.errorCount = 0;
        this.errorLogger = logger;
        this.hasParentLogger = logger != null;
        this.hasErrors = false;
        this.doScanner(strings);
        if (this.verbose) {
            Job.getUserInterface().setProgressNote("Parsing...");
            Job.getUserInterface().setProgressValue(0);
        }
        this.doParser();
        if (this.verbose) {
            Job.getUserInterface().stopProgressDialog();
        }
        for (VModule module : this.allModules) {
            for (int i = 0; i < module.wires.size(); ++i) {
                String wire = (String)module.wires.get(i);
                String assignedName = (String)module.assignments.get(wire);
                if (assignedName == null) continue;
                module.wires.remove(i);
                --i;
            }
            for (VInstance in : module.instances) {
                for (VPort lp : in.ports.keySet()) {
                    String[] signalNames = (String[])in.ports.get(lp);
                    for (int i = 0; i < signalNames.length; ++i) {
                        ArrayList<VPort> portsOnNet;
                        String assignedName = (String)module.assignments.get(signalNames[i]);
                        if (assignedName == null) {
                            assignedName = signalNames[i];
                        }
                        if ((portsOnNet = (ArrayList<VPort>)module.allNetworks.get(assignedName)) == null) {
                            portsOnNet = new ArrayList<VPort>();
                            module.allNetworks.put(assignedName, portsOnNet);
                        }
                        portsOnNet.add(lp);
                    }
                }
            }
        }
        if (this.errorLogger != null && !this.hasParentLogger) {
            this.errorLogger.termLogging(true);
        }
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    private void resetTokenListPointer() {
        this.tokenIndex = 0;
    }

    private TokenList getNextToken() {
        if (this.tokenIndex >= this.tList.size()) {
            return null;
        }
        TokenList token2 = this.tList.get(this.tokenIndex++);
        return token2;
    }

    private TokenList peekNextToken() {
        if (this.tokenIndex >= this.tList.size()) {
            return null;
        }
        return this.tList.get(this.tokenIndex);
    }

    private TokenType getTokenType(TokenList token2) {
        if (token2 == null) {
            return TokenType.UNKNOWN;
        }
        return token2.type;
    }

    private TokenList needNextToken(TokenType type) {
        TokenList token2 = this.getNextToken();
        if (token2 == null) {
            this.reportErrorMsg(null, "End of file encountered");
            return null;
        }
        if (token2.type != type) {
            this.reportErrorMsg(token2, "Expecting a " + type.getName());
            this.parseToSemicolon();
            return null;
        }
        return token2;
    }

    private void doScanner(String[] strings) {
        String buf = "";
        int bufPos = 0;
        int lineNum = 0;
        boolean space = false;
        block23: while (true) {
            int end;
            if (bufPos >= buf.length()) {
                if (lineNum >= strings.length) {
                    return;
                }
                buf = strings[lineNum++];
                if (this.verbose && lineNum % 100 == 0) {
                    Job.getUserInterface().setProgressValue(lineNum * 100 / strings.length);
                }
                bufPos = 0;
                space = true;
            } else {
                space = Character.isWhitespace(buf.charAt(bufPos));
            }
            while (bufPos < buf.length() && Character.isWhitespace(buf.charAt(bufPos))) {
                ++bufPos;
            }
            if (bufPos >= buf.length()) continue;
            char c = buf.charAt(bufPos);
            if (Character.isLetter(c)) {
                char eChar;
                for (end = bufPos; end < buf.length() && (Character.isLetterOrDigit(eChar = buf.charAt(end)) || eChar == '_'); ++end) {
                }
                VKeyword key = VKeyword.findKeyword(buf.substring(bufPos, end));
                if (key != null) {
                    new TokenList(TokenType.KEYWORD, key, lineNum, space);
                } else {
                    String ident2 = buf.substring(bufPos, end);
                    new TokenList(TokenType.IDENTIFIER, ident2, lineNum, space);
                }
                bufPos = end;
                continue;
            }
            if (TextUtils.isDigit(c)) {
                char eChar;
                for (end = bufPos + 1; end < buf.length() && (TextUtils.isDigit(eChar = buf.charAt(end)) || eChar == '_'); ++end) {
                }
                new TokenList(TokenType.DECIMAL, buf.substring(bufPos, end), lineNum, space);
                bufPos = end;
                continue;
            }
            switch (c) {
                case '\\': {
                    for (end = bufPos + 1; end < buf.length() && buf.charAt(end) != '\n' && !Character.isWhitespace(buf.charAt(end)); ++end) {
                    }
                    String ident3 = buf.substring(bufPos + 1, end);
                    new TokenList(TokenType.IDENTIFIER, ident3, lineNum, space);
                    bufPos = end;
                    continue block23;
                }
                case '/': {
                    if (end < buf.length() && buf.charAt(end) == '/') {
                        for (end = bufPos + 1; end < buf.length() && buf.charAt(end) != '\n'; ++end) {
                        }
                        if (end >= buf.length() || buf.charAt(end) == '\n') {
                            // empty if block
                        }
                        bufPos = ++end;
                        continue block23;
                    }
                    if (end < buf.length() && buf.charAt(end) == '*') {
                        bufPos = end + 1;
                        while (true) {
                            if (bufPos < buf.length() - 1 && buf.charAt(bufPos) == '*' && buf.charAt(bufPos + 1) == '/') {
                                bufPos += 2;
                                continue block23;
                            }
                            if (++bufPos < buf.length() - 1) continue;
                            if (lineNum >= strings.length) {
                                return;
                            }
                            buf = strings[lineNum++];
                            if (this.verbose && lineNum % 100 == 0) {
                                Job.getUserInterface().setProgressValue(lineNum * 100 / strings.length);
                            }
                            bufPos = 0;
                            space = true;
                        }
                    }
                    new TokenList(TokenType.SLASH, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case '\"': {
                    for (end = bufPos + 1; end < buf.length() && buf.charAt(end) != '\n'; ++end) {
                        if (buf.charAt(end) != '\"') continue;
                        if (end + 1 >= buf.length() || buf.charAt(end + 1) != '\"') break;
                        ++end;
                    }
                    String newString = buf.substring(bufPos + 1, end);
                    newString.replaceAll("\"\"", "\"");
                    new TokenList(TokenType.STRING, newString, lineNum, space);
                    if (buf.charAt(end) == '\"') {
                        // empty if block
                    }
                    bufPos = ++end;
                    continue block23;
                }
                case '`': {
                    for (end = bufPos + 1; end < buf.length() && buf.charAt(end) != '\n'; ++end) {
                    }
                    if (end >= buf.length() || buf.charAt(end) == '\n') {
                        // empty if block
                    }
                    bufPos = ++end;
                    continue block23;
                }
                case '\'': {
                    if (bufPos + 2 < buf.length() && buf.charAt(bufPos + 2) == '\'') {
                        new TokenList(TokenType.CHAR, new Character(buf.charAt(bufPos + 1)), lineNum, space);
                        bufPos += 3;
                        continue block23;
                    }
                    if (this.tList.size() > 0 && bufPos < buf.length() - 1) {
                        TokenList prevTL = this.tList.get(this.tList.size() - 1);
                        char nextC = buf.charAt(bufPos + 1);
                        if (prevTL.type == TokenType.DECIMAL && Character.toLowerCase(nextC) == 'b' && bufPos + 1 < buf.length() - 1) {
                            nextC = buf.charAt(bufPos + 2);
                            String sym = null;
                            if (nextC == '1') {
                                sym = "vdd";
                            } else if (nextC == '0') {
                                sym = "gnd";
                            }
                            if (sym != null) {
                                bufPos += 3;
                                this.tList.remove(this.tList.size() - 1);
                                new TokenList(TokenType.IDENTIFIER, sym, lineNum, space);
                                continue block23;
                            }
                        }
                    }
                    new TokenList(TokenType.APOSTROPHE, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case '(': {
                    new TokenList(TokenType.LEFTPAREN, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case ')': {
                    new TokenList(TokenType.RIGHTPAREN, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case '[': {
                    new TokenList(TokenType.LEFTBRACKET, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case ']': {
                    new TokenList(TokenType.RIGHTBRACKET, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case '{': {
                    new TokenList(TokenType.LEFTBRACE, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case '}': {
                    new TokenList(TokenType.RIGHTBRACE, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case ',': {
                    new TokenList(TokenType.COMMA, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case '?': {
                    new TokenList(TokenType.QUESTION, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case '#': {
                    new TokenList(TokenType.HASH, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case '~': {
                    new TokenList(TokenType.TILDE, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case '@': {
                    new TokenList(TokenType.ATSIGN, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case '=': {
                    new TokenList(TokenType.EQUALS, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case '-': {
                    if (bufPos + 1 < buf.length() && buf.charAt(bufPos + 1) == '-') {
                        bufPos = buf.length();
                        continue block23;
                    }
                    new TokenList(TokenType.MINUS, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case '.': {
                    if (bufPos + 1 < buf.length() && buf.charAt(bufPos + 1) == '.') {
                        new TokenList(TokenType.DOUBLEDOT, null, lineNum, space);
                        bufPos += 2;
                        continue block23;
                    }
                    new TokenList(TokenType.PERIOD, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case ':': {
                    if (bufPos + 1 < buf.length() && buf.charAt(bufPos + 1) == '=') {
                        new TokenList(TokenType.VARASSIGN, null, lineNum, space);
                        bufPos += 2;
                        continue block23;
                    }
                    new TokenList(TokenType.COLON, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
                case ';': {
                    new TokenList(TokenType.SEMICOLON, null, lineNum, space);
                    ++bufPos;
                    continue block23;
                }
            }
            new TokenList(TokenType.UNKNOWN, null, lineNum, space);
            ++bufPos;
        }
    }

    private void doParser() {
        TokenList token2;
        this.curModule = null;
        this.resetTokenListPointer();
        int tokenCount = 0;
        while ((token2 = this.getNextToken()) != null) {
            if (this.verbose && ++tokenCount % 100 == 0) {
                Job.getUserInterface().setProgressValue(this.tokenIndex * 100 / this.tList.size());
            }
            if (token2.type == TokenType.KEYWORD) {
                VKeyword vk = (VKeyword)token2.pointer;
                if (vk == VKeyword.MODULE || vk == VKeyword.PRIMITIVE) {
                    this.curModule = this.parseModule(vk == VKeyword.PRIMITIVE);
                    continue;
                }
                if (vk == VKeyword.ENDMODULE || vk == VKeyword.ENDPRIMITIVE) {
                    this.curModule = null;
                    continue;
                }
                if (vk == VKeyword.INPUT || vk == VKeyword.OUTPUT || vk == VKeyword.INOUT || vk == VKeyword.WIRE || vk == VKeyword.SUPPLY || vk == VKeyword.SUPPLY0 || vk == VKeyword.SUPPLY1) {
                    this.parseDeclare(token2);
                    continue;
                }
                if (vk == VKeyword.TRANIF0 || vk == VKeyword.TRANIF1) {
                    VInstance inst = this.parseGate(token2, vk == VKeyword.TRANIF0 ? PrimitiveNode.Function.TRAPMOS : PrimitiveNode.Function.TRANMOS);
                    if (inst == null) continue;
                    this.curModule.instances.add(inst);
                    continue;
                }
                if (vk == VKeyword.ASSIGN) {
                    this.parseAssign();
                    continue;
                }
                if (vk == VKeyword.LOGIC || vk == VKeyword.REAL || vk == VKeyword.REG || vk == VKeyword.ELECTRICAL || vk == VKeyword.PARAMETER) {
                    this.parseToSemicolon();
                    continue;
                }
                if (vk == VKeyword.ANALOG || vk == VKeyword.INITIAL) {
                    this.ignoreNextStatement();
                    continue;
                }
                if (vk == VKeyword.TABLE) {
                    this.ignoreToKeyword(VKeyword.ENDTABLE);
                    continue;
                }
                if (vk == VKeyword.SPECIFY) {
                    this.ignoreToKeyword(VKeyword.ENDSPECIFY);
                    continue;
                }
                if (vk == VKeyword.ALWAYS) {
                    this.ignoreAlwaysStatement();
                    continue;
                }
                if (vk == VKeyword.BEGIN) {
                    this.ignoreToKeyword(VKeyword.END);
                    continue;
                }
                this.reportErrorMsg(token2, "Unknown keyword");
                continue;
            }
            if (token2.type == TokenType.IDENTIFIER) {
                if (this.curModule == null) {
                    this.reportErrorMsg(token2, "Instance declaration is not inside a Module");
                    this.parseToSemicolon();
                    break;
                }
                VInstance inst = this.parseInstance(token2);
                if (inst == null) continue;
                this.curModule.instances.add(inst);
                continue;
            }
            this.reportErrorMsg(token2, "Expecting an identifier");
            this.parseToSemicolon();
        }
        for (VModule module : this.allModules) {
            for (VInstance in : module.instances) {
                if (in.module == null) continue;
                for (VPort lp : in.ports.keySet()) {
                    boolean found = false;
                    for (VExport subPort : in.module.ports) {
                        if (!subPort.name.equals(lp.portName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    VExport fp = new VExport(lp.portName);
                    in.module.ports.add(fp);
                }
            }
        }
    }

    private VModule parseModule(boolean primitive) {
        TokenList token2 = this.needNextToken(TokenType.IDENTIFIER);
        if (token2 == null) {
            return null;
        }
        String name = (String)token2.pointer;
        VModule module = this.findModule(name);
        if (module != null) {
            this.reportErrorMsg(token2, "Module already exists");
            this.parseToSemicolon();
            return null;
        }
        module = new VModule(name, true, primitive);
        token2 = this.needNextToken(TokenType.LEFTPAREN);
        if (token2 == null) {
            return null;
        }
        do {
            if ((token2 = this.needNextToken(TokenType.IDENTIFIER)) == null) {
                return null;
            }
            VExport port = new VExport((String)token2.pointer);
            module.ports.add(port);
        } while (this.getTokenType(token2 = this.getNextToken()) == TokenType.COMMA);
        if (this.getTokenType(token2) != TokenType.RIGHTPAREN) {
            this.reportErrorMsg(token2, "Expecting a right parenthesis");
            this.parseToSemicolon();
            return null;
        }
        token2 = this.needNextToken(TokenType.SEMICOLON);
        if (token2 == null) {
            return null;
        }
        return module;
    }

    private void parseDeclare(TokenList declareToken) {
        if (this.curModule == null) {
            this.reportErrorMsg(declareToken, "Not in a module");
            this.parseToSemicolon();
            return;
        }
        int mode = 1;
        VKeyword vk = (VKeyword)declareToken.pointer;
        if (vk == VKeyword.OUTPUT) {
            mode = 2;
        } else if (vk == VKeyword.INOUT) {
            mode = 3;
        }
        TokenList token2 = this.getNextToken();
        int firstRange = -1;
        int secondRange = -1;
        if (this.getTokenType(token2) == TokenType.LEFTBRACKET) {
            token2 = this.getNextToken();
            firstRange = TextUtils.atoi((String)token2.pointer);
            token2 = this.needNextToken(TokenType.COLON);
            if (token2 == null) {
                return;
            }
            token2 = this.getNextToken();
            secondRange = TextUtils.atoi((String)token2.pointer);
            token2 = this.needNextToken(TokenType.RIGHTBRACKET);
            if (token2 == null) {
                return;
            }
            token2 = this.getNextToken();
        }
        while (true) {
            if (this.getTokenType(token2) != TokenType.IDENTIFIER) {
                this.reportErrorMsg(token2, "Expected identifier");
                this.parseToSemicolon();
                return;
            }
            String idName = (String)token2.pointer;
            boolean found = false;
            if (vk == VKeyword.WIRE || vk == VKeyword.SUPPLY || vk == VKeyword.SUPPLY0 || vk == VKeyword.SUPPLY1) {
                if (firstRange != -1 && secondRange != -1) {
                    String realName;
                    if (firstRange > secondRange) {
                        for (int i = firstRange; i >= secondRange; --i) {
                            realName = idName + "[" + i + "]";
                            if (this.curModule.wires.contains(realName)) {
                                this.reportErrorMsg(token2, "Identifier " + realName + " defined twice");
                                this.parseToSemicolon();
                                return;
                            }
                            this.curModule.wires.add(realName);
                        }
                    } else {
                        for (int i = firstRange; i <= secondRange; ++i) {
                            realName = idName + "[" + i + "]";
                            if (this.curModule.wires.contains(realName)) {
                                this.reportErrorMsg(token2, "Identifier " + realName + " defined twice");
                                this.parseToSemicolon();
                                return;
                            }
                            this.curModule.wires.add(realName);
                        }
                    }
                } else {
                    if (this.curModule.wires.contains(idName)) {
                        this.reportErrorMsg(token2, "Identifier defined twice");
                        this.parseToSemicolon();
                        return;
                    }
                    this.curModule.wires.add(idName);
                }
            } else {
                for (VExport fp : this.curModule.ports) {
                    if (!fp.name.equals(idName)) continue;
                    fp.mode = mode;
                    fp.firstIndex = firstRange;
                    fp.secondIndex = secondRange;
                    found = true;
                    break;
                }
                if (!found) {
                    this.reportErrorMsg(token2, "Unknown identifier");
                    this.parseToSemicolon();
                    return;
                }
            }
            token2 = this.getNextToken();
            if (this.getTokenType(token2) != TokenType.COMMA) break;
            token2 = this.getNextToken();
        }
        if (this.getTokenType(token2) != TokenType.SEMICOLON) {
            this.reportErrorMsg(token2, "Unknown separator between identifiers");
            this.parseToSemicolon();
            return;
        }
    }

    private void parseAssign() {
        TokenList token2 = this.getNextToken();
        if (this.getTokenType(token2) == TokenType.HASH) {
            token2 = this.needNextToken(TokenType.DECIMAL);
            token2 = this.needNextToken(TokenType.IDENTIFIER);
        }
        if (this.getTokenType(token2) != TokenType.IDENTIFIER) {
            return;
        }
        String[] firstNames = this.getSignalNames(token2);
        token2 = this.needNextToken(TokenType.EQUALS);
        if (token2 == null) {
            return;
        }
        token2 = this.getNextToken();
        if (this.getTokenType(token2) == TokenType.TILDE) {
            token2 = this.getNextToken();
        }
        if (this.getTokenType(token2) == TokenType.LEFTPAREN) {
            while (this.getTokenType(token2 = this.getNextToken()) != TokenType.RIGHTPAREN) {
            }
            token2 = this.needNextToken(TokenType.SEMICOLON);
            return;
        }
        if (this.getTokenType(token2) != TokenType.IDENTIFIER) {
            return;
        }
        String[] secondNames = this.getSignalNames(token2);
        token2 = this.needNextToken(TokenType.SEMICOLON);
        if (token2 == null) {
            return;
        }
        if (firstNames.length != secondNames.length) {
            this.reportErrorMsg(token2, "Assigning unequal length busses (first part is " + firstNames.length + " long, second part is " + secondNames.length + " long)");
            return;
        }
        for (int i = 0; i < firstNames.length; ++i) {
            this.curModule.assignments.put(secondNames[i], firstNames[i]);
        }
    }

    private VInstance parseInstance(TokenList token2) {
        String cellName = (String)token2.pointer;
        token2 = this.getNextToken();
        if (this.getTokenType(token2) == TokenType.HASH) {
            token2 = this.getNextToken();
            if (this.getTokenType(token2) == TokenType.LEFTPAREN) {
                while (this.getTokenType(token2 = this.getNextToken()) != TokenType.RIGHTPAREN) {
                }
            }
            token2 = this.getNextToken();
        }
        if (this.getTokenType(token2) != TokenType.IDENTIFIER) {
            this.reportErrorMsg(token2, "Expecting an instance name identifier");
            this.parseToSemicolon();
            return null;
        }
        String instanceName = (String)token2.pointer;
        token2 = this.needNextToken(TokenType.LEFTPAREN);
        if (token2 == null) {
            return null;
        }
        VModule module = this.findModule(cellName);
        if (module == null) {
            module = new VModule(cellName, false, false);
        }
        VInstance inst = new VInstance(module, instanceName);
        int argNum = 1;
        while (this.getTokenType(token2 = this.getNextToken()) != TokenType.RIGHTPAREN) {
            String[] sigNames;
            String portName = "ARG" + argNum;
            ++argNum;
            if (this.getTokenType(token2) == TokenType.PERIOD) {
                token2 = this.needNextToken(TokenType.IDENTIFIER);
                if (token2 == null) {
                    return null;
                }
                portName = (String)token2.pointer;
                token2 = this.needNextToken(TokenType.LEFTPAREN);
                if (token2 == null) {
                    return null;
                }
                token2 = this.getNextToken();
                if (this.getTokenType(token2) == TokenType.LEFTBRACE) {
                    int i;
                    ArrayList<String> signalNames;
                    block22: {
                        signalNames = new ArrayList<String>();
                        do {
                            if (this.getTokenType(token2 = this.getNextToken()) != TokenType.IDENTIFIER) {
                                this.reportErrorMsg(token2, "Expecting an identifier");
                                this.parseToSemicolon();
                                return null;
                            }
                            String[] sns = this.getSignalNames(token2);
                            for (i = 0; i < sns.length; ++i) {
                                signalNames.add(sns[i]);
                            }
                            token2 = this.getNextToken();
                            if (this.getTokenType(token2) == TokenType.RIGHTBRACE) break block22;
                        } while (this.getTokenType(token2) == TokenType.COMMA);
                        this.reportErrorMsg(token2, "Expecting a comma");
                        this.parseToSemicolon();
                        return null;
                    }
                    String[] sigNames2 = new String[signalNames.size()];
                    for (i = 0; i < signalNames.size(); ++i) {
                        sigNames2[i] = (String)signalNames.get(i);
                    }
                    inst.addConnection(new VPort(inst, portName, true), sigNames2);
                } else {
                    if (this.getTokenType(token2) != TokenType.IDENTIFIER) {
                        this.reportErrorMsg(token2, "Expecting an identifier");
                        this.parseToSemicolon();
                        return null;
                    }
                    sigNames = this.getSignalNames(token2);
                    inst.addConnection(new VPort(inst, portName, sigNames.length > 1), sigNames);
                }
                token2 = this.needNextToken(TokenType.RIGHTPAREN);
                if (token2 == null) {
                    return null;
                }
            } else if (this.getTokenType(token2) == TokenType.IDENTIFIER) {
                sigNames = this.getSignalNames(token2);
                inst.addConnection(new VPort(inst, portName, sigNames.length > 1), sigNames);
            } else {
                this.reportErrorMsg(token2, "Unknown separator between identifiers");
                this.parseToSemicolon();
                return null;
            }
            if (this.getTokenType(token2 = this.getNextToken()) == TokenType.RIGHTPAREN) break;
            if (this.getTokenType(token2) == TokenType.COMMA) continue;
            this.reportErrorMsg(token2, "Expecting a comma");
            this.parseToSemicolon();
            return null;
        }
        token2 = this.needNextToken(TokenType.SEMICOLON);
        if (token2 == null) {
            return null;
        }
        return inst;
    }

    private VInstance parseGate(TokenList declareToken, PrimitiveNode.Function fun) {
        if (this.curModule == null) {
            this.reportErrorMsg(declareToken, "Not in a module");
            this.parseToSemicolon();
            return null;
        }
        TokenList token2 = this.needNextToken(TokenType.IDENTIFIER);
        if (token2 == null) {
            return null;
        }
        String instanceName = (String)token2.pointer;
        token2 = this.needNextToken(TokenType.LEFTPAREN);
        if (token2 == null) {
            return null;
        }
        VInstance inst = new VInstance(fun, instanceName);
        int argNum = 1;
        while (this.getTokenType(token2 = this.getNextToken()) != TokenType.RIGHTPAREN) {
            String portName = null;
            switch (argNum++) {
                case 1: {
                    portName = "s";
                    break;
                }
                case 2: {
                    portName = "d";
                    break;
                }
                case 3: {
                    portName = "g";
                }
            }
            if (this.getTokenType(token2) != TokenType.IDENTIFIER) {
                this.reportErrorMsg(token2, "Unknown separator between identifiers");
                this.parseToSemicolon();
                return null;
            }
            String[] sigNames = this.getSignalNames(token2);
            inst.addConnection(new VPort(inst, portName, sigNames.length > 1), sigNames);
            token2 = this.getNextToken();
            if (this.getTokenType(token2) == TokenType.RIGHTPAREN) break;
            if (this.getTokenType(token2) == TokenType.COMMA) continue;
            this.reportErrorMsg(token2, "Expecting a comma");
            this.parseToSemicolon();
            return null;
        }
        token2 = this.needNextToken(TokenType.SEMICOLON);
        if (token2 == null) {
            return null;
        }
        return inst;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] getSignalNames(TokenList token2) {
        ArrayList<String> signalNames = new ArrayList<String>();
        if (this.getTokenType(token2) == TokenType.IDENTIFIER) {
            String signalName = (String)token2.pointer;
            TokenList next2 = this.peekNextToken();
            if (this.getTokenType(next2) == TokenType.LEFTBRACKET) {
                this.getNextToken();
                TokenList index = this.needNextToken(TokenType.DECIMAL);
                if (index == null) {
                    return new String[0];
                }
                TokenList nxt = this.getNextToken();
                if (this.getTokenType(nxt) == TokenType.COLON) {
                    int i;
                    int endIndex;
                    TokenList index2 = this.needNextToken(TokenType.DECIMAL);
                    if (index2 == null) {
                        return new String[0];
                    }
                    TokenList cls = this.needNextToken(TokenType.RIGHTBRACKET);
                    if (cls == null) {
                        return new String[0];
                    }
                    int startIndex = TextUtils.atoi((String)index.pointer);
                    if (startIndex < (endIndex = TextUtils.atoi((String)index2.pointer))) {
                        for (i = startIndex; i <= endIndex; ++i) {
                            signalNames.add(signalName + "[" + i + "]");
                        }
                    } else {
                        for (i = startIndex; i >= endIndex; --i) {
                            signalNames.add(signalName + "[" + i + "]");
                        }
                    }
                } else {
                    if (this.getTokenType(nxt) != TokenType.RIGHTBRACKET) return new String[0];
                    signalNames.add(signalName + "[" + (String)index.pointer + "]");
                }
            } else {
                boolean foundBus = false;
                for (String wire : this.curModule.wires) {
                    if (!wire.startsWith(signalName) || wire.length() <= signalName.length() || wire.charAt(signalName.length()) != '[') continue;
                    signalNames.add(wire);
                    foundBus = true;
                }
                if (!foundBus) {
                    for (VExport fp : this.curModule.ports) {
                        int i;
                        if (!fp.name.equals(signalName)) continue;
                        if (fp.firstIndex < fp.secondIndex) {
                            foundBus = true;
                            for (i = fp.firstIndex; i <= fp.secondIndex; ++i) {
                                signalNames.add(signalName + "[" + i + "]");
                            }
                            continue;
                        }
                        if (fp.firstIndex <= fp.secondIndex) continue;
                        foundBus = true;
                        for (i = fp.firstIndex; i >= fp.secondIndex; --i) {
                            signalNames.add(signalName + "[" + i + "]");
                        }
                    }
                }
                if (!foundBus) {
                    signalNames.add(signalName);
                }
            }
        }
        String[] sigNames = new String[signalNames.size()];
        for (int i = 0; i < signalNames.size(); ++i) {
            sigNames[i] = (String)signalNames.get(i);
        }
        return sigNames;
    }

    private VModule findModule(String name) {
        for (VModule mod : this.allModules) {
            if (!mod.name.equals(name)) continue;
            return mod;
        }
        return null;
    }

    private void ignoreAlwaysStatement() {
        TokenList token2 = this.needNextToken(TokenType.ATSIGN);
        if (token2 == null) {
            return;
        }
        this.ignoreParentheticalClause();
        this.ignoreNextStatement();
    }

    private void ignoreIfStatement() {
        this.ignoreParentheticalClause();
        this.ignoreNextStatement();
        TokenList token2 = this.peekNextToken();
        if (token2.type == TokenType.KEYWORD && (VKeyword)token2.pointer == VKeyword.ELSE) {
            this.getNextToken();
            this.ignoreNextStatement();
        }
    }

    private void parseToSemicolon() {
        TokenList token2;
        while ((token2 = this.getNextToken()) != null && token2.type != TokenType.SEMICOLON) {
        }
    }

    private void ignoreNextStatement() {
        TokenList token2;
        while ((token2 = this.getNextToken()).type != TokenType.SEMICOLON) {
            if (token2.type != TokenType.KEYWORD) continue;
            VKeyword vk = (VKeyword)token2.pointer;
            if (vk == VKeyword.BEGIN) {
                this.ignoreUntilEndOfStatement(VKeyword.END, 0);
                break;
            }
            if (vk != VKeyword.IF) continue;
            this.ignoreIfStatement();
            break;
        }
    }

    private void ignoreParentheticalClause() {
        int numParens = 0;
        while (true) {
            TokenList token2;
            if ((token2 = this.getNextToken()).type == TokenType.LEFTPAREN) {
                ++numParens;
                continue;
            }
            if (token2.type == TokenType.RIGHTPAREN && --numParens <= 0) break;
        }
    }

    private void ignoreToKeyword(VKeyword keyword2) {
        this.ignoreUntilEndOfStatement(keyword2, 0);
    }

    private void ignoreUntilEndOfStatement(VKeyword keyword2, int nestedLoop) {
        while (true) {
            TokenList token2;
            if ((token2 = this.getNextToken()) == null) {
                return;
            }
            if (token2.type != TokenType.KEYWORD) continue;
            VKeyword vk = (VKeyword)token2.pointer;
            if (vk == VKeyword.BEGIN) {
                this.ignoreUntilEndOfStatement(VKeyword.END, nestedLoop + 1);
                continue;
            }
            if (vk == keyword2 && nestedLoop == 0) break;
        }
    }

    private void reportErrorMsg(TokenList tList, String errMsg) {
        String msg;
        this.hasErrors = true;
        ++this.errorCount;
        if (this.errorCount == 30) {
            msg = "TOO MANY ERRORS...PRINTING NO MORE";
            if (this.verbose) {
                System.out.println(msg);
            } else {
                if (this.errorLogger == null) {
                    this.errorLogger = ErrorLogger.newInstance("Compile Verilog");
                }
                this.errorLogger.logError(msg, 0);
            }
        }
        if (this.errorCount >= 30) {
            return;
        }
        if (tList == null) {
            msg = "ERROR " + errMsg;
            if (this.verbose) {
                System.out.println(msg);
            } else {
                if (this.errorLogger == null) {
                    this.errorLogger = ErrorLogger.newInstance("Compile Verilog");
                }
                this.errorLogger.logError(msg, 0);
            }
            return;
        }
        msg = "ERROR on line " + tList.lineNum + ", " + errMsg + ":";
        StringBuffer buffer = new StringBuffer();
        int pointer = tList.makeErrorLine(buffer);
        if (this.verbose) {
            System.out.println(msg);
            System.out.println(buffer.toString());
            buffer = new StringBuffer();
            for (int i = 0; i < pointer; ++i) {
                buffer.append(" ");
            }
            System.out.println(buffer.toString() + "^");
        } else {
            if (this.errorLogger == null) {
                this.errorLogger = ErrorLogger.newInstance("Compile Verilog");
            }
            this.errorLogger.logError(msg + " " + buffer.toString(), 0);
        }
    }

    public Cell genCell(Library destLib, boolean schematic, EditingPreferences ep, IconParameters ip) {
        if (this.hasErrors()) {
            return null;
        }
        HashMap<NodeProto, Map<PortProto, Point2D>> portLocMap = new HashMap<NodeProto, Map<PortProto, Point2D>>();
        if (this.verbose) {
            Job.getUserInterface().startProgressDialog("Building Rats-Nest Cells", null);
        }
        Cell cell = null;
        for (VModule mod : this.allModules) {
            PortInst pi;
            if (!mod.defined) continue;
            String cellName = mod.name + (schematic ? "{sch}" : "{lay}");
            System.out.println("Creating cell " + cellName);
            if (this.verbose) {
                Job.getUserInterface().setProgressNote("Creating Nodes in Cell " + cellName);
                Job.getUserInterface().setProgressValue(0);
            }
            if ((cell = Cell.makeInstance(ep, destLib, cellName)) == null) {
                if (this.verbose) {
                    Job.getUserInterface().stopProgressDialog();
                }
                return null;
            }
            double GAP = 15.0;
            double x2 = 0.0;
            double y = 0.0;
            double highest = 0.0;
            double totalSize = 0.0;
            for (VInstance in : mod.instances) {
                double height;
                double width;
                if (in.module == null) {
                    PrimitiveNode tranNP = Schematics.tech().transistorNode;
                    width = tranNP.getDefWidth(ep);
                    height = tranNP.getDefHeight(ep);
                    totalSize += (width + GAP) * (height + GAP);
                    continue;
                }
                Cell subCell = in.module.cell;
                if (subCell == null) continue;
                width = subCell.getDefWidth();
                height = subCell.getDefHeight();
                totalSize += (width + GAP) * (height + GAP);
            }
            double cellSize = Math.sqrt(totalSize);
            HashMap<VInstance, NodeInst> placed = new HashMap<VInstance, NodeInst>();
            int instancesPlaced = 0;
            for (VInstance in : mod.instances) {
                Comparable<PrimitiveNode> np;
                NodeInst ni = null;
                double width = 0.0;
                double height = 0.0;
                if (in.module != null) {
                    np = in.module.cell;
                    if (np != null) {
                        width = np.getDefWidth(ep);
                        height = np.getDefHeight(ep);
                        ni = NodeInst.makeInstance(np, ep, EPoint.fromLambda(x2, y), width, height, cell, Orientation.IDENT, in.instanceName);
                    }
                } else {
                    np = Schematics.tech().transistorNode;
                    width = np.getDefWidth(ep);
                    height = np.getDefHeight(ep);
                    ni = NodeInst.makeInstance(np, ep, (Point2D)EPoint.fromLambda(x2, y), width, height, cell, Orientation.R, in.instanceName, in.fun);
                }
                if (ni == null) continue;
                placed.put(in, ni);
                HashMap<PortProto, Point2D.Double> portMap = (HashMap<PortProto, Point2D.Double>)portLocMap.get(np);
                if (portMap == null) {
                    portMap = new HashMap<PortProto, Point2D.Double>();
                    portLocMap.put((NodeProto)((Object)np), (Map<PortProto, Point2D>)portMap);
                    Iterator<PortInst> it = ni.getPortInsts();
                    while (it.hasNext()) {
                        PortInst pi2 = it.next();
                        PortProto pp = pi2.getPortProto();
                        EPoint ept = pi2.getCenter();
                        Point2D.Double pt = new Point2D.Double(ept.getX() - ni.getAnchorCenterX(), ept.getY() - ni.getAnchorCenterY());
                        portMap.put(pp, pt);
                    }
                }
                if (this.verbose && ++instancesPlaced % 100 == 0) {
                    Job.getUserInterface().setProgressValue(instancesPlaced * 100 / mod.instances.size());
                }
                x2 += width + GAP;
                highest = Math.max(highest, height);
                if (!(x2 >= cellSize)) continue;
                x2 = 0.0;
                y += highest + GAP;
                highest = 0.0;
            }
            if (instancesPlaced > 0) {
                System.out.println("Placed " + instancesPlaced + " instances");
            }
            Netlist nl = cell.getNetlist();
            HashSet<VInstance> notFound = new HashSet<VInstance>();
            for (String netName : mod.allNetworks.keySet()) {
                List ports = (List)mod.allNetworks.get(netName);
                HashSet<Network> used = new HashSet<Network>();
                for (int i = 0; i < ports.size(); ++i) {
                    VPort lp = (VPort)ports.get(i);
                    NodeInst ni = (NodeInst)placed.get(lp.in);
                    if (ni == null) {
                        this.hasErrors = true;
                        notFound.add(lp.in);
                        continue;
                    }
                    PortInst pi3 = this.findPortOnNode(ni, lp.portName);
                    if (pi3 == null) {
                        return null;
                    }
                    if (this.getPortWidth(pi3, nl) > 1) continue;
                    Network net = nl.getNetwork(pi3);
                    if (used.contains(net)) {
                        ports.remove(i);
                        --i;
                        continue;
                    }
                    used.add(net);
                }
            }
            for (VInstance in : notFound) {
                System.out.println("ERROR: Cannot find instance " + in.instanceName + " of module " + in.module.name);
            }
            if (this.verbose) {
                Job.getUserInterface().setProgressNote("Creating Arcs in Cell " + cellName);
                Job.getUserInterface().setProgressValue(0);
            }
            int total = 0;
            for (String netName : mod.allNetworks.keySet()) {
                List ports = (List)mod.allNetworks.get(netName);
                for (int i = 1; i < ports.size(); ++i) {
                    ++total;
                }
            }
            for (VInstance in : mod.instances) {
                if (in.module == null) continue;
                for (VPort lp : in.ports.keySet()) {
                    String name;
                    ArcProto ap;
                    PrimitiveNode np;
                    NodeInst ni;
                    String[] signals = (String[])in.ports.get(lp);
                    if (signals.length == 1) continue;
                    boolean allScalar = true;
                    for (int i = 0; i < signals.length; ++i) {
                        if (signals[i].indexOf(91) < 0) continue;
                        allScalar = false;
                        break;
                    }
                    if (allScalar || (ni = (NodeInst)placed.get(in)) == null) continue;
                    PortProto pp = null;
                    Iterator<PortProto> it = ni.getProto().getPorts();
                    while (it.hasNext()) {
                        PortProto ppTry = it.next();
                        String tryName = ppTry.getName();
                        if (tryName.equals(lp.portName)) {
                            pp = ppTry;
                            break;
                        }
                        if (!tryName.startsWith(lp.portName) || tryName.length() <= lp.portName.length() || tryName.charAt(lp.portName.length()) != '[') continue;
                        pp = ppTry;
                        break;
                    }
                    if (pp == null) {
                        System.out.println("Cannot find port " + lp.portName + " on cell " + ni.getProto().describe(false));
                        continue;
                    }
                    if (pp == null) continue;
                    pi = ni.findPortInstFromEquivalentProto(pp);
                    EPoint piLoc = pi.getCenter();
                    double dX = 0.0;
                    double dY = 0.0;
                    double leftDist = Math.abs(piLoc.getX() - ni.getBounds().getMinX());
                    double rightDist = Math.abs(piLoc.getX() - ni.getBounds().getMaxX());
                    double downDist = Math.abs(piLoc.getY() - ni.getBounds().getMinY());
                    double upDist = Math.abs(piLoc.getY() - ni.getBounds().getMaxY());
                    double minDist = Math.min(Math.min(leftDist, rightDist), Math.min(upDist, downDist));
                    if (minDist == leftDist) {
                        dX = -5.0;
                    } else if (minDist == rightDist) {
                        dX = 5.0;
                    } else {
                        dY = minDist == upDist ? 5.0 : -5.0;
                    }
                    EPoint busPinLoc = EPoint.fromLambda(piLoc.getX() + dX, piLoc.getY() + dY);
                    if (signals.length == 1) {
                        np = Schematics.tech().wirePinNode;
                        ap = Schematics.tech().wire_arc;
                        if (!pi.getPortProto().getBasePort().connectsTo(ap)) {
                            ap = pi.getPortProto().getBasePort().getConnections()[0];
                            np = ap.findPinProto();
                        }
                        name = signals[0];
                    } else {
                        np = Schematics.tech().busPinNode;
                        ap = Schematics.tech().bus_arc;
                        name = this.makeBusName(signals);
                    }
                    NodeInst stubPin = NodeInst.makeInstance(np, ep, busPinLoc, np.getDefWidth(ep), np.getDefHeight(ep), cell);
                    ArcInst.makeInstance(ap, ep, pi, stubPin.getOnlyPortInst(), piLoc, busPinLoc, name);
                }
            }
            int count2 = 0;
            HashMap<String, PortInst> portMap = new HashMap<String, PortInst>();
            for (String netName : mod.allNetworks.keySet()) {
                List ports = (List)mod.allNetworks.get(netName);
                ArrayList<VPort> scalarPorts = new ArrayList<VPort>();
                for (VPort lp : ports) {
                    if (lp.onBus) continue;
                    scalarPorts.add(lp);
                }
                if (scalarPorts.size() == 1) {
                    VPort port = (VPort)scalarPorts.get(0);
                    NodeInst ni = (NodeInst)placed.get(port.in);
                    if (ni == null) continue;
                    pi = this.findPortOnNode(ni, port.portName);
                    if (pi != null) {
                        portMap.put(netName, pi);
                    }
                }
                for (int i = 1; i < scalarPorts.size(); ++i) {
                    ArcInst ai;
                    VPort fromPort = (VPort)scalarPorts.get(i - 1);
                    VPort toPort = (VPort)scalarPorts.get(i);
                    NodeInst fromNi = (NodeInst)placed.get(fromPort.in);
                    NodeInst toNi = (NodeInst)placed.get(toPort.in);
                    if (fromNi == null || toNi == null) continue;
                    PortInst fromPi = this.findPortOnNode(fromNi, fromPort.portName);
                    if (fromPi == null) {
                        return null;
                    }
                    PortInst toPi = this.findPortOnNode(toNi, toPort.portName);
                    if (toPi == null) {
                        return null;
                    }
                    portMap.put(netName, fromPi);
                    portMap.put(netName, toPi);
                    EPoint fromCtr = this.getPortCenter(fromPi, portLocMap);
                    EPoint toCtr = this.getPortCenter(toPi, portLocMap);
                    ArcProto ap = Generic.tech().unrouted_arc;
                    if (schematic && fromPi.getPortProto().getBasePort().connectsTo(Schematics.tech().wire_arc) && toPi.getPortProto().getBasePort().connectsTo(Schematics.tech().wire_arc)) {
                        ap = Schematics.tech().wire_arc;
                    }
                    if ((ai = ArcInst.makeInstance(ap, ep, fromPi, toPi, fromCtr, toCtr, netName)) != null && schematic) {
                        ai.setFixedAngle(false);
                    }
                    if (!this.verbose || ++count2 % 100 != 0) continue;
                    Job.getUserInterface().setProgressValue(count2 * 100 / total);
                }
            }
            HashMap<String, PortInst> allExports = new HashMap<String, PortInst>();
            for (VExport port : mod.ports) {
                PortInst pi4;
                PortCharacteristic pc = null;
                switch (port.mode) {
                    case 0: {
                        pc = PortCharacteristic.UNKNOWN;
                        break;
                    }
                    case 1: {
                        pc = PortCharacteristic.IN;
                        break;
                    }
                    case 2: {
                        pc = PortCharacteristic.OUT;
                        break;
                    }
                    case 3: {
                        pc = PortCharacteristic.BIDIR;
                    }
                }
                String portName = port.name;
                if (port.firstIndex != port.secondIndex) {
                    if (schematic) {
                        portName = portName + "[" + port.firstIndex + ":" + port.secondIndex + "]";
                    } else {
                        int low = Math.min(port.firstIndex, port.secondIndex);
                        int high = Math.max(port.firstIndex, port.secondIndex);
                        for (int i = low; i <= high; ++i) {
                            String thisPortName = portName + "[" + i + "]";
                            PortInst pi5 = (PortInst)portMap.get(thisPortName);
                            if (pi5 == null) {
                                VPort lp;
                                NodeInst ni;
                                List ports = (List)mod.allNetworks.get(thisPortName);
                                if (ports != null && ports.size() > 0 && (ni = (NodeInst)placed.get((lp = (VPort)ports.get(0)).in)) != null) {
                                    pi5 = ni.findPortInst(lp.portName);
                                }
                                if (pi5 == null) {
                                    PrimitiveNode np = Generic.tech().universalPinNode;
                                    ni = NodeInst.makeInstance(np, ep, EPoint.fromLambda(x2, y), np.getDefWidth(ep), np.getDefHeight(ep), cell);
                                    pi5 = ni.getOnlyPortInst();
                                    y += GAP;
                                }
                            }
                            Export.newInstance(cell, pi5, thisPortName, ep, pc);
                            allExports.put(thisPortName, pi5);
                        }
                        continue;
                    }
                }
                if ((pi4 = (PortInst)portMap.get(portName)) == null) {
                    NodeInst ni;
                    List ports = (List)mod.allNetworks.get(portName);
                    if (ports != null) {
                        VPort lp = (VPort)ports.get(0);
                        ni = (NodeInst)placed.get(lp.in);
                        if (lp != null && ni != null) {
                            pi4 = ni.findPortInst(lp.portName);
                        }
                    }
                    if (pi4 == null) {
                        PrimitiveNode np = Generic.tech().universalPinNode;
                        ni = NodeInst.makeInstance(np, ep, EPoint.fromLambda(x2, y), np.getDefWidth(ep), np.getDefHeight(ep), cell);
                        pi4 = ni.getOnlyPortInst();
                        y += GAP;
                    }
                }
                Export.newInstance(cell, pi4, portName, ep, pc);
                allExports.put(portName, pi4);
            }
            for (String name2 : mod.assignments.keySet()) {
                String name1;
                PortInst pi1;
                PortInst pi2 = (PortInst)allExports.get(name2);
                if (pi2 == null || (pi1 = (PortInst)allExports.get(name1 = (String)mod.assignments.get(name2))) == null) continue;
                ArcProto ap = Generic.tech().unrouted_arc;
                ArcInst.makeInstance(ap, ep, pi1, pi2);
            }
            if (schematic) {
                try {
                    Cell iconCell = ip.makeIconForCell(cell, ep);
                    int exampleLocation = ep.getIconGenInstanceLocation();
                    if (exampleLocation != 4) {
                        Point2D.Double iconPos = new Point2D.Double(0.0, 0.0);
                        ERectangle cellBounds = cell.getBounds();
                        ERectangle iconBounds = iconCell.getBounds();
                        double halfWidth = ((RectangularShape)iconBounds).getWidth() / 2.0;
                        double halfHeight = ((RectangularShape)iconBounds).getHeight() / 2.0;
                        switch (exampleLocation) {
                            case 0: {
                                ((Point2D)iconPos).setLocation(((RectangularShape)cellBounds).getMaxX() + halfWidth, ((RectangularShape)cellBounds).getMaxY() + halfHeight);
                                break;
                            }
                            case 1: {
                                ((Point2D)iconPos).setLocation(((RectangularShape)cellBounds).getMinX() - halfWidth, ((RectangularShape)cellBounds).getMaxY() + halfHeight);
                                break;
                            }
                            case 2: {
                                ((Point2D)iconPos).setLocation(((RectangularShape)cellBounds).getMaxX() + halfWidth, ((RectangularShape)cellBounds).getMinY() - halfHeight);
                                break;
                            }
                            case 3: {
                                ((Point2D)iconPos).setLocation(((RectangularShape)cellBounds).getMinX() - halfWidth, ((RectangularShape)cellBounds).getMinY() - halfHeight);
                            }
                        }
                        DBMath.gridAlign(iconPos, ep.getAlignmentToGrid());
                        double px = iconCell.getBounds().getWidth();
                        double py = iconCell.getBounds().getHeight();
                        NodeInst.makeInstance(iconCell, ep, iconPos, px, py, cell);
                    }
                }
                catch (JobException e) {
                    // empty catch block
                }
            }
            if (count2 > 0) {
                System.out.println("Created " + count2 + " wires");
            }
            if (!this.verbose) continue;
            Job.getUserInterface().stopProgressDialog();
        }
        if (this.verbose) {
            Job.getUserInterface().stopProgressDialog();
        }
        return cell;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String makeBusName(String[] signals) {
        String prefix;
        int lastIndex;
        int startIndex;
        boolean breakBus;
        block17: {
            breakBus = false;
            startIndex = 0;
            lastIndex = 0;
            int dir = 0;
            int braPos = signals[0].indexOf(91);
            prefix = null;
            if (braPos < 0) break block17;
            prefix = signals[0].substring(0, braPos);
            for (int i = 0; i < signals.length; ++i) {
                int ind;
                block16: {
                    block18: {
                        braPos = signals[i].indexOf(91);
                        if (braPos < 0) {
                            breakBus = true;
                            break;
                        }
                        String pre = signals[i].substring(0, braPos);
                        if (!pre.equals(prefix)) {
                            breakBus = true;
                            break;
                        }
                        int cloPos = signals[i].indexOf(93, braPos);
                        if (cloPos < 0) {
                            breakBus = true;
                            break;
                        }
                        String index = signals[i].substring(braPos + 1, cloPos);
                        if (!TextUtils.isANumber(index)) {
                            breakBus = true;
                            break;
                        }
                        ind = TextUtils.atoi(index);
                        if (cloPos + 1 != signals[i].length()) {
                            breakBus = true;
                            break;
                        }
                        if (i == 0) {
                            startIndex = ind;
                            continue;
                        }
                        if (i != 1) break block18;
                        if (ind == startIndex + 1) {
                            dir = 1;
                            break block16;
                        } else if (ind == startIndex - 1) {
                            dir = -1;
                            break block16;
                        } else {
                            breakBus = true;
                            break;
                        }
                    }
                    if (ind != lastIndex + dir) {
                        breakBus = true;
                        break;
                    }
                }
                lastIndex = ind;
            }
        }
        if (!breakBus) {
            return prefix + "[" + startIndex + ":" + lastIndex + "]";
        }
        String name = "";
        int i = 0;
        while (i < signals.length) {
            if (i > 0) {
                name = name + ",";
            }
            name = name + signals[i];
            ++i;
        }
        return name;
    }

    private int getPortWidth(PortInst pi, Netlist nl) {
        int busWidth = 1;
        if (pi.getNodeInst().isCellInstance()) {
            busWidth = nl.getBusWidth((Export)pi.getPortProto());
        }
        return busWidth;
    }

    private PortInst findPortOnNode(NodeInst ni, String portName) {
        PortInst pi = ni.findPortInst(portName);
        if (pi != null) {
            return pi;
        }
        String desiredName = portName;
        int bracketPos = desiredName.indexOf(91);
        if (bracketPos >= 0) {
            desiredName = desiredName.substring(0, bracketPos);
        }
        Iterator<PortInst> it = ni.getPortInsts();
        while (it.hasNext()) {
            PortInst pInst = it.next();
            String pName = pInst.getPortProto().getName();
            bracketPos = pName.indexOf(91);
            if (bracketPos >= 0) {
                pName = pName.substring(0, bracketPos);
            }
            if (!pName.equals(desiredName)) continue;
            if (pi != null) {
                pi = null;
                break;
            }
            pi = pInst;
        }
        if (pi != null) {
            return pi;
        }
        this.hasErrors = true;
        System.out.println("Cannot find port " + portName + " on node " + ni.describe(false));
        System.out.println("Check errors reported.");
        if (this.verbose) {
            Job.getUserInterface().stopProgressDialog();
        }
        return null;
    }

    private EPoint getPortCenter(PortInst pi, Map<NodeProto, Map<PortProto, Point2D>> portLocMap) {
        NodeInst ni = pi.getNodeInst();
        Map<PortProto, Point2D> portMap = portLocMap.get(ni.getProto());
        Point2D pt = portMap.get(pi.getPortProto());
        return EPoint.fromLambda(pt.getX() + ni.getAnchorCenterX(), pt.getY() + ni.getAnchorCenterY());
    }

    public List<String> getALSNetlist(Library destLib) {
        if (this.hasErrors) {
            return null;
        }
        ArrayList<String> netlist = new ArrayList<String>();
        netlist.add("#*************************************************");
        netlist.add("#  ALS Netlist file");
        netlist.add("#");
        if (User.isIncludeDateAndVersionInOutput()) {
            netlist.add("#  File Creation:    " + TextUtils.formatDate(new Date()));
        }
        netlist.add("#*************************************************");
        netlist.add("");
        for (VModule mod : this.allModules) {
            if (!mod.defined) continue;
            this.genALSInterface(mod, netlist);
        }
        netlist.add("#********* End of netlist *******************");
        return netlist;
    }

    private void genALSInterface(VModule module, List<String> netlist) {
        String modLine = "model " + module.name + "(";
        boolean first = true;
        for (VExport fp : module.ports) {
            for (int i = fp.firstIndex; i <= fp.secondIndex; ++i) {
                if (!first) {
                    modLine = modLine + ", ";
                }
                first = false;
                modLine = modLine + fp.name;
                if (i == -1) continue;
                modLine = modLine + "_" + i + "_";
            }
        }
        modLine = modLine + ")";
        netlist.add(modLine);
        for (VInstance in : module.instances) {
            first = true;
            String inName = in.instanceName.replaceAll("/", "_").replaceAll("\\[", "_").replaceAll("\\]", "_");
            String inLine = inName + ": " + in.module.name + "(";
            for (VPort lp : in.ports.keySet()) {
                if (!first) {
                    inLine = inLine + ", ";
                }
                first = false;
                String[] signalNames = (String[])in.ports.get(lp);
                for (int i = 0; i < signalNames.length; ++i) {
                    String name = signalNames[i].replaceAll("/", "_").replaceAll("\\[", "_").replaceAll("\\]", "_");
                    inLine = inLine + name;
                }
            }
            inLine = inLine + ")";
            netlist.add(inLine);
        }
        netlist.add("");
    }

    public List<String> getQUISCNetlist(Library destLib, boolean isIncludeDateAndVersionInOutput) {
        if (this.hasErrors) {
            return null;
        }
        ArrayList<String> netlist = new ArrayList<String>();
        netlist.add("!*************************************************");
        netlist.add("!  QUISC Command file");
        netlist.add("!");
        if (isIncludeDateAndVersionInOutput) {
            netlist.add("!  File Creation:    " + TextUtils.formatDate(new Date()));
        }
        netlist.add("!-------------------------------------------------");
        netlist.add("");
        for (VModule mod : this.allModules) {
            if (!mod.defined) continue;
            this.genQuiscInterface(mod, netlist);
        }
        netlist.add("!********* End of command file *******************");
        return netlist;
    }

    private void genQuiscInterface(VModule module, List<String> netlist) {
        netlist.add("create cell " + module.name);
        for (VInstance in : module.instances) {
            netlist.add("create instance " + in.instanceName + " " + in.module.name);
        }
        for (String netName : module.allNetworks.keySet()) {
            List ports = (List)module.allNetworks.get(netName);
            VPort last2 = null;
            for (VPort lp : ports) {
                if (last2 != null) {
                    netlist.add("connect " + last2.in.instanceName + " " + last2.portName + " " + lp.in.instanceName + " " + lp.portName);
                }
                last2 = lp;
            }
        }
        for (VExport port : module.ports) {
            for (int i = port.firstIndex; i <= port.secondIndex; ++i) {
                String name = port.name;
                if (i != -1) {
                    name = name + "[" + i + "]";
                }
                boolean found = false;
                for (VInstance in : module.instances) {
                    for (VPort lp : in.ports.keySet()) {
                        String[] signalNames = (String[])in.ports.get(lp);
                        for (int j = 0; j < signalNames.length; ++j) {
                            if (!signalNames[j].equals(name)) continue;
                            String line = "export " + in.instanceName + " " + lp.portName + " " + name + " ";
                            switch (port.mode) {
                                case 0: {
                                    line = line + "unknown";
                                    break;
                                }
                                case 1: {
                                    line = line + "input";
                                    break;
                                }
                                case 2: {
                                    line = line + "output";
                                    break;
                                }
                                case 3: {
                                    line = line + "inout";
                                }
                            }
                            netlist.add(line);
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                netlist.add("! DID NOT FIND EXPORT " + name);
            }
        }
    }

    private static class VKeyword {
        private String name;
        private static List<VKeyword> theKeywords = new ArrayList<VKeyword>();
        public static final VKeyword ALWAYS = new VKeyword("always");
        public static final VKeyword ANALOG = new VKeyword("analog");
        public static final VKeyword ASSIGN = new VKeyword("assign");
        public static final VKeyword BEGIN = new VKeyword("begin");
        public static final VKeyword ELECTRICAL = new VKeyword("electrical");
        public static final VKeyword ELSE = new VKeyword("else");
        public static final VKeyword END = new VKeyword("end");
        public static final VKeyword ENDMODULE = new VKeyword("endmodule");
        public static final VKeyword ENDPRIMITIVE = new VKeyword("endprimitive");
        public static final VKeyword ENDSPECIFY = new VKeyword("endspecify");
        public static final VKeyword ENDTABLE = new VKeyword("endtable");
        public static final VKeyword IF = new VKeyword("if");
        public static final VKeyword INITIAL = new VKeyword("initial");
        public static final VKeyword INOUT = new VKeyword("inout");
        public static final VKeyword INPUT = new VKeyword("input");
        public static final VKeyword LOGIC = new VKeyword("logic");
        public static final VKeyword MODULE = new VKeyword("module");
        public static final VKeyword OUTPUT = new VKeyword("output");
        public static final VKeyword PARAMETER = new VKeyword("parameter");
        public static final VKeyword PRIMITIVE = new VKeyword("primitive");
        public static final VKeyword REAL = new VKeyword("real");
        public static final VKeyword REG = new VKeyword("reg");
        public static final VKeyword SPECIFY = new VKeyword("specify");
        public static final VKeyword SUPPLY = new VKeyword("supply");
        public static final VKeyword SUPPLY0 = new VKeyword("supply0");
        public static final VKeyword SUPPLY1 = new VKeyword("supply1");
        public static final VKeyword TABLE = new VKeyword("table");
        public static final VKeyword TRANIF0 = new VKeyword("tranif0");
        public static final VKeyword TRANIF1 = new VKeyword("tranif1");
        public static final VKeyword WIRE = new VKeyword("wire");

        VKeyword(String name) {
            this.name = name;
            theKeywords.add(this);
        }

        public static VKeyword findKeyword(String tString) {
            for (VKeyword vk : theKeywords) {
                if (!vk.name.equals(tString)) continue;
                return vk;
            }
            return null;
        }
    }

    private class TokenList {
        private TokenType type;
        private Object pointer;
        private boolean space;
        private int lineNum;

        private TokenList(TokenType type, Object pointer, int lineNum, boolean space) {
            this.type = type;
            this.pointer = pointer;
            this.lineNum = lineNum;
            this.space = true;
            CompileVerilogStruct.this.tList.add(this);
        }

        public int makeErrorLine(StringBuffer buffer) {
            int lineNumber = this.lineNum;
            for (int index = CompileVerilogStruct.this.tList.indexOf(this); index > 0 && ((TokenList)((CompileVerilogStruct)CompileVerilogStruct.this).tList.get((int)(index - 1))).lineNum == lineNumber; --index) {
            }
            int pointer = 0;
            for (int i = index; i < CompileVerilogStruct.this.tList.size(); ++i) {
                TokenList tok = (TokenList)CompileVerilogStruct.this.tList.get(i);
                if (tok.lineNum != lineNumber) break;
                if (tok == this) {
                    pointer = buffer.length();
                }
                buffer.append(tok.toString());
                if (!tok.space) continue;
                buffer.append(" ");
            }
            return pointer;
        }

        public String toString() {
            if (this.type == TokenType.STRING) {
                return "\"" + this.pointer + "\" ";
            }
            if (this.type == TokenType.KEYWORD) {
                return ((VKeyword)this.pointer).name;
            }
            if (this.type == TokenType.DECIMAL) {
                return (String)this.pointer;
            }
            if (this.type == TokenType.CHAR) {
                return ((Character)this.pointer).charValue() + "";
            }
            if (this.type == TokenType.IDENTIFIER) {
                if (this.pointer == null) {
                    return "NULL";
                }
                return this.pointer.toString();
            }
            return this.type.getChar();
        }
    }

    private static class TokenType {
        private String name;
        private String str;
        public static final TokenType LEFTPAREN = new TokenType("Left Parenthesis", "(");
        public static final TokenType RIGHTPAREN = new TokenType("Right Parenthesis", ")");
        public static final TokenType LEFTBRACKET = new TokenType("Left Bracket", "[");
        public static final TokenType RIGHTBRACKET = new TokenType("Right Bracket", "]");
        public static final TokenType LEFTBRACE = new TokenType("Left Brace", "{");
        public static final TokenType RIGHTBRACE = new TokenType("Right Brace", "}");
        public static final TokenType SLASH = new TokenType("Forward Slash", "/");
        public static final TokenType COMMA = new TokenType("Comma", ",");
        public static final TokenType MINUS = new TokenType("Minus", "-");
        public static final TokenType PERIOD = new TokenType("Period", ".");
        public static final TokenType APOSTROPHE = new TokenType("Apostrophe", "'");
        public static final TokenType QUESTION = new TokenType("Question", "?");
        public static final TokenType HASH = new TokenType("Hash", "#");
        public static final TokenType COLON = new TokenType("Colon", ":");
        public static final TokenType ATSIGN = new TokenType("At Sign", "@");
        public static final TokenType EQUALS = new TokenType("Equals", "=");
        public static final TokenType SEMICOLON = new TokenType("Semicolon", ";");
        public static final TokenType DOUBLEDOT = new TokenType("DotDot", "..");
        public static final TokenType VARASSIGN = new TokenType("Assign", "=>");
        public static final TokenType UNKNOWN = new TokenType("Unknown", "");
        public static final TokenType IDENTIFIER = new TokenType("Identifier", "");
        public static final TokenType KEYWORD = new TokenType("Keyword", "");
        public static final TokenType DECIMAL = new TokenType("Decimal Number", "");
        public static final TokenType CHAR = new TokenType("Character", "");
        public static final TokenType STRING = new TokenType("String", "");
        public static final TokenType TILDE = new TokenType("TILDE", "~");

        private TokenType(String name, String str) {
            this.name = name;
            this.str = str;
        }

        public String getName() {
            return this.name;
        }

        public String getChar() {
            return this.str;
        }
    }

    public static class VPort {
        private VInstance in;
        private String portName;
        private boolean onBus;

        public VPort(VInstance in, String portName, boolean onBus) {
            this.in = in;
            this.portName = portName;
            this.onBus = onBus;
        }
    }

    public static class VInstance {
        private VModule module;
        private PrimitiveNode.Function fun;
        private String instanceName;
        private Map<VPort, String[]> ports;

        public VInstance(VModule module, String instanceName) {
            this.module = module;
            this.fun = null;
            this.instanceName = instanceName;
            this.ports = new HashMap<VPort, String[]>();
        }

        public VInstance(PrimitiveNode.Function fun, String instanceName) {
            this.module = null;
            this.fun = fun;
            this.instanceName = instanceName;
            this.ports = new HashMap<VPort, String[]>();
        }

        public void addConnection(VPort lp, String[] signalNames) {
            this.ports.put(lp, signalNames);
        }

        public VModule getModule() {
            return this.module;
        }

        public PrimitiveNode.Function getFunction() {
            return this.fun;
        }
    }

    public static class VExport {
        private String name;
        private int mode;
        private int firstIndex;
        private int secondIndex;

        public VExport(String name) {
            this.name = name;
            this.mode = 0;
            this.secondIndex = -1;
            this.firstIndex = -1;
        }

        public String getName() {
            return this.name;
        }

        public boolean isBus() {
            return this.firstIndex >= 0;
        }
    }

    public class VModule {
        private String name;
        private boolean defined;
        private boolean primitive;
        private Cell cell;
        private List<VExport> ports;
        private List<String> wires;
        private List<VInstance> instances;
        private Map<String, String> assignments;
        private Map<String, List<VPort>> allNetworks;

        VModule(String name, boolean defined, boolean primitive) {
            this.name = name;
            this.defined = defined;
            this.cell = null;
            if (!defined) {
                for (Library lib : Library.getVisibleLibraries()) {
                    Iterator<Cell> it = lib.getCells();
                    while (it.hasNext()) {
                        Cell libCell = it.next();
                        if (!libCell.getName().equals(name)) continue;
                        this.cell = libCell.otherView(View.LAYOUT);
                        if (this.cell != null) continue;
                        this.cell = libCell;
                        break;
                    }
                    if (this.cell == null) continue;
                    break;
                }
            }
            this.ports = new ArrayList<VExport>();
            this.wires = new ArrayList<String>();
            this.instances = new ArrayList<VInstance>();
            this.allNetworks = new HashMap<String, List<VPort>>();
            this.assignments = new HashMap<String, String>();
            CompileVerilogStruct.this.allModules.add(this);
        }

        public boolean isPrimitive() {
            return this.primitive;
        }

        public String getName() {
            return this.name;
        }

        public List<VInstance> getInstances() {
            return this.instances;
        }

        public List<VExport> getPorts() {
            return this.ports;
        }

        public boolean isDefined() {
            return this.defined;
        }

        public Cell getCell() {
            return this.cell;
        }
    }
}

