/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.output.EDIFEquiv;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.user.IconParameters;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.MutableDouble;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EDIF
extends Input<Object> {
    private static final double INCH = 10.0;
    private static final int SHEETWIDTH = 44;
    private static final int SHEETHEIGHT = 20;
    private static final ViewType VNULL = new ViewType("Null");
    private static final ViewType VBEHAVIOR = new ViewType("Behavior");
    private static final ViewType VDOCUMENT = new ViewType("Document");
    private static final ViewType VGRAPHIC = new ViewType("Graphic");
    private static final ViewType VLOGICMODEL = new ViewType("LogicModel");
    private static final ViewType VMASKLAYOUT = new ViewType("MaskLayout");
    private static final ViewType VNETLIST = new ViewType("Netlist");
    private static final ViewType VPCBLAYOUT = new ViewType("PCBLayout");
    private static final ViewType VSCHEMATIC = new ViewType("Schematic");
    private static final ViewType VSTRANGER = new ViewType("Stranger");
    private static final ViewType VSYMBOLIC = new ViewType("Symbolic");
    private static final GeometryType GUNKNOWN = new GeometryType();
    private static final GeometryType GINSTANCE = new GeometryType();
    private static final GeometryType GPORTIMPLEMENTATION = new GeometryType();
    private static final GeometryType GPROTECTIONFRAME = new GeometryType();
    private static final GeometryType GNET = new GeometryType();
    private static final GeometryType GBUS = new GeometryType();
    private static final Orientation OR0 = Orientation.fromC(0, false);
    private static final Orientation OR90 = Orientation.fromC(900, false);
    private static final Orientation OR180 = Orientation.fromC(1800, false);
    private static final Orientation OR270 = Orientation.fromC(2700, false);
    private static final Orientation OMX = Orientation.fromC(2700, true);
    private static final Orientation OMY = Orientation.fromC(900, true);
    private static final Orientation OMYR90 = Orientation.fromC(0, true);
    private static final Orientation OMXR90 = Orientation.fromC(1800, true);
    private static final VendorType EVUNKNOWN = new VendorType();
    private static final VendorType EVCADENCE = new VendorType();
    private static final VendorType EVVIEWLOGIC = new VendorType();
    private ViewType activeView;
    private VendorType curVendor;
    private EDIFKEY curKeyword;
    private String inputBuffer;
    private int inputBufferPos;
    private boolean ignoreBlock;
    private boolean ignoreHigherBlock;
    private int errorCount;
    private int warningCount;
    private Library curLibrary;
    private Technology curTech;
    private Cell curCell;
    private Map<Library, Cell> currentCells;
    private int curCellPage;
    private NodeInst curNode;
    private ArcInst curArc;
    private NodeProto curFigureGroup;
    private NodeProto cellRefProto;
    private PrimitiveNode.Function cellRefProtoFunction;
    private int cellRefProtoRotation;
    private double cellRefOffsetX;
    private double cellRefOffsetY;
    private PortProto curPort;
    private List<Network> curPortlist;
    private List<Network> lastPortlist;
    private Job job;
    private GeometryType curGeometryType;
    private List<Point2D> curPoints;
    private Orientation curOrientation;
    private PortCharacteristic curDirection;
    private double pathWidth;
    private boolean extendEnd;
    private boolean isArray;
    private int arrayXVal;
    private int arrayYVal;
    private double deltaPointXX;
    private double deltaPointXY;
    private double deltaPointYX;
    private double deltaPointYY;
    private boolean deltaPointsSet;
    private int memberXVal;
    private int memberYVal;
    private String textString;
    private double textHeight;
    private AbstractTextDescriptor.Position textJustification;
    private List<Point2D> saveTextPoints;
    private double saveTextHeight;
    private AbstractTextDescriptor.Position saveTextJustification;
    private String cellReference;
    private String cellName;
    private String portReference;
    private String portName;
    private String instanceReference;
    private String instanceName;
    private String bundleReference;
    private String bundleName;
    private String netReference;
    private String netName;
    private String propertyReference;
    private String viewRef;
    private String cellRef;
    private String libraryRef;
    private Object propertyValue;
    private String objectName;
    private String originalName;
    private Set<Cell> builtCells;
    private boolean symbolDefined;
    private List<NameEntry> activeFigures;
    private NameEntry curActiveFigure;
    private Map<String, NameEntry> cellTable;
    private List<PlannedPort> plannedPorts;
    private double inputLocY;
    private double outputLocY;
    private List<EDIFProperty> propertiesList;
    private int sheetXPos;
    private int sheetYPos;
    private int sheetOffset;
    private EDIFKEY[] keyStack = new EDIFKEY[1000];
    private int keyStackDepth;
    private int saveStack = -1;
    private EDIFEquiv equivs;
    private List<PortInst> netPortRefs;
    private Map<String, String> renamedObjects;
    private Map<String, EDIFEquiv.NodeEquivalence> mappedNodes;
    private Map<Cell, Map<String, List<ArcInst>>> namedArcs = new HashMap<Cell, Map<String, List<ArcInst>>>();
    private Set<String> exportsOnNet;
    private List<ArcInst> arcsOnNet;
    private List<NodeInst> nodesOnNet;
    private PortProto defaultPort;
    private PortProto defaultBusPort;
    private static Map<String, EDIFKEY> edifKeys = new HashMap<String, EDIFKEY>();
    private static final Variable.Key PORT_SIZE = Variable.newKey("ATTR_EDIF_port_size");
    private EDIFPreferences localPrefs;
    private EDIFKEY KUNKNOWN = new EDIFKEY("");
    private EDIFKEY KINIT = new EDIFKEY("");
    private EDIFKEY KANNOTATE = new EDIFKEY("annotate");
    private EDIFKEY KARC = new KeyArc();
    private EDIFKEY KARRAY = new KeyArray();
    private EDIFKEY KAUTHOR = new EDIFKEY("author");
    private EDIFKEY KBOOLEAN = new EDIFKEY("boolean");
    private EDIFKEY KBOOLEANMAP = new EDIFKEY("booleanMap");
    private EDIFKEY KBORDERPATTERN = new EDIFKEY("borderpattern");
    private EDIFKEY KBOUNDINGBOX = new KeyBoundingBox();
    private EDIFKEY KCELL = new KeyCell();
    private EDIFKEY KCELLREF = new KeyCellRef();
    private EDIFKEY KCELLTYPE = new EDIFKEY("cellType");
    private EDIFKEY KCIRCLE = new KeyCircle();
    private EDIFKEY KCOLOR = new EDIFKEY("color");
    private EDIFKEY KCOMMENT = new EDIFKEY("comment");
    private EDIFKEY KCOMMENTGRAPHICS = new EDIFKEY("commentGraphics");
    private EDIFKEY KCONNECTLOCATION = new EDIFKEY("connectLocation");
    private EDIFKEY KCONTENTS = new KeyContents();
    private EDIFKEY KCORNERTYPE = new KeyCornerType();
    private EDIFKEY KCRITICALITY = new EDIFKEY("criticality");
    private EDIFKEY KCURVE = new EDIFKEY("curve");
    private EDIFKEY KDATAORIGIN = new EDIFKEY("dataOrigin");
    private EDIFKEY KDCFANOUTLOAD = new EDIFKEY("dcFanoutLoad");
    private EDIFKEY KDCMAXFANOUT = new EDIFKEY("dcMaxFanout");
    private EDIFKEY KDELTA = new KeyDelta();
    private EDIFKEY KDESIGN = new KeyDesign();
    private EDIFKEY KDESIGNATOR = new EDIFKEY("designator");
    private EDIFKEY KDIRECTION = new KeyDirection();
    private EDIFKEY KDISPLAY = new EDIFKEY("display");
    private EDIFKEY KDOT = new KeyDot();
    private EDIFKEY KSCALEDINTEGER = new EDIFKEY("e");
    private EDIFKEY KEDIF = new EDIFKEY("edif");
    private EDIFKEY KEDIFLEVEL = new EDIFKEY("edifLevel");
    private EDIFKEY KEDIFVERSION = new EDIFKEY("edifVersion");
    private EDIFKEY KENDTYPE = new KeyEndType();
    private EDIFKEY KEXTERNAL = new KeyExternal();
    private EDIFKEY KFABRICATE = new KeyFabricate();
    private EDIFKEY KFALSE = new KeyFalse();
    private EDIFKEY KFIGURE = new KeyFigure();
    private EDIFKEY KFIGUREGROUP = new KeyFigureGroup();
    private EDIFKEY KFIGUREGROUPOVERRIDE = new KeyFigureGroupOverride();
    private EDIFKEY KFILLPATTERN = new EDIFKEY("fillpattern");
    private EDIFKEY KGRIDMAP = new EDIFKEY("gridMap");
    private EDIFKEY KINSTANCE = new KeyInstance();
    private EDIFKEY KINSTANCEREF = new KeyInstanceRef();
    private EDIFKEY KINTEGER = new KeyInteger();
    private EDIFKEY KINTERFACE = new KeyInterface();
    private EDIFKEY KJOINED = new KeyJoined();
    private EDIFKEY KJUSTIFY = new KeyJustify();
    private EDIFKEY KKEYWORDDISPLAY = new EDIFKEY("keywordDisplay");
    private EDIFKEY KEDIFKEYLEVEL = new EDIFKEY("keywordLevel");
    private EDIFKEY KEDIFKEYMAP = new EDIFKEY("keywordMap");
    private EDIFKEY KLIBRARY = new KeyLibrary();
    private EDIFKEY KLIBRARYREF = new LibraryRef();
    private EDIFKEY KLISTOFNETS = new EDIFKEY("listOfNets");
    private EDIFKEY KLISTOFPORTS = new EDIFKEY("listOfPorts");
    private EDIFKEY KLOGICVALUE = new EDIFKEY("logicValue");
    private EDIFKEY KMEMBER = new KeyMember();
    private EDIFKEY KNAME = new KeyName();
    private EDIFKEY KNET = new KeyNet();
    private EDIFKEY KNETBUNDLE = new KeyNetBundle();
    private EDIFKEY KNUMBER = new KeyNumber();
    private EDIFKEY KNUMBERDEFINITION = new EDIFKEY("numberDefinition");
    private EDIFKEY KOPENSHAPE = new KeyOpenShape();
    private EDIFKEY KORIENTATION = new KeyOrientation();
    private EDIFKEY KORIGIN = new EDIFKEY("origin");
    private EDIFKEY KOWNER = new EDIFKEY("owner");
    private EDIFKEY KPAGE = new EDIFKEY("page");
    private EDIFKEY KPAGESIZE = new EDIFKEY("pageSize");
    private EDIFKEY KPATH = new KeyPath();
    private EDIFKEY KPATHWIDTH = new KeyPathWidth();
    private EDIFKEY KPOINT = new EDIFKEY("point");
    private EDIFKEY KPOINTLIST = new EDIFKEY("pointList");
    private EDIFKEY KPOLYGON = new KeyPolygon();
    private EDIFKEY KPORT = new KeyPort();
    private EDIFKEY KPORTBUNDLE = new EDIFKEY("portBundle");
    private EDIFKEY KPORTIMPLEMENTATION = new KeyPortImplementation();
    private EDIFKEY KPORTINSTANCE = new EDIFKEY("portInstance");
    private EDIFKEY KPORTLIST = new KeyPortList();
    private EDIFKEY KPORTREF = new KeyPortRef();
    private EDIFKEY KPROGRAM = new KeyProgram();
    private EDIFKEY KPROPERTY = new KeyProperty();
    private EDIFKEY KPROPERTYDISPLAY = new EDIFKEY("propertyDisplay");
    private EDIFKEY KPROTECTIONFRAME = new KeyProtectionFrame();
    private EDIFKEY KPT = new KeyPt();
    private EDIFKEY KRECTANGLE = new KeyRectangle();
    private EDIFKEY KRENAME = new KeyRename();
    private EDIFKEY KSCALE = new EDIFKEY("scale");
    private EDIFKEY KSCALEX = new EDIFKEY("scaleX");
    private EDIFKEY KSCALEY = new EDIFKEY("scaleY");
    private EDIFKEY KSHAPE = new EDIFKEY("shape");
    private EDIFKEY KSIMULATIONINFO = new EDIFKEY("simulationInfo");
    private EDIFKEY KSTATUS = new EDIFKEY("status");
    private EDIFKEY KSTRING = new KeyString();
    private EDIFKEY KSTRINGDISPLAY = new KeyStringDisplay();
    private EDIFKEY KSYMBOL = new KeySymbol();
    private EDIFKEY KTECHNOLOGY = new EDIFKEY("technology");
    private EDIFKEY KTEXTHEIGHT = new KeyTextHeight();
    private EDIFKEY KTIMESTAMP = new EDIFKEY("timestamp");
    private EDIFKEY KTRANSFORM = new EDIFKEY("transform");
    private EDIFKEY KTRUE = new KeyTrue();
    private EDIFKEY KUNIT = new KeyUnit();
    private EDIFKEY KUNUSED = new KeyUnused();
    private EDIFKEY KUSERDATA = new EDIFKEY("userData");
    private EDIFKEY KVERSION = new EDIFKEY("version");
    private EDIFKEY KVIEW = new KeyView();
    private EDIFKEY KVIEWREF = new ViewRef();
    private EDIFKEY KVIEWTYPE = new KeyViewType();
    private EDIFKEY KVISIBLE = new EDIFKEY("visible");
    private EDIFKEY KWRITTEN = new EDIFKEY("written");

    EDIF(EditingPreferences ep, EDIFPreferences ap) {
        super(ep);
        this.localPrefs = ap;
    }

    @Override
    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        EDIFKEY.access$302(this.KARRAY, new EDIFKEY[]{this.KINSTANCE, this.KPORT, this.KNET});
        EDIFKEY.access$302(this.KAUTHOR, new EDIFKEY[]{this.KWRITTEN});
        EDIFKEY.access$302(this.KBOUNDINGBOX, new EDIFKEY[]{this.KSYMBOL, this.KCONTENTS, this.KPROTECTIONFRAME});
        EDIFKEY.access$302(this.KCELL, new EDIFKEY[]{this.KEXTERNAL, this.KLIBRARY});
        EDIFKEY.access$302(this.KCELLREF, new EDIFKEY[]{this.KDESIGN, this.KVIEWREF, this.KINSTANCE});
        EDIFKEY.access$302(this.KCELLTYPE, new EDIFKEY[]{this.KCELL});
        EDIFKEY.access$302(this.KCONTENTS, new EDIFKEY[]{this.KVIEW});
        EDIFKEY.access$302(this.KDESIGN, new EDIFKEY[]{this.KEDIF});
        EDIFKEY.access$302(this.KDIRECTION, new EDIFKEY[]{this.KPORT});
        EDIFKEY.access$302(this.KUNUSED, new EDIFKEY[]{this.KPORT});
        EDIFKEY.access$302(this.KEDIF, new EDIFKEY[]{this.KINIT});
        EDIFKEY.access$302(this.KEDIFLEVEL, new EDIFKEY[]{this.KEDIF, this.KEXTERNAL, this.KLIBRARY});
        EDIFKEY.access$302(this.KEXTERNAL, new EDIFKEY[]{this.KEDIF});
        EDIFKEY.access$302(this.KINSTANCE, new EDIFKEY[]{this.KCONTENTS, this.KPAGE, this.KPORTIMPLEMENTATION, this.KCOMMENTGRAPHICS});
        EDIFKEY.access$302(this.KINSTANCEREF, new EDIFKEY[]{this.KINSTANCEREF, this.KPORTREF});
        EDIFKEY.access$302(this.KINTERFACE, new EDIFKEY[]{this.KVIEW});
        EDIFKEY.access$302(this.KJOINED, new EDIFKEY[]{this.KINTERFACE, this.KNET});
        EDIFKEY.access$302(this.KEDIFKEYMAP, new EDIFKEY[]{this.KEDIF});
        EDIFKEY.access$302(this.KLIBRARYREF, new EDIFKEY[]{this.KCELLREF});
        EDIFKEY.access$302(this.KLISTOFNETS, new EDIFKEY[]{this.KNETBUNDLE});
        EDIFKEY.access$302(this.KNET, new EDIFKEY[]{this.KCONTENTS, this.KPAGE, this.KLISTOFNETS});
        EDIFKEY.access$302(this.KNETBUNDLE, new EDIFKEY[]{this.KCONTENTS, this.KPAGE});
        EDIFKEY.access$302(this.KNUMBERDEFINITION, new EDIFKEY[]{this.KTECHNOLOGY});
        EDIFKEY.access$302(this.KPORT, new EDIFKEY[]{this.KINTERFACE, this.KLISTOFPORTS});
        EDIFKEY.access$302(this.KPROTECTIONFRAME, new EDIFKEY[]{this.KINTERFACE, this.KLISTOFPORTS});
        EDIFKEY.access$302(this.KSCALE, new EDIFKEY[]{this.KNUMBERDEFINITION});
        EDIFKEY.access$302(this.KSTATUS, new EDIFKEY[]{this.KCELL, this.KDESIGN, this.KEDIF, this.KEXTERNAL, this.KLIBRARY, this.KVIEW});
        EDIFKEY.access$302(this.KSYMBOL, new EDIFKEY[]{this.KINTERFACE});
        EDIFKEY.access$302(this.KTECHNOLOGY, new EDIFKEY[]{this.KEXTERNAL, this.KLIBRARY});
        EDIFKEY.access$302(this.KTIMESTAMP, new EDIFKEY[]{this.KWRITTEN});
        EDIFKEY.access$302(this.KUNIT, new EDIFKEY[]{this.KPROPERTY, this.KSCALE});
        EDIFKEY.access$302(this.KVIEW, new EDIFKEY[]{this.KPROPERTY, this.KCELL});
        EDIFKEY.access$302(this.KVIEWREF, new EDIFKEY[]{this.KINSTANCE, this.KINSTANCEREF, this.KPORTREF});
        EDIFKEY.access$302(this.KVIEWTYPE, new EDIFKEY[]{this.KVIEW});
        EDIFKEY.access$302(this.KWRITTEN, new EDIFKEY[]{this.KSTATUS});
        this.propertyValue = null;
        this.curPoints = new ArrayList<Point2D>();
        this.saveTextPoints = new ArrayList<Point2D>();
        this.curKeyword = this.KINIT;
        this.inputBuffer = "";
        this.inputBufferPos = 0;
        this.warningCount = 0;
        this.errorCount = 0;
        this.ignoreHigherBlock = false;
        this.ignoreBlock = false;
        this.curVendor = EVUNKNOWN;
        this.builtCells = new HashSet<Cell>();
        this.curLibrary = lib;
        this.curTech = tech;
        this.cellTable = new HashMap<String, NameEntry>();
        this.propertiesList = new ArrayList<EDIFProperty>();
        this.curCell = null;
        this.currentCells = currentCells;
        this.curCellPage = 0;
        this.curNode = null;
        this.curArc = null;
        this.curPort = null;
        this.curFigureGroup = null;
        this.cellRefProto = null;
        this.cellReference = "";
        this.portReference = "";
        this.instanceReference = "";
        this.bundleReference = "";
        this.netReference = "";
        this.propertyReference = "";
        this.activeFigures = new ArrayList<NameEntry>();
        this.curActiveFigure = null;
        this.freePointList();
        this.textHeight = 0.0;
        this.textJustification = AbstractTextDescriptor.Position.DOWNRIGHT;
        this.freeSavedPointList();
        this.sheetYPos = -1;
        this.sheetXPos = -1;
        this.keyStackDepth = 0;
        this.defaultPort = Schematics.tech().wirePinNode.findPortProto("wire");
        this.defaultBusPort = Schematics.tech().busPinNode.findPortProto("bus");
        this.equivs = new EDIFEquiv(this.localPrefs.configurationFile);
        this.netPortRefs = new ArrayList<PortInst>();
        this.renamedObjects = new HashMap<String, String>();
        try {
            this.loadEDIF();
        }
        catch (IOException e) {
            System.out.println("line " + this.lineReader.getLineNumber() + ": " + e.getMessage());
            return null;
        }
        if (this.errorCount != 0 || this.warningCount != 0) {
            System.out.println("A total of " + this.errorCount + " errors, and " + this.warningCount + " warnings encountered during load");
        }
        if (this.curLibrary != null && !currentCells.containsKey(this.curLibrary) && this.curLibrary.getCells().hasNext()) {
            currentCells.put(this.curLibrary, this.curLibrary.getCells().next());
        }
        return this.curLibrary;
    }

    private void loadEDIF() throws IOException {
        String token2;
        while ((token2 = this.getKeyword()) != null) {
            EDIFKEY key = edifKeys.get(TextUtils.canonicString(token2));
            if (key == null) {
                System.out.println("Warning, line " + this.lineReader.getLineNumber() + ": unknown keyword <" + token2 + ">");
                ++this.warningCount;
                this.keyStack[this.keyStackDepth++] = this.curKeyword;
                this.curKeyword = this.KUNKNOWN;
                continue;
            }
            if (key.stateArray != null && this.curKeyword != this.KUNKNOWN) {
                boolean found = false;
                for (int i = 0; i < key.stateArray.length; ++i) {
                    if (key.stateArray[i] != this.curKeyword) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    System.out.println("Error, line " + this.lineReader.getLineNumber() + ": illegal state (" + this.curKeyword.name + ") for keyword <" + token2 + ">");
                    ++this.errorCount;
                }
            }
            this.keyStack[this.keyStackDepth++] = this.curKeyword;
            this.curKeyword = key;
            if (this.saveStack >= this.keyStackDepth) {
                this.saveStack = -1;
                this.ignoreBlock = false;
            }
            if (!this.ignoreBlock) {
                key.push();
                if (this.ignoreHigherBlock) {
                    this.ignoreHigherBlock = false;
                    this.ignoreBlock = true;
                    this.saveStack = this.keyStackDepth - 1;
                }
            }
            if (!this.ignoreBlock || this.saveStack != -1) continue;
            this.saveStack = this.keyStackDepth;
        }
        if (this.curKeyword != this.KINIT) {
            System.out.println("Error, line " + this.lineReader.getLineNumber() + ": unexpected end-of-file encountered");
            ++this.errorCount;
        }
        this.cleanupAtEnd();
    }

    private String getKeyword() throws IOException {
        String p;
        while ((p = this.getToken('\u0000')) != null && !p.equals("(")) {
            if (p.equals(")")) {
                if (this.keyStackDepth == 0) continue;
                if (!this.ignoreBlock) {
                    this.curKeyword.pop();
                }
                this.curKeyword = this.keyStackDepth != 0 ? this.keyStack[--this.keyStackDepth] : this.KINIT;
                if (this.saveStack <= this.keyStackDepth) continue;
                this.saveStack = -1;
                this.ignoreBlock = false;
                continue;
            }
            if (!TextUtils.isANumber(p)) continue;
            this.processInteger(TextUtils.atoi(p));
        }
        return this.getToken('\u0000');
    }

    private void cleanupAtEnd() {
        ArrayList<Cell> cellsToStitch = new ArrayList<Cell>();
        for (Cell cell : this.builtCells) {
            if (!cell.isSchematic()) continue;
            ArrayList<NodeInst> deletePins = new ArrayList<NodeInst>();
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (ni.getProto() != Schematics.tech().wirePinNode || ni.hasConnections() || ni.hasExports()) continue;
                deletePins.add(ni);
            }
            for (NodeInst ni : deletePins) {
                ni.kill();
            }
            cellsToStitch.add(cell);
        }
        if (cellsToStitch.size() > 0 && this.localPrefs.importStitchesCells) {
            for (int i = 0; i < cellsToStitch.size(); ++i) {
                Cell cell;
                cell = (Cell)cellsToStitch.get(i);
                Job.getUserInterface().setProgressNote("Stitching " + cell.noLibDescribe() + "(" + (i + 1) + " of " + cellsToStitch.size() + ")");
                Job.getUserInterface().setProgressValue(i * 100 / cellsToStitch.size());
                if (!cell.isLinked()) continue;
                AutoStitch.runAutoStitch(cell, null, null, this.job, null, null, false, false, this.ep, this.localPrefs.autoParameters, false, null);
            }
            Job.getUserInterface().setProgressValue(0);
            System.out.println("Stitched " + cellsToStitch.size() + " cells");
        }
        for (Cell cell : this.namedArcs.keySet()) {
            Netlist nl = cell.getNetlist();
            Map<String, List<ArcInst>> arcsInCell = this.namedArcs.get(cell);
            HashMap<ArcInst, String> arcsToName = new HashMap<ArcInst, String>();
            for (String name : arcsInCell.keySet()) {
                List<ArcInst> arcsWithName = arcsInCell.get(name);
                Collections.sort(arcsWithName, new ArcInst.ArcsByLength());
                HashSet<Network> netsNamed = new HashSet<Network>();
                for (int i = 0; i < arcsWithName.size(); ++i) {
                    Network net;
                    ArcInst ai = arcsWithName.get(i);
                    if (!ai.isLinked() || netsNamed.contains(net = nl.getNetwork(ai, 0))) continue;
                    netsNamed.add(net);
                    arcsToName.put(ai, name);
                }
            }
            for (ArcInst ai : arcsToName.keySet()) {
                String arcName = (String)arcsToName.get(ai);
                if (ai.getName().equals(arcName)) continue;
                if (ai.getNameKey().isTempname()) {
                    ai.setName(arcName, this.ep);
                    if (this.localPrefs.showArcNames) continue;
                    TextDescriptor td = ai.getTextDescriptor(ArcInst.ARC_NAME);
                    td = td.withDisplay(AbstractTextDescriptor.Display.NONE);
                    ai.setTextDescriptor(ArcInst.ARC_NAME, td);
                    continue;
                }
                ArcInst second = ArcInst.newInstanceBase(ai.getProto(), this.ep, ai.getLambdaBaseWidth(), ai.getHeadPortInst(), ai.getTailPortInst(), ai.getHeadLocation(), ai.getTailLocation(), arcName, ai.getAngle(), ai.getD().flags);
                TextDescriptor td = this.ep.getArcTextDescriptor().withOff(0.0, -1.0);
                if (!this.localPrefs.showArcNames) {
                    td = td.withDisplay(AbstractTextDescriptor.Display.NONE);
                }
                second.setTextDescriptor(ArcInst.ARC_NAME, td);
            }
        }
    }

    private void processInteger(int value2) {
        if (this.keyStackDepth > 0 && !this.ignoreBlock) {
            if (this.curKeyword == this.KARRAY) {
                if (this.arrayXVal == 0) {
                    this.arrayXVal = value2;
                } else if (this.arrayYVal == 0) {
                    this.arrayYVal = value2;
                }
            } else if (this.curKeyword == this.KMEMBER) {
                if (this.memberXVal == -1) {
                    this.memberXVal = value2;
                } else if (this.memberYVal == -1) {
                    this.memberYVal = value2;
                }
            }
        }
    }

    private boolean positionToNextToken() throws IOException {
        while (true) {
            if (this.inputBuffer == null) {
                return true;
            }
            if (this.inputBufferPos >= this.inputBuffer.length()) {
                this.inputBuffer = this.readWholeLine();
                if (this.inputBuffer == null) {
                    return true;
                }
                this.inputBufferPos = 0;
                continue;
            }
            char chr = this.inputBuffer.charAt(this.inputBufferPos);
            if (chr != ' ' && chr != '\t') break;
            ++this.inputBufferPos;
        }
        return false;
    }

    private void getDelimeter(char delim) throws IOException {
        if (this.positionToNextToken()) {
            throw new IOException("Unexpected end-of-file");
        }
        char chr = this.inputBuffer.charAt(this.inputBufferPos);
        if (chr != delim) {
            throw new IOException("Illegal delimeter");
        }
        ++this.inputBufferPos;
    }

    private String getToken(char iDelim) throws IOException {
        char delim = iDelim;
        if (delim == '\u0000' && this.positionToNextToken()) {
            return null;
        }
        StringBuffer sBuf = new StringBuffer();
        char chr = this.inputBuffer.charAt(this.inputBufferPos);
        if (delim == '\u0000' && chr == '\"') {
            delim = '\"';
            sBuf.append(chr);
            ++this.inputBufferPos;
        }
        while (true) {
            if (this.inputBufferPos >= this.inputBuffer.length()) {
                this.inputBuffer = this.readWholeLine();
                if (this.inputBuffer == null) {
                    if (delim != '\u0000') break;
                    return sBuf.toString();
                }
                this.inputBufferPos = 0;
                continue;
            }
            if (delim == '\u0000') {
                chr = this.inputBuffer.charAt(this.inputBufferPos);
                switch (chr) {
                    case '\t': 
                    case ' ': {
                        ++this.inputBufferPos;
                        return sBuf.toString();
                    }
                    case '(': 
                    case ')': {
                        if (sBuf.length() == 0) {
                            sBuf.append(chr);
                            ++this.inputBufferPos;
                        }
                        return sBuf.toString();
                    }
                }
                sBuf.append(chr);
                ++this.inputBufferPos;
                continue;
            }
            chr = this.inputBuffer.charAt(this.inputBufferPos);
            if (chr == delim) {
                if (delim != iDelim) {
                    sBuf.append(chr);
                }
                ++this.inputBufferPos;
                return sBuf.toString();
            }
            sBuf.append(chr);
            ++this.inputBufferPos;
        }
        return null;
    }

    private void makeFigure() throws IOException {
        if (this.positionToNextToken()) {
            return;
        }
        if (this.inputBuffer.charAt(this.inputBufferPos) == '(') {
            return;
        }
        String layer = this.getToken('\u0000');
        for (NameEntry nt : this.activeFigures) {
            if (!nt.original.equalsIgnoreCase(layer)) continue;
            this.curFigureGroup = nt.node;
            this.textHeight = nt.textHeight;
            this.textJustification = nt.justification;
            this.curActiveFigure = nt;
            return;
        }
        NameEntry nt = new NameEntry();
        this.activeFigures.add(nt);
        nt.original = layer;
        nt.replace = nt.original;
        nt.node = Artwork.tech().boxNode;
        this.curFigureGroup = nt.node;
        this.textHeight = nt.textHeight = 0.0;
        this.textJustification = nt.justification = AbstractTextDescriptor.Position.DOWNRIGHT;
        this.curActiveFigure = nt;
    }

    private boolean isBusName(String name) {
        if (name == null || name.length() <= 0) {
            return false;
        }
        Name nn = Name.findName(name);
        if (nn == null) {
            return false;
        }
        return nn.isBus();
    }

    private boolean checkName() throws IOException {
        this.positionToNextToken();
        char chr = this.inputBuffer.charAt(this.inputBufferPos);
        if (chr != '(' && chr != ')') {
            String aName = this.getToken('\u0000');
            this.objectName = this.fixLeadingAmpersand(aName);
            return true;
        }
        return false;
    }

    private void freePointList() {
        this.curPoints = new ArrayList<Point2D>();
    }

    private void freeSavedPointList() {
        this.saveTextPoints = new ArrayList<Point2D>();
    }

    private double getNumber() throws IOException {
        String value2 = this.getToken('\u0000');
        if (value2 == null) {
            throw new IOException("No integer value");
        }
        if (value2.startsWith("(")) {
            value2 = this.getToken('\u0000');
            if (value2 == null) {
                throw new IOException("Illegal number value");
            }
            if (!value2.equalsIgnoreCase("e")) {
                throw new IOException("Illegal number value");
            }
            value2 = this.getToken('\u0000');
            if (value2 == null) {
                throw new IOException("No matissa value");
            }
            double matissa = TextUtils.atof(value2);
            value2 = this.getToken('\u0000');
            if (value2 == null) {
                throw new IOException("No exponent value");
            }
            double exponent2 = TextUtils.atof(value2);
            this.getDelimeter(')');
            return matissa * Math.pow(10.0, exponent2);
        }
        return TextUtils.atof(value2);
    }

    private NodeInst placePin(NodeProto np, double cX, double cY, double sX, double sY, Orientation orient, Cell parent) {
        Iterator<NodeInst> it = parent.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.getProto() != np || !ni.getOrient().equals(orient) || ni.getAnchorCenterX() != cX || ni.getAnchorCenterY() != cY) continue;
            return ni;
        }
        NodeInst ni = NodeInst.makeInstance(np, this.ep, new Point2D.Double(cX, cY), sX, sY, parent, orient, null);
        return ni;
    }

    private double convertTextSize(double textHeight) {
        double i = textHeight / 4.0;
        if (i < 0.25) {
            i = 0.25;
        }
        if (i > 127.75) {
            i = 127.75;
        }
        return i;
    }

    private void makeArc(double[] x2, double[] y) {
        NodeInst ni;
        if (this.curCell == null) {
            return;
        }
        MutableDouble[] A = new MutableDouble[2];
        MutableDouble[] B = new MutableDouble[2];
        MutableDouble[] C = new MutableDouble[2];
        for (int i = 0; i < 2; ++i) {
            A[i] = new MutableDouble(0.0);
            B[i] = new MutableDouble(0.0);
            C[i] = new MutableDouble(0.0);
        }
        double px1 = (x2[0] + x2[1]) / 2.0;
        double py1 = (y[0] + y[1]) / 2.0;
        double px0 = px1 - (y[0] - py1);
        double py0 = py1 + (x2[0] - px1);
        this.equationOfALine(px0, py0, px1, py1, A[0], B[0], C[0]);
        px1 = (x2[2] + x2[1]) / 2.0;
        py1 = (y[2] + y[1]) / 2.0;
        double px2 = px1 - (y[2] - py1);
        double py2 = py1 + (x2[2] - px1);
        this.equationOfALine(px1, py1, px2, py2, A[1], B[1], C[1]);
        Point2D ctr = this.determineIntersection(A, B, C);
        double ixc = ctr.getX();
        double iyc = ctr.getY();
        double dx = ixc - x2[0];
        double dy = iyc - y[0];
        double r = Math.hypot(dx, dy);
        dx = x2[0] - ixc;
        dy = y[0] - iyc;
        if (dx == 0.0 && dy == 0.0) {
            System.out.println("Domain error doing arc computation");
            return;
        }
        double a0 = Math.atan2(dy, dx) * 1800.0 / Math.PI;
        if (a0 < 0.0) {
            a0 += 3600.0;
        }
        dx = x2[2] - ixc;
        dy = y[2] - iyc;
        if (dx == 0.0 && dy == 0.0) {
            System.out.println("Domain error doing arc computation");
            return;
        }
        double a2 = Math.atan2(dy, dx) * 1800.0 / Math.PI;
        if (a2 < 0.0) {
            a2 += 3600.0;
        }
        double area = x2[0] * y[1] + x2[1] * y[2] + x2[2] * y[0] - y[0] * x2[1] - y[1] * x2[2] - y[2] * x2[0];
        double ar = 0.0;
        double so = 0.0;
        int rot = 0;
        boolean trans = false;
        if (area > 0.0) {
            if (a2 < a0) {
                a2 += 3600.0;
            }
            ar = a2 - a0;
            rot = (int)a0;
            so = (a0 - (double)rot) * Math.PI / 1800.0;
        } else {
            if (a0 > 2700.0) {
                rot = 3600 - (int)a0 + 2700;
                so = (3600.0 - a0 + 2700.0 - (double)rot) * Math.PI / 1800.0;
            } else {
                rot = 2700 - (int)a0;
                so = (2700.0 - a0 - (double)rot) * Math.PI / 1800.0;
            }
            if (a0 < a2) {
                a0 += 3600.0;
            }
            ar = a0 - a2;
            trans = true;
        }
        double sX = r * 2.0;
        double sY = r * 2.0;
        Orientation or = Orientation.fromC(rot, trans);
        if (this.curCellPage > 0) {
            iyc += (double)(this.curCellPage - 1) * 1000.0;
        }
        if ((ni = NodeInst.makeInstance(this.curFigureGroup != null && this.curFigureGroup != Artwork.tech().boxNode ? this.curFigureGroup : Artwork.tech().circleNode, this.ep, new Point2D.Double(ixc, iyc), sX, sY, this.curCell, or, null)) == null) {
            System.out.println("Error, line " + this.lineReader.getLineNumber() + ": could not create arc");
            ++this.errorCount;
        } else {
            ni.setArcDegrees(so, ar * Math.PI / 1800.0, this.ep);
        }
    }

    private String convertParens(String name) {
        return name.replace('(', '[').replace(')', ']');
    }

    private Point2D determineIntersection(MutableDouble[] A, MutableDouble[] B, MutableDouble[] C) {
        double A2B1;
        double A1B2 = A[0].doubleValue() * B[1].doubleValue();
        if (A1B2 == (A2B1 = A[1].doubleValue() * B[0].doubleValue())) {
            if (C[0].doubleValue() == C[1].doubleValue()) {
                return null;
            }
            return null;
        }
        double A1C2 = A[0].doubleValue() * C[1].doubleValue();
        double A2C1 = A[1].doubleValue() * C[0].doubleValue();
        if (A[0].doubleValue() != 0.0) {
            double Y = (A2C1 - A1C2) / (A1B2 - A2B1);
            double X = -(B[0].doubleValue() * Y + C[0].doubleValue()) / A[0].doubleValue();
            return new Point2D.Double(X, Y);
        }
        double Y = (A1C2 - A2C1) / (A2B1 - A1B2);
        double X = -(B[1].doubleValue() * Y + C[1].doubleValue()) / A[1].doubleValue();
        return new Point2D.Double(X, Y);
    }

    private void equationOfALine(double sx, double sy, double ex, double ey, MutableDouble A, MutableDouble B, MutableDouble C) {
        if (sx == ex) {
            A.setValue(1.0);
            B.setValue(0.0);
            C.setValue(-ex);
        } else if (sy == ey) {
            A.setValue(0.0);
            B.setValue(1.0);
            C.setValue(-ey);
        } else {
            B.setValue(1.0);
            if (sx != 0.0) {
                C.setValue((ey * sx - sy * ex) / (ex - sx));
                A.setValue(-(C.doubleValue() + sy) / sx);
            } else {
                C.setValue((sy * ex - ey * sx) / (sx - ex));
                A.setValue(-(C.doubleValue() + ey) / ex);
            }
        }
    }

    private void nameEDIFArc(ArcInst ai, boolean forceBus) {
        if (this.isArray) {
            if (this.netReference.length() > 0) {
                ai.newVar("EDIF_name", (Object)this.stripPercentEscapes(this.netReference), this.ep);
            }
            StringBuffer aName = new StringBuffer();
            if (this.netName.indexOf(91) >= 0) {
                int yMost = this.arrayYVal;
                int xMost = this.arrayXVal;
                if (yMost > xMost) {
                    xMost = this.arrayYVal;
                    yMost = this.arrayXVal;
                }
                for (int iX = 0; iX < xMost; ++iX) {
                    for (int iY = 0; iY < yMost; ++iY) {
                        if (aName.length() > 0) {
                            aName.append(',');
                        }
                        aName.append(this.getMemberName(this.netName, iX, iY));
                    }
                }
            } else if (forceBus) {
                for (int iX = 0; iX < this.arrayXVal; ++iX) {
                    for (int iY = 0; iY < this.arrayYVal; ++iY) {
                        if (aName.length() > 0) {
                            aName.append(',');
                        }
                        if (this.arrayXVal > 1) {
                            if (this.arrayYVal > 1) {
                                aName.append(this.netName + "[" + iX + "," + iY + "]");
                                continue;
                            }
                            aName.append(this.netName + "[" + iX + "]");
                            continue;
                        }
                        aName.append(this.netName + "[" + iY + "]");
                    }
                }
            } else {
                aName.append(this.netName);
            }
            this.putNameOnArcOnce(ai, this.convertParens(aName.toString()));
        } else {
            if (this.netReference.length() > 0) {
                ai.newVar("EDIF_name", (Object)this.stripPercentEscapes(this.netName), this.ep);
            }
            if (this.netName.length() > 0) {
                String arcName = this.convertParens(this.netName).replaceAll("@", "_");
                this.putNameOnArcOnce(ai, arcName);
            }
        }
    }

    private void putNameOnArcOnce(ArcInst ai, String name) {
        if (this.namedArcs != null && this.curCell != null) {
            List<ArcInst> arcsWithName;
            Map<String, List<ArcInst>> cellArcNames = this.namedArcs.get(this.curCell);
            if (cellArcNames == null) {
                cellArcNames = new HashMap<String, List<ArcInst>>();
                this.namedArcs.put(this.curCell, cellArcNames);
            }
            if ((arcsWithName = cellArcNames.get(name)) == null) {
                arcsWithName = new ArrayList<ArcInst>();
                cellArcNames.put(name, arcsWithName);
            }
            arcsWithName.add(ai);
        }
    }

    private void putNameOnNode(NodeInst ni, String name) {
        ni.setName(this.convertParens(name));
        if (!this.localPrefs.showNodeNames) {
            TextDescriptor td = ni.getTextDescriptor(NodeInst.NODE_NAME);
            td = td.withDisplay(AbstractTextDescriptor.Display.NONE);
            ni.setTextDescriptor(NodeInst.NODE_NAME, td);
        }
    }

    private List<PortInst> findEDIFPort(Cell cell, double x2, double y, ArcProto ap) {
        ArrayList<PortInst> ports = new ArrayList<PortInst>();
        ArrayList<PortInst> closePorts = new ArrayList<PortInst>();
        PortInst bestPi = null;
        Point2D.Double pt = new Point2D.Double(x2, y);
        double bestDist = Double.MAX_VALUE;
        ArcInst ai = null;
        Iterator<Geometric> sea = cell.searchIterator(new Rectangle2D.Double(x2, y, 0.0, 0.0));
        while (sea.hasNext()) {
            Geometric geom = sea.next();
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                Iterator<PortInst> it = ni.getPortInsts();
                while (it.hasNext()) {
                    String sizeStr;
                    int xPos;
                    Export pp;
                    NodeInst subNode;
                    Variable var;
                    PortInst pi = it.next();
                    Poly poly = pi.getPoly();
                    if (poly.isInside(pt)) {
                        if (!pi.getPortProto().getBasePort().connectsTo(ap)) continue;
                        ports.add(pi);
                        continue;
                    }
                    if (ni.isCellInstance() && (var = (subNode = (pp = (Export)pi.getPortProto()).getOriginalPort().getNodeInst()).getVar(PORT_SIZE)) != null && (xPos = (sizeStr = (String)var.getObject()).indexOf(120)) >= 0) {
                        double wid = TextUtils.atof(sizeStr.substring(0, xPos));
                        double hei = TextUtils.atof(sizeStr.substring(xPos + 1));
                        EPoint ctr = pi.getCenter();
                        Rectangle2D.Double rect = new Rectangle2D.Double(ctr.getX() - wid / 2.0, ctr.getY() - hei / 2.0, wid, hei);
                        if (GenMath.containedInRectangle(rect, pt)) {
                            closePorts.add(pi);
                        }
                    }
                    double dist = pt.distance(new Point2D.Double(poly.getCenterX(), poly.getCenterY()));
                    if (bestPi != null && !(dist < bestDist)) continue;
                    bestDist = dist;
                    bestPi = pi;
                }
                continue;
            }
            ArcInst oAi = (ArcInst)geom;
            if (oAi.getProto().getTechnology() != Schematics.tech() || GenMath.distToLine(oAi.getHeadLocation(), oAi.getTailLocation(), pt) != 0.0) continue;
            ai = oAi;
        }
        if (ports.size() == 0 && closePorts.size() > 0) {
            return closePorts;
        }
        if (ports.size() == 0 && ai != null) {
            ArcProto nAp = ai.getProto();
            PrimitiveNode np = nAp.findPinProto();
            if (np == null) {
                return ports;
            }
            PrimitivePort pp = np.getPort(0);
            if (!pp.getBasePort().connectsTo(ap)) {
                return ports;
            }
            PortInst fPi = ai.getHeadPortInst();
            EPoint fPt = ai.getHeadLocation();
            PortInst tPi = ai.getTailPortInst();
            EPoint tPt = ai.getTailLocation();
            NodeInst ni = this.placePin(np, x2, y, np.getDefWidth(this.ep), np.getDefHeight(this.ep), Orientation.IDENT, cell);
            if (ni == null) {
                System.out.println("Cannot create splitting pin");
                return ports;
            }
            PortInst pi = ni.findPortInstFromProto(pp);
            ports.add(pi);
            ArcInst ar1 = ArcInst.makeInstance(nAp, this.ep, fPi, pi, fPt, pt, null);
            ArcInst ar2 = ArcInst.makeInstance(nAp, this.ep, pi, tPi, pt, tPt, null);
            if (ar1 == null || ar2 == null) {
                System.out.println("Error creating the split arc parts");
                return ports;
            }
            ar1.copyPropertiesFrom(ai);
            if (ai.isHeadNegated()) {
                ar1.setHeadNegated(true);
            }
            if (ai.isTailNegated()) {
                ar2.setTailNegated(true);
            }
            ai.kill();
        }
        return ports;
    }

    private void checkBusNames(ArcInst ai, String base, HashSet<ArcInst> seenArcs) {
        String aName;
        if (ai.getProto() != Schematics.tech().bus_arc && (aName = ai.getName()).startsWith(base) && aName.length() > base.length() && TextUtils.isDigit(aName.charAt(base.length()))) {
            String newName = base + "[" + aName.substring(base.length()) + "]";
            this.putNameOnArcOnce(ai, newName);
        }
        seenArcs.add(ai);
        for (int i = 0; i < 2; ++i) {
            NodeInst ni = ai.getPortInst(i).getNodeInst();
            if (!ni.getFunction().isPin()) continue;
            Iterator<Connection> it = ni.getConnections();
            while (it.hasNext()) {
                Connection oCon = it.next();
                ArcInst pAi = oCon.getArc();
                if (seenArcs.contains(pAi)) continue;
                this.checkBusNames(pAi, base, seenArcs);
            }
        }
    }

    private void doPoly() {
        NodeInst ni;
        double cY;
        if (this.curPoints.size() == 0) {
            return;
        }
        if (this.curCell == null) {
            return;
        }
        Point2D p0 = this.curPoints.get(0);
        double lX = p0.getX();
        double lY = p0.getY();
        double hX = lX;
        double hY = lY;
        for (int i = 1; i < this.curPoints.size(); ++i) {
            Point2D point = this.curPoints.get(i);
            if (lX > point.getX()) {
                lX = point.getX();
            }
            if (hX < point.getX()) {
                hX = point.getX();
            }
            if (lY > point.getY()) {
                lY = point.getY();
            }
            if (!(hY < point.getY())) continue;
            hY = point.getY();
        }
        NodeProto np = this.curFigureGroup;
        if (this.curFigureGroup == null || this.curFigureGroup == Artwork.tech().boxNode) {
            np = this.curKeyword == this.KPOLYGON ? Artwork.tech().closedPolygonNode : Artwork.tech().openedPolygonNode;
        }
        double sX = hX - lX;
        double sY = hY - lY;
        double cX = (hX + lX) / 2.0;
        double yPos = cY = (hY + lY) / 2.0;
        if (this.curCellPage > 0) {
            yPos += (double)(this.curCellPage - 1) * 1000.0;
        }
        if ((ni = NodeInst.makeInstance(np, this.ep, new Point2D.Double(cX, yPos), sX, sY, this.curCell, this.curOrientation, null)) == null) {
            System.out.println("Error, line " + this.lineReader.getLineNumber() + ": could not create " + sX + "x" + sY + " node " + np.describe(false) + " at (" + cX + "," + yPos + ")");
            ++this.errorCount;
        } else {
            EPoint[] trace = new EPoint[this.curPoints.size()];
            for (int i = 0; i < this.curPoints.size(); ++i) {
                Point2D point = this.curPoints.get(i);
                trace[i] = EPoint.fromLambda(point.getX(), point.getY());
            }
            ni.setTrace(trace);
        }
        this.freePointList();
    }

    private String fixLeadingAmpersand(String inStr) {
        if (inStr.startsWith("&") && inStr.length() > 1 && Character.isDigit(inStr.charAt(1))) {
            return inStr.substring(1);
        }
        return inStr;
    }

    private String fixAngleBracketBusses(String busName) {
        int closeAngle;
        int openAngle;
        while ((openAngle = busName.indexOf(60)) >= 0 && (closeAngle = busName.indexOf(62, openAngle)) >= 0) {
            String busPart = busName.substring(openAngle + 1, closeAngle);
            busPart = busPart.startsWith("*") ? "" : "[" + busPart + "]";
            busName = busName.substring(0, openAngle) + busPart + busName.substring(closeAngle + 1);
        }
        return busName;
    }

    private String getMemberName(String name, int ind1, int ind2) {
        int endInd1;
        int comma;
        int openSq;
        String baseName = this.renamedObjects.get(name);
        if (baseName == null) {
            baseName = name;
        }
        if ((openSq = baseName.indexOf(91)) < 0) {
            return baseName;
        }
        int closeSq = baseName.indexOf(93, openSq);
        if (closeSq < 0) {
            closeSq = baseName.length();
        }
        if ((comma = baseName.indexOf(44, openSq)) < 0) {
            comma = baseName.length();
        }
        if ((endInd1 = Math.min(closeSq, comma)) < 0) {
            return baseName;
        }
        String index1 = baseName.substring(openSq + 1, endInd1);
        String index2 = null;
        String restOfLine = baseName.substring(endInd1);
        if (comma >= 0 && comma < baseName.length() && (closeSq = baseName.indexOf(93, comma)) >= 0) {
            index2 = baseName.substring(comma + 1, closeSq);
            restOfLine = baseName.substring(closeSq);
        }
        int[] indices = this.getIndices(index1);
        if (ind1 >= 0 && ind1 < indices.length) {
            baseName = baseName.substring(0, openSq + 1) + indices[ind1];
        }
        if (index2 != null) {
            int[] indices2 = this.getIndices(index2);
            if (ind2 >= 0 && ind2 < indices2.length) {
                baseName = baseName + "," + indices2[ind2];
            }
        }
        baseName = baseName + restOfLine;
        return baseName;
    }

    private int[] getIndices(String index) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int pos = 0;
        while (pos < index.length()) {
            int i;
            int val;
            if (Character.isWhitespace(index.charAt(pos))) {
                ++pos;
                continue;
            }
            if (!Character.isDigit(index.charAt(pos))) break;
            int valEnd = val = TextUtils.atoi(index.substring(pos));
            while (pos < index.length() && Character.isDigit(index.charAt(pos))) {
                ++pos;
            }
            while (pos < index.length() && Character.isWhitespace(index.charAt(pos))) {
                ++pos;
            }
            if (pos < index.length() && index.charAt(pos) == ':') {
                ++pos;
                while (pos < index.length() && Character.isWhitespace(index.charAt(pos))) {
                    ++pos;
                }
                if (Character.isDigit(index.charAt(pos))) {
                    valEnd = TextUtils.atoi(index.substring(pos));
                    while (pos < index.length() && Character.isDigit(index.charAt(pos))) {
                        ++pos;
                    }
                    while (pos < index.length() && Character.isWhitespace(index.charAt(pos))) {
                        ++pos;
                    }
                }
            }
            if (valEnd < val) {
                for (i = val; i >= valEnd; --i) {
                    indices.add(new Integer(i));
                }
                continue;
            }
            for (i = val; i <= valEnd; ++i) {
                indices.add(new Integer(i));
            }
        }
        int[] retInd = new int[indices.size()];
        for (int i = 0; i < indices.size(); ++i) {
            retInd[i] = (Integer)indices.get(i);
        }
        return retInd;
    }

    private Cell findCell(String libName, String name, String view) {
        Library namedLib;
        Library lib = this.curLibrary;
        if (libName != null && (namedLib = Library.findLibrary(libName)) != null) {
            lib = namedLib;
        }
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            if (!cell.getName().equalsIgnoreCase(name) || !cell.getView().getAbbreviation().equalsIgnoreCase(view)) continue;
            return cell;
        }
        return null;
    }

    private Cell createCell(String libName, String name, String view) {
        Library namedLib;
        Cell proto = this.findCell(libName, name, view);
        if (proto != null) {
            return proto;
        }
        Library lib = this.curLibrary;
        if (libName != null && (namedLib = Library.findLibrary(libName)) != null) {
            lib = namedLib;
        }
        String cName = name;
        if (view.length() > 0) {
            cName = cName + "{" + view + "}";
        }
        if ((proto = Cell.makeInstance(this.ep, lib, cName)) != null) {
            if (view.equals("ic")) {
                proto.setWantExpanded();
            }
            this.builtCells.add(proto);
        }
        return proto;
    }

    private void instantiatePlannedPort(PlannedPort plp, Rectangle2D cellBounds) {
        Export e;
        Cell iconCell;
        String name;
        String exportName;
        if (plp.createdPort != null) {
            return;
        }
        if (this.curCell == null) {
            return;
        }
        PortInst pi = null;
        if (plp.alreadyThere == null) {
            List<PortInst> tList;
            NodeProto type;
            if (!plp.knownLocation) {
                if (plp.direction == PortCharacteristic.IN || plp.direction == PortCharacteristic.BIDIR) {
                    plp.x = cellBounds.getMinX() - 5.0;
                    plp.y = cellBounds.getMinY() + this.inputLocY * 10.0 / 2.0;
                    this.inputLocY += 1.0;
                } else {
                    plp.x = cellBounds.getMaxX() + 5.0;
                    plp.y = cellBounds.getMinY() + this.outputLocY * 10.0 / 2.0;
                    this.outputLocY += 1.0;
                }
                plp.knownLocation = true;
            }
            if ((type = plp.pinType) == Schematics.tech().offpageNode && this.curCell.getView() == View.LAYOUT) {
                type = this.curTech.getNodes().next();
            }
            if (type == Artwork.tech().boxNode) {
                if (this.curCell.getView() == View.SCHEMATIC) {
                    type = Schematics.tech().offpageNode;
                } else if (this.curCell.getView() == View.ICON) {
                    type = Schematics.tech().busPinNode;
                }
            }
            if ((tList = this.findEDIFPort(this.curCell, plp.x, plp.y, type.getPort(0).getBasePort().getConnections()[0])).size() != 0) {
                pi = tList.get(0);
                plp.alreadyThere = pi.getNodeInst();
            } else {
                double psX = type.getDefWidth(this.ep);
                double psY = type.getDefHeight(this.ep);
                plp.alreadyThere = NodeInst.makeInstance(type, this.ep, new Point2D.Double(plp.x, plp.y), psX, psY, this.curCell);
                if (plp.alreadyThere == null) {
                    System.out.println("Error, line " + this.lineReader.getLineNumber() + ": could not create external port");
                    ++this.errorCount;
                    return;
                }
                if (plp.sX != 0.0 || plp.sY != 0.0) {
                    String sizeString = TextUtils.formatDouble(plp.sX) + "x" + TextUtils.formatDouble(plp.sY);
                    plp.alreadyThere.newVar(PORT_SIZE, (Object)sizeString, this.ep);
                }
                pi = plp.alreadyThere.getPortInst(0);
            }
        }
        if (plp.alreadyThere.getProto() == Schematics.tech().offpageNode) {
            PortProto fPp = Schematics.tech().offpageNode.findPortProto("y");
            if (plp.direction == PortCharacteristic.OUT) {
                fPp = Schematics.tech().offpageNode.findPortProto("a");
            }
            pi = plp.alreadyThere.findPortInstFromProto(fPp);
        }
        if ((exportName = this.renamedObjects.get(name = plp.name)) != null) {
            name = exportName;
        }
        plp.createdPort = Export.newInstanceNoIcon(this.curCell, pi, this.convertParens(name), this.ep, plp.direction);
        if (plp.createdPort == null) {
            System.out.println("Error, line " + this.lineReader.getLineNumber() + ": could not create port <" + name + ">");
            ++this.errorCount;
        }
        TextDescriptor td = plp.createdPort.getTextDescriptor(Export.EXPORT_NAME);
        td = td.withPos(AbstractTextDescriptor.Position.UP);
        plp.createdPort.setTextDescriptor(Export.EXPORT_NAME, td);
        if (this.curCell.getView() == View.SCHEMATIC && (iconCell = this.curCell.iconView()) != null && (e = plp.createdPort.findEquivalent(iconCell)) != null && plp.direction == PortCharacteristic.UNKNOWN && e.getCharacteristic() != PortCharacteristic.UNKNOWN) {
            plp.createdPort.setCharacteristic(e.getCharacteristic());
        }
        for (EDIFProperty property : plp.properties) {
            plp.createdPort.newVar(this.stripPercentEscapes(property.name), (Object)this.stripPercentEscapes(property.val.toString()), this.ep);
        }
    }

    private boolean isSpiceParameter(String x2) {
        int closePos;
        int parPos;
        return this.localPrefs.cadenceCompatibility && (parPos = x2.indexOf("pPar(")) >= 0 && (closePos = x2.indexOf(")", parPos)) >= 0;
    }

    private String stripPercentEscapes(String x2) {
        if (this.localPrefs.cadenceCompatibility) {
            boolean checkAgain = true;
            while (checkAgain) {
                int closePos;
                checkAgain = false;
                int parPos = x2.indexOf("pPar(");
                if (parPos >= 0 && (closePos = x2.indexOf(")", parPos)) >= 0) {
                    String par2 = x2.substring(parPos + 5, closePos);
                    if (par2.startsWith("%34%") && par2.endsWith("%34%")) {
                        par2 = par2.substring(4, par2.length() - 4);
                    }
                    x2 = x2.substring(0, parPos) + "@" + par2 + x2.substring(closePos + 1);
                    checkAgain = true;
                    continue;
                }
                if (x2.indexOf("%34%") < 0) continue;
                x2 = x2.replaceAll("%34%", "\"");
                checkAgain = true;
            }
        }
        return x2;
    }

    private PlannedPort addPlannedPort(String name) {
        for (PlannedPort plp : this.plannedPorts) {
            if (!plp.name.equalsIgnoreCase(name) && !plp.alternateName.equalsIgnoreCase(name)) continue;
            return plp;
        }
        PlannedPort plp = new PlannedPort();
        plp.name = name;
        plp.alternateName = name;
        plp.direction = PortCharacteristic.UNKNOWN;
        plp.properties = new ArrayList<EDIFProperty>();
        plp.pinType = Schematics.tech().offpageNode;
        plp.alreadyThere = null;
        this.plannedPorts.add(plp);
        return plp;
    }

    private boolean isAcceptedParameter(String param2, Object value2) {
        if (this.localPrefs.importAllParameters) {
            return true;
        }
        if (this.localPrefs.acceptedParameters.length() == 0) {
            return false;
        }
        String[] params = this.localPrefs.acceptedParameters.split("/");
        for (int i = 0; i < params.length; ++i) {
            if (!param2.equalsIgnoreCase(params[i])) continue;
            return true;
        }
        return false;
    }

    private class KeyViewType
    extends EDIFKEY {
        private KeyViewType() {
            super("viewType");
        }

        @Override
        protected void push() throws IOException {
            String aName = EDIF.this.getToken('\u0000');
            if (aName.equalsIgnoreCase("BEHAVIOR")) {
                EDIF.this.activeView = VBEHAVIOR;
            } else if (aName.equalsIgnoreCase("DOCUMENT")) {
                EDIF.this.activeView = VDOCUMENT;
            } else if (aName.equalsIgnoreCase("GRAPHIC")) {
                EDIF.this.activeView = VGRAPHIC;
            } else if (aName.equalsIgnoreCase("LOGICMODEL")) {
                EDIF.this.activeView = VLOGICMODEL;
            } else if (aName.equalsIgnoreCase("MASKLAYOUT")) {
                EDIF.this.activeView = VMASKLAYOUT;
            } else if (aName.equalsIgnoreCase("NETLIST")) {
                EDIF.this.activeView = VNETLIST;
            } else if (aName.equalsIgnoreCase("PCBLAYOUT")) {
                EDIF.this.activeView = VPCBLAYOUT;
            } else if (aName.equalsIgnoreCase("SCHEMATIC")) {
                EDIF.this.activeView = VSCHEMATIC;
            } else if (aName.equalsIgnoreCase("STRANGER")) {
                EDIF.this.activeView = VSTRANGER;
            } else if (aName.equalsIgnoreCase("SYMBOLIC")) {
                EDIF.this.activeView = VSYMBOLIC;
            }
            NameEntry nt = new NameEntry();
            nt.original = EDIF.this.cellReference;
            nt.replace = EDIF.this.cellName;
            EDIF.this.cellTable.put(EDIF.this.cellReference, nt);
        }
    }

    private class ViewRef
    extends EDIFKEY {
        private ViewRef() {
            super("viewRef");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.viewRef = EDIF.this.getToken('\u0000');
        }

        @Override
        protected void pop() {
            EDIF.this.viewRef = null;
        }
    }

    private class KeyView
    extends EDIFKEY {
        private KeyView() {
            super("view");
        }

        @Override
        protected void push() {
            EDIF.this.activeView = VNULL;
            EDIF.this.mappedNodes = new HashMap();
        }

        @Override
        protected void pop() {
            if (EDIF.this.curVendor == EVVIEWLOGIC && EDIF.this.activeView != VNETLIST && EDIF.this.curCell != null) {
                HashSet seenArcs = new HashSet();
                Iterator<ArcInst> it = EDIF.this.curCell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai = it.next();
                    if (seenArcs.contains(ai) || ai.getProto() != Schematics.tech().bus_arc) continue;
                    String baseName = ai.getName();
                    int openPos = baseName.indexOf(91);
                    if (openPos >= 0) {
                        baseName = baseName.substring(0, openPos);
                    }
                    EDIF.this.checkBusNames(ai, baseName, seenArcs);
                }
            }
            EDIF.this.mappedNodes = null;
        }
    }

    private class KeyUnused
    extends EDIFKEY {
        private KeyUnused() {
            super("unused");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.curDirection = PortCharacteristic.UNKNOWN;
        }
    }

    private class KeyUnit
    extends EDIFKEY {
        private KeyUnit() {
            super("unit");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.getToken('\u0000');
        }
    }

    private class KeyTrue
    extends EDIFKEY {
        private KeyTrue() {
            super("true");
        }

        @Override
        protected void push() {
            EDIF.this.propertyValue = new Boolean(true);
        }
    }

    private class KeyTextHeight
    extends EDIFKEY {
        private KeyTextHeight() {
            super("textHeight");
        }

        @Override
        protected void push() throws IOException {
            String val = EDIF.this.getToken('\u0000');
            EDIF.this.textHeight = (double)TextUtils.atoi(val) * ((EDIF)EDIF.this).localPrefs.inputScale;
            if (EDIF.this.curActiveFigure != null) {
                EDIF.this.curActiveFigure.textHeight = EDIF.this.textHeight;
            }
        }
    }

    private class KeySymbol
    extends EDIFKEY {
        private KeySymbol() {
            super("symbol");
        }

        @Override
        protected void push() {
            EDIF.this.symbolDefined = true;
        }
    }

    private class KeyStringDisplay
    extends EDIFKEY {
        private KeyStringDisplay() {
            super("stringDisplay");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.freePointList();
            EDIF.this.curOrientation = OR0;
            EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWNRIGHT;
            EDIF.this.textHeight = 0.0;
            EDIF.this.getDelimeter('\"');
            EDIF.this.textString = EDIF.this.getToken('\"');
            if (EDIF.this.textString == null) {
                throw new IOException("Unexpected end-of-file");
            }
            if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] != EDIF.this.KRENAME) {
                return;
            }
            EDIF.this.originalName = EDIF.this.fixAngleBracketBusses(EDIF.this.textString);
            int kPtr = EDIF.this.keyStackDepth - 2;
            if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 2] == EDIF.this.KARRAY) {
                kPtr = EDIF.this.keyStackDepth - 3;
            }
            if (EDIF.this.keyStack[kPtr] == EDIF.this.KCELL) {
                EDIF.this.cellName = EDIF.this.fixLeadingAmpersand(EDIF.this.originalName);
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KPORT) {
                EDIF.this.portName = EDIF.this.fixLeadingAmpersand(EDIF.this.originalName);
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KINSTANCE) {
                EDIF.this.instanceName = EDIF.this.originalName;
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KNET) {
                EDIF.this.netName = EDIF.this.fixLeadingAmpersand(EDIF.this.originalName);
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KNETBUNDLE) {
                EDIF.this.bundleName = EDIF.this.originalName;
            }
        }

        @Override
        protected void pop() {
            if (EDIF.this.keyStackDepth <= 1) {
                System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": bad location for \"stringDisplay\"");
                EDIF.this.errorCount++;
            } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KRENAME) {
                EDIF.this.freeSavedPointList();
                EDIF.this.textString = "";
                EDIF.this.saveTextPoints = EDIF.this.curPoints;
                EDIF.this.curPoints = new ArrayList();
                EDIF.this.saveTextHeight = EDIF.this.textHeight;
                EDIF.this.textHeight = 0.0;
                EDIF.this.saveTextJustification = EDIF.this.textJustification;
                EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWNRIGHT;
                EDIF.this.curOrientation = OR0;
            }
            EDIF.this.freePointList();
            EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWNRIGHT;
            EDIF.this.textHeight = 0.0;
        }
    }

    private class KeyString
    extends EDIFKEY {
        private KeyString() {
            super("string");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.positionToNextToken();
            char chr = EDIF.this.inputBuffer.charAt(EDIF.this.inputBufferPos);
            if (chr != '(' && chr != ')') {
                String value2 = EDIF.this.getToken('\u0000');
                if (value2 == null) {
                    throw new IOException("Unexpected end-of-file");
                }
                EDIF.this.propertyValue = value2.substring(1, value2.length() - 1);
            }
        }
    }

    private class KeyRename
    extends EDIFKEY {
        private KeyRename() {
            super("rename");
        }

        @Override
        protected void push() throws IOException {
            String aName = EDIF.this.getToken('\u0000');
            EDIF.this.objectName = aName;
            EDIF.this.positionToNextToken();
            char chr = EDIF.this.inputBuffer.charAt(EDIF.this.inputBufferPos);
            if (chr == '(') {
                EDIF.this.originalName = EDIF.this.objectName;
            } else {
                aName = EDIF.this.getToken('\u0000');
                EDIF.this.originalName = aName.substring(1, aName.length() - 1);
            }
            EDIF.this.originalName = EDIF.this.fixAngleBracketBusses(EDIF.this.fixLeadingAmpersand(EDIF.this.originalName));
            int kPtr = EDIF.this.keyStackDepth;
            if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KNAME) {
                kPtr = EDIF.this.keyStackDepth - 1;
            }
            kPtr = EDIF.this.keyStack[kPtr - 1] == EDIF.this.KARRAY ? (kPtr -= 2) : --kPtr;
            if (EDIF.this.keyStack[kPtr] == EDIF.this.KCELL) {
                EDIF.this.cellName = (EDIF.this.cellReference = EDIF.this.originalName);
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KPORT) {
                EDIF.this.portReference = (EDIF.this.portName = EDIF.this.originalName);
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KINSTANCE) {
                EDIF.this.instanceReference = (EDIF.this.instanceName = EDIF.this.originalName);
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KNETBUNDLE) {
                EDIF.this.bundleReference = (EDIF.this.bundleName = EDIF.this.originalName);
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KNET) {
                EDIF.this.netReference = (EDIF.this.netName = EDIF.this.originalName);
            } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KPROPERTY) {
                EDIF.this.propertyReference = EDIF.this.objectName;
            }
            if (!EDIF.this.objectName.equals(EDIF.this.originalName)) {
                EDIF.this.renamedObjects.put(EDIF.this.objectName, EDIF.this.originalName);
            }
        }
    }

    private class KeyRectangle
    extends EDIFKEY {
        private KeyRectangle() {
            super("rectangle");
        }

        @Override
        protected void push() {
            EDIF.this.freePointList();
            EDIF.this.curOrientation = OR0;
        }

        @Override
        protected void pop() {
            if (EDIF.this.curCell == null) {
                EDIF.this.freePointList();
                return;
            }
            if (EDIF.this.keyStackDepth > 1 && (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KPAGESIZE || EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KBOUNDINGBOX)) {
                EDIF.this.freePointList();
                return;
            }
            if (EDIF.this.curPoints.size() == 2) {
                Point2D p0 = (Point2D)EDIF.this.curPoints.get(0);
                Point2D p1 = (Point2D)EDIF.this.curPoints.get(1);
                double hX = p1.getX();
                double lX = p0.getX();
                if (p0.getX() > p1.getX()) {
                    lX = p1.getX();
                    hX = p0.getX();
                }
                double hY = p1.getY();
                double lY = p0.getY();
                if (p0.getY() > p1.getY()) {
                    lY = p1.getY();
                    hY = p0.getY();
                }
                double sX = hX - lX;
                double sY = hY - lY;
                double yPos = (lY + hY) / 2.0;
                double xPos = (lX + hX) / 2.0;
                if (EDIF.this.curCellPage > 0) {
                    yPos += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                }
                if (EDIF.this.curGeometryType == GPROTECTIONFRAME) {
                    PrimitiveNode eb = Generic.tech().essentialBoundsNode;
                    double wid = eb.getDefWidth(EDIF.this.ep);
                    double hei = eb.getDefHeight(EDIF.this.ep);
                    NodeInst ni1 = NodeInst.makeInstance((NodeProto)eb, EDIF.this.ep, new Point2D.Double(hX, hY), wid, hei, EDIF.this.curCell, Orientation.IDENT, null);
                    NodeInst ni2 = NodeInst.makeInstance((NodeProto)eb, EDIF.this.ep, new Point2D.Double(lX, hY), wid, hei, EDIF.this.curCell, Orientation.R, null);
                    NodeInst ni3 = NodeInst.makeInstance((NodeProto)eb, EDIF.this.ep, new Point2D.Double(lX, lY), wid, hei, EDIF.this.curCell, Orientation.RR, null);
                    NodeInst ni4 = NodeInst.makeInstance((NodeProto)eb, EDIF.this.ep, new Point2D.Double(hX, lY), wid, hei, EDIF.this.curCell, Orientation.RRR, null);
                    if (ni1 != null) {
                        ni1.setHardSelect();
                    }
                    if (ni2 != null) {
                        ni2.setHardSelect();
                    }
                    if (ni3 != null) {
                        ni3.setHardSelect();
                    }
                    if (ni4 != null) {
                        ni4.setHardSelect();
                    }
                } else {
                    NodeInst ni = NodeInst.makeInstance(EDIF.this.curFigureGroup != null ? EDIF.this.curFigureGroup : Artwork.tech().boxNode, EDIF.this.ep, new Point2D.Double(xPos, yPos), sX, sY, EDIF.this.curCell, EDIF.this.curOrientation, null);
                    if (ni == null) {
                        System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create rectangle");
                        EDIF.this.errorCount++;
                    } else if (EDIF.this.curFigureGroup == Artwork.tech().openedDottedPolygonNode) {
                        EPoint[] pts = new EPoint[]{EPoint.fromLambda(p0.getX(), p0.getY()), EPoint.fromLambda(p0.getX(), p1.getY()), EPoint.fromLambda(p1.getX(), p1.getY()), EPoint.fromLambda(p1.getX(), p0.getY()), EPoint.fromLambda(p0.getX(), p0.getY())};
                        ni.setTrace(pts);
                    } else if (EDIF.this.curGeometryType == GPORTIMPLEMENTATION) {
                        PlannedPort plp;
                        String exportName = (String)EDIF.this.renamedObjects.get(EDIF.this.objectName);
                        if (exportName == null) {
                            exportName = EDIF.this.objectName;
                        }
                        if ((plp = EDIF.this.addPlannedPort(exportName)) != null) {
                            plp.pinType = EDIF.this.cellRefProto;
                            plp.knownLocation = true;
                            plp.x = (lX + hX) / 2.0;
                            plp.y = (lY + hY) / 2.0;
                            plp.sX = sX;
                            plp.sY = sY;
                            if (EDIF.this.curCellPage > 0) {
                                plp.y += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                            }
                        }
                    } else if (EDIF.this.nodesOnNet != null) {
                        EDIF.this.nodesOnNet.add(ni);
                    }
                }
            }
            EDIF.this.freePointList();
        }
    }

    private class KeyPt
    extends EDIFKEY {
        private KeyPt() {
            super("pt");
        }

        @Override
        protected void push() throws IOException {
            String xStr = EDIF.this.getToken('\u0000');
            if (xStr == null) {
                throw new IOException("Unexpected end-of-file");
            }
            String yStr = EDIF.this.getToken('\u0000');
            if (yStr == null) {
                throw new IOException("Unexpected end-of-file");
            }
            if (EDIF.this.keyStackDepth > 1 && EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KDELTA) {
                double x2 = TextUtils.atof(xStr) * ((EDIF)EDIF.this).localPrefs.inputScale;
                double y = TextUtils.atof(yStr) * ((EDIF)EDIF.this).localPrefs.inputScale;
                if (EDIF.this.curOrientation == OR90) {
                    double s = x2;
                    x2 = -y;
                    y = s;
                } else if (EDIF.this.curOrientation == OR180) {
                    x2 = -x2;
                    y = -y;
                } else if (EDIF.this.curOrientation == OR270) {
                    double s = x2;
                    x2 = y;
                    y = -s;
                } else if (EDIF.this.curOrientation == OMY) {
                    x2 = -x2;
                } else if (EDIF.this.curOrientation == OMX) {
                    y = -y;
                } else if (EDIF.this.curOrientation == OMYR90) {
                    double s = y;
                    y = -x2;
                    x2 = -s;
                } else if (EDIF.this.curOrientation == OMXR90) {
                    double s = x2;
                    x2 = y;
                    y = s;
                }
                if (!EDIF.this.deltaPointsSet) {
                    EDIF.this.deltaPointXX = x2;
                    EDIF.this.deltaPointXY = y;
                } else {
                    EDIF.this.deltaPointYX = x2;
                    EDIF.this.deltaPointYY = y;
                }
                EDIF.this.deltaPointsSet = true;
            } else {
                Point2D.Double point = new Point2D.Double(TextUtils.atof(xStr) * ((EDIF)EDIF.this).localPrefs.inputScale, TextUtils.atof(yStr) * ((EDIF)EDIF.this).localPrefs.inputScale);
                EDIF.this.curPoints.add(point);
            }
        }
    }

    private class KeyProtectionFrame
    extends EDIFKEY {
        private KeyProtectionFrame() {
            super("protectionFrame");
        }

        @Override
        protected void push() {
            EDIF.this.curGeometryType = GPROTECTIONFRAME;
        }

        @Override
        protected void pop() {
            EDIF.this.curGeometryType = GUNKNOWN;
        }
    }

    private class KeyProperty
    extends EDIFKEY {
        private KeyProperty() {
            super("property");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.propertyReference = "";
            EDIF.this.objectName = "";
            EDIF.this.originalName = "";
            EDIF.this.propertyValue = null;
            if (EDIF.this.checkName()) {
                EDIF.this.propertyReference = EDIF.this.objectName;
            }
        }

        private boolean checkValidArrayDescription(Object obj) {
            if (!(obj instanceof String)) {
                return true;
            }
            String val = (String)obj;
            if (!val.startsWith("[")) {
                return val.contains("==") || !val.contains("=");
            }
            return val.charAt(val.length() - 1) == ']';
        }

        @Override
        protected void pop() throws IOException {
            String value2;
            EDIFProperty property;
            if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KINTERFACE) {
                property = new EDIFProperty();
                EDIF.this.propertiesList.add(property);
                property.name = "ATTR_" + EDIF.this.propertyReference;
                property.val = EDIF.this.propertyValue;
                if (!this.checkValidArrayDescription(EDIF.this.propertyValue)) {
                    System.out.println("Warning, line " + EDIF.this.lineReader.getLineNumber() + ": badly formed variable <" + EDIF.this.propertyValue + ">");
                }
            } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KINSTANCE || EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KNET || EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KPORT) {
                property = new EDIFProperty();
                EDIF.this.propertiesList.add(property);
                property.name = "ATTR_" + EDIF.this.propertyReference;
                property.val = EDIF.this.propertyValue;
                if (!this.checkValidArrayDescription(EDIF.this.propertyValue)) {
                    System.out.println("Warning, line " + EDIF.this.lineReader.getLineNumber() + ": badly formed variable <" + EDIF.this.propertyValue + ">");
                }
            } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KCELL && EDIF.this.isAcceptedParameter(EDIF.this.propertyReference, null) && EDIF.this.curCell != null && EDIF.this.curCell.getCellGroup() != null) {
                TextDescriptor td = EDIF.this.ep.getCellTextDescriptor().withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE).withInherit(true).withParam(true).withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
                Variable param2 = Variable.newInstance(Variable.newKey("ATTR_" + EDIF.this.propertyReference), EDIF.this.propertyValue, td);
                EDIF.this.curCell.getCellGroup().addParam(param2);
            }
            if (EDIF.this.curActiveFigure != null && EDIF.this.propertyReference.equals("layerNumber") && TextUtils.isANumber(value2 = EDIF.this.propertyValue.toString())) {
                int layerNum = TextUtils.atoi(value2);
                for (Map.Entry<Layer, String> e : EDIF.this.curTech.getGDSLayers().entrySet()) {
                    PrimitiveNode pure;
                    Layer layer = e.getKey();
                    String gdsLayer = e.getValue();
                    if (layerNum != TextUtils.atoi(gdsLayer) || (pure = layer.getPureLayerNode()) == null) continue;
                    EDIF.this.curActiveFigure.node = pure;
                    break;
                }
            }
            EDIF.this.propertyReference = "";
            EDIF.this.freeSavedPointList();
        }
    }

    private class KeyProgram
    extends EDIFKEY {
        private KeyProgram() {
            super("program");
        }

        @Override
        protected void push() throws IOException {
            String program = EDIF.this.getToken('\u0000');
            if (program.substring(1).startsWith("VIEWlogic")) {
                EDIF.this.curVendor = EVVIEWLOGIC;
            } else if (program.substring(1).startsWith("edifout")) {
                EDIF.this.curVendor = EVCADENCE;
            }
        }
    }

    private class KeyPortRef
    extends EDIFKEY {
        private KeyPortRef() {
            super("portRef");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.portReference = "";
            EDIF.this.instanceReference = "";
            if (EDIF.this.checkName()) {
                EDIF.this.portReference = EDIF.this.objectName;
            }
        }

        @Override
        protected void pop() {
            Poly portPoly;
            String alternateName;
            Iterator<Cell> it;
            if (EDIF.this.portReference.length() <= 0) {
                return;
            }
            NodeInst fNi = EDIF.this.curNode;
            PortProto fPp = EDIF.this.curPort;
            ArcProto ap = Generic.tech().unrouted_arc;
            Geometric ni = null;
            Nodable no = null;
            PortProto pp = null;
            if (EDIF.this.instanceReference.length() > 0) {
                String nodeName = EDIF.this.instanceReference;
                String alternateInstName = (String)EDIF.this.renamedObjects.get(nodeName);
                if (alternateInstName != null) {
                    nodeName = alternateInstName;
                }
                if (EDIF.this.activeView == VNETLIST) {
                    it = EDIF.this.curLibrary.getCells();
                    while (it.hasNext()) {
                        Cell cell = it.next();
                        if (!cell.getName().equalsIgnoreCase(EDIF.this.cellName)) continue;
                        Iterator<NodeInst> nIt = cell.getNodes();
                        while (nIt.hasNext()) {
                            NodeInst oNi = nIt.next();
                            Variable var = oNi.getVar("EDIF_name");
                            if (var != null && var.getPureValue(-1).equalsIgnoreCase(nodeName)) {
                                ni = oNi;
                                break;
                            }
                            String name = oNi.getName();
                            if (!name.equalsIgnoreCase(nodeName)) continue;
                            ni = oNi;
                            break;
                        }
                        if (ni == null) continue;
                        break;
                    }
                    if (ni == null) {
                        System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not locate netlist node (" + nodeName + ")");
                        return;
                    }
                } else if (EDIF.this.curCell != null) {
                    Iterator<Nodable> nIt = EDIF.this.curCell.getNodes();
                    while (nIt.hasNext()) {
                        NodeInst oNi = nIt.next();
                        Variable var = oNi.getVar("EDIF_name");
                        if (var != null && var.getPureValue(-1).equalsIgnoreCase(nodeName)) {
                            ni = oNi;
                            break;
                        }
                        String name = oNi.getName();
                        if (!name.equalsIgnoreCase(nodeName)) continue;
                        ni = oNi;
                        break;
                    }
                    if (ni == null) {
                        nIt = EDIF.this.curCell.getNetlist().getNodables();
                        while (nIt.hasNext()) {
                            Nodable oNo = nIt.next();
                            if (!oNo.getName().equalsIgnoreCase(nodeName)) continue;
                            no = oNo;
                            ni = no.getNodeInst();
                            break;
                        }
                    }
                    if (ni == null) {
                        System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not locate schematic node '" + nodeName + "' in " + EDIF.this.curCell);
                        return;
                    }
                    ap = !EDIF.this.isArray ? Schematics.tech().wire_arc : Schematics.tech().bus_arc;
                }
                if ((pp = ((NodeInst)ni).getProto().findPortProto(EDIF.this.portReference)) == null) {
                    EDIFEquiv.NodeEquivalence ne;
                    alternateName = (String)EDIF.this.renamedObjects.get(EDIF.this.portReference);
                    if (alternateName != null) {
                        alternateName = EDIF.this.convertParens(alternateName);
                        pp = ((NodeInst)ni).getProto().findPortProto(alternateName);
                    }
                    if (pp == null && (ne = (EDIFEquiv.NodeEquivalence)EDIF.this.mappedNodes.get(nodeName)) != null) {
                        for (EDIFEquiv.PortEquivalence pe : ne.portEquivs) {
                            if (pe.getExtPort().name.equals(EDIF.this.portReference)) {
                                pp = ((NodeInst)ni).getProto().findPortProto(pe.getElecPort().name);
                                break;
                            }
                            if (alternateName == null || !pe.getExtPort().name.equals(alternateName)) continue;
                            pp = ((NodeInst)ni).getProto().findPortProto(pe.getElecPort().name);
                            break;
                        }
                    }
                    if (pp == null) {
                        String errorMsg = "Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not find port '" + EDIF.this.portReference;
                        if (alternateName != null) {
                            errorMsg = errorMsg + "' or '" + alternateName;
                        }
                        errorMsg = errorMsg + "' on node '" + nodeName + "' in " + EDIF.this.curCell;
                        System.out.println(errorMsg);
                        return;
                    }
                }
                EDIF.this.curNode = (NodeInst)ni;
                EDIF.this.curPort = pp;
                EDIF.this.netPortRefs.add(((NodeInst)ni).findPortInstFromProto(pp));
                if (EDIF.this.activeView == VNETLIST && EDIF.this.curCell != null && ni != null) {
                    portPoly = ((NodeInst)ni).findPortInstFromProto(pp).getPoly();
                    double hX = portPoly.getCenterX();
                    double hY = portPoly.getCenterY();
                    double lX = hX;
                    double lY = hY;
                    if (pp.getCharacteristic() == PortCharacteristic.IN) {
                        lX = hX - 1.0;
                    } else if (pp.getCharacteristic() == PortCharacteristic.BIDIR) {
                        lY = hY - 1.0;
                    } else if (pp.getCharacteristic() == PortCharacteristic.OUT) {
                        lX = hX;
                        hX += 1.0;
                    }
                    ArcProto lAp = Schematics.tech().bus_arc;
                    PortProto lPp = EDIF.this.defaultBusPort;
                    NodeInst lNi = null;
                    if (EDIF.this.isArray) {
                        lNi = EDIF.this.placePin(Schematics.tech().busPinNode, (lX + hX) / 2.0, (lY + hY) / 2.0, hX - lX, hY - lY, Orientation.IDENT, EDIF.this.curCell);
                        if (lNi == null) {
                            System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create bus pin");
                            return;
                        }
                    } else {
                        lNi = EDIF.this.placePin(Schematics.tech().wirePinNode, (lX + hX) / 2.0, (lY + hY) / 2.0, hX - lX, hY - lY, Orientation.IDENT, EDIF.this.curCell);
                        if (lNi == null) {
                            System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create wire pin");
                            return;
                        }
                        lPp = EDIF.this.defaultPort;
                        lAp = Schematics.tech().wire_arc;
                    }
                    PortInst head2 = lNi.findPortInstFromProto(lPp);
                    PortInst tail = ((NodeInst)ni).findPortInstFromProto(pp);
                    EDIF.this.curArc = ArcInst.makeInstance(lAp, EDIF.this.ep, head2, tail);
                    if (EDIF.this.curArc == null) {
                        System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create auto-path");
                    } else {
                        EDIF.this.nameEDIFArc(EDIF.this.curArc, true);
                    }
                }
            } else {
                if (EDIF.this.exportsOnNet != null) {
                    String alternateName2 = (String)EDIF.this.renamedObjects.get(EDIF.this.portReference);
                    if (alternateName2 == null) {
                        alternateName2 = EDIF.this.portReference;
                    }
                    EDIF.this.exportsOnNet.add(alternateName2);
                }
                if (EDIF.this.activeView == VNETLIST) {
                    Cell np = null;
                    Cell npIcon = null;
                    it = EDIF.this.curLibrary.getCells();
                    while (it.hasNext()) {
                        Cell cell = it.next();
                        if (!cell.getName().equalsIgnoreCase(EDIF.this.cellName)) continue;
                        if (cell.isSchematic()) {
                            np = cell;
                            continue;
                        }
                        if (cell.getView() != View.ICON) continue;
                        npIcon = cell;
                    }
                    if (np == null && npIcon != null) {
                        np = npIcon;
                    }
                    if (np == null) {
                        System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not locate top level schematic");
                        return;
                    }
                    pp = np.findPortProto(EDIF.this.portReference);
                    if (pp == null) {
                        String altName;
                        if (EDIF.this.originalName.length() > 0) {
                            pp = np.findPortProto(EDIF.this.originalName);
                        }
                        alternateName = EDIF.this.portReference;
                        if (pp == null && (altName = (String)EDIF.this.renamedObjects.get(EDIF.this.portReference)) != null) {
                            alternateName = altName;
                            pp = np.findPortProto(alternateName);
                        }
                        if (pp == null && EDIF.this.curCell != null) {
                            PlannedPort plp = EDIF.this.addPlannedPort(alternateName);
                            ERectangle cellBounds = EDIF.this.curCell.getBounds();
                            EDIF.this.instantiatePlannedPort(plp, cellBounds);
                            pp = plp.createdPort;
                        }
                        if (pp == null) {
                            System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not locate port '" + EDIF.this.portReference + "' on cell " + np.describe(false));
                            return;
                        }
                    }
                    fNi = ((Export)pp).getOriginalPort().getNodeInst();
                    fPp = ((Export)pp).getOriginalPort().getPortProto();
                    portPoly = fNi.findPortInstFromProto(fPp).getPoly();
                    double lX = portPoly.getCenterX();
                    double lY = portPoly.getCenterY();
                    if (pp.getCharacteristic() == PortCharacteristic.IN) {
                        lX = 10.0;
                    } else if (pp.getCharacteristic() == PortCharacteristic.BIDIR) {
                        lY = 40.0;
                    } else if (pp.getCharacteristic() == PortCharacteristic.OUT) {
                        lX = 50.0;
                    }
                    if (EDIF.this.isArray) {
                        ni = EDIF.this.placePin(Schematics.tech().busPinNode, lX, lY, Schematics.tech().busPinNode.getDefWidth(EDIF.this.ep), Schematics.tech().busPinNode.getDefHeight(EDIF.this.ep), Orientation.IDENT, np);
                        if (ni == null) {
                            System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create bus pin");
                            return;
                        }
                        pp = EDIF.this.defaultBusPort;
                    } else {
                        ni = EDIF.this.placePin(Schematics.tech().wirePinNode, lX, lY, Schematics.tech().wirePinNode.getDefWidth(EDIF.this.ep), Schematics.tech().wirePinNode.getDefHeight(EDIF.this.ep), Orientation.IDENT, np);
                        if (ni == null) {
                            System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create wire pin");
                            return;
                        }
                        pp = EDIF.this.defaultPort;
                    }
                    ap = !EDIF.this.isArray ? Schematics.tech().wire_arc : Schematics.tech().bus_arc;
                }
            }
            if (fNi != null && fPp != null) {
                if (fNi.getParent() != ni.getParent()) {
                    System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create path (arc) between " + fNi.getParent() + " and " + ni.getParent());
                } else {
                    Poly fPortPoly = fNi.findPortInstFromProto(fPp).getPoly();
                    double lX = fPortPoly.getCenterX();
                    double lY = fPortPoly.getCenterY();
                    Poly portPoly2 = ((NodeInst)ni).findPortInstFromProto(pp).getPoly();
                    double hX = portPoly2.getCenterX();
                    double hY = portPoly2.getCenterY();
                    EDIF.this.curArc = null;
                    PortInst head3 = fNi.findPortInstFromProto(fPp);
                    PortInst tail = ((NodeInst)ni).findPortInstFromProto(pp);
                    if (head3 != tail) {
                        Point2D.Double headPt = new Point2D.Double(lX, lY);
                        Point2D.Double tailPt = new Point2D.Double(hX, hY);
                        double dist = 0.0;
                        if (lX != hX || lY != hY) {
                            dist = headPt.distance(tailPt);
                        }
                        if (dist <= 1.0) {
                            if (!head3.getPortProto().connectsTo(ap) || !tail.getPortProto().connectsTo(ap)) {
                                ArcProto[] headList = head3.getPortProto().getBasePort().getConnections();
                                for (int i = 0; i < headList.length; ++i) {
                                    ArcProto apAlt = headList[i];
                                    if (!tail.getPortProto().connectsTo(apAlt)) continue;
                                    ap = apAlt;
                                    break;
                                }
                            }
                            EDIF.this.curArc = ArcInst.makeInstance(ap, EDIF.this.ep, head3, tail, headPt, tailPt, null);
                            if (EDIF.this.curArc == null) {
                                System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create path (arc) among cells");
                            }
                        } else if (EDIF.this.activeView == VNETLIST) {
                            EDIF.this.curArc = ArcInst.makeInstance(ap, EDIF.this.ep, head3, tail, headPt, tailPt, null);
                            if (EDIF.this.curArc == null) {
                                System.out.println("error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create auto-path in portRef");
                            }
                        }
                        if (EDIF.this.curArc != null && no == null) {
                            EDIF.this.nameEDIFArc(EDIF.this.curArc, false);
                        }
                    }
                }
            }
        }
    }

    private class KeyPortList
    extends EDIFKEY {
        private KeyPortList() {
            super("portList");
        }

        @Override
        protected void push() {
            EDIF.this.curPortlist = new ArrayList();
        }

        @Override
        protected void pop() {
            if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KJOINED && EDIF.this.curPortlist != null) {
                if (EDIF.this.lastPortlist != null && EDIF.this.curPortlist.size() > 0 && EDIF.this.lastPortlist.size() != EDIF.this.curPortlist.size()) {
                    String errorMsg = "Error, line " + EDIF.this.lineReader.getLineNumber() + ": net " + EDIF.this.netName + " joins portlists with different length (" + EDIF.this.lastPortlist.size() + " and " + EDIF.this.curPortlist.size() + ") in cell " + EDIF.this.curCell;
                    System.out.println(errorMsg);
                }
                EDIF.this.lastPortlist = EDIF.this.curPortlist;
            }
        }
    }

    private class KeyPortImplementation
    extends EDIFKEY {
        private KeyPortImplementation() {
            super("portImplementation");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.freePointList();
            EDIF.this.cellRefProto = Schematics.tech().busPinNode;
            EDIF.this.curGeometryType = GPORTIMPLEMENTATION;
            EDIF.this.curOrientation = OR0;
            EDIF.this.isArray = false;
            EDIF.this.arrayXVal = (EDIF.this.arrayYVal = 1);
            EDIF.this.objectName = "";
            EDIF.this.originalName = "";
            EDIF.this.checkName();
        }

        @Override
        protected void pop() {
            EDIF.this.curGeometryType = GUNKNOWN;
        }
    }

    private class KeyPort
    extends EDIFKEY {
        private KeyPort() {
            super("port");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.objectName = "";
            EDIF.this.originalName = "";
            EDIF.this.curDirection = PortCharacteristic.IN;
            EDIF.this.portReference = "";
            EDIF.this.isArray = false;
            EDIF.this.arrayXVal = (EDIF.this.arrayYVal = 1);
            if (EDIF.this.checkName()) {
                EDIF.this.portReference = EDIF.this.objectName;
                EDIF.this.portName = EDIF.this.objectName;
            }
        }

        @Override
        protected void pop() {
            PlannedPort plp = EDIF.this.addPlannedPort(EDIF.this.portName);
            if (plp == null) {
                return;
            }
            plp.alternateName = EDIF.this.objectName;
            plp.direction = EDIF.this.curDirection;
            plp.knownLocation = false;
            plp.y = 0.0;
            plp.x = 0.0;
            if (EDIF.this.curCellPage > 0) {
                plp.y += (double)(EDIF.this.curCellPage - 1) * 1000.0;
            }
            for (EDIFProperty property : EDIF.this.propertiesList) {
                plp.properties.add(property);
            }
            EDIF.this.portReference = "";
            EDIF.this.propertiesList = new ArrayList();
        }
    }

    private class KeyPolygon
    extends EDIFKEY {
        private KeyPolygon() {
            super("polygon");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.freePointList();
            EDIF.this.curOrientation = OR0;
        }

        @Override
        protected void pop() {
            EDIF.this.doPoly();
        }
    }

    private class KeyPathWidth
    extends EDIFKEY {
        private KeyPathWidth() {
            super("pathWidth");
        }

        @Override
        protected void push() throws IOException {
            String width = EDIF.this.getToken('\u0000');
            EDIF.this.pathWidth = (double)TextUtils.atoi(width) * ((EDIF)EDIF.this).localPrefs.inputScale;
        }
    }

    private class KeyPath
    extends EDIFKEY {
        private KeyPath() {
            super("path");
        }

        @Override
        protected void push() {
            EDIF.this.freePointList();
            EDIF.this.curOrientation = OR0;
        }

        @Override
        protected void pop() {
            if (EDIF.this.curCell == null) {
                return;
            }
            if (EDIF.this.pathWidth == 0.0 && EDIF.this.curGeometryType != GNET && EDIF.this.curGeometryType != GBUS) {
                EDIF.this.doPoly();
                return;
            }
            List<PortInst> fList = new ArrayList();
            PrimitiveNode np = Schematics.tech().wirePinNode;
            if (EDIF.this.curGeometryType == GBUS || EDIF.this.isArray) {
                np = Schematics.tech().busPinNode;
            }
            if (EDIF.this.curGeometryType == GNET && EDIF.this.isBusName(EDIF.this.netName)) {
                np = Schematics.tech().busPinNode;
            }
            for (int i = 0; i < EDIF.this.curPoints.size() - 1; ++i) {
                NodeInst ni;
                Point2D fPoint = (Point2D)EDIF.this.curPoints.get(i);
                Point2D tPoint = (Point2D)EDIF.this.curPoints.get(i + 1);
                double fX = fPoint.getX();
                double fY = fPoint.getY();
                double tX = tPoint.getX();
                double tY = tPoint.getY();
                if (EDIF.this.curCellPage > 0) {
                    fY += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                    tY += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                }
                if (EDIF.this.curGeometryType == GNET || EDIF.this.curGeometryType == GBUS) {
                    List tList;
                    if (fList.size() == 0) {
                        NodeInst ni2;
                        fList = EDIF.this.findEDIFPort(EDIF.this.curCell, fX, fY, Schematics.tech().wire_arc);
                        if (fList.size() == 0) {
                            for (PortInst pi : EDIF.this.netPortRefs) {
                                EDIFEquiv.NodeEquivalence ne = EDIF.this.equivs.getNodeEquivalence(pi.getNodeInst());
                                if (ne == null) continue;
                                Point2D curPoint = new Point2D.Double(fX, fY);
                                String orientation = com.sun.electric.tool.io.output.EDIF.getOrientation(pi.getNodeInst(), 0);
                                String port = ne.getPortEquivElec((String)pi.getPortProto().getName()).getExtPort().name;
                                curPoint = EDIF.this.equivs.translatePortConnection(curPoint, ne.externalLib, ne.externalCell, ne.externalView, port, orientation);
                                if (curPoint.getX() == fX && curPoint.getY() == fY || (fList = EDIF.this.findEDIFPort(EDIF.this.curCell, curPoint.getX(), curPoint.getY(), Schematics.tech().wire_arc)).size() == 0) continue;
                                fX = curPoint.getX();
                                fY = curPoint.getY();
                                break;
                            }
                        }
                        if (fList.size() == 0 && (ni2 = EDIF.this.placePin(np, fX, fY, np.getDefWidth(EDIF.this.ep), np.getDefHeight(EDIF.this.ep), Orientation.IDENT, EDIF.this.curCell)) != null) {
                            fList.add(ni2.getOnlyPortInst());
                        }
                    }
                    if ((tList = EDIF.this.findEDIFPort(EDIF.this.curCell, tX, tY, Schematics.tech().wire_arc)).size() == 0) {
                        for (PortInst pi : EDIF.this.netPortRefs) {
                            EDIFEquiv.NodeEquivalence ne = EDIF.this.equivs.getNodeEquivalence(pi.getNodeInst());
                            if (ne == null) continue;
                            Point2D curPoint = new Point2D.Double(tX, tY);
                            String orientation = com.sun.electric.tool.io.output.EDIF.getOrientation(pi.getNodeInst(), 0);
                            String port = ne.getPortEquivElec((String)pi.getPortProto().getName()).getExtPort().name;
                            curPoint = EDIF.this.equivs.translatePortConnection(curPoint, ne.externalLib, ne.externalCell, ne.externalView, port, orientation);
                            if (curPoint.getX() == tX && curPoint.getY() == tY || (tList = EDIF.this.findEDIFPort(EDIF.this.curCell, curPoint.getX(), curPoint.getY(), Schematics.tech().wire_arc)).size() == 0) continue;
                            tX = curPoint.getX();
                            tY = curPoint.getY();
                            break;
                        }
                    }
                    if (tList.size() == 0) {
                        NodeInst ni3;
                        if (EDIF.this.curCellPage > 0) {
                            tY += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                        }
                        if ((ni3 = EDIF.this.placePin(np, tX, tY, np.getDefWidth(EDIF.this.ep), np.getDefHeight(EDIF.this.ep), Orientation.IDENT, EDIF.this.curCell)) != null) {
                            tList.add(ni3.getOnlyPortInst());
                        }
                    }
                    if (fList.size() == 0 || tList.size() == 0) {
                        System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create path");
                        EDIF.this.errorCount++;
                        continue;
                    }
                    ArcInst ai = null;
                    PortInst fPi = null;
                    PortInst tPi = null;
                    for (int count2 = 0; count2 < fList.size() || count2 < tList.size(); ++count2) {
                        Variable var;
                        NodeInst ni4;
                        boolean fbus = false;
                        boolean tbus = false;
                        if (count2 < fList.size()) {
                            fPi = (PortInst)fList.get(count2);
                            ni4 = fPi.getNodeInst();
                            var = ni4.getVar("EDIF_array");
                            if (var != null) {
                                fbus = true;
                            } else if (EDIF.this.isBusName(fPi.getPortProto().getName())) {
                                fbus = true;
                            }
                        }
                        if (count2 < tList.size()) {
                            tPi = (PortInst)tList.get(count2);
                            ni4 = tPi.getNodeInst();
                            var = ni4.getVar("EDIF_array");
                            if (var != null) {
                                tbus = true;
                            } else if (EDIF.this.isBusName(tPi.getPortProto().getName())) {
                                tbus = true;
                            }
                        }
                        ArcProto ap = Schematics.tech().wire_arc;
                        if ((fPi.getPortProto() == EDIF.this.defaultBusPort || fbus) && (tPi.getPortProto() == EDIF.this.defaultBusPort || tbus)) {
                            ap = Schematics.tech().bus_arc;
                        } else if (EDIF.this.curGeometryType == GNET) {
                            if (EDIF.this.isBusName(EDIF.this.netName)) {
                                ap = Schematics.tech().bus_arc;
                            }
                        } else if (EDIF.this.curGeometryType == GBUS && EDIF.this.isBusName(EDIF.this.bundleName)) {
                            ap = Schematics.tech().bus_arc;
                        }
                        Point2D fromPoint = new Point2D.Double(fX, fY);
                        if (!fPi.getPoly().contains(fromPoint)) {
                            fromPoint = fPi.getPoly().getCenter();
                        }
                        Point2D toPoint = new Point2D.Double(tX, tY);
                        if (!tPi.getPoly().contains(toPoint)) {
                            toPoint = tPi.getPoly().getCenter();
                        }
                        if (ap == Schematics.tech().wire_arc) {
                            PortInst newFrom;
                            NodeInst ni5;
                            Point2D.Double ctrPoint;
                            PrimitiveNode joinNode;
                            if (EDIF.this.isBusName(fPi.getPortProto().getName())) {
                                joinNode = Schematics.tech().wireConNode;
                                ctrPoint = new Point2D.Double(fromPoint.getX() + (toPoint.getX() - fromPoint.getX()) / 3.0, fromPoint.getY() + (toPoint.getY() - fromPoint.getY()) / 3.0);
                                ni5 = NodeInst.makeInstance(joinNode, EDIF.this.ep, ctrPoint, joinNode.getDefWidth(EDIF.this.ep), joinNode.getDefHeight(EDIF.this.ep), EDIF.this.curCell);
                                newFrom = ni5.getOnlyPortInst();
                                ArcInst.makeInstance(Schematics.tech().bus_arc, EDIF.this.ep, fPi, newFrom);
                                fPi = newFrom;
                                fromPoint = ctrPoint;
                            }
                            if (EDIF.this.isBusName(tPi.getPortProto().getName())) {
                                joinNode = Schematics.tech().wireConNode;
                                ctrPoint = new Point2D.Double(toPoint.getX() + (fromPoint.getX() - toPoint.getX()) / 3.0, toPoint.getY() + (fromPoint.getY() - toPoint.getY()) / 3.0);
                                ni5 = NodeInst.makeInstance(joinNode, EDIF.this.ep, ctrPoint, joinNode.getDefWidth(EDIF.this.ep), joinNode.getDefHeight(EDIF.this.ep), EDIF.this.curCell);
                                newFrom = ni5.getOnlyPortInst();
                                ArcInst.makeInstance(Schematics.tech().bus_arc, EDIF.this.ep, tPi, newFrom);
                                tPi = newFrom;
                                toPoint = ctrPoint;
                            }
                        } else if (ap == Schematics.tech().bus_arc) {
                            NodeInst nowBus;
                            if (fPi.getNodeInst().getProto() == Schematics.tech().wirePinNode) {
                                nowBus = fPi.getNodeInst().replace(Schematics.tech().busPinNode, EDIF.this.ep, true, true);
                                fPi = nowBus.getOnlyPortInst();
                            }
                            if (tPi.getNodeInst().getProto() == Schematics.tech().wirePinNode) {
                                nowBus = tPi.getNodeInst().replace(Schematics.tech().busPinNode, EDIF.this.ep, true, true);
                                tPi = nowBus.getOnlyPortInst();
                            }
                        }
                        if (fPi == tPi) continue;
                        ai = ArcInst.makeInstance(ap, EDIF.this.ep, fPi, tPi, fromPoint, toPoint, null);
                        if (ai == null) {
                            System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create path (arc)");
                            EDIF.this.errorCount++;
                            continue;
                        }
                        if (EDIF.this.arcsOnNet != null) {
                            EDIF.this.arcsOnNet.add(ai);
                        }
                        if (EDIF.this.curGeometryType == GNET && i == 0) {
                            if (EDIF.this.netReference.length() > 0) {
                                ai.newVar("EDIF_name", (Object)EDIF.this.stripPercentEscapes(EDIF.this.netReference), EDIF.this.ep);
                            }
                            if (EDIF.this.netName.length() <= 0) continue;
                            EDIF.this.putNameOnArcOnce(ai, EDIF.this.convertParens(EDIF.this.netName));
                            continue;
                        }
                        if (EDIF.this.curGeometryType != GBUS || i != 0) continue;
                        if (EDIF.this.bundleReference.length() > 0) {
                            ai.newVar("EDIF_name", (Object)EDIF.this.stripPercentEscapes(EDIF.this.bundleReference), EDIF.this.ep);
                        }
                        if (EDIF.this.bundleName.length() <= 0) continue;
                        EDIF.this.putNameOnArcOnce(ai, EDIF.this.convertParens(EDIF.this.bundleName));
                    }
                    if (ai != null) {
                        EDIF.this.curArc = ai;
                    }
                    fList = tList;
                    continue;
                }
                if (fY == tY || EDIF.this.extendEnd) {
                    fY -= EDIF.this.pathWidth / 2.0;
                    tY += EDIF.this.pathWidth / 2.0;
                }
                if (fX == tX || EDIF.this.extendEnd) {
                    fX -= EDIF.this.pathWidth / 2.0;
                    tX += EDIF.this.pathWidth / 2.0;
                }
                double cY = (fY + tY) / 2.0;
                double cX = (fX + tX) / 2.0;
                if (EDIF.this.curCellPage > 0) {
                    cY += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                }
                if ((ni = EDIF.this.placePin(EDIF.this.curFigureGroup, cX, cY, Math.abs(fX - tX), Math.abs(fY - tY), EDIF.this.curOrientation, EDIF.this.curCell)) != null) continue;
                System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create path");
                EDIF.this.errorCount++;
            }
            EDIF.this.freePointList();
        }
    }

    private class KeyOrientation
    extends EDIFKEY {
        private KeyOrientation() {
            super("orientation");
        }

        @Override
        protected void push() throws IOException {
            String orient = EDIF.this.getToken('\u0000');
            if (orient.equalsIgnoreCase("R0")) {
                EDIF.this.curOrientation = OR0;
            } else if (orient.equalsIgnoreCase("R90")) {
                EDIF.this.curOrientation = OR90;
            } else if (orient.equalsIgnoreCase("R180")) {
                EDIF.this.curOrientation = OR180;
            } else if (orient.equalsIgnoreCase("R270")) {
                EDIF.this.curOrientation = OR270;
            } else if (orient.equalsIgnoreCase("MY")) {
                EDIF.this.curOrientation = OMY;
            } else if (orient.equalsIgnoreCase("MX")) {
                EDIF.this.curOrientation = OMX;
            } else if (orient.equalsIgnoreCase("MYR90")) {
                EDIF.this.curOrientation = OMYR90;
            } else if (orient.equalsIgnoreCase("MXR90")) {
                EDIF.this.curOrientation = OMXR90;
            } else {
                System.out.println("Warning, line " + EDIF.this.lineReader.getLineNumber() + ": unknown orientation value <" + orient + ">");
                EDIF.this.warningCount++;
            }
        }
    }

    private class KeyOpenShape
    extends EDIFKEY {
        private KeyOpenShape() {
            super("openShape");
        }

        @Override
        protected void push() {
            EDIF.this.freePointList();
            EDIF.this.curOrientation = OR0;
        }

        @Override
        protected void pop() {
            EDIF.this.doPoly();
        }
    }

    private class KeyNumber
    extends EDIFKEY {
        private KeyNumber() {
            super("number");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.propertyValue = new Double(EDIF.this.getNumber());
        }
    }

    private class KeyNetBundle
    extends EDIFKEY {
        private KeyNetBundle() {
            super("netBundle");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.curGeometryType = GBUS;
            EDIF.this.bundleReference = "";
            EDIF.this.objectName = "";
            EDIF.this.originalName = "";
            EDIF.this.isArray = false;
            if (EDIF.this.checkName()) {
                EDIF.this.bundleReference = EDIF.this.objectName;
                EDIF.this.bundleName = EDIF.this.objectName;
            }
        }

        @Override
        protected void pop() {
            EDIF.this.bundleReference = "";
            EDIF.this.curArc = null;
            EDIF.this.curGeometryType = GUNKNOWN;
            EDIF.this.freeSavedPointList();
        }
    }

    private class KeyNet
    extends EDIFKEY {
        private KeyNet() {
            super("net");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.netReference = "";
            EDIF.this.objectName = "";
            EDIF.this.originalName = "";
            EDIF.this.curArc = null;
            EDIF.this.curNode = null;
            EDIF.this.curPort = null;
            EDIF.this.isArray = false;
            EDIF.this.arrayXVal = (EDIF.this.arrayYVal = 1);
            if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 2] != EDIF.this.KNETBUNDLE) {
                EDIF.this.curGeometryType = GNET;
            }
            if (EDIF.this.checkName()) {
                EDIF.this.netReference = EDIF.this.objectName;
                EDIF.this.netName = EDIF.this.objectName;
            }
            EDIF.this.exportsOnNet = new HashSet();
            EDIF.this.arcsOnNet = new ArrayList();
            EDIF.this.nodesOnNet = new ArrayList();
        }

        @Override
        protected void pop() {
            for (EDIFProperty property : EDIF.this.propertiesList) {
                if (EDIF.this.curArc == null) continue;
                String objStr = property.val.toString();
                Object newV = EDIF.this.stripPercentEscapes(objStr);
                if (EDIF.this.isSpiceParameter(objStr)) {
                    newV = Variable.withCode(newV, CodeExpression.Code.SPICE);
                }
                EDIF.this.curArc.newVar(EDIF.this.stripPercentEscapes(property.name), newV, EDIF.this.ep);
            }
            EDIF.this.propertiesList = new ArrayList();
            EDIF.this.netReference = "";
            EDIF.this.curArc = null;
            if (EDIF.this.curGeometryType != GBUS) {
                EDIF.this.curGeometryType = GUNKNOWN;
            }
            EDIF.this.freeSavedPointList();
            EDIF.this.netPortRefs.clear();
            block1: for (String exportName : EDIF.this.exportsOnNet) {
                ArcInst unNamedArc = null;
                boolean nameFound = false;
                for (ArcInst ai : EDIF.this.arcsOnNet) {
                    String arcName = ai.getName();
                    if (arcName.equals(exportName)) {
                        nameFound = true;
                    }
                    if (!ai.getNameKey().isTempname()) continue;
                    unNamedArc = ai;
                }
                if (nameFound) continue;
                if (unNamedArc != null) {
                    unNamedArc.setName(exportName, EDIF.this.ep);
                    if (((EDIF)EDIF.this).localPrefs.showArcNames) continue;
                    TextDescriptor td = unNamedArc.getTextDescriptor(ArcInst.ARC_NAME);
                    td = td.withDisplay(AbstractTextDescriptor.Display.NONE);
                    unNamedArc.setTextDescriptor(ArcInst.ARC_NAME, td);
                    continue;
                }
                if (EDIF.this.arcsOnNet.size() > 0) {
                    ArcInst ai = (ArcInst)EDIF.this.arcsOnNet.get(0);
                    ArcInst second = ArcInst.newInstanceBase(ai.getProto(), EDIF.this.ep, ai.getLambdaBaseWidth(), ai.getHeadPortInst(), ai.getTailPortInst(), ai.getHeadLocation(), ai.getTailLocation(), exportName, ai.getAngle(), ai.getD().flags);
                    TextDescriptor td = EDIF.this.ep.getArcTextDescriptor().withOff(0.0, -1.0);
                    if (!((EDIF)EDIF.this).localPrefs.showArcNames) {
                        td = td.withDisplay(AbstractTextDescriptor.Display.NONE);
                    }
                    second.setTextDescriptor(ArcInst.ARC_NAME, td);
                    continue;
                }
                if (EDIF.this.nodesOnNet.size() <= 0) continue;
                for (PlannedPort plp : EDIF.this.plannedPorts) {
                    if (!plp.name.equalsIgnoreCase(exportName) && !plp.alternateName.equalsIgnoreCase(exportName)) continue;
                    if (plp.alreadyThere != null) continue block1;
                    plp.alreadyThere = (NodeInst)EDIF.this.nodesOnNet.get(0);
                    continue block1;
                }
            }
            EDIF.this.exportsOnNet = null;
            EDIF.this.arcsOnNet = null;
            EDIF.this.nodesOnNet = null;
        }
    }

    private class KeyName
    extends EDIFKEY {
        private KeyName() {
            super("name");
        }

        @Override
        protected void push() throws IOException {
            int kPtr = EDIF.this.keyStackDepth - 1;
            if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KARRAY || EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KMEMBER) {
                kPtr = EDIF.this.keyStackDepth - 2;
            }
            if (EDIF.this.checkName()) {
                if (EDIF.this.keyStack[kPtr] == EDIF.this.KCELL) {
                    EDIF.this.cellName = (EDIF.this.cellReference = EDIF.this.fixLeadingAmpersand(EDIF.this.objectName));
                } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KPORTIMPLEMENTATION || EDIF.this.keyStack[kPtr] == EDIF.this.KPORT) {
                    EDIF.this.portName = (EDIF.this.portReference = EDIF.this.fixLeadingAmpersand(EDIF.this.objectName));
                } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KPORTREF) {
                    EDIF.this.portReference = EDIF.this.fixLeadingAmpersand(EDIF.this.objectName);
                } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KINSTANCE) {
                    EDIF.this.instanceName = (EDIF.this.instanceReference = EDIF.this.objectName);
                } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KINSTANCEREF) {
                    EDIF.this.instanceReference = EDIF.this.objectName;
                } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KNET) {
                    EDIF.this.netReference = (EDIF.this.netName = EDIF.this.fixLeadingAmpersand(EDIF.this.objectName));
                } else if (EDIF.this.keyStack[kPtr] == EDIF.this.KPROPERTY) {
                    EDIF.this.propertyReference = EDIF.this.objectName;
                }
                EDIF.this.freePointList();
                EDIF.this.curOrientation = OR0;
                EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWNRIGHT;
                EDIF.this.textHeight = 0.0;
                EDIF.this.textString = EDIF.this.objectName;
            }
        }

        @Override
        protected void pop() {
            EDIF.this.freeSavedPointList();
            EDIF.this.textString = "";
            EDIF.this.saveTextPoints = EDIF.this.curPoints;
            EDIF.this.curPoints = new ArrayList();
            EDIF.this.saveTextHeight = EDIF.this.textHeight;
            EDIF.this.textHeight = 0.0;
            EDIF.this.saveTextJustification = EDIF.this.textJustification;
            EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWNRIGHT;
            EDIF.this.curOrientation = OR0;
        }
    }

    private class KeyMember
    extends EDIFKEY {
        private KeyMember() {
            super("member");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.memberXVal = -1;
            EDIF.this.memberYVal = -1;
            if (EDIF.this.checkName()) {
                if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KPORTREF) {
                    EDIF.this.portReference = EDIF.this.objectName;
                } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KINSTANCEREF) {
                    EDIF.this.instanceReference = EDIF.this.objectName;
                }
            }
        }

        @Override
        protected void pop() {
            if (EDIF.this.memberXVal != -1) {
                if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KINSTANCEREF) {
                    EDIF.this.instanceReference = EDIF.this.getMemberName(EDIF.this.instanceReference, EDIF.this.memberXVal, EDIF.this.memberYVal);
                } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KPORTREF) {
                    EDIF.this.portReference = EDIF.this.getMemberName(EDIF.this.portReference, EDIF.this.memberXVal, EDIF.this.memberYVal);
                }
            }
        }
    }

    private class LibraryRef
    extends EDIFKEY {
        private LibraryRef() {
            super("libraryRef");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.libraryRef = EDIF.this.getToken('\u0000');
        }
    }

    private class KeyLibrary
    extends EDIFKEY {
        private KeyLibrary() {
            super("library");
        }

        @Override
        protected void push() throws IOException {
            String libName = EDIF.this.getToken('\u0000');
            EDIF.this.curLibrary = Library.findLibrary(libName);
            if (EDIF.this.curLibrary == null) {
                EDIF.this.curLibrary = Library.newInstance(libName, null);
            }
        }
    }

    private class KeyJustify
    extends EDIFKEY {
        private KeyJustify() {
            super("justify");
        }

        @Override
        protected void push() throws IOException {
            String val = EDIF.this.getToken('\u0000');
            if (val.equalsIgnoreCase("UPPERLEFT")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWNRIGHT;
            } else if (val.equalsIgnoreCase("UPPERCENTER")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWN;
            } else if (val.equalsIgnoreCase("UPPERRIGHT")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWNLEFT;
            } else if (val.equalsIgnoreCase("CENTERLEFT")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.RIGHT;
            } else if (val.equalsIgnoreCase("CENTERCENTER")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.CENT;
            } else if (val.equalsIgnoreCase("CENTERRIGHT")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.LEFT;
            } else if (val.equalsIgnoreCase("LOWERLEFT")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.UPRIGHT;
            } else if (val.equalsIgnoreCase("LOWERCENTER")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.UP;
            } else if (val.equalsIgnoreCase("LOWERRIGHT")) {
                EDIF.this.textJustification = AbstractTextDescriptor.Position.UPLEFT;
            } else {
                System.out.println("Warning, line " + EDIF.this.lineReader.getLineNumber() + ": unknown justify keyword <" + val + ">");
                EDIF.this.warningCount++;
                return;
            }
            if (EDIF.this.curActiveFigure != null) {
                EDIF.this.curActiveFigure.justification = EDIF.this.textJustification;
            }
        }
    }

    private class KeyJoined
    extends EDIFKEY {
        private KeyJoined() {
            super("joined");
        }

        @Override
        protected void push() {
            EDIF.this.lastPortlist = null;
        }
    }

    private class KeyInterface
    extends EDIFKEY {
        private KeyInterface() {
            super("interface");
        }

        @Override
        protected void push() throws IOException {
            String viewName = "ic";
            if (EDIF.this.activeView == VMASKLAYOUT) {
                viewName = "lay";
            }
            EDIF.this.curCell = EDIF.this.findCell(null, EDIF.this.cellName, viewName);
            if (EDIF.this.curCell == null) {
                EDIF.this.curCell = EDIF.this.createCell(null, EDIF.this.cellName, viewName);
                if (EDIF.this.curCell == null) {
                    throw new IOException("Error creating cell");
                }
            } else {
                EDIF.this.ignoreBlock = true;
            }
            EDIF.this.curCellPage = 0;
            EDIF.this.inputLocY = (EDIF.this.outputLocY = 0.0);
            EDIF.this.plannedPorts = new ArrayList();
            EDIF.this.symbolDefined = false;
        }

        @Override
        protected void pop() {
            if (EDIF.this.symbolDefined || EDIF.this.activeView == VGRAPHIC) {
                ERectangle cellBounds = EDIF.this.curCell.getBounds();
                for (PlannedPort plp : EDIF.this.plannedPorts) {
                    EDIF.this.instantiatePlannedPort(plp, cellBounds);
                }
                if (((EDIF)EDIF.this).localPrefs.cadenceCompatibility && EDIF.this.curCell.getView() == View.ICON) {
                    double yPos;
                    TextDescriptor td = EDIF.this.ep.getAnnotationTextDescriptor();
                    double xPos = EDIF.this.curCell.getBounds().getCenterX();
                    NodeInst ni = NodeInst.makeInstance(Generic.tech().invisiblePinNode, EDIF.this.ep, new Point2D.Double(xPos, yPos = EDIF.this.curCell.getBounds().getMaxY() - td.getSize().getSize() / 2.0), 0.0, 0.0, EDIF.this.curCell);
                    if (ni != null) {
                        td = td.withDisplay(true);
                        ni.newVar(Artwork.ART_MESSAGE, (Object)EDIF.this.curCell.getName(), td);
                    }
                }
            } else if (EDIF.this.activeView != VMASKLAYOUT) {
                ERectangle cellBounds = EDIF.this.curCell.getBounds();
                for (PlannedPort plp : EDIF.this.plannedPorts) {
                    EDIF.this.instantiatePlannedPort(plp, cellBounds);
                }
                Cell nnp = null;
                try {
                    nnp = ((EDIF)EDIF.this).localPrefs.iconParameters.makeIconForCell(EDIF.this.curCell, EDIF.this.ep);
                }
                catch (JobException jobException) {
                    // empty catch block
                }
                if (nnp == null) {
                    System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ", could not create icon <" + EDIF.this.curCell.describe(true) + ">");
                    EDIF.this.errorCount++;
                } else {
                    EDIF.this.curCell.kill();
                    EDIF.this.curCell = nnp;
                }
            }
            EDIF.this.plannedPorts = null;
        }
    }

    private class KeyInteger
    extends EDIFKEY {
        private KeyInteger() {
            super("integer");
        }

        @Override
        protected void push() throws IOException {
            String value2 = EDIF.this.getToken('\u0000');
            EDIF.this.propertyValue = new Integer(TextUtils.atoi(value2));
        }
    }

    private class KeyInstanceRef
    extends EDIFKEY {
        private KeyInstanceRef() {
            super("instanceRef");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.instanceReference = "";
            if (EDIF.this.checkName()) {
                EDIF.this.instanceReference = EDIF.this.objectName;
            }
        }
    }

    private class KeyInstance
    extends EDIFKEY {
        private KeyInstance() {
            super("instance");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.freePointList();
            EDIF.this.cellRefProto = null;
            EDIF.this.curGeometryType = GINSTANCE;
            EDIF.this.curOrientation = OR0;
            EDIF.this.isArray = false;
            EDIF.this.arrayXVal = (EDIF.this.arrayYVal = 1);
            EDIF.this.objectName = "";
            EDIF.this.originalName = "";
            EDIF.this.instanceReference = "";
            EDIF.this.curNode = null;
            if (EDIF.this.checkName()) {
                EDIF.this.instanceReference = EDIF.this.objectName;
                EDIF.this.instanceName = EDIF.this.objectName;
            }
        }

        @Override
        protected void pop() throws IOException {
            if (EDIF.this.activeView == VNETLIST) {
                block0: for (int iX = 0; iX < EDIF.this.arrayXVal; ++iX) {
                    for (int iY = 0; iY < EDIF.this.arrayYVal; ++iY) {
                        double width = EDIF.this.cellRefProto.getDefWidth(EDIF.this.ep);
                        double height = EDIF.this.cellRefProto.getDefHeight(EDIF.this.ep);
                        width = (width + 10.0 - 1.0) / 10.0;
                        height = (height + 10.0 - 1.0) / 10.0;
                        if (EDIF.this.sheetXPos == -1) {
                            EDIF.this.curCell = EDIF.this.createCell(null, EDIF.this.cellName, "sch");
                            if (EDIF.this.curCell == null) {
                                throw new IOException("Error creating cell");
                            }
                            EDIF.this.sheetXPos = (EDIF.this.sheetYPos = 1);
                            EDIF.this.sheetOffset = 2;
                        }
                        double cX = (double)(EDIF.this.sheetXPos - 22) * 10.0;
                        double cY = (double)(EDIF.this.sheetYPos - 10) * 10.0;
                        if (EDIF.this.curCellPage > 0) {
                            cY += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                        }
                        Orientation orient = EDIF.this.curOrientation.concatenate(Orientation.fromAngle(EDIF.this.cellRefProtoRotation * 10));
                        NodeInst ni = NodeInst.makeInstance(EDIF.this.cellRefProto, EDIF.this.ep, (Point2D)new Point2D.Double(cX + EDIF.this.cellRefOffsetX, cY + EDIF.this.cellRefOffsetY), EDIF.this.cellRefProto.getDefWidth(EDIF.this.ep), EDIF.this.cellRefProto.getDefHeight(EDIF.this.ep), EDIF.this.curCell, orient, null, EDIF.this.cellRefProtoFunction);
                        EDIF.this.curNode = ni;
                        if (ni == null) {
                            System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create instance");
                            EDIF.this.errorCount++;
                            continue block0;
                        }
                        if (width + 2.0 > (double)EDIF.this.sheetOffset) {
                            EDIF.this.sheetOffset = (int)width + 2;
                        }
                        if ((EDIF.this.sheetYPos = (int)((double)EDIF.this.sheetYPos + (height + 1.0))) >= 20) {
                            EDIF.this.sheetYPos = 1;
                            EDIF.this.sheetXPos += EDIF.this.sheetOffset;
                            EDIF.this.sheetOffset = 2;
                        }
                        if (EDIF.this.instanceReference.length() <= 0) continue;
                        String nodeName = EDIF.this.instanceReference;
                        if (!(EDIF.this.arrayXVal <= 1 && EDIF.this.arrayYVal <= 1 || EDIF.this.deltaPointXX == 0.0 && EDIF.this.deltaPointXY == 0.0 && EDIF.this.deltaPointYX == 0.0 && EDIF.this.deltaPointYY == 0.0)) {
                            if (EDIF.this.arrayXVal > 1) {
                                nodeName = EDIF.this.arrayYVal > 1 ? EDIF.this.instanceReference + "[" + iX + "," + iY + "]" : EDIF.this.instanceReference + "[" + iX + "]";
                            } else if (EDIF.this.arrayYVal > 1) {
                                nodeName = EDIF.this.instanceReference + "[" + iY + "]";
                            }
                        }
                        if (EDIF.this.arrayXVal > 1 || EDIF.this.arrayYVal > 1) {
                            String baseName = iX + ":" + (EDIF.this.deltaPointXX == 0.0 && EDIF.this.deltaPointYX == 0.0 ? EDIF.this.arrayXVal - 1 : iX) + ":" + EDIF.this.arrayXVal + " " + iY + ":" + (EDIF.this.deltaPointXY == 0.0 && EDIF.this.deltaPointYY == 0.0 ? EDIF.this.arrayYVal - 1 : iY) + ":" + EDIF.this.arrayYVal;
                            ni.newVar("EDIF_array", (Object)EDIF.this.stripPercentEscapes(baseName), EDIF.this.ep);
                        }
                        if (EDIF.this.instanceReference.equalsIgnoreCase(EDIF.this.instanceName)) {
                            EDIF.this.putNameOnNode(ni, nodeName);
                            continue;
                        }
                        if (iX == 0 && iY == 0) {
                            EDIF.this.putNameOnNode(ni, EDIF.this.instanceName);
                        }
                        ni.newVar("EDIF_name", (Object)EDIF.this.stripPercentEscapes(nodeName), EDIF.this.ep);
                    }
                }
            } else {
                double instPtX = 0.0;
                double instPtY = 0.0;
                int instCount = EDIF.this.curPoints.size();
                if (instCount > 0) {
                    Point2D point = (Point2D)EDIF.this.curPoints.get(0);
                    instPtX = point.getX();
                    instPtY = point.getY();
                }
                if (instCount == 0) {
                    instCount = 1;
                }
                if (instCount == 1 && EDIF.this.cellRefProto != null) {
                    for (int iX = 0; iX < EDIF.this.arrayXVal; ++iX) {
                        double lX = instPtX + (double)iX * EDIF.this.deltaPointXX;
                        double lY = instPtY + (double)iX * EDIF.this.deltaPointXY;
                        for (int iY = 0; iY < EDIF.this.arrayYVal; ++iY) {
                            double yPos = lY;
                            if (EDIF.this.curCellPage > 0) {
                                yPos += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                            }
                            Orientation orient = EDIF.this.curOrientation.concatenate(Orientation.fromAngle(EDIF.this.cellRefProtoRotation * 10));
                            if (EDIF.this.cellRefProto instanceof Cell && Cell.isInstantiationRecursive((Cell)EDIF.this.cellRefProto, EDIF.this.curCell) && EDIF.this.curCell.getView() == View.ICON) {
                                System.out.println("Cannot create instance of " + EDIF.this.cellRefProto + " in icon " + EDIF.this.curCell);
                                if (EDIF.this.deltaPointYX == 0.0 && EDIF.this.deltaPointYY == 0.0) break;
                                lX += EDIF.this.deltaPointYX;
                                lY += EDIF.this.deltaPointYY;
                                continue;
                            }
                            NodeInst ni = NodeInst.makeInstance(EDIF.this.cellRefProto, EDIF.this.ep, (Point2D)new Point2D.Double(lX + EDIF.this.cellRefOffsetX, yPos + EDIF.this.cellRefOffsetY), EDIF.this.cellRefProto.getDefWidth(EDIF.this.ep), EDIF.this.cellRefProto.getDefHeight(EDIF.this.ep), EDIF.this.curCell, orient, null, EDIF.this.cellRefProtoFunction);
                            EDIF.this.curNode = ni;
                            if (ni == null) {
                                System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create instance");
                                assert (false);
                                NodeInst.makeInstance(EDIF.this.cellRefProto, EDIF.this.ep, (Point2D)new Point2D.Double(lX + EDIF.this.cellRefOffsetX, yPos + EDIF.this.cellRefOffsetY), EDIF.this.cellRefProto.getDefWidth(EDIF.this.ep), EDIF.this.cellRefProto.getDefHeight(EDIF.this.ep), EDIF.this.curCell, orient, null, EDIF.this.cellRefProtoFunction);
                                EDIF.this.errorCount++;
                                iX = EDIF.this.arrayXVal;
                                iY = EDIF.this.arrayYVal;
                                EDIF.this.freePointList();
                                return;
                            }
                            if (EDIF.this.curGeometryType == GPORTIMPLEMENTATION && lX == 0.0 && lY == 0.0) {
                                PortProto ppt;
                                String pName = EDIF.this.portName;
                                int dup = 0;
                                while ((ppt = EDIF.this.curCell.findPortProto(pName)) != null) {
                                    pName = EDIF.this.portName + "_" + (dup + 1);
                                    ++dup;
                                }
                                iX = EDIF.this.arrayXVal;
                                iY = EDIF.this.arrayYVal;
                                PlannedPort plp = EDIF.this.addPlannedPort(pName);
                                plp.alreadyThere = ni;
                            } else if (EDIF.this.instanceReference.length() > 0) {
                                Variable.Key varKey;
                                String nodeName = EDIF.this.instanceReference;
                                if (!(EDIF.this.arrayXVal <= 1 && EDIF.this.arrayYVal <= 1 || EDIF.this.deltaPointXX == 0.0 && EDIF.this.deltaPointXY == 0.0 && EDIF.this.deltaPointYX == 0.0 && EDIF.this.deltaPointYY == 0.0)) {
                                    if (EDIF.this.arrayXVal > 1) {
                                        nodeName = EDIF.this.arrayYVal > 1 ? EDIF.this.instanceReference + "[" + iX + "," + iY + "]" : EDIF.this.instanceReference + "[" + iX + "]";
                                    } else if (EDIF.this.arrayYVal > 1) {
                                        nodeName = EDIF.this.instanceReference + "[" + iY + "]";
                                    }
                                }
                                if (EDIF.this.arrayXVal > 1 || EDIF.this.arrayYVal > 1) {
                                    String baseName = iX + ":" + (EDIF.this.deltaPointXX == 0.0 && EDIF.this.deltaPointYX == 0.0 ? EDIF.this.arrayXVal - 1 : iX) + ":" + EDIF.this.arrayXVal + " " + iY + ":" + (EDIF.this.deltaPointXY == 0.0 && EDIF.this.deltaPointYY == 0.0 ? EDIF.this.arrayYVal - 1 : iY) + ":" + EDIF.this.arrayYVal;
                                    ni.newVar("EDIF_array", (Object)EDIF.this.stripPercentEscapes(baseName), EDIF.this.ep);
                                }
                                if (EDIF.this.instanceReference.equalsIgnoreCase(EDIF.this.instanceName)) {
                                    EDIF.this.putNameOnNode(ni, nodeName);
                                    varKey = NodeInst.NODE_NAME;
                                } else {
                                    if (iX == 0 && iY == 0) {
                                        EDIF.this.putNameOnNode(ni, EDIF.this.instanceName);
                                    }
                                    Variable var = ni.newVar("EDIF_name", (Object)EDIF.this.stripPercentEscapes(nodeName), EDIF.this.ep);
                                    varKey = var.getKey();
                                }
                                if (EDIF.this.saveTextPoints.size() != 0) {
                                    Point2D sP0 = (Point2D)EDIF.this.saveTextPoints.get(0);
                                    double xOff = sP0.getX() - ni.getTrueCenterX();
                                    double yOff = sP0.getY() - ni.getTrueCenterY();
                                    if (varKey != NodeInst.NODE_NAME) {
                                        TextDescriptor td = ni.getTextDescriptor(varKey);
                                        td = td.withRelSize(EDIF.this.convertTextSize(EDIF.this.saveTextHeight)).withPos(EDIF.this.saveTextJustification).withOff(xOff, yOff);
                                        ni.setTextDescriptor(varKey, td);
                                    }
                                }
                            }
                            if (EDIF.this.deltaPointYX == 0.0 && EDIF.this.deltaPointYY == 0.0) break;
                            lX += EDIF.this.deltaPointYX;
                            lY += EDIF.this.deltaPointYY;
                        }
                        if (EDIF.this.deltaPointXX == 0.0 && EDIF.this.deltaPointXY == 0.0) break;
                    }
                }
                EDIF.this.freePointList();
            }
            for (EDIFProperty property : EDIF.this.propertiesList) {
                if (EDIF.this.curNode == null) continue;
                String varName = property.name;
                Object varValue = property.val;
                String varNameLookup = varName;
                if (varNameLookup.startsWith("ATTR_")) {
                    varNameLookup = varNameLookup.substring(5);
                }
                if (!EDIF.this.isAcceptedParameter(varNameLookup, varValue)) continue;
                EDIFEquiv.VariableEquivalence ve = EDIF.this.equivs.getExternalVariableEquivalence(varNameLookup);
                if (ve != null) {
                    String varValueString;
                    varName = "ATTR_" + ve.elecVarName;
                    if (ve.appendElecOutput.length() > 0 && (varValueString = varValue.toString()).endsWith(ve.appendElecOutput)) {
                        varValue = varValueString.substring(0, varValueString.length() - ve.appendElecOutput.length());
                    }
                    if (ve.scale != 1.0) {
                        varValueString = varValue.toString();
                        double newValue = TextUtils.atof(varValueString) / ve.scale;
                        varValue = Double.toString(newValue);
                    }
                }
                TextDescriptor td = EDIF.this.ep.getNodeTextDescriptor().withDisplay(true).withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE).withPos(AbstractTextDescriptor.Position.DOWN);
                Cell parent = (Cell)EDIF.this.curNode.getProto();
                Iterator<Variable> it = parent.getParameters();
                while (it.hasNext()) {
                    Variable var = it.next();
                    if (!var.getKey().getName().equals(varName)) continue;
                    td = td.withOff(var.getXOff(), var.getYOff());
                    break;
                }
                String objStr = varValue.toString();
                Object newV = EDIF.this.stripPercentEscapes(objStr);
                if (EDIF.this.isSpiceParameter(objStr)) {
                    newV = Variable.withCode(newV, CodeExpression.Code.SPICE);
                }
                EDIF.this.curNode.newVar(Variable.newKey(varName), newV, td);
            }
            EDIF.this.propertiesList = new ArrayList();
            EDIF.this.instanceReference = "";
            EDIF.this.curNode = null;
            EDIF.this.freeSavedPointList();
        }
    }

    private class KeyFigureGroupOverride
    extends EDIFKEY {
        private KeyFigureGroupOverride() {
            super("figureGroupOverride");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.makeFigure();
        }
    }

    private class KeyFigureGroup
    extends EDIFKEY {
        private KeyFigureGroup() {
            super("figureGroup");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.makeFigure();
        }

        @Override
        protected void pop() {
            EDIF.this.curActiveFigure = null;
        }
    }

    private class KeyFigure
    extends EDIFKEY {
        private KeyFigure() {
            super("figure");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.makeFigure();
            EDIF.this.extendEnd = false;
            EDIF.this.pathWidth = 0.0;
        }

        @Override
        protected void pop() {
            EDIF.this.curActiveFigure = null;
            EDIF.this.textJustification = AbstractTextDescriptor.Position.DOWNRIGHT;
            EDIF.this.textHeight = 0.0;
            if (EDIF.this.curGeometryType == GPORTIMPLEMENTATION) {
                PlannedPort plp;
                String exportName = (String)EDIF.this.renamedObjects.get(EDIF.this.objectName);
                if (exportName == null) {
                    exportName = EDIF.this.objectName;
                }
                if ((plp = EDIF.this.addPlannedPort(exportName)) != null) {
                    plp.pinType = EDIF.this.curFigureGroup;
                }
            }
        }
    }

    private class KeyFalse
    extends EDIFKEY {
        private KeyFalse() {
            super("false");
        }

        @Override
        protected void push() {
            EDIF.this.propertyValue = new Boolean(false);
        }
    }

    private class KeyFabricate
    extends EDIFKEY {
        private KeyFabricate() {
            super("fabricate");
        }

        @Override
        protected void push() throws IOException {
            NameEntry nt = new NameEntry();
            EDIF.this.activeFigures.add(nt);
            nt.original = EDIF.this.getToken('\u0000');
            nt.replace = EDIF.this.getToken('\u0000');
            nt.textHeight = 0.0;
            nt.justification = AbstractTextDescriptor.Position.DOWNRIGHT;
        }
    }

    private class KeyExternal
    extends EDIFKEY {
        private KeyExternal() {
            super("external");
        }

        @Override
        protected void push() throws IOException {
            String libName = EDIF.this.getToken('\u0000');
            EDIF.this.curLibrary = Library.findLibrary(libName);
            if (EDIF.this.curLibrary == null) {
                EDIF.this.curLibrary = Library.newInstance(libName, null);
            }
        }
    }

    private class KeyEndType
    extends EDIFKEY {
        private KeyEndType() {
            super("endType");
        }

        @Override
        protected void push() throws IOException {
            String type = EDIF.this.getToken('\u0000');
            if (type.equalsIgnoreCase("EXTEND")) {
                EDIF.this.extendEnd = true;
            }
        }
    }

    private class KeyDot
    extends EDIFKEY {
        private KeyDot() {
            super("dot");
        }

        @Override
        protected void push() {
            EDIF.this.freePointList();
            EDIF.this.curOrientation = OR0;
        }

        @Override
        protected void pop() {
            if (EDIF.this.curGeometryType == GPORTIMPLEMENTATION) {
                PlannedPort plp;
                String exportName = (String)EDIF.this.renamedObjects.get(EDIF.this.objectName);
                if (exportName == null) {
                    exportName = EDIF.this.objectName;
                }
                if ((plp = EDIF.this.addPlannedPort(exportName)) != null) {
                    plp.pinType = EDIF.this.cellRefProto;
                    plp.knownLocation = true;
                    Point2D p0 = (Point2D)EDIF.this.curPoints.get(0);
                    plp.x = p0.getX();
                    plp.y = p0.getY();
                    if (EDIF.this.curCellPage > 0) {
                        plp.y += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                    }
                }
            } else if (EDIF.this.curCell != null) {
                NodeInst ni;
                Point2D p0 = (Point2D)EDIF.this.curPoints.get(0);
                double xPos = p0.getX();
                double yPos = p0.getY();
                if (EDIF.this.curCellPage > 0) {
                    yPos += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                }
                if ((ni = NodeInst.makeInstance(EDIF.this.curFigureGroup != null ? EDIF.this.curFigureGroup : Artwork.tech().boxNode, EDIF.this.ep, new Point2D.Double(xPos, yPos), 0.0, 0.0, EDIF.this.curCell)) == null) {
                    System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create rectangle");
                    EDIF.this.errorCount++;
                }
            }
            EDIF.this.freePointList();
        }
    }

    private class KeyDirection
    extends EDIFKEY {
        private KeyDirection() {
            super("direction");
        }

        @Override
        protected void push() throws IOException {
            String aName = EDIF.this.getToken('\u0000');
            if (aName.equalsIgnoreCase("INPUT")) {
                EDIF.this.curDirection = PortCharacteristic.IN;
            } else if (aName.equalsIgnoreCase("INOUT")) {
                EDIF.this.curDirection = PortCharacteristic.BIDIR;
            } else if (aName.equalsIgnoreCase("OUTPUT")) {
                EDIF.this.curDirection = PortCharacteristic.OUT;
            }
        }
    }

    private class KeyDesign
    extends EDIFKEY {
        private KeyDesign() {
            super("design");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.getToken('\u0000');
        }

        @Override
        protected void pop() {
            if (EDIF.this.cellRefProto != null) {
                EDIF.this.currentCells.put(EDIF.this.curLibrary, (Cell)EDIF.this.cellRefProto);
            }
        }
    }

    private class KeyDelta
    extends EDIFKEY {
        private KeyDelta() {
            super("delta");
        }

        @Override
        protected void push() {
            EDIF.this.deltaPointXX = (EDIF.this.deltaPointXY = 0.0);
            EDIF.this.deltaPointYX = (EDIF.this.deltaPointYY = 0.0);
            EDIF.this.deltaPointsSet = false;
        }
    }

    private class KeyCornerType
    extends EDIFKEY {
        private KeyCornerType() {
            super("cornerType");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.getToken('\u0000');
        }
    }

    private class KeyContents
    extends EDIFKEY {
        private KeyContents() {
            super("contents");
        }

        @Override
        protected void push() throws IOException {
            if (EDIF.this.activeView != VNETLIST) {
                View view = View.SCHEMATIC;
                if (EDIF.this.activeView == VMASKLAYOUT) {
                    view = View.LAYOUT;
                } else if (EDIF.this.activeView == VGRAPHIC) {
                    view = View.ICON;
                }
                EDIF.this.checkName();
                Cell proto = EDIF.this.findCell(null, EDIF.this.cellName, view.getAbbreviation());
                if (proto == null) {
                    proto = EDIF.this.createCell(null, EDIF.this.cellName, view.getAbbreviation());
                    if (proto == null) {
                        throw new IOException("Error creating cell");
                    }
                } else if (EDIF.this.activeView == VSCHEMATIC) {
                    EDIF.this.ignoreBlock = true;
                }
                EDIF.this.curCell = proto;
                EDIF.this.curCellPage = 0;
                EDIF.this.inputLocY = (EDIF.this.outputLocY = 0.0);
            }
            EDIF.this.plannedPorts = new ArrayList();
        }

        @Override
        protected void pop() {
            if (EDIF.this.curCell != null) {
                ERectangle cellBounds = EDIF.this.curCell.getBounds();
                for (PlannedPort plp : EDIF.this.plannedPorts) {
                    EDIF.this.instantiatePlannedPort(plp, cellBounds);
                }
            }
            EDIF.this.plannedPorts = null;
        }
    }

    private class KeyCircle
    extends EDIFKEY {
        private KeyCircle() {
            super("circle");
        }

        @Override
        protected void push() {
            EDIF.this.freePointList();
            EDIF.this.curOrientation = OR0;
        }

        @Override
        protected void pop() {
            if (EDIF.this.curPoints.size() == 2 && EDIF.this.curCell != null) {
                NodeInst ni;
                Point2D p0 = (Point2D)EDIF.this.curPoints.get(0);
                Point2D p1 = (Point2D)EDIF.this.curPoints.get(1);
                double lX = Math.min(p0.getX(), p1.getX());
                double hX = Math.max(p0.getX(), p1.getX());
                double lY = Math.min(p0.getY(), p1.getY());
                double hY = Math.max(p0.getY(), p1.getY());
                if (lX == hX) {
                    lX -= (hY - lY) / 2.0;
                    hX += (hY - lY) / 2.0;
                } else {
                    lY -= (hX - lX) / 2.0;
                    hY += (hX - lX) / 2.0;
                }
                double sX = hX - lX;
                double sY = hY - lY;
                double cX = (hX + lX) / 2.0;
                double cY = (hY + lY) / 2.0;
                if (EDIF.this.curCellPage > 0) {
                    cY += (double)(EDIF.this.curCellPage - 1) * 1000.0;
                }
                if ((ni = NodeInst.makeInstance((NodeProto)Artwork.tech().circleNode, EDIF.this.ep, new Point2D.Double(cX, cY), sX, sY, EDIF.this.curCell, EDIF.this.curOrientation, null)) == null) {
                    System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not create circle");
                    EDIF.this.errorCount++;
                }
            }
            EDIF.this.freePointList();
        }
    }

    private class KeyCellRef
    extends EDIFKEY {
        private KeyCellRef() {
            super("cellRef");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.cellRef = EDIF.this.fixLeadingAmpersand(EDIF.this.getToken('\u0000'));
            EDIF.this.libraryRef = null;
        }

        @Override
        protected void pop() {
            String alternateName;
            EDIFEquiv.NodeEquivalence ne;
            String aName = EDIF.this.cellRef;
            EDIF.this.cellRefProtoFunction = PrimitiveNode.Function.UNKNOWN;
            EDIF.this.cellRefProtoRotation = 0;
            EDIF.this.cellRefOffsetX = (EDIF.this.cellRefOffsetY = 0.0);
            String view = "lay";
            if (EDIF.this.activeView != VMASKLAYOUT) {
                view = EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KDESIGN ? "sch" : "ic";
            }
            if (EDIF.this.curVendor == EVVIEWLOGIC && aName.equalsIgnoreCase("SPLITTER")) {
                EDIF.this.cellRefProto = null;
                return;
            }
            String libName = EDIF.this.libraryRef;
            if (libName == null) {
                libName = EDIF.this.curLibrary.getName();
            }
            if ((ne = EDIF.this.equivs.getNodeEquivalence(libName, EDIF.this.cellRef, EDIF.this.viewRef)) != null && ne.np != null) {
                Technology tech;
                EDIF.this.mappedNodes.put(EDIF.this.instanceName, ne);
                EDIF.this.cellRefProto = ne.np;
                EDIF.this.cellRefProtoFunction = PrimitiveNode.Function.UNKNOWN;
                EDIF.this.cellRefProtoRotation = ne.rotation;
                EDIF.this.cellRefOffsetX = ne.xOffset;
                EDIF.this.cellRefOffsetY = ne.yOffset;
                if (EDIF.this.cellRefProto instanceof PrimitiveNode && (tech = EDIF.this.cellRefProto.getTechnology()) instanceof Schematics) {
                    EDIF.this.cellRefProtoFunction = ne.function;
                }
                return;
            }
            NameEntry nt = (NameEntry)EDIF.this.cellTable.get(aName);
            if (nt == null && (alternateName = (String)EDIF.this.renamedObjects.get(aName)) != null) {
                nt = (NameEntry)EDIF.this.cellTable.get(alternateName);
            }
            if (nt != null) {
                aName = nt.replace;
            } else {
                Cell c = Library.findCellInLibraries(aName, View.findView(view), null);
                if (c == null) {
                    System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": could not find cellRef '" + aName + "'");
                } else {
                    EDIF.this.cellRefProto = c;
                    return;
                }
            }
            Cell proto = EDIF.this.createCell(EDIF.this.libraryRef, aName, view);
            if (proto == null) {
                System.out.println("Error, line " + EDIF.this.lineReader.getLineNumber() + ": cannot create cell " + aName + " in library " + EDIF.this.libraryRef);
            }
            EDIF.this.cellRefProto = proto;
        }
    }

    private class KeyCell
    extends EDIFKEY {
        private KeyCell() {
            super("cell");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.activeView = VNULL;
            EDIF.this.objectName = "";
            EDIF.this.originalName = "";
            EDIF.this.sheetXPos = (EDIF.this.sheetYPos = -1);
            if (EDIF.this.checkName()) {
                EDIF.this.cellName = (EDIF.this.cellReference = EDIF.this.fixLeadingAmpersand(EDIF.this.objectName));
            }
        }
    }

    private class KeyBoundingBox
    extends EDIFKEY {
        private KeyBoundingBox() {
            super("boundingBox");
        }

        @Override
        protected void push() {
            EDIF.this.curFigureGroup = Artwork.tech().openedDottedPolygonNode;
        }

        @Override
        protected void pop() {
            EDIF.this.curFigureGroup = null;
        }
    }

    private class KeyArray
    extends EDIFKEY {
        private KeyArray() {
            super("array");
        }

        @Override
        protected void push() throws IOException {
            EDIF.this.isArray = true;
            EDIF.this.arrayXVal = (EDIF.this.arrayYVal = 0);
            EDIF.this.deltaPointXX = (EDIF.this.deltaPointXY = 0.0);
            EDIF.this.deltaPointYX = (EDIF.this.deltaPointYY = 0.0);
            EDIF.this.deltaPointsSet = false;
            if (EDIF.this.checkName()) {
                if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KCELL) {
                    EDIF.this.cellName = (EDIF.this.cellReference = EDIF.this.fixLeadingAmpersand(EDIF.this.objectName));
                } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KPORT) {
                    EDIF.this.portName = (EDIF.this.portReference = EDIF.this.fixLeadingAmpersand(EDIF.this.objectName));
                } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KINSTANCE) {
                    EDIF.this.instanceName = (EDIF.this.instanceReference = EDIF.this.objectName);
                } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KNET) {
                    EDIF.this.netReference = (EDIF.this.netName = EDIF.this.fixLeadingAmpersand(EDIF.this.objectName));
                } else if (EDIF.this.keyStack[EDIF.this.keyStackDepth - 1] == EDIF.this.KPROPERTY) {
                    EDIF.this.propertyReference = EDIF.this.objectName;
                }
            }
        }

        @Override
        protected void pop() {
            if (EDIF.this.arrayXVal == 0) {
                EDIF.this.arrayXVal = 1;
            }
            if (EDIF.this.arrayYVal == 0) {
                EDIF.this.arrayYVal = 1;
            }
        }
    }

    private class KeyArc
    extends EDIFKEY {
        private KeyArc() {
            super("arc");
        }

        @Override
        protected void pop() {
            if (EDIF.this.curPoints.size() >= 3) {
                double[] x2 = new double[3];
                double[] y = new double[3];
                Point2D p0 = (Point2D)EDIF.this.curPoints.get(0);
                Point2D p1 = (Point2D)EDIF.this.curPoints.get(1);
                Point2D p2 = (Point2D)EDIF.this.curPoints.get(2);
                x2[0] = p0.getX();
                y[0] = p0.getY();
                x2[1] = p1.getX();
                y[1] = p1.getY();
                x2[2] = p2.getX();
                y[2] = p2.getY();
                EDIF.this.makeArc(x2, y);
            }
            EDIF.this.freePointList();
        }
    }

    private class EDIFKEY {
        private String name;
        private EDIFKEY[] stateArray;

        private EDIFKEY(String name) {
            this.name = name;
            edifKeys.put(TextUtils.canonicString(name), this);
        }

        protected void push() throws IOException {
        }

        protected void pop() throws IOException {
        }

        static /* synthetic */ EDIFKEY[] access$302(EDIFKEY x0, EDIFKEY[] x1) {
            x0.stateArray = x1;
            return x1;
        }
    }

    public static class EDIFPreferences
    extends Input.InputPreferences {
        public double inputScale;
        public boolean importAllParameters;
        public boolean importStitchesCells;
        public String acceptedParameters;
        public String configurationFile;
        public boolean cadenceCompatibility;
        public boolean showArcNames;
        public boolean showNodeNames;
        public IconParameters iconParameters;
        public AutoStitch.AutoOptions autoParameters;

        public EDIFPreferences(boolean factory) {
            super(factory);
            this.iconParameters = IconParameters.makeInstance(!factory);
            this.autoParameters = new AutoStitch.AutoOptions(factory);
            if (factory) {
                this.inputScale = IOTool.getFactoryEDIFInputScale();
                this.acceptedParameters = IOTool.getFactoryEDIFAcceptedParameters();
                this.importAllParameters = IOTool.isFactoryEDIFImportAllParameters();
                this.importStitchesCells = IOTool.isFactoryEDIFImportStitchesCells();
                this.configurationFile = IOTool.getFactoryEDIFConfigurationFile();
                this.cadenceCompatibility = IOTool.isFactoryEDIFCadenceCompatibility();
                this.showArcNames = IOTool.isFactoryEDIFShowArcNames();
                this.showNodeNames = IOTool.isFactoryEDIFShowNodeNames();
                this.autoParameters.createExports = false;
            } else {
                this.inputScale = IOTool.getEDIFInputScale();
                this.acceptedParameters = IOTool.getEDIFAcceptedParameters();
                this.importAllParameters = IOTool.isEDIFImportAllParameters();
                this.importStitchesCells = IOTool.isEDIFImportStitchesCells();
                this.configurationFile = IOTool.getEDIFConfigurationFile();
                this.cadenceCompatibility = IOTool.isEDIFCadenceCompatibility();
                this.showArcNames = IOTool.isEDIFShowArcNames();
                this.showNodeNames = IOTool.isEDIFShowNodeNames();
            }
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, EditingPreferences ep, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            EDIF in = new EDIF(ep, this);
            in.job = job;
            if (in.openTextInput(fileURL)) {
                return null;
            }
            lib = in.importALibrary(lib, tech, currentCells);
            in.closeInput();
            return lib;
        }
    }

    private static class PlannedPort {
        List<EDIFProperty> properties;
        PortCharacteristic direction;
        boolean knownLocation;
        Export createdPort;
        double x;
        double y;
        double sX = 0.0;
        double sY = 0.0;
        String name;
        String alternateName;
        NodeInst alreadyThere;
        NodeProto pinType;

        PlannedPort() {
        }
    }

    private static class EDIFProperty {
        private String name;
        private Object val;

        private EDIFProperty() {
        }
    }

    private static class VendorType {
        private VendorType() {
        }
    }

    private static class GeometryType {
        private GeometryType() {
        }
    }

    private static class ViewType {
        private String name;

        ViewType(String name) {
            this.name = name;
        }

        public String toString() {
            return "VIEWTYPE " + this.name;
        }
    }

    private static class NameEntry {
        private String original;
        private String replace;
        private NodeProto node;
        private double textHeight;
        private AbstractTextDescriptor.Position justification;

        private NameEntry() {
        }
    }
}

