/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellTree;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.util.collections.ArrayIterator;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpCoord;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.MutableInteger;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractShapeBuilder {
    private Layer.Function.Set onlyTheseLayers;
    private boolean reasonable;
    private boolean wipePins;
    private boolean electrical;
    private final boolean rotateNodes;
    private Orientation orient;
    protected long[] coords = new long[8];
    protected int pointCount;
    private CellBackup cellBackup;
    private Shrinkage shrinkage;
    private TechPool techPool;
    private ImmutableNodeInst curNode;
    private ImmutableArcInst curArc;

    public AbstractShapeBuilder() {
        this(true);
    }

    public AbstractShapeBuilder(boolean rotateNodes) {
        this.rotateNodes = rotateNodes;
    }

    public void setup(TechPool techPool) {
        this.cellBackup = null;
        this.shrinkage = null;
        this.techPool = techPool;
        this.orient = null;
        this.electrical = false;
        this.wipePins = false;
        this.reasonable = false;
        this.onlyTheseLayers = null;
    }

    public void setup(Cell cell) {
        this.setup(cell.backup(), null, false, true, false, null);
    }

    public void setup(CellTree cellTree, Orientation orient, boolean electrical, boolean wipePins, boolean reasonable, Layer.Function.Set onlyTheseLayers) {
        this.setup(cellTree.top, orient, electrical, wipePins, reasonable, onlyTheseLayers);
        this.techPool = cellTree.techPool;
    }

    public void setup(CellBackup cellBackup, Orientation orient, boolean electrical, boolean wipePins, boolean reasonable, Layer.Function.Set onlyTheseLayers) {
        this.cellBackup = cellBackup;
        this.shrinkage = cellBackup.getShrinkage();
        this.techPool = cellBackup.techPool;
        this.orient = orient == null || orient.isIdent() ? null : orient.canonic();
        this.electrical = electrical;
        this.wipePins = wipePins;
        this.reasonable = reasonable;
        this.onlyTheseLayers = onlyTheseLayers;
        this.pointCount = 0;
        this.curNode = null;
        this.curArc = null;
    }

    public boolean isWipePins() {
        return this.wipePins;
    }

    public boolean isElectrical() {
        return this.electrical;
    }

    public boolean isReasonable() {
        return this.reasonable;
    }

    public boolean skipLayer(Layer layer) {
        return this.onlyTheseLayers != null && !this.onlyTheseLayers.contains(layer.getFunction(), layer.getFunctionExtras());
    }

    public CellBackup getCellBackup() {
        return this.cellBackup;
    }

    public boolean pinUseCount(ImmutableNodeInst n) {
        return this.cellBackup != null && this.cellBackup.cellRevision.pinUseCount(n);
    }

    public boolean hasExportsOnNode(ImmutableNodeInst n) {
        return this.cellBackup != null && this.cellBackup.cellRevision.hasExportsOnNode(n);
    }

    public Iterator<ImmutableExport> getExportsOnNode(ImmutableNodeInst originalNode) {
        return this.cellBackup != null ? this.cellBackup.cellRevision.getExportsOnNode(originalNode) : ArrayIterator.emptyIterator();
    }

    public List<ImmutableArcInst> getConnections(BitSet headEnds, ImmutableNodeInst n) {
        return this.cellBackup != null ? this.cellBackup.cellRevision.getConnectionsOnNode(headEnds, n) : Collections.emptyList();
    }

    public List<ImmutableArcInst> getConnections(BitSet headEnds, ImmutableNodeInst n, PortProtoId portId) {
        return this.cellBackup != null ? this.cellBackup.cellRevision.getConnectionsOnPort(headEnds, n, portId) : Collections.emptyList();
    }

    public boolean isWiped(ImmutableNodeInst n) {
        return this.cellBackup != null && this.cellBackup.isWiped(n);
    }

    public Shrinkage getShrinkage() {
        return this.shrinkage;
    }

    public TechPool getTechPool() {
        return this.techPool;
    }

    public void genShapeOfArc(ImmutableArcInst a) {
        this.curNode = null;
        this.curArc = a;
        if (this.genShapeEasy(a)) {
            return;
        }
        this.pointCount = 0;
        assert (this.curNode == null);
        this.techPool.getArcProto(a.protoId).getShapeOfArc(this, a);
    }

    public void setCurNode(ImmutableNodeInst n) {
        this.pointCount = 0;
        this.curNode = n;
        this.curArc = null;
    }

    public ImmutableElectricObject getCurObj() {
        if (this.curNode != null) {
            return this.curNode;
        }
        return this.curArc;
    }

    public void genShapeOfNode(ImmutableNodeInst n, PrimitiveNode np, Technology.NodeLayer[] primLayers, EGraphics graphicsOverride) {
        this.pointCount = 0;
        this.curNode = n;
        this.curArc = null;
        for (int i = 0; i < primLayers.length; ++i) {
            Technology.NodeLayer primLayer = primLayers[i];
            Layer layer = primLayer.getLayer();
            if (this.skipLayer(layer)) continue;
            Poly.Type style = primLayer.getStyle();
            PrimitivePort pp = primLayer.getPort(np);
            if (layer.isCarbonNanotubeLayer() && (np.getFunction() == PrimitiveNode.Function.TRANMOSCN || np.getFunction() == PrimitiveNode.Function.TRAPMOSCN)) {
                CarbonNanotube cnd = new CarbonNanotube(n, primLayer);
                for (int j = 0; j < cnd.numTubes; ++j) {
                    cnd.fillCutPoly(j, style, layer, pp);
                }
                assert (graphicsOverride == null);
                continue;
            }
            int representation = primLayer.getRepresentation();
            if (representation == 1) {
                EdgeH leftEdge = primLayer.getLeftEdge();
                EdgeH rightEdge = primLayer.getRightEdge();
                EdgeV topEdge = primLayer.getTopEdge();
                EdgeV bottomEdge = primLayer.getBottomEdge();
                long portLowX = leftEdge.getFixpValue(n.size);
                long portHighX = rightEdge.getFixpValue(n.size);
                long portLowY = bottomEdge.getFixpValue(n.size);
                long portHighY = topEdge.getFixpValue(n.size);
                this.pushPoint(portLowX, portLowY);
                this.pushPoint(portHighX, portLowY);
                this.pushPoint(portHighX, portHighY);
                this.pushPoint(portLowX, portHighY);
            } else if (representation == 0) {
                Technology.TechPoint[] points = primLayer.getPoints();
                for (int j = 0; j < points.length; ++j) {
                    long x2 = points[j].getX().getFixpValue(n.size);
                    long y = points[j].getY().getFixpValue(n.size);
                    this.pushPoint(x2, y);
                }
            } else if (representation == 3) {
                MultiCutData mcd = new MultiCutData(n, primLayer);
                int numExtraLayers = this.reasonable ? mcd.cutsReasonable : mcd.cutsTotal;
                for (int j = 0; j < numExtraLayers; ++j) {
                    mcd.fillCutPoly(j, style, layer, pp);
                }
                assert (graphicsOverride == null);
                continue;
            }
            if (style.isText()) {
                assert (graphicsOverride == null);
                this.pushTextPoly(style, layer, pp, primLayer.getMessage(), primLayer.getDescriptor());
                continue;
            }
            this.pushPoly(style, layer, graphicsOverride, pp);
        }
    }

    public void pushOutlineSegment(EPoint[] outline, int offset, int count2, boolean removeCoincidentPoints, boolean removeSameStartEnd) {
        if (removeSameStartEnd) {
            while (count2 > 1 && outline[offset + count2 - 1].equals(outline[0])) {
                --count2;
            }
        }
        if (removeCoincidentPoints) {
            EPoint prevP = null;
            for (int i = 0; i < count2; ++i) {
                EPoint p = outline[offset + i];
                if (prevP != null && p.equals(prevP)) continue;
                this.pushPoint(p);
                prevP = p;
            }
        } else {
            for (int i = 0; i < count2; ++i) {
                this.pushPoint(outline[offset + i]);
            }
        }
    }

    public void genShapeOfPort(ImmutableNodeInst n, PrimitivePort pp) {
        this.pointCount = 0;
        this.curNode = n;
        this.curArc = null;
        pp.genShape(this, n);
    }

    public void genShapeOfPort(ImmutableNodeInst n, PrimitivePort pp, Point2D selectPt) {
        if (selectPt == null) {
            throw new NullPointerException();
        }
        this.pointCount = 0;
        this.curNode = n;
        this.curArc = null;
        pp.genShape(this, n, selectPt);
    }

    public void genShapeOfPort(ImmutableNodeInst n, PrimitiveNode pn, PrimitivePort pp) {
        long portLowX = pp.getLeft().getFixpValue(n.size);
        long portHighX = pp.getRight().getFixpValue(n.size);
        long portLowY = pp.getBottom().getFixpValue(n.size);
        long portHighY = pp.getTop().getFixpValue(n.size);
        this.pushPoint(portLowX, portLowY);
        this.pushPoint(portHighX, portLowY);
        this.pushPoint(portHighX, portHighY);
        this.pushPoint(portLowX, portHighY);
        this.pushPoly(Poly.Type.FILLED, null, null, null);
    }

    public void makeGridPoly(ImmutableArcInst a, long gridWidth, Poly.Type style, Layer layer, EGraphics graphicsOverride) {
        short shrinkH;
        short shrinkT;
        if (gridWidth <= 0L) {
            this.pushPoint(a.tailLocation);
            this.pushPoint(a.headLocation);
            if (style == Poly.Type.FILLED) {
                style = Poly.Type.OPENED;
            }
            this.pushPoly(style, layer, graphicsOverride, null);
            return;
        }
        long w2 = gridWidth << 19;
        if (this.shrinkage == null) {
            shrinkT = a.isTailExtended() ? (short)0 : 1;
            shrinkH = a.isHeadExtended() ? (short)0 : 1;
        } else {
            shrinkT = a.isTailExtended() ? this.shrinkage.get(a.tailNodeId) : (short)1;
            shrinkH = a.isHeadExtended() ? this.shrinkage.get(a.headNodeId) : (short)1;
        }
        int angle = a.getDefinedAngle();
        long w2x = (long)GenMath.rint((double)w2 * GenMath.cos(angle));
        long w2y = (long)GenMath.rint((double)w2 * GenMath.sin(angle));
        long tx = 0L;
        long ty = 0L;
        if (shrinkT == 0) {
            tx = -w2x;
            ty = -w2y;
        } else if (shrinkT != 1) {
            int oppAngle = a.getOppositeAngle();
            if (oppAngle == -1) {
                oppAngle = 0;
            }
            PolyBase.Point e = AbstractShapeBuilder.computeExtension(w2, -w2x, -w2y, oppAngle, shrinkT);
            tx = e.getFixpX();
            ty = e.getFixpY();
        }
        long hx = 0L;
        long hy = 0L;
        if (shrinkH == 0) {
            hx = w2x;
            hy = w2y;
        } else if (shrinkH != 1) {
            PolyBase.Point e = AbstractShapeBuilder.computeExtension(w2, w2x, w2y, angle, shrinkH);
            hx = e.getFixpX();
            hy = e.getFixpY();
        }
        this.pushPoint(a.tailLocation, tx - w2y, ty + w2x);
        this.pushPoint(a.tailLocation, tx + w2y, ty - w2x);
        this.pushPoint(a.headLocation, hx + w2y, hy - w2x);
        this.pushPoint(a.headLocation, hx - w2y, hy + w2x);
        if (gridWidth != 0L && style.isOpened()) {
            this.pushPoint(a.tailLocation, tx - w2y, ty + w2x);
        }
        this.pushPoly(style, layer, graphicsOverride, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PolyBase.Point computeExtension(long w2, long ix1, long iy1, int angle, short shrink) {
        double s2;
        double s1;
        int shrinkBits = shrink & 7;
        int valueFromBits = shrink >>> 3;
        if (shrinkBits == 3) {
            shrinkBits = angle == valueFromBits ? 1 : 0;
        }
        if (shrinkBits == 0) {
            return Poly.fromFixp(ix1, iy1);
        }
        if (shrinkBits == 1) {
            return Poly.fromFixp(0L, 0L);
        }
        int angle2 = angle - 1350;
        if (shrinkBits == 4) {
            angle2 = valueFromBits - angle;
        }
        if (angle2 < 0) {
            angle2 += 3600;
        }
        double x1 = ix1;
        double y1 = iy1;
        if (y1 == 0.0) {
            if (x1 > 0.0) {
                s1 = x1;
                x1 = 1.0;
            } else {
                if (!(x1 < 0.0)) return Poly.fromFixp(0L, 0L);
                s1 = -x1;
                x1 = -1.0;
            }
        } else if (x1 == 0.0) {
            if (y1 > 0.0) {
                s1 = y1;
                y1 = 1.0;
            } else {
                s1 = -y1;
                y1 = -1.0;
            }
        } else {
            s1 = x1 * x1 + y1 * y1;
        }
        double x2 = GenMath.rint((double)w2 * GenMath.cos(angle2));
        double y2 = GenMath.rint((double)w2 * GenMath.sin(angle2));
        if (y2 == 0.0) {
            if (x2 > 0.0) {
                s2 = x2;
                x2 = 1.0;
            } else {
                if (!(x2 < 0.0)) return Poly.fromFixp(0L, 0L);
                s2 = -x2;
                x2 = -1.0;
            }
        } else if (x2 == 0.0) {
            if (y2 > 0.0) {
                s2 = y2;
                y2 = 1.0;
            } else {
                s2 = -y2;
                y2 = -1.0;
            }
        } else {
            s2 = x2 * x2 + y2 * y2;
        }
        double det = x1 * y2 - y1 * x2;
        if (det == 0.0) {
            return Poly.fromFixp(0L, 0L);
        }
        double x3 = (x2 * s1 + x1 * s2) / det;
        double y = (y2 * s1 + y1 * s2) / det;
        long lx = (long)GenMath.rint(x3);
        long ly = (long)GenMath.rint(y);
        if (!(det < 0.0)) return Poly.fromFixp(lx += iy1, ly -= ix1);
        lx = -lx;
        ly = -ly;
        return Poly.fromFixp(lx += iy1, ly -= ix1);
    }

    private boolean genShapeEasy(ImmutableArcInst a) {
        boolean headExtended;
        boolean tailExtended;
        ArcProto protoType = this.techPool.getArcProto(a.protoId);
        if (this.cellBackup != null ? this.cellBackup.isHardArc(a.arcId) : !protoType.isEasyShape(a, false)) {
            return false;
        }
        long gridExtendOverMin = a.getGridExtendOverMin();
        long minLayerExtend = gridExtendOverMin + protoType.getMinLayerExtend().getGrid();
        if (minLayerExtend == 0L) {
            assert (protoType.getNumArcLayers() == 1);
            Technology.ArcLayer primLayer = protoType.getArcLayer(0);
            Layer layer = primLayer.getLayer();
            if (this.skipLayer(layer)) {
                return true;
            }
            Poly.Type style = primLayer.getStyle();
            if (style == Poly.Type.FILLED) {
                style = Poly.Type.OPENED;
            }
            this.coords[0] = a.tailLocation.getGridX() << 20;
            this.coords[1] = a.tailLocation.getGridY() << 20;
            this.coords[2] = a.headLocation.getGridX() << 20;
            this.coords[3] = a.headLocation.getGridY() << 20;
            assert (this.curNode == null);
            if (this.orient != null && this.orient.canonic() != Orientation.IDENT) {
                this.orient.transformPoints(2, this.coords);
            }
            this.addPoly(2, style, layer, null, null);
            assert (this.pointCount == 0);
            return true;
        }
        if (this.shrinkage == null) {
            tailExtended = a.isTailExtended();
            headExtended = a.isHeadExtended();
        } else {
            tailExtended = false;
            if (a.isTailExtended()) {
                short shrinkT = this.shrinkage.get(a.tailNodeId);
                if (shrinkT == 0) {
                    tailExtended = true;
                } else if (shrinkT != 1) {
                    return false;
                }
            }
            headExtended = false;
            if (a.isHeadExtended()) {
                short shrinkH = this.shrinkage.get(a.headNodeId);
                if (shrinkH == 0) {
                    headExtended = true;
                } else if (shrinkH != 1) {
                    return false;
                }
            }
        }
        int n = protoType.getNumArcLayers();
        for (int i = 0; i < n; ++i) {
            Technology.ArcLayer primLayer = protoType.getArcLayer(i);
            Layer layer = primLayer.getLayer();
            assert (primLayer.getStyle() == Poly.Type.FILLED);
            if (this.skipLayer(layer)) continue;
            a.makeFixpBox(this.coords, tailExtended, headExtended, gridExtendOverMin + protoType.getLayerExtend(i).getGrid());
            this.pushBox(layer);
        }
        return true;
    }

    public void pushPoint(EPoint p, long fixpX, long fixpY) {
        this.pushPoint(p.getFixpX() + fixpX, p.getFixpY() + fixpY);
    }

    public void pushPoint(EPoint p, double fixpX, double fixpY) {
        this.pushPoint(p, (long)Math.rint(fixpX), (long)Math.rint(fixpY));
    }

    public void pushPoint(double fixpX, double fixpY) {
        this.pushPoint((long)GenMath.rint(fixpX), (long)GenMath.rint(fixpY));
    }

    public void pushPoint(EPoint p) {
        this.pushPoint(p.getGridX() << 20, p.getGridY() << 20);
    }

    public void pushPoint(long fixpX, long fixpY) {
        if (this.pointCount * 2 >= this.coords.length) {
            this.resize();
        }
        this.coords[this.pointCount * 2] = fixpX;
        this.coords[this.pointCount * 2 + 1] = fixpY;
        ++this.pointCount;
    }

    private void resize() {
        long[] newCoords = new long[this.coords.length * 2];
        System.arraycopy(this.coords, 0, newCoords, 0, this.coords.length);
        this.coords = newCoords;
    }

    public void pushPoly(Poly.Type style, Layer layer, EGraphics graphicsOverride, PrimitivePort pp) {
        if (!this.electrical) {
            pp = null;
        }
        this.transformCoords(style);
        if (style == Poly.Type.FILLED && this.pointCount == 4 && graphicsOverride == null && pp == null && (this.coords[0] == this.coords[2] && this.coords[4] == this.coords[6] && this.coords[1] == this.coords[7] && this.coords[3] == this.coords[5] || this.coords[0] == this.coords[6] && this.coords[2] == this.coords[4] && this.coords[1] == this.coords[3] && this.coords[5] == this.coords[7])) {
            long lx = Math.min(this.coords[0], this.coords[4]);
            long hx = Math.max(this.coords[0], this.coords[4]);
            long ly = Math.min(this.coords[1], this.coords[5]);
            long hy = Math.max(this.coords[1], this.coords[5]);
            this.pointCount = 0;
            this.coords[0] = lx;
            this.coords[1] = ly;
            this.coords[2] = hx;
            this.coords[3] = hy;
            this.addBox(layer);
            return;
        }
        this.addPoly(this.pointCount, style, layer, graphicsOverride, pp);
        this.pointCount = 0;
    }

    public void pushTextPoly(Poly.Type style, Layer layer, PrimitivePort pp, String message, TextDescriptor descriptor) {
        if (!this.electrical) {
            pp = null;
        }
        this.transformCoords(style);
        this.addTextPoly(this.pointCount, style, layer, pp, message, descriptor);
        this.pointCount = 0;
    }

    private void transformCoords(Poly.Type style) {
        long t;
        if (this.curNode != null) {
            if (this.rotateNodes && !this.curNode.orient.isIdent()) {
                if ((style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) && this.curNode.orient.canonic().isCTranspose()) {
                    assert (this.pointCount == 3);
                    t = this.coords[2];
                    this.coords[2] = this.coords[4];
                    this.coords[4] = t;
                    t = this.coords[3];
                    this.coords[3] = this.coords[5];
                    this.coords[5] = t;
                }
                this.curNode.orient.transformPoints(this.pointCount, this.coords);
            }
            long anchorX = this.curNode.anchor.getGridX() << 20;
            long anchorY = this.curNode.anchor.getGridY() << 20;
            for (int i = 0; i < this.pointCount; ++i) {
                int n = i * 2 + 0;
                this.coords[n] = this.coords[n] + anchorX;
                int n2 = i * 2 + 1;
                this.coords[n2] = this.coords[n2] + anchorY;
            }
        }
        if (this.orient != null) {
            if ((style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) && this.orient.canonic().isCTranspose()) {
                assert (this.pointCount == 3);
                t = this.coords[2];
                this.coords[2] = this.coords[4];
                this.coords[4] = t;
                t = this.coords[3];
                this.coords[3] = this.coords[5];
                this.coords[5] = t;
            }
            this.orient.transformPoints(this.pointCount, this.coords);
        }
    }

    private void pushBox(Layer layer) {
        assert (this.pointCount == 0);
        if (this.curNode != null && !this.curNode.orient.isManhattan() || this.orient != null && !this.orient.isManhattan()) {
            long lx = this.coords[0];
            long ly = this.coords[1];
            long hx = this.coords[2];
            long hy = this.coords[3];
            this.pushPoint(lx, ly);
            this.pushPoint(hx, ly);
            this.pushPoint(hx, hy);
            this.pushPoint(lx, hy);
            this.pushPoly(Poly.Type.FILLED, layer, null, null);
            return;
        }
        if (this.curNode != null) {
            if (this.rotateNodes && !this.curNode.orient.isIdent()) {
                this.curNode.orient.rectangleBounds(this.coords);
            }
            long anchorX = this.curNode.anchor.getGridX();
            long anchorY = this.curNode.anchor.getGridY();
            this.coords[0] = this.coords[0] + anchorX;
            this.coords[1] = this.coords[1] + anchorY;
            this.coords[2] = this.coords[2] + anchorX;
            this.coords[3] = this.coords[3] + anchorY;
        }
        if (this.orient != null) {
            this.orient.rectangleBounds(this.coords);
        }
        this.addBox(layer);
    }

    public void addTextPoly(int numPoints, Poly.Type style, Layer layer, PrimitivePort pp, String message, TextDescriptor descriptor) {
        this.addPoly(numPoints, style, layer, null, pp);
    }

    protected abstract void addPoly(int var1, Poly.Type var2, Layer var3, EGraphics var4, PrimitivePort var5);

    protected abstract void addBox(Layer var1);

    SerpentineTrans newSerpentineTrans(ImmutableNodeInst niD, PrimitiveNode protoType, Technology.NodeLayer[] pLayers) {
        return new SerpentineTrans(niD, protoType, pLayers);
    }

    class SerpentineTrans {
        private static final int LEFTANGLE = 900;
        private static final int RIGHTANGLE = 2700;
        private PrimitiveNode theProto;
        int layersTotal = 0;
        private int numSegments;
        private double extraScale;
        private Technology.NodeLayer[] primLayers;
        private EPoint[] points;
        private double[] specialValues;
        private boolean fieldPolyOnEndsOnly;
        private int fillBox;

        private SerpentineTrans(ImmutableNodeInst niD, PrimitiveNode protoType, Technology.NodeLayer[] pLayers) {
            this.points = niD.getTrace();
            if (this.points != null && this.points.length < 2) {
                this.points = null;
            }
            if (this.points != null) {
                this.theProto = protoType;
                this.specialValues = this.theProto.getSpecialValues();
                this.primLayers = pLayers;
                int count2 = this.primLayers.length;
                this.numSegments = this.points.length - 1;
                this.layersTotal = count2;
                this.extraScale = 0.0;
                double length = niD.getSerpentineTransistorLength();
                if (length > 0.0) {
                    this.extraScale = (length - this.specialValues[3]) / 2.0;
                }
                this.fieldPolyOnEndsOnly = false;
                int numFieldPoly = 0;
                int numGatePoly = 0;
                for (int i = 0; i < count2; ++i) {
                    if (!this.primLayers[i].getLayer().getFunction().isPoly()) continue;
                    if (this.primLayers[i].getLayer().getFunction() == Layer.Function.GATE) {
                        ++numGatePoly;
                        continue;
                    }
                    ++numFieldPoly;
                }
                if (numFieldPoly > 0 && numGatePoly > 0) {
                    this.fieldPolyOnEndsOnly = true;
                }
            }
        }

        boolean hasValidData() {
            return this.points != null;
        }

        void initTransPolyFilling() {
            this.fillBox = 0;
        }

        void fillTransPoly() {
            int element;
            Technology.NodeLayer primLayer;
            Layer layer;
            if (AbstractShapeBuilder.this.skipLayer(layer = (primLayer = this.primLayers[element = this.fillBox++]).getLayer())) {
                return;
            }
            double extendt = primLayer.getSerpentineExtentT().getLambda();
            double extendb = primLayer.getSerpentineExtentB().getLambda();
            boolean extendEnds = true;
            if (this.fieldPolyOnEndsOnly && layer.getFunction().isPoly()) {
                if (layer.getFunction() == Layer.Function.GATE) {
                    extendEnds = false;
                } else {
                    if (extendt != 0.0) {
                        int thissg = 0;
                        int nextsg = 1;
                        Point2D thisPt = this.points[thissg];
                        EPoint nextPt = this.points[nextsg];
                        int angle = DBMath.figureAngle(thisPt, nextPt);
                        nextPt = thisPt;
                        int ang = angle + 1800;
                        thisPt = DBMath.addPoints(thisPt, DBMath.cos(ang) * extendt, DBMath.sin(ang) * extendt);
                        this.buildSerpentinePoly(element, 0, this.numSegments, thisPt, nextPt, angle);
                        return;
                    }
                    if (extendb != 0.0) {
                        int thissg = this.numSegments - 1;
                        int nextsg = this.numSegments;
                        EPoint thisPt = this.points[thissg];
                        Point2D nextPt = this.points[nextsg];
                        int angle = DBMath.figureAngle(thisPt, nextPt);
                        thisPt = nextPt;
                        nextPt = DBMath.addPoints(nextPt, DBMath.cos(angle) * extendb, DBMath.sin(angle) * extendb);
                        this.buildSerpentinePoly(element, 0, this.numSegments, thisPt, nextPt, angle);
                        return;
                    }
                }
            }
            Point2D.Double[] outPoints = new Point2D.Double[(this.numSegments + 1) * 2];
            for (int segment = 0; segment < this.numSegments; ++segment) {
                EPoint otherPt;
                int otherang;
                int thissg = segment;
                int nextsg = segment + 1;
                Point2D thisPt = this.points[thissg];
                Point2D nextPt = this.points[nextsg];
                int angle = DBMath.figureAngle(thisPt, nextPt);
                if (extendEnds) {
                    if (thissg == 0) {
                        int ang = angle + 1800;
                        thisPt = DBMath.addPoints(thisPt, DBMath.cos(ang) * extendt, DBMath.sin(ang) * extendt);
                    }
                    if (nextsg == this.numSegments) {
                        nextPt = DBMath.addPoints(nextPt, DBMath.cos(angle) * extendb, DBMath.sin(angle) * extendb);
                    }
                }
                double lwid = primLayer.getSerpentineLWidth().getLambda();
                double rwid = primLayer.getSerpentineRWidth().getLambda();
                rwid += this.extraScale;
                int ang = angle + 900;
                double sin = DBMath.sin(ang) * (lwid += this.extraScale);
                double cos = DBMath.cos(ang) * lwid;
                Point2D thisL = DBMath.addPoints(thisPt, cos, sin);
                Point2D nextL = DBMath.addPoints(nextPt, cos, sin);
                ang = angle + 2700;
                sin = DBMath.sin(ang) * rwid;
                cos = DBMath.cos(ang) * rwid;
                Point2D thisR = DBMath.addPoints(thisPt, cos, sin);
                Point2D nextR = DBMath.addPoints(nextPt, cos, sin);
                if (thissg != 0 && (otherang = DBMath.figureAngle(otherPt = this.points[thissg - 1], thisPt)) != angle) {
                    ang = otherang + 900;
                    thisL = DBMath.intersect(DBMath.addPoints(thisPt, DBMath.cos(ang) * lwid, DBMath.sin(ang) * lwid), otherang, thisL, angle);
                    ang = otherang + 2700;
                    thisR = DBMath.intersect(DBMath.addPoints(thisPt, DBMath.cos(ang) * rwid, DBMath.sin(ang) * rwid), otherang, thisR, angle);
                }
                if (nextsg != this.numSegments && (otherang = DBMath.figureAngle(nextPt, otherPt = this.points[nextsg + 1])) != angle) {
                    ang = otherang + 900;
                    Point2D newPtL = DBMath.addPoints(nextPt, DBMath.cos(ang) * lwid, DBMath.sin(ang) * lwid);
                    nextL = DBMath.intersect(newPtL, otherang, nextL, angle);
                    ang = otherang + 2700;
                    Point2D newPtR = DBMath.addPoints(nextPt, DBMath.cos(ang) * rwid, DBMath.sin(ang) * rwid);
                    nextR = DBMath.intersect(newPtR, otherang, nextR, angle);
                }
                if (segment == 0) {
                    outPoints[0] = thisL;
                    outPoints[1] = nextL;
                    outPoints[(this.numSegments + 1) * 2 - 2] = nextR;
                    outPoints[(this.numSegments + 1) * 2 - 1] = thisR;
                    continue;
                }
                outPoints[segment + 1] = nextL;
                outPoints[(this.numSegments + 1) * 2 - 2 - segment] = nextR;
            }
            for (Point2D.Double point : outPoints) {
                AbstractShapeBuilder.this.pushPoint(FixpCoord.lambdaToFixp(((Point2D)point).getX()), FixpCoord.lambdaToFixp(((Point2D)point).getY()));
            }
            AbstractShapeBuilder.this.pushPoly(primLayer.getStyle(), layer, null, primLayer.getPort(this.theProto));
        }

        private void buildSerpentinePoly(int element, int thissg, int nextsg, Point2D thisPt, Point2D nextPt, int angle) {
            EPoint otherPt;
            int otherang;
            Technology.NodeLayer primLayer = this.primLayers[element];
            double lwid = primLayer.getSerpentineLWidth().getLambda();
            double rwid = primLayer.getSerpentineRWidth().getLambda();
            rwid += this.extraScale;
            int ang = angle + 900;
            double sin = DBMath.sin(ang) * (lwid += this.extraScale);
            double cos = DBMath.cos(ang) * lwid;
            Point2D thisL = DBMath.addPoints(thisPt, cos, sin);
            Point2D nextL = DBMath.addPoints(nextPt, cos, sin);
            ang = angle + 2700;
            sin = DBMath.sin(ang) * rwid;
            cos = DBMath.cos(ang) * rwid;
            Point2D thisR = DBMath.addPoints(thisPt, cos, sin);
            Point2D nextR = DBMath.addPoints(nextPt, cos, sin);
            if (thissg != 0 && (otherang = DBMath.figureAngle(otherPt = this.points[thissg - 1], thisPt)) != angle) {
                ang = otherang + 900;
                thisL = DBMath.intersect(DBMath.addPoints(thisPt, DBMath.cos(ang) * lwid, DBMath.sin(ang) * lwid), otherang, thisL, angle);
                ang = otherang + 2700;
                thisR = DBMath.intersect(DBMath.addPoints(thisPt, DBMath.cos(ang) * rwid, DBMath.sin(ang) * rwid), otherang, thisR, angle);
            }
            if (nextsg != this.numSegments && (otherang = DBMath.figureAngle(nextPt, otherPt = this.points[nextsg + 1])) != angle) {
                ang = otherang + 900;
                Point2D newPtL = DBMath.addPoints(nextPt, DBMath.cos(ang) * lwid, DBMath.sin(ang) * lwid);
                nextL = DBMath.intersect(newPtL, otherang, nextL, angle);
                ang = otherang + 2700;
                Point2D newPtR = DBMath.addPoints(nextPt, DBMath.cos(ang) * rwid, DBMath.sin(ang) * rwid);
                nextR = DBMath.intersect(newPtR, otherang, nextR, angle);
            }
            AbstractShapeBuilder.this.pushPoint(FixpCoord.lambdaToFixp(thisL.getX()), FixpCoord.lambdaToFixp(thisL.getY()));
            AbstractShapeBuilder.this.pushPoint(FixpCoord.lambdaToFixp(thisR.getX()), FixpCoord.lambdaToFixp(thisR.getY()));
            AbstractShapeBuilder.this.pushPoint(FixpCoord.lambdaToFixp(nextR.getX()), FixpCoord.lambdaToFixp(nextR.getY()));
            AbstractShapeBuilder.this.pushPoint(FixpCoord.lambdaToFixp(nextL.getX()), FixpCoord.lambdaToFixp(nextL.getY()));
            AbstractShapeBuilder.this.pushPoly(primLayer.getStyle(), primLayer.getLayer(), null, primLayer.getPort(this.theProto));
        }

        void fillTransPort(PortProto pp) {
            Point2D.Double nextPt;
            Point2D.Double thisPt;
            PortProto lpp;
            double diffInset = this.specialValues[1];
            double diffExtend = this.specialValues[2];
            double defWid = this.specialValues[3] + this.extraScale;
            double polyInset = this.specialValues[4];
            double polyExtend = this.specialValues[5];
            int total = this.points.length;
            int which = 0;
            Iterator<PortProto> it = this.theProto.getPorts();
            while (it.hasNext() && (lpp = it.next()) != pp) {
                ++which;
            }
            assert (which == pp.getPortIndex());
            if (which == 0) {
                thisPt = new Point2D.Double(this.points[0].getX(), this.points[0].getY());
                nextPt = new Point2D.Double(this.points[1].getX(), this.points[1].getY());
                int angle = DBMath.figureAngle(thisPt, nextPt);
                int ang = (angle + 1800) % 3600;
                ((Point2D)thisPt).setLocation(((Point2D)thisPt).getX() + DBMath.cos(ang) * polyExtend, ((Point2D)thisPt).getY() + DBMath.sin(ang) * polyExtend);
                ang = (angle + 900) % 3600;
                Point2D.Double end1 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                ang = (angle + 2700) % 3600;
                Point2D.Double end2 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                AbstractShapeBuilder.this.pushPoint(FixpCoord.lambdaToFixp(((Point2D)end1).getX()), FixpCoord.lambdaToFixp(((Point2D)end1).getY()));
                AbstractShapeBuilder.this.pushPoint(FixpCoord.lambdaToFixp(((Point2D)end2).getX()), FixpCoord.lambdaToFixp(((Point2D)end2).getY()));
                AbstractShapeBuilder.this.pushPoly(Poly.Type.OPENED, null, null, null);
                return;
            }
            if (which == 2) {
                thisPt = new Point2D.Double(this.points[total - 1].getX(), this.points[total - 1].getY());
                nextPt = new Point2D.Double(this.points[total - 2].getX(), this.points[total - 2].getY());
                int angle = DBMath.figureAngle(thisPt, nextPt);
                int ang = (angle + 1800) % 3600;
                ((Point2D)thisPt).setLocation(((Point2D)thisPt).getX() + DBMath.cos(ang) * polyExtend, ((Point2D)thisPt).getY() + DBMath.sin(ang) * polyExtend);
                ang = (angle + 900) % 3600;
                Point2D.Double end1 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                ang = (angle + 2700) % 3600;
                Point2D.Double end2 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                AbstractShapeBuilder.this.pushPoint(FixpCoord.lambdaToFixp(((Point2D)end1).getX()), FixpCoord.lambdaToFixp(((Point2D)end1).getY()));
                AbstractShapeBuilder.this.pushPoint(FixpCoord.lambdaToFixp(((Point2D)end2).getX()), FixpCoord.lambdaToFixp(((Point2D)end2).getY()));
                AbstractShapeBuilder.this.pushPoly(Poly.Type.OPENED, null, null, null);
                return;
            }
            if (which == 3) {
                diffExtend = -diffExtend;
                defWid = -defWid;
            }
            if (which == 4) {
                defWid = 0.0;
                diffExtend = 0.0;
            }
            Point2D.Double[] portPoints = new Point2D.Double[total];
            Point2D.Double lastPoint = null;
            int lastAngle = 0;
            for (int nextIndex = 1; nextIndex < total; ++nextIndex) {
                int thisIndex = nextIndex - 1;
                Point2D thisPt2 = new Point2D.Double(this.points[thisIndex].getX(), this.points[thisIndex].getY());
                Point2D.Double nextPt2 = new Point2D.Double(this.points[nextIndex].getX(), this.points[nextIndex].getY());
                int angle = DBMath.figureAngle(thisPt2, nextPt2);
                if (thisIndex == 0) {
                    ((Point2D)thisPt2).setLocation(((Point2D)thisPt2).getX() + DBMath.cos(angle) * diffInset, ((Point2D)thisPt2).getY() + DBMath.sin(angle) * diffInset);
                }
                if (nextIndex == total - 1) {
                    int backAng = (angle + 1800) % 3600;
                    ((Point2D)nextPt2).setLocation(((Point2D)nextPt2).getX() + DBMath.cos(backAng) * diffInset, ((Point2D)nextPt2).getY() + DBMath.sin(backAng) * diffInset);
                }
                int ang = (angle + 900) % 3600;
                double sine = DBMath.sin(ang);
                double cosine = DBMath.cos(ang);
                ((Point2D)thisPt2).setLocation(((Point2D)thisPt2).getX() + cosine * (defWid / 2.0 + diffExtend), ((Point2D)thisPt2).getY() + sine * (defWid / 2.0 + diffExtend));
                ((Point2D)nextPt2).setLocation(((Point2D)nextPt2).getX() + cosine * (defWid / 2.0 + diffExtend), ((Point2D)nextPt2).getY() + sine * (defWid / 2.0 + diffExtend));
                if (thisIndex != 0) {
                    thisPt2 = DBMath.intersect(lastPoint, lastAngle, thisPt2, angle);
                }
                portPoints[thisIndex] = thisPt2;
                lastPoint = thisPt2;
                lastAngle = angle;
                if (nextIndex != total - 1) continue;
                portPoints[nextIndex] = nextPt2;
            }
            for (Point2D.Double point : portPoints) {
                AbstractShapeBuilder.this.pushPoint(FixpCoord.lambdaToFixp(((Point2D)point).getX()), FixpCoord.lambdaToFixp(((Point2D)point).getY()));
            }
            AbstractShapeBuilder.this.pushPoly(Poly.Type.OPENED, null, null, null);
        }
    }

    private class MultiCutData {
        private long cutSizeX;
        private long cutSizeY;
        private long cutSep;
        private long cutSep1D;
        private long cutSep2D;
        private int cutsX;
        private int cutsY;
        private int cutsTotal;
        private int cutsReasonable;
        private long cutBaseX;
        private long cutBaseY;
        private long cutShiftLeftXPos;
        private long cutShiftRightXPos;
        private long cutShiftNoneXPos;
        private long cutShiftDownYPos;
        private long cutShiftUpYPos;
        private long cutShiftNoneYPos;
        private long cutShiftLeftXAmt;
        private long cutShiftRightXAmt;
        private long cutShiftDownYAmt;
        private long cutShiftUpYAmt;
        private double cutTopEdge;
        private double cutLeftEdge;
        private double cutRightEdge;

        private MultiCutData(ImmutableNodeInst niD, Technology.NodeLayer cutLayer) {
            this.calculateInternalData(niD, cutLayer);
        }

        private MultiCutData(ImmutableNodeInst niD, TechPool techPool) {
            this.calculateInternalData(niD, techPool.getPrimitiveNode((PrimitiveNodeId)niD.protoId).findMulticut());
        }

        private void calculateInternalData(ImmutableNodeInst niD, Technology.NodeLayer cutLayer) {
            Integer cutAlignment;
            double spacingD;
            Variable var;
            assert (cutLayer.getRepresentation() == 3);
            Technology.TechPoint[] techPoints = cutLayer.getPoints();
            long lx = techPoints[0].getX().getGridValue(niD.size);
            long hx = techPoints[1].getX().getGridValue(niD.size);
            long ly = techPoints[0].getY().getGridValue(niD.size);
            long hy = techPoints[1].getY().getGridValue(niD.size);
            this.cutSizeX = cutLayer.getMulticutSizeX().getGrid();
            this.cutSizeY = cutLayer.getMulticutSizeY().getGrid();
            this.cutSep1D = cutLayer.getMulticutSep1D().getGrid();
            this.cutSep2D = cutLayer.getMulticutSep2D().getGrid();
            if (!niD.isEasyShape() && (var = niD.getVar(Technology.NodeLayer.CUT_SPACING)) != null && (spacingD = VarContext.objectToDouble(var.getObject(), -1.0)) != -1.0) {
                this.cutSep1D = this.cutSep2D = DBMath.lambdaToGrid(spacingD);
            }
            this.cutBaseX = lx + hx >> 1;
            this.cutBaseY = ly + hy >> 1;
            long cutAreaWidth = hx - lx;
            long cutAreaHeight = hy - ly;
            int oneDcutsX = 1 + (int)(cutAreaWidth / (this.cutSizeX + this.cutSep1D));
            int oneDcutsY = 1 + (int)(cutAreaHeight / (this.cutSizeY + this.cutSep1D));
            this.cutSep = this.cutSep1D;
            this.cutsX = oneDcutsX;
            this.cutsY = oneDcutsY;
            if (this.cutsX > 1 && this.cutsY > 1) {
                int twoDcutsX = 1 + (int)(cutAreaWidth / (this.cutSizeX + this.cutSep2D));
                int twoDcutsY = 1 + (int)(cutAreaHeight / (this.cutSizeY + this.cutSep2D));
                this.cutSep = this.cutSep2D;
                this.cutsX = twoDcutsX;
                this.cutsY = twoDcutsY;
                if (this.cutsX == 1 || this.cutsY == 1) {
                    this.cutSep = this.cutSep1D;
                    if (cutAreaWidth > cutAreaHeight) {
                        this.cutsX = oneDcutsX;
                    } else {
                        this.cutsY = oneDcutsY;
                    }
                }
            }
            if (this.cutsX <= 0) {
                this.cutsX = 1;
            }
            if (this.cutsY <= 0) {
                this.cutsY = 1;
            }
            this.cutShiftLeftXPos = this.cutsX;
            this.cutShiftRightXPos = this.cutsX;
            this.cutShiftDownYPos = this.cutsY;
            this.cutShiftUpYPos = this.cutsY;
            this.cutShiftNoneXPos = -1L;
            this.cutShiftNoneYPos = -1L;
            if (!niD.isEasyShape() && (cutAlignment = (Integer)niD.getVarValue(Technology.NodeLayer.CUT_ALIGNMENT, Integer.class)) != null) {
                if (cutAlignment == 1) {
                    this.cutShiftLeftXPos = 0L;
                    this.cutShiftDownYPos = 0L;
                    this.cutShiftLeftXAmt = (long)(1 - this.cutsX) * (this.cutSizeX + this.cutSep) / 2L - lx;
                    this.cutShiftDownYAmt = (long)(1 - this.cutsY) * (this.cutSizeY + this.cutSep) / 2L - ly;
                    this.cutShiftRightXPos = this.cutsX / 2;
                    this.cutShiftUpYPos = this.cutsY / 2;
                    this.cutShiftRightXAmt = hx - (long)(this.cutsX - 1) * (this.cutSizeX + this.cutSep) / 2L;
                    this.cutShiftUpYAmt = hy - (long)(this.cutsY - 1) * (this.cutSizeY + this.cutSep) / 2L;
                    if ((this.cutsX & 1) != 0) {
                        this.cutShiftNoneXPos = this.cutsX / 2;
                    }
                    if ((this.cutsY & 1) != 0) {
                        this.cutShiftNoneYPos = this.cutsY / 2;
                    }
                } else if (cutAlignment == 2) {
                    this.cutShiftLeftXPos = 0L;
                    this.cutShiftDownYPos = 0L;
                    this.cutShiftLeftXAmt = (long)(1 - this.cutsX) * (this.cutSizeX + this.cutSep) / 2L - lx;
                    this.cutShiftDownYAmt = (long)(1 - this.cutsY) * (this.cutSizeY + this.cutSep) / 2L - ly;
                }
            }
            this.cutsReasonable = this.cutsTotal = this.cutsX * this.cutsY;
            if (this.cutsTotal != 1 && this.cutsX > 2 && this.cutsY > 2) {
                this.cutsReasonable = this.cutsX * 2 + (this.cutsY - 2) * 2;
                this.cutTopEdge = this.cutsX * 2;
                this.cutLeftEdge = this.cutsX * 2 + this.cutsY - 2;
                this.cutRightEdge = this.cutsX * 2 + (this.cutsY - 2) * 2;
            }
        }

        private void fillCutPoly(int cut, Poly.Type style, Layer layer, PrimitivePort pp) {
            long cX = this.cutBaseX;
            long cY = this.cutBaseY;
            if (this.cutsX > 1 || this.cutsY > 1) {
                int cutNum;
                if (this.cutsX > 2 && this.cutsY > 2 && cut >= this.cutsX) {
                    if ((double)cut < this.cutTopEdge) {
                        cut += this.cutsX * (this.cutsY - 2);
                    } else if ((double)cut < this.cutLeftEdge) {
                        cut = (int)(((double)cut - this.cutTopEdge) * (double)this.cutsX + (double)this.cutsX);
                    } else if ((double)cut < this.cutRightEdge) {
                        cut = (int)(((double)cut - this.cutLeftEdge) * (double)this.cutsX + (double)(this.cutsX * 2) - 1.0);
                    } else {
                        int cutx = (cut -= (int)this.cutRightEdge) % (this.cutsX - 2);
                        int cuty = cut / (this.cutsX - 2);
                        cut = cuty * this.cutsX + cutx + this.cutsX + 1;
                    }
                }
                if (this.cutsX != 1) {
                    cutNum = cut % this.cutsX;
                    cX = (long)((double)cX + (double)((long)(cutNum * 2 - (this.cutsX - 1)) * (this.cutSizeX + this.cutSep)) * 0.5);
                    if ((long)cutNum != this.cutShiftNoneXPos) {
                        if ((long)cutNum >= this.cutShiftRightXPos) {
                            cX += this.cutShiftRightXAmt;
                        } else if ((long)cutNum >= this.cutShiftLeftXPos) {
                            cX -= this.cutShiftLeftXAmt;
                        }
                    }
                }
                if (this.cutsY != 1) {
                    cutNum = cut / this.cutsX;
                    cY = (long)((double)cY + (double)((long)(cutNum * 2 - (this.cutsY - 1)) * (this.cutSizeY + this.cutSep)) * 0.5);
                    if ((long)cutNum != this.cutShiftNoneYPos) {
                        if ((long)cutNum >= this.cutShiftUpYPos) {
                            cY += this.cutShiftUpYAmt;
                        } else if ((long)cutNum >= this.cutShiftDownYPos) {
                            cY -= this.cutShiftDownYAmt;
                        }
                    }
                }
            }
            long lX = cX - (this.cutSizeX >> 1) << 20;
            long hX = cX + (this.cutSizeX >> 1) << 20;
            long lY = cY - (this.cutSizeY >> 1) << 20;
            long hY = cY + (this.cutSizeY >> 1) << 20;
            AbstractShapeBuilder.this.pushPoint(lX, lY);
            AbstractShapeBuilder.this.pushPoint(hX, lY);
            AbstractShapeBuilder.this.pushPoint(hX, hY);
            AbstractShapeBuilder.this.pushPoint(lX, hY);
            AbstractShapeBuilder.this.pushPoly(style, layer, null, pp);
        }
    }

    private class CarbonNanotube {
        private ImmutableNodeInst niD;
        private Technology.NodeLayer tubeLayer;
        private int numTubes;
        private long tubeSpacing;

        private CarbonNanotube(ImmutableNodeInst niD, Technology.NodeLayer tubeLayer) {
            this.niD = niD;
            this.tubeLayer = tubeLayer;
            this.numTubes = 10;
            Variable var = niD.getVar(Technology.NodeLayer.CARBON_NANOTUBE_COUNT);
            if (var != null) {
                this.numTubes = (Integer)var.getObject();
            }
            this.tubeSpacing = -1L;
            var = niD.getVar(Technology.NodeLayer.CARBON_NANOTUBE_PITCH);
            if (var != null) {
                this.tubeSpacing = DBMath.lambdaToGrid((Double)var.getObject());
            }
        }

        private void fillCutPoly(int r, Poly.Type style, Layer layer, PrimitivePort pp) {
            Technology.TechPoint[] techPoints = this.tubeLayer.getPoints();
            long lx = techPoints[0].getX().getGridValue(this.niD.size);
            long hx = techPoints[1].getX().getGridValue(this.niD.size);
            long ly = techPoints[0].getY().getGridValue(this.niD.size);
            long hy = techPoints[1].getY().getGridValue(this.niD.size);
            if (this.tubeSpacing < 0L) {
                this.tubeSpacing = (hx - lx) / (long)(this.numTubes * 2 - 1);
            }
            long tubeDia = (hx - lx - (long)(this.numTubes - 1) * this.tubeSpacing) / (long)this.numTubes;
            long cX = lx + (tubeDia >> 1) + (tubeDia + this.tubeSpacing) * (long)r;
            long lX = cX - (tubeDia >> 1);
            long hX = cX + (tubeDia >> 1);
            long lY = ly;
            long hY = hy;
            AbstractShapeBuilder.this.pushPoint(lX << 20, lY << 20);
            AbstractShapeBuilder.this.pushPoint(hX << 20, lY << 20);
            AbstractShapeBuilder.this.pushPoint(hX << 20, hY << 20);
            AbstractShapeBuilder.this.pushPoint(lX << 20, hY << 20);
            AbstractShapeBuilder.this.pushPoly(style, layer, null, pp);
        }
    }

    public static class Shrinkage {
        private static final boolean NEW_WAY = true;
        private static final int EXTEND_CONTROL_MASK = 7;
        public static final short EXTEND_90 = 0;
        public static final short EXTEND_0 = 1;
        public static final short EXTEND_45 = 2;
        private static final short EXTEND_ALL_BUT_ONE = 3;
        private static final short EXTEND_ANY = 4;
        private static final int EXTEND_VALUE_SHIFT = 3;
        private static final int ANGLE_SHIFT = 12;
        private static final int ANGLE_MASK = 4095;
        private static final int ONE_NONMANHATTAN_MASK = 0x1000000;
        private static final int ANGLE_DIAGONAL_MASK = 0x2000000;
        private static final int ANGLE_45_MASK = 0x4000000;
        private static final int ANGLE_COUNT_SHIFT = 27;
        private final short[] shrink;

        public Shrinkage() {
            this.shrink = new short[0];
        }

        public Shrinkage(CellBackup cellBackup) {
            CellRevision cellRevision = cellBackup.cellRevision;
            TechPool techPool = cellBackup.techPool;
            int maxNodeId = -1;
            for (int nodeIndex = 0; nodeIndex < cellRevision.nodes.size(); ++nodeIndex) {
                maxNodeId = Math.max(maxNodeId, cellRevision.nodes.get((int)nodeIndex).nodeId);
            }
            int[] angles = new int[maxNodeId + 1];
            for (ImmutableArcInst a : cellRevision.arcs) {
                ArcProto ap = techPool.getArcProto(a.protoId);
                if (a.getGridExtendOverMin() + ap.getMaxLayerExtend().getGrid() == 0L) continue;
                if (a.tailNodeId == a.headNodeId && a.tailPortId == a.headPortId) {
                    this.registerArcEnd(angles, a.tailNodeId, 0, false, false);
                    continue;
                }
                boolean is90 = a.isManhattan();
                this.registerArcEnd(angles, a.tailNodeId, a.getOppositeAngle(), is90, a.isTailExtended());
                this.registerArcEnd(angles, a.headNodeId, a.getAngle(), is90, a.isHeadExtended());
            }
            short[] shrink = new short[maxNodeId + 1];
            for (int nodeIndex = 0; nodeIndex < cellRevision.nodes.size(); ++nodeIndex) {
                PrimitiveNode pnp;
                ImmutableNodeInst n = cellRevision.nodes.get(nodeIndex);
                shrink[n.nodeId] = 0;
                NodeProtoId np = n.protoId;
                if (!(np instanceof PrimitiveNodeId) || (pnp = techPool.getPrimitiveNode((PrimitiveNodeId)np)).getFunction() != PrimitiveNode.Function.PIN && pnp.getFunction() != PrimitiveNode.Function.CONTACT || !(np instanceof PrimitiveNodeId) || !pnp.isArcsShrink()) continue;
                shrink[n.nodeId] = Shrinkage.computeShrink(angles[n.nodeId]);
            }
            this.shrink = shrink;
        }

        public short get(int nodeId) {
            return nodeId < this.shrink.length ? this.shrink[nodeId] : (short)0;
        }

        private void registerArcEnd(int[] angles, int nodeId, int angle, boolean is90, boolean extended) {
            if (angle == -1) {
                angle = 0;
            }
            assert (angle >= 0 && angle < 3600);
            int ang = angles[nodeId];
            if (extended) {
                int count2 = ang >>> 27;
                switch (count2) {
                    case 0: {
                        ang |= angle;
                        ang += 0x8000000;
                        break;
                    }
                    case 1: {
                        int ang0 = ang & 0xFFF;
                        ang |= angle << 12;
                        ang += 0x8000000;
                        int da = Math.abs(ang0 - angle);
                        if (!this.is45(da)) break;
                        ang |= 0x4000000;
                        break;
                    }
                    case 2: {
                        int ang0Orig = ang & 0xFFF;
                        int ang1Orig = ang >> 12 & 0xFFF;
                        MutableInteger ang0MI = new MutableInteger(ang0Orig);
                        MutableInteger ang1MI = new MutableInteger(ang1Orig);
                        int extraBits = this.reduceThreeAngles(ang0MI, ang1MI, angle);
                        if (extraBits != -1) {
                            ang = extraBits | ang & 0x2000000 | 0x8000000 | ang0MI.intValue() | ang1MI.intValue() << 12;
                        }
                        ang += 0x8000000;
                    }
                }
                if (!is90) {
                    ang |= 0x2000000;
                }
            } else {
                ang |= 0x18000000;
            }
            angles[nodeId] = ang;
        }

        private int reduceThreeAngles(MutableInteger ang1MI, MutableInteger ang2MI, int ang3) {
            int da2;
            int da1;
            int ang1 = ang1MI.intValue();
            int ang2 = ang2MI.intValue();
            int extraBits = 0;
            if ((ang1 % 900 != 0 || ang2 % 900 != 0 || ang3 % 900 != 0) && ang1 % 450 == 0 && ang2 % 450 == 0 && ang3 % 450 == 0) {
                extraBits = 0x4000000;
            }
            if (ang1 == ang3 || ang2 == ang3) {
                return extraBits;
            }
            if (ang1 == ang2) {
                ang1MI.setValue(ang3);
                return extraBits;
            }
            if (ang1 % 900 == ang3 % 900) {
                da1 = Math.abs(ang1 - ang2);
                da2 = Math.abs(ang3 - ang2);
                if (this.is45(da1) && this.is45(da2)) {
                    ang1MI.setValue(ang2);
                    return 0x1000000;
                }
                if (900 < da1 && da1 < 2700) {
                    return extraBits;
                }
                if (900 < da2 && da2 < 2700) {
                    ang1MI.setValue(ang3);
                    return extraBits;
                }
            }
            if (ang2 % 900 == ang3 % 900) {
                da1 = Math.abs(ang2 - ang1);
                da2 = Math.abs(ang3 - ang1);
                if (this.is45(da1) && this.is45(da2)) {
                    return 0x1000000;
                }
                if (900 < da1 && da1 < 2700) {
                    return extraBits;
                }
                if (900 < da2 && da2 < 2700) {
                    ang2MI.setValue(ang3);
                    return extraBits;
                }
            }
            if (ang1 % 900 == ang2 % 900) {
                da1 = Math.abs(ang1 - ang3);
                da2 = Math.abs(ang2 - ang3);
                if (this.is45(da1) && this.is45(da2)) {
                    ang1MI.setValue(ang3);
                    return 0x1000000;
                }
                if (900 < da1 && da1 < 2700) {
                    ang2MI.setValue(ang3);
                    return extraBits;
                }
                if (900 < da2 && da2 < 2700) {
                    ang1MI.setValue(ang3);
                    return extraBits;
                }
            }
            return -1;
        }

        private boolean is45(int angle) {
            return angle == 450 || angle == 3150;
        }

        static short computeShrink(int angs) {
            boolean hasAny = (angs & 0x2000000) != 0;
            boolean hasAll45 = (angs & 0x4000000) != 0;
            boolean hasOneNoShrink = (angs & 0x1000000) != 0;
            int count2 = angs >>> 27;
            if (count2 == 2) {
                int ang0 = angs & 0xFFF;
                if (hasOneNoShrink) {
                    return (short)(3 | ang0 << 3);
                }
                if (hasAll45) {
                    return 2;
                }
                if (hasAny) {
                    int da;
                    int ang1 = angs >> 12 & 0xFFF;
                    int n = da = ang0 > ang1 ? ang0 - ang1 : ang1 - ang0;
                    if (da == 900 || da == 2700) {
                        return 0;
                    }
                    if (da == 1800) {
                        return 1;
                    }
                    if (900 < da && da < 2700) {
                        int a = ang0 + ang1;
                        if (a >= 3600) {
                            a -= 3600;
                        }
                        return (short)(4 | a << 3);
                    }
                }
            }
            return 0;
        }
    }
}

