/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree;

import com.sun.electric.database.geometry.btree.BTree;
import com.sun.electric.database.geometry.btree.CachingPageStorageWrapper;
import com.sun.electric.database.geometry.btree.FilePageStorage;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedInt;
import java.util.Random;
import java.util.TreeMap;

public class BTreeTest {
    public static void main(String[] s) throws Exception {
        if (s.length != 4) {
            System.err.println("");
            System.err.println("usage: java " + BTree.class.getName() + " <maxsize> <numops> <cachesize> <seed>");
            System.err.println("");
            System.err.println("  Creates a BTree and runs random operations on both it and an in-memory TreeMap.");
            System.err.println("  Reports any disagreements.");
            System.err.println("");
            System.err.println("    <maxsize>   maximum number of entries in the tree, or 0 for no limit");
            System.err.println("    <numops>    number of operations to perform, or 0 for no limit");
            System.err.println("    <cachesize> number of pages to cache in memory, or 0 for no cache");
            System.err.println("    <seed>      seed for random number generator, in hex");
            System.err.println("");
            System.exit(-1);
        }
        if (!BTree.class.desiredAssertionStatus()) {
            throw new RuntimeException("You need to run this test with assertions enabled!");
        }
        Random rand = new Random(Integer.parseInt(s[3], 16));
        int cachesize = Integer.parseInt(s[2]);
        int numops = Integer.parseInt(s[1]);
        int maxsize = Integer.parseInt(s[0]);
        boolean size2 = false;
        CachingPageStorageWrapper ps = new CachingPageStorageWrapper(FilePageStorage.create(), cachesize, false);
        BTree btree = new BTree(ps, UnboxedInt.instance, UnboxedInt.instance, null);
        TreeMap<Integer, Integer> tm = new TreeMap<Integer, Integer>();
        int puts = 0;
        int gets = 0;
        int deletes = 0;
        int misses = 0;
        boolean inserts = false;
        long lastprint = 0L;
        boolean do_tm = true;
        boolean do_bt = true;
        block5: for (int i = 0; numops == 0 || i < numops; ++i) {
            if (System.currentTimeMillis() - lastprint > 200L) {
                lastprint = System.currentTimeMillis();
                System.out.print("\r puts=" + puts + " gets=" + (gets - misses) + "/" + gets + " deletes=" + deletes);
            }
            int key = rand.nextInt() % 1000000;
            switch (rand.nextInt() % 3) {
                case 0: {
                    Integer tget = do_tm ? (Integer)tm.get(key) : null;
                    Integer bget = do_bt ? btree.getValFromKey(key) : null;
                    ++gets;
                    if (!do_tm || !do_bt) continue block5;
                    if (tget == null && bget == null) {
                        ++misses;
                        continue block5;
                    }
                    if (tget != null && bget != null && tget.equals(bget)) continue block5;
                    System.out.print("\r puts=" + puts + " gets=" + (gets - misses) + "/" + gets + " deletes=" + deletes);
                    System.out.println();
                    System.out.println();
                    throw new RuntimeException("  disagreement on key " + key + ": btree=" + bget + ", treemap=" + tget);
                }
                case 1: {
                    int ord;
                    int sz = do_bt ? btree.size() : tm.size();
                    int n = ord = sz == 0 ? 0 : Math.abs(rand.nextInt()) % sz;
                    Integer tget = do_tm ? (sz == 0 ? null : tm.values().toArray(new Integer[0])[ord]) : null;
                    Integer bget = do_bt ? btree.getValFromOrd(ord) : null;
                    ++gets;
                    if (!do_tm || !do_bt || tget == null && bget == null || tget != null && bget != null && tget.equals(bget)) continue block5;
                    System.out.print("\r puts=" + puts + " gets=" + (gets - misses) + "/" + gets + " deletes=" + deletes);
                    System.out.println();
                    System.out.println();
                    System.out.println("dump:");
                    throw new RuntimeException("  disagreement on ordinal " + ord + ": btree=" + bget + ", treemap=" + tget);
                }
                case 2: {
                    int val = rand.nextInt();
                    boolean already_there = false;
                    boolean should_delete = false;
                    if (do_bt) {
                        boolean bl = do_tm ? tm.get(key) != null : (already_there = btree.getValFromKey(key) != null);
                    }
                    if (already_there) {
                        boolean bl = should_delete = Math.abs(rand.nextInt()) % 10 < 5;
                    }
                    if (do_tm) {
                        if (should_delete) {
                            tm.remove(key);
                        } else {
                            tm.put(key, val);
                        }
                    }
                    if (do_bt) {
                        if (should_delete) {
                            btree.remove(key);
                        } else if (already_there) {
                            btree.replace(key, val);
                        } else {
                            btree.insert(key, val);
                        }
                    }
                    if (should_delete) {
                        ++deletes;
                        continue block5;
                    }
                    ++puts;
                    continue block5;
                }
            }
        }
    }
}

