/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class TechnologyTab
extends PreferencePanel {
    private int initialTechRules;
    private int initialTechNumMetalLayers;
    private boolean initialTechSecondPolyLayers;
    private String initialSchematicTechnology;
    private String initialDefaultTechnology;
    private boolean initialTechNoStackedVias;
    private boolean initialTechAlternateContactRules;
    private boolean initialTechSpecialTransistors;
    private boolean initialTechArtworkArrowsFilled;
    private double initialTechNegatingBubbleSize;
    private JLabel defaultTechLabel;
    private JComboBox defaultTechPulldown;
    private JLabel jLabel49;
    private JLabel jLabel52;
    private JLabel jLabel59;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel9;
    private JCheckBox techArtworkArrowsFilled;
    private JCheckBox techMOCMOSAlternateContactRules;
    private JRadioButton techMOCMOSDeepRules;
    private JCheckBox techMOCMOSDisallowStackedVias;
    private JComboBox techMOCMOSMetalLayers;
    private ButtonGroup techMOCMOSRules;
    private JRadioButton techMOCMOSSCMOSRules;
    private JCheckBox techMOCMOSSecondPoly;
    private JCheckBox techMOCMOSShowSpecialTrans;
    private JRadioButton techMOCMOSSubmicronRules;
    private JTextField techSchematicsNegatingSize;
    private JPanel technology;
    private JComboBox technologyPopup;

    public TechnologyTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.technology;
    }

    public String getName() {
        return "Technology";
    }

    public void init() {
        this.initialTechRules = MoCMOS.getRuleSet();
        if (this.initialTechRules == 0) {
            this.techMOCMOSSCMOSRules.setSelected(true);
        } else if (this.initialTechRules == 1) {
            this.techMOCMOSSubmicronRules.setSelected(true);
        } else {
            this.techMOCMOSDeepRules.setSelected(true);
        }
        this.techMOCMOSMetalLayers.addItem("2 Layers");
        this.techMOCMOSMetalLayers.addItem("3 Layers");
        this.techMOCMOSMetalLayers.addItem("4 Layers");
        this.techMOCMOSMetalLayers.addItem("5 Layers");
        this.techMOCMOSMetalLayers.addItem("6 Layers");
        this.initialTechNumMetalLayers = MoCMOS.getNumMetal();
        this.techMOCMOSMetalLayers.setSelectedIndex(this.initialTechNumMetalLayers - 2);
        this.initialTechSecondPolyLayers = MoCMOS.isSecondPolysilicon();
        this.techMOCMOSSecondPoly.setSelected(this.initialTechSecondPolyLayers);
        this.initialTechNoStackedVias = MoCMOS.isDisallowStackedVias();
        this.techMOCMOSDisallowStackedVias.setSelected(this.initialTechNoStackedVias);
        this.initialTechAlternateContactRules = MoCMOS.isAlternateActivePolyRules();
        this.techMOCMOSAlternateContactRules.setSelected(this.initialTechAlternateContactRules);
        this.initialTechSpecialTransistors = MoCMOS.isSpecialTransistors();
        this.techMOCMOSShowSpecialTrans.setSelected(this.initialTechSpecialTransistors);
        this.initialTechArtworkArrowsFilled = Artwork.isFilledArrowHeads();
        this.techArtworkArrowsFilled.setSelected(this.initialTechArtworkArrowsFilled);
        this.initialSchematicTechnology = User.getSchematicTechnology();
        Iterator it = Technology.getTechnologiesSortedByName().iterator();
        while (it.hasNext()) {
            Technology tech = (Technology)it.next();
            this.technologyPopup.addItem(tech.getTechName());
            this.defaultTechPulldown.addItem(tech.getTechName());
        }
        this.technologyPopup.setSelectedItem(this.initialSchematicTechnology);
        this.initialDefaultTechnology = User.getDefaultTechnology();
        this.defaultTechPulldown.setSelectedItem(this.initialDefaultTechnology);
        this.initialTechNegatingBubbleSize = Schematics.getNegatingBubbleSize();
        this.techSchematicsNegatingSize.setText(TextUtils.formatDouble(this.initialTechNegatingBubbleSize));
    }

    public void term() {
        double currentNegatingBubbleSize;
        String defaultTech;
        String currentTech;
        boolean currentArrowsFilled;
        boolean currentSpecialTransistors;
        boolean currentAlternateContact;
        boolean currentNoStackedVias;
        boolean currentSecondPolys;
        boolean redrawPalette = false;
        boolean redrawWindows = false;
        int currentNumMetals = this.techMOCMOSMetalLayers.getSelectedIndex() + 2;
        int currentRules = 0;
        if (this.techMOCMOSSubmicronRules.isSelected()) {
            currentRules = 1;
        } else if (this.techMOCMOSDeepRules.isSelected()) {
            currentRules = 2;
        }
        switch (currentNumMetals) {
            case 2: 
            case 3: 
            case 4: {
                if (currentRules != 2) break;
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot use Deep rules if there are less than 5 layers of metal...using SubMicron rules.");
                currentRules = 1;
                break;
            }
            case 5: 
            case 6: {
                if (currentRules != 0) break;
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot use SCMOS rules if there are more than 4 layers of metal...using SubMicron rules.");
                currentRules = 1;
            }
        }
        if (currentNumMetals != this.initialTechNumMetalLayers) {
            MoCMOS.setNumMetal(currentNumMetals);
        }
        if (currentRules != this.initialTechRules) {
            MoCMOS.setRuleSet(currentRules);
        }
        if ((currentSecondPolys = this.techMOCMOSSecondPoly.isSelected()) != this.initialTechSecondPolyLayers) {
            MoCMOS.setSecondPolysilicon(currentSecondPolys);
        }
        if ((currentNoStackedVias = this.techMOCMOSDisallowStackedVias.isSelected()) != this.initialTechNoStackedVias) {
            MoCMOS.setDisallowStackedVias(currentNoStackedVias);
        }
        if ((currentAlternateContact = this.techMOCMOSAlternateContactRules.isSelected()) != this.initialTechAlternateContactRules) {
            MoCMOS.setAlternateActivePolyRules(currentAlternateContact);
        }
        if ((currentSpecialTransistors = this.techMOCMOSShowSpecialTrans.isSelected()) != this.initialTechSpecialTransistors) {
            MoCMOS.setSpecialTransistors(currentSpecialTransistors);
            redrawPalette = true;
        }
        if ((currentArrowsFilled = this.techArtworkArrowsFilled.isSelected()) != this.initialTechArtworkArrowsFilled) {
            Artwork.setFilledArrowHeads(currentArrowsFilled);
            redrawWindows = true;
        }
        if (!(currentTech = (String)this.technologyPopup.getSelectedItem()).equals(this.initialSchematicTechnology)) {
            User.setSchematicTechnology(currentTech);
        }
        if (!(defaultTech = (String)this.defaultTechPulldown.getSelectedItem()).equals(this.initialDefaultTechnology)) {
            User.setDefaultTechnology(defaultTech);
        }
        if ((currentNegatingBubbleSize = TextUtils.atof(this.techSchematicsNegatingSize.getText())) != this.initialTechNegatingBubbleSize) {
            Schematics.setNegatingBubbleSize(currentNegatingBubbleSize);
            redrawWindows = true;
        }
        if (redrawPalette) {
            TopLevel.getPaletteFrame().loadForTechnology();
        }
        if (redrawWindows) {
            EditWindow.repaintAllContents();
        }
    }

    private void initComponents() {
        this.techMOCMOSRules = new ButtonGroup();
        this.technology = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel49 = new JLabel();
        this.techMOCMOSMetalLayers = new JComboBox();
        this.techMOCMOSSCMOSRules = new JRadioButton();
        this.techMOCMOSSubmicronRules = new JRadioButton();
        this.techMOCMOSDeepRules = new JRadioButton();
        this.techMOCMOSSecondPoly = new JCheckBox();
        this.techMOCMOSDisallowStackedVias = new JCheckBox();
        this.techMOCMOSAlternateContactRules = new JCheckBox();
        this.techMOCMOSShowSpecialTrans = new JCheckBox();
        this.jPanel9 = new JPanel();
        this.techArtworkArrowsFilled = new JCheckBox();
        this.jPanel10 = new JPanel();
        this.techSchematicsNegatingSize = new JTextField();
        this.jLabel52 = new JLabel();
        this.jLabel59 = new JLabel();
        this.technologyPopup = new JComboBox();
        this.jPanel2 = new JPanel();
        this.defaultTechLabel = new JLabel();
        this.defaultTechPulldown = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TechnologyTab.this.closeDialog(evt);
            }
        });
        this.technology.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder("MOSIS CMOS"));
        this.jLabel49.setText("Metal layers:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel49, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.techMOCMOSMetalLayers, gridBagConstraints);
        this.techMOCMOSSCMOSRules.setText("SCMOS rules (4 metal or less)");
        this.techMOCMOSRules.add(this.techMOCMOSSCMOSRules);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel1.add((Component)this.techMOCMOSSCMOSRules, gridBagConstraints);
        this.techMOCMOSSubmicronRules.setText("Submicron rules");
        this.techMOCMOSRules.add(this.techMOCMOSSubmicronRules);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.techMOCMOSSubmicronRules, gridBagConstraints);
        this.techMOCMOSDeepRules.setText("Deep rules (5 metal or more)");
        this.techMOCMOSRules.add(this.techMOCMOSDeepRules);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel1.add((Component)this.techMOCMOSDeepRules, gridBagConstraints);
        this.techMOCMOSSecondPoly.setText("Second Polysilicon Layer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.techMOCMOSSecondPoly, gridBagConstraints);
        this.techMOCMOSDisallowStackedVias.setText("Disallow stacked vias");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.techMOCMOSDisallowStackedVias, gridBagConstraints);
        this.techMOCMOSAlternateContactRules.setText("Alternate Active and Poly contact rules");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.techMOCMOSAlternateContactRules, gridBagConstraints);
        this.techMOCMOSShowSpecialTrans.setText("Show Special transistors");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.techMOCMOSShowSpecialTrans, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.technology.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel9.setLayout(new GridBagLayout());
        this.jPanel9.setBorder(new TitledBorder("Artwork"));
        this.techArtworkArrowsFilled.setText("Arrows filled");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel9.add((Component)this.techArtworkArrowsFilled, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.technology.add((Component)this.jPanel9, gridBagConstraints);
        this.jPanel10.setLayout(new GridBagLayout());
        this.jPanel10.setBorder(new TitledBorder("Schematics"));
        this.techSchematicsNegatingSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel10.add((Component)this.techSchematicsNegatingSize, gridBagConstraints);
        this.jLabel52.setText("Negating Bubble Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel10.add((Component)this.jLabel52, gridBagConstraints);
        this.jLabel59.setText("Use scale values from this technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel10.add((Component)this.jLabel59, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel10.add((Component)this.technologyPopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.technology.add((Component)this.jPanel10, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new TitledBorder("Default Technology"));
        this.defaultTechLabel.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.defaultTechLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.defaultTechPulldown, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.technology.add((Component)this.jPanel2, gridBagConstraints);
        this.getContentPane().add((Component)this.technology, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

