/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.technologies.Generic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class Variable {
    private Object addr;
    private int flags;
    private final Key key;
    private final TextDescriptor descriptor;
    private boolean linked;
    private static final int VCODE1 = 32;
    private static final int VDISPLAY = 64;
    private static final int VCODE2 = 0x20000000;
    private static final int VLISP = 32;
    private static final int VTCL = 0x20000000;
    private static final int VJAVA = 0x20000020;
    private static final int VDONTSAVE = 0x40000000;
    private static final int VCANTSET = Integer.MIN_VALUE;

    Variable(ElectricObject owner, Object addr, TextDescriptor descriptor, Key key) {
        this.addr = addr;
        this.descriptor = new TextDescriptor(owner, descriptor);
        this.key = key;
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Variable var = (Variable)obj;
        boolean check = var.getTextDescriptor().compare(this.getTextDescriptor());
        if (!check && buffer != null) {
            buffer.append("No same variables detected in " + var + " and " + this + "\n");
        }
        return check;
    }

    public final void checkChanging() {
        ElectricObject owner = this.descriptor.owner;
        if (!owner.isDatabaseObject()) {
            return;
        }
        owner.checkChanging();
        Undo.modifyVariableFlags(owner, this, this.flags);
    }

    public synchronized int getLength() {
        if (this.addr instanceof Object[]) {
            return ((Object[])this.addr).length;
        }
        return 1;
    }

    public Object getObject() {
        return this.addr;
    }

    public synchronized Object getObject(int index) {
        if (!(this.addr instanceof Object[])) {
            return null;
        }
        return ((Object[])this.addr)[index];
    }

    public synchronized void lowLevelInsert(int index, Object value) {
        int i;
        Object[] oldArr = (Object[])this.addr;
        Object[] newArr = new Object[oldArr.length + 1];
        for (i = 0; i < index; ++i) {
            newArr[i] = oldArr[i];
        }
        newArr[index] = value;
        for (i = index; i < oldArr.length; ++i) {
            newArr[i + 1] = oldArr[i];
        }
        this.addr = newArr;
    }

    public synchronized void lowLevelDelete(int index) {
        int i;
        Object[] oldArr = (Object[])this.addr;
        Object[] newArr = new Object[oldArr.length - 1];
        for (i = 0; i < index; ++i) {
            newArr[i] = oldArr[i];
        }
        for (i = index; i < newArr.length; ++i) {
            newArr[i] = oldArr[i + 1];
        }
        this.addr = newArr;
    }

    public Key getKey() {
        return this.key;
    }

    public void setLinked(boolean linked) {
        this.linked = linked;
    }

    public boolean isLinked() {
        return this.linked && this.descriptor.owner.isLinked();
    }

    public ElectricObject getOwner() {
        return this.descriptor.owner;
    }

    public boolean isActuallyLinked() {
        ElectricObject owner = this.getOwner();
        return owner != null && owner.isActuallyLinked() && owner.getVar(this.key) == this;
    }

    public String getReadableName() {
        String betterName;
        String trueName = "";
        String name = this.key.getName();
        trueName = name.startsWith("ATTR_") ? (this.getTextDescriptor().isParam() ? trueName + "Parameter '" + name.substring(5) + "'" : trueName + "Attribute '" + name.substring(5) + "'") : ((betterName = Variable.betterVariableName(name)) != null ? trueName + betterName : trueName + "Variable '" + name + "'");
        return trueName;
    }

    public String getFullDescription(ElectricObject eobj) {
        String trueName = this.getReadableName();
        String description = null;
        if (eobj instanceof Export) {
            description = trueName + " on export '" + ((Export)eobj).getName() + "'";
        } else if (eobj instanceof PortInst) {
            PortInst pi = (PortInst)eobj;
            description = trueName + " on port " + pi.getPortProto().getName() + " of " + pi.getNodeInst().describe();
        } else if (eobj instanceof ArcInst) {
            description = trueName + " on " + ((ArcInst)eobj).describe();
        } else if (eobj instanceof NodeInst) {
            String varName;
            String betterName;
            NodeInst ni = (NodeInst)eobj;
            description = trueName + " on " + ni.describe();
            if (ni.getProto() == Generic.tech.invisiblePinNode && (betterName = Variable.betterVariableName(varName = this.getKey().getName())) != null) {
                description = betterName;
            }
        } else if (eobj instanceof Cell) {
            description = trueName + " of cell " + ((Cell)eobj).describe();
        }
        return description;
    }

    public static String betterVariableName(String name) {
        if (name.equals("ARC_name")) {
            return "Arc Name";
        }
        if (name.equals("ARC_radius")) {
            return "Arc Radius";
        }
        if (name.equals("ART_color")) {
            return "Color";
        }
        if (name.equals("ART_degrees")) {
            return "Number of Degrees";
        }
        if (name.equals("ART_message")) {
            return "Annotation text";
        }
        if (name.equals("NET_ncc_match")) {
            return "NCC equivalence";
        }
        if (name.equals("NET_ncc_forcedassociation")) {
            return "NCC association";
        }
        if (name.equals("NODE_name")) {
            return "Node Name";
        }
        if (name.equals("SCHEM_capacitance")) {
            return "Capacitance";
        }
        if (name.equals("SCHEM_diode")) {
            return "Diode Size";
        }
        if (name.equals("SCHEM_global_name")) {
            return "Global Signal Name";
        }
        if (name.equals("SCHEM_inductance")) {
            return "Inductance";
        }
        if (name.equals("SCHEM_resistance")) {
            return "Resistance";
        }
        if (name.equals("SIM_fall_delay")) {
            return "Fall Delay";
        }
        if (name.equals("SIM_fasthenry_group_name")) {
            return "FastHenry Group";
        }
        if (name.equals("SIM_rise_delay")) {
            return "Rise Delay";
        }
        if (name.equals("SIM_spice_card")) {
            return "SPICE code";
        }
        if (name.equals("SIM_spice_model")) {
            return "SPICE model";
        }
        if (name.equals("SIM_verilog_wire_type")) {
            return "Verilog Wire type";
        }
        if (name.equals("SIM_weak_node")) {
            return "Transistor Strength";
        }
        if (name.equals("transistor_width")) {
            return "Transistor Width";
        }
        if (name.equals("VERILOG_code")) {
            return "Verilog code";
        }
        if (name.equals("VERILOG_declaration")) {
            return "Verilog declaration";
        }
        return null;
    }

    public String getTrueName() {
        String name = this.key.getName();
        if (name.startsWith("ATTR_")) {
            return name.substring(5);
        }
        if (name.startsWith("ATTRP_")) {
            int i = name.lastIndexOf(95);
            return name.substring(i);
        }
        return name;
    }

    public String describe(VarContext context, ElectricObject eobj) {
        return this.describe(-1, context, eobj);
    }

    public String describe(int aindex) {
        return this.describe(aindex, VarContext.globalContext, null);
    }

    public String describe(int aindex, VarContext context, ElectricObject eobj) {
        TextDescriptor.Unit units = this.descriptor.getUnit();
        StringBuffer returnVal = new StringBuffer();
        TextDescriptor.DispPos dispPos = this.descriptor.getDispPart();
        if (this.isCode()) {
            if (context == null) {
                context = VarContext.globalContext;
            }
            Object val = null;
            try {
                val = context.evalVarRecurse(this, eobj);
            }
            catch (VarContext.EvalException e) {
                val = e.getMessage();
            }
            if (val == null) {
                val = "?";
            }
            returnVal.append(this.makeStringVar(val, units));
        } else {
            returnVal.append(this.getPureValue(aindex));
        }
        if (dispPos == TextDescriptor.DispPos.NAMEVALUE && (aindex < 0 || this.getLength() == 1)) {
            return this.getTrueName() + "=" + returnVal.toString();
        }
        return returnVal.toString();
    }

    public String getPureValue(int aindex) {
        TextDescriptor.Unit units = this.descriptor.getUnit();
        StringBuffer returnVal = new StringBuffer();
        Object thisAddr = this.getObject();
        if (thisAddr instanceof Object[]) {
            Object[] addrArray = (Object[])thisAddr;
            int len = addrArray.length;
            if (aindex >= 0) {
                if (aindex < len) {
                    returnVal.append(this.makeStringVar(addrArray[aindex], units));
                }
            } else {
                if (len > 1) {
                    returnVal.append("[");
                }
                for (int i = 0; i < len; ++i) {
                    if (i != 0) {
                        returnVal.append(",");
                    }
                    returnVal.append(this.makeStringVar(addrArray[i], units));
                }
                if (len > 1) {
                    returnVal.append("]");
                }
            }
        } else {
            returnVal.append(this.makeStringVar(thisAddr, units));
        }
        return returnVal.toString();
    }

    private String makeStringVar(Object addr, TextDescriptor.Unit units) {
        if (addr instanceof Integer) {
            return ((Integer)addr).toString();
        }
        if (addr instanceof Float) {
            return TextUtils.makeUnits(((Float)addr).floatValue(), units);
        }
        if (addr instanceof Double) {
            return TextUtils.makeUnits((Double)addr, units);
        }
        if (addr instanceof Short) {
            return ((Short)addr).toString();
        }
        if (addr instanceof Byte) {
            return ((Byte)addr).toString();
        }
        if (addr instanceof String) {
            return (String)addr;
        }
        if (addr instanceof NodeInst) {
            return ((NodeInst)addr).describe();
        }
        if (addr instanceof ArcInst) {
            return ((ArcInst)addr).describe();
        }
        return "?";
    }

    public TextDescriptor getTextDescriptor() {
        return this.descriptor;
    }

    public void setTextDescriptor(TextDescriptor descriptor) {
        this.descriptor.copy(descriptor);
    }

    public int lowLevelGetFlags() {
        return this.flags;
    }

    public synchronized void lowLevelSetFlags(int flags) {
        this.flags = flags;
    }

    public void copyFlags(Variable var) {
        this.checkChanging();
        this.lowLevelSetFlags(var.lowLevelGetFlags());
    }

    public synchronized void setDisplay(boolean state) {
        this.checkChanging();
        this.flags = state ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    public boolean isDisplay() {
        return (this.flags & 0x40) != 0;
    }

    public synchronized Code getCode() {
        if (this.isJava()) {
            return Code.JAVA;
        }
        if (this.isTCL()) {
            return Code.TCL;
        }
        if (this.isLisp()) {
            return Code.LISP;
        }
        return Code.NONE;
    }

    public synchronized void setCode(Code code) {
        if (code == Code.JAVA) {
            this.setJava();
        }
        if (code == Code.LISP) {
            this.setLisp();
        }
        if (code == Code.TCL) {
            this.setTCL();
        }
        if (code == Code.NONE) {
            this.clearCode();
        }
    }

    private void setJava() {
        this.checkChanging();
        this.flags = this.flags & 0xDFFFFFDF | 0x20000020;
    }

    private boolean isJava() {
        return (this.flags & 0x20000020) == 0x20000020;
    }

    private void setLisp() {
        this.checkChanging();
        this.flags = this.flags & 0xDFFFFFDF | 0x20;
    }

    private boolean isLisp() {
        return (this.flags & 0x20000020) == 32;
    }

    private void setTCL() {
        this.checkChanging();
        this.flags = this.flags & 0xDFFFFFDF | 0x20000000;
    }

    private boolean isTCL() {
        return (this.flags & 0x20000020) == 0x20000000;
    }

    public boolean isCode() {
        return (this.flags & 0x20000020) != 0;
    }

    private void clearCode() {
        this.checkChanging();
        this.flags &= 0xDFFFFFDF;
    }

    public synchronized void setDontSave() {
        this.checkChanging();
        this.flags |= 0x40000000;
    }

    public synchronized void clearDontSave() {
        this.checkChanging();
        this.flags &= 0xBFFFFFFF;
    }

    public boolean isDontSave() {
        return (this.flags & 0x40000000) != 0;
    }

    public synchronized void setCantSet() {
        this.checkChanging();
        this.flags |= Integer.MIN_VALUE;
    }

    public synchronized void clearCantSet() {
        this.checkChanging();
        this.flags &= Integer.MAX_VALUE;
    }

    public boolean isCantSet() {
        return (this.flags & Integer.MIN_VALUE) != 0;
    }

    public boolean isAttribute() {
        return this.getKey().getName().startsWith("ATTR_");
    }

    public String toString() {
        return this.key.getName();
    }

    public static class Code {
        private final String name;
        private static final ArrayList allCodes = new ArrayList();
        public static final Code JAVA = new Code("Java");
        public static final Code LISP = new Code("Lisp (not avail.)");
        public static final Code TCL = new Code("TCL (not avail.)");
        public static final Code NONE = new Code("Not Code");

        private Code(String name) {
            this.name = name;
            allCodes.add(this);
        }

        public String toString() {
            return this.name;
        }

        public static Iterator getCodes() {
            return Collections.unmodifiableList(allCodes).iterator();
        }
    }

    public static class Key {
        private final String name;
        private final int index;
        private static int currentIndex = 0;

        Key(String name) {
            this.name = name;
            this.index = currentIndex++;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Key k) {
            return this.name.equals(k.getName());
        }
    }
}

