/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GTK_GLWINDOW_H__
#define __GTK_GLWINDOW_H__


#include <gdk/gdk.h>
#include <gtk/gtkwindow.h>
#include <GL/glx.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_GLWINDOW(obj)          GTK_CHECK_CAST (obj, gtk_glwindow_get_type (), GtkGLWindow)
#define GTK_GLWINDOW_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_glwindow_get_type (), GtkGLWindowClass)
#define GTK_IS_GLWINDOW(obj)       GTK_CHECK_TYPE (obj, gtk_glwindow_get_type ())

/*  creation flags  */
#define GTK_GLWIN_NO_DOUBLE_BUFFER  0x0001    /* don't call swapbuffers */

    
typedef struct _GtkGLWindow       GtkGLWindow;
typedef struct _GtkGLWindowClass  GtkGLWindowClass;

struct _GtkGLWindow
{
    GtkWidget widget;

    GLXContext context;
    int *glattrib;
    gint swapbuffers;
};


struct _GtkGLWindowClass
{
    GtkWidgetClass parent_class;

    void (* glinit)           ( GtkGLWindow *glwindow );
    void (* gldraw)           ( GtkGLWindow *glwindow );
    void (* glresize)         ( GtkGLWindow *glwindow, GtkAllocation * );
};


guint      gtk_glwindow_get_type       ( void );
GtkWidget* gtk_glwindow_new            ( int *glattrib, gint attribLength,
					 guint flags );
void       gtk_glwindow_draw           ( GtkGLWindow *glwindow );
void       gtk_glwindow_make_current   ( GtkGLWindow *glwindow );



#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_GLWINDOW_H__ */




