# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools

DESCRIPTION="Small library to interface to the Ident protocol server"
HOMEPAGE="http://www.simphalempin.com/dev/libident/"
SRC_URI="http://people.via.ecp.fr/~rem/libident/${P}.tar.bz2"

LICENSE="public-domain"
SLOT="0"
KEYWORDS="~alpha amd64 ~arm arm64 ~hppa ~mips ppc ppc64 ~s390 ~sparc x86"
IUSE="test"
# Interactive tests only.
RESTRICT="!test? ( test ) test"

PATCHES=(
	"${FILESDIR}"/${PN}-0.32-fix_c23.patch
)

src_prepare() {
	default
	eautoreconf
}

src_configure() {
	econf \
		--disable-static \
		$(use_enable test testers)
}

src_install() {
	default
	find "${ED}" -name '*.la' -delete || die
}
