/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.Navigator;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.NoNodeTest;
import com.icl.saxon.pattern.Pattern;
import javax.xml.transform.TransformerException;

public class Mode {
    private Rule[] ruleDict = new Rule[114];
    private int nameCode = -1;
    private int sequence = 0;

    public void setNameCode(int n) {
        this.nameCode = n;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public void addRule(Pattern pattern, Object object, int n, double d) {
        if (pattern instanceof NoNodeTest) {
            return;
        }
        int n2 = pattern.getFingerprint();
        short s = pattern.getNodeType();
        int n3 = this.getList(n2, s);
        Rule rule = new Rule(pattern, object, n, d, this.sequence++);
        Rule rule2 = this.ruleDict[n3];
        if (rule2 == null) {
            this.ruleDict[n3] = rule;
            return;
        }
        Rule rule3 = null;
        while (rule2 != null) {
            if (rule2.precedence < n || rule2.precedence == n && rule2.priority <= d) {
                rule.next = rule2;
                if (rule3 == null) {
                    this.ruleDict[n3] = rule;
                    break;
                }
                rule3.next = rule;
                break;
            }
            rule3 = rule2;
            rule2 = rule2.next;
        }
        if (rule2 == null) {
            rule3.next = rule;
            rule.next = null;
        }
    }

    public int getList(int n, int n2) {
        if (n2 == 1) {
            if (n == -1) {
                return 0;
            }
            return 13 + n % 101;
        }
        return n2;
    }

    public Object getRule(NodeInfo nodeInfo, Context context) throws TransformerException {
        Rule rule;
        int n = nodeInfo.getFingerprint();
        short s = nodeInfo.getNodeType();
        int n2 = this.getList(n, s);
        int n3 = context.getController().getRecoveryPolicy();
        Rule rule2 = null;
        Rule rule3 = null;
        int n4 = -1;
        double d = Double.NEGATIVE_INFINITY;
        if (n2 != 0) {
            rule = this.ruleDict[n2];
            while (rule != null) {
                if (rule2 != null && (rule.precedence < n4 || rule.precedence == n4 && rule.priority < d)) break;
                if (rule.pattern.matches(nodeInfo, context)) {
                    if (rule2 != null) {
                        if (rule.precedence != n4 || rule.priority != d) break;
                        this.reportAmbiguity(nodeInfo, rule2.pattern, rule.pattern, context);
                        break;
                    }
                    rule2 = rule;
                    n4 = rule.precedence;
                    d = rule.priority;
                    if (n3 == 0) break;
                }
                rule = rule.next;
            }
        }
        rule = this.ruleDict[0];
        while (rule != null) {
            if (rule.precedence < n4 || rule.precedence == n4 && rule.priority < d) break;
            if (rule.pattern.matches(nodeInfo, context)) {
                if (rule3 != null) {
                    if (rule.precedence != rule3.precedence || rule.priority != rule3.priority) break;
                    this.reportAmbiguity(nodeInfo, rule.pattern, rule3.pattern, context);
                    break;
                }
                rule3 = rule;
                if (n3 == 0) break;
            }
            rule = rule.next;
        }
        if (rule2 != null && rule3 == null) {
            return rule2.object;
        }
        if (rule2 == null && rule3 != null) {
            return rule3.object;
        }
        if (rule2 != null && rule3 != null) {
            if (rule2.precedence == rule3.precedence && rule2.priority == rule3.priority) {
                Object object;
                Object object2 = object = rule2.sequence > rule3.sequence ? rule2.object : rule3.object;
                if (n3 != 0) {
                    this.reportAmbiguity(nodeInfo, rule2.pattern, rule3.pattern, context);
                }
                return object;
            }
            if (rule2.precedence > rule3.precedence || rule2.precedence == rule3.precedence && rule2.priority >= rule3.priority) {
                return rule2.object;
            }
            return rule3.object;
        }
        return null;
    }

    public Object getRule(NodeInfo nodeInfo, int n, int n2, Context context) throws XPathException {
        Rule rule;
        int n3 = nodeInfo.getFingerprint();
        short s = nodeInfo.getNodeType();
        int n4 = this.getList(n3, s);
        Rule rule2 = null;
        Rule rule3 = null;
        if (n4 != 0) {
            rule = this.ruleDict[n4];
            while (rule != null) {
                if (rule.precedence >= n && rule.precedence <= n2 && rule.pattern.matches(nodeInfo, context)) {
                    rule2 = rule;
                    break;
                }
                rule = rule.next;
            }
        }
        rule = this.ruleDict[0];
        while (rule != null) {
            if (rule.precedence >= n && rule.precedence <= n2 && rule.pattern.matches(nodeInfo, context)) {
                rule3 = rule;
                break;
            }
            rule = rule.next;
        }
        if (rule2 != null && rule3 == null) {
            return rule2.object;
        }
        if (rule2 == null && rule3 != null) {
            return rule3.object;
        }
        if (rule2 != null && rule3 != null) {
            if (rule2.precedence > rule3.precedence || rule2.precedence == rule3.precedence && rule2.priority >= rule3.priority) {
                return rule2.object;
            }
            return rule3.object;
        }
        return null;
    }

    private void reportAmbiguity(NodeInfo nodeInfo, Pattern pattern, Pattern pattern2, Context context) throws TransformerException {
        if (pattern.getStaticContext() == pattern2.getStaticContext()) {
            return;
        }
        context.getController().reportRecoverableError("Ambiguous rule match for " + Navigator.getPath(nodeInfo) + "\n" + "Matches both \"" + pattern + "\" on line " + pattern.getLineNumber() + " of " + pattern.getSystemId() + "\nand \"" + pattern2 + "\" on line " + pattern2.getLineNumber() + " of " + pattern2.getSystemId(), null);
    }

    private static class Rule {
        public Pattern pattern;
        public Object object;
        public int precedence;
        public double priority;
        public int sequence;
        public Rule next;

        public Rule(Pattern pattern, Object object, int n, double d, int n2) {
            this.pattern = pattern;
            this.object = object;
            this.precedence = n;
            this.priority = d;
            this.sequence = n2;
            this.next = null;
        }
    }
}

