/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.HttpUtils;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.tree.iter.NamespaceIterator;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.dom.HtmlDocumentBuilder;
import org.ccil.cowan.tagsoup.Parser;
import org.json.JSONTokener;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class UnescapeMarkup
extends DefaultStep {
    private static final QName _namespace = new QName("namespace");
    private static final QName _content_type = new QName("content-type");
    private static final QName _encoding = new QName("encoding");
    private static final QName _charset = new QName("charset");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private String namespace = null;

    public UnescapeMarkup(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String contentType = this.getOption(_content_type, "application/xml");
        String defCharset = HttpUtils.getCharset(contentType);
        contentType = HttpUtils.baseContentType(contentType);
        if (this.getOption(_namespace) != null) {
            this.namespace = this.getOption(_namespace).getString();
        }
        String encoding = null;
        if (this.getOption(_encoding) != null) {
            encoding = this.getOption(_encoding).getString();
        }
        String charset = null;
        charset = this.getOption(_charset) == null ? defCharset : this.getOption(_charset).getString();
        XdmNode doc = this.source.read();
        String escapedContent = null;
        if ("base64".equals(encoding)) {
            if (charset == null) {
                throw XProcException.stepError(10);
            }
            escapedContent = this.decodeBase64(doc, charset);
        } else {
            if (encoding != null) {
                throw new XProcException(this.step.getNode(), "Unexpected encoding: " + encoding);
            }
            escapedContent = this.extractText(doc);
        }
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(doc.getBaseURI());
        XdmSequenceIterator iter = doc.axisIterator(Axis.CHILD);
        XdmNode child = (XdmNode)iter.next();
        while (child.getNodeKind() != XdmNodeKind.ELEMENT) {
            tree.addSubtree(child);
            child = (XdmNode)iter.next();
        }
        tree.addStartElement(child);
        tree.addAttributes(child);
        tree.startContent();
        if ("text/html".equals(contentType)) {
            XdmNode tagDoc = null;
            tagDoc = "tagsoup".equals(this.runtime.htmlParser()) ? this.tagSoup(escapedContent) : this.parseHTML(escapedContent);
            if (this.namespace == null) {
                tree.addSubtree(tagDoc);
            } else {
                this.remapDefaultNamespace(tree, tagDoc);
            }
        } else if ("application/json".equals(contentType) || "text/json".equals(contentType)) {
            JSONTokener jt = new JSONTokener(escapedContent);
            XdmNode jsonDoc = JSONtoXML.convert(this.runtime.getProcessor(), jt, this.runtime.jsonFlavor());
            tree.addSubtree(jsonDoc);
        } else {
            if (!"application/xml".equals(contentType)) {
                throw XProcException.stepError(51);
            }
            escapedContent = "<wrapper>" + escapedContent + "</wrapper>";
            StringReader sr = new StringReader(escapedContent);
            InputSource is = new InputSource(sr);
            is.setSystemId(doc.getBaseURI().toASCIIString());
            XdmNode unesc = this.runtime.parse(is);
            XdmNode dummyWrapper = S9apiUtils.getDocumentElement(unesc);
            XdmSequenceIterator realNodes = dummyWrapper.axisIterator(Axis.CHILD);
            while (realNodes.hasNext()) {
                unesc = (XdmNode)realNodes.next();
                if (this.namespace == null) {
                    tree.addSubtree(unesc);
                    continue;
                }
                this.remapDefaultNamespace(tree, unesc);
            }
        }
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }

    private void remapDefaultNamespace(TreeWriter tree, XdmNode unescnode) {
        if (unescnode.getNodeKind() == XdmNodeKind.ELEMENT) {
            String pfx;
            NodeInfo inode = unescnode.getUnderlyingNode();
            NamePool pool = inode.getNamePool();
            int[] inscopeNS = NamespaceIterator.getInScopeNamespaceCodes((NodeInfo)inode);
            boolean replaced = false;
            int[] newNS = null;
            if (inscopeNS.length > 0) {
                newNS = new int[inscopeNS.length + 1];
                for (int pos = 0; pos < inscopeNS.length; ++pos) {
                    int ns = inscopeNS[pos];
                    pfx = pool.getPrefixFromNamespaceCode(ns);
                    if ("".equals(pfx)) {
                        int newns = pool.getNamespaceCode(pfx, this.namespace);
                        if (newns < 0) {
                            newns = pool.allocateNamespaceCode(pfx, this.namespace);
                        }
                        newNS[pos] = newns;
                        replaced = true;
                        continue;
                    }
                    newNS[pos] = ns;
                }
                if (!replaced) {
                    int newns = pool.getNamespaceCode("", this.namespace);
                    if (newns < 0) {
                        newns = pool.allocateNamespaceCode("", this.namespace);
                    }
                    newNS[newNS.length - 1] = newns;
                }
            }
            int nameCode = inode.getNameCode();
            int typeCode = inode.getTypeAnnotation() & 0xFFFFF;
            pfx = pool.getPrefix(nameCode);
            String uri = pool.getURI(nameCode);
            if ("".equals(pfx) && !this.namespace.equals(uri)) {
                nameCode = pool.allocate(pfx, this.namespace, unescnode.getNodeName().getLocalName());
            }
            tree.addStartElement(nameCode, typeCode, newNS);
            XdmSequenceIterator iter = unescnode.axisIterator(Axis.ATTRIBUTE);
            while (iter.hasNext()) {
                XdmNode child = (XdmNode)iter.next();
                tree.addAttribute(child);
            }
            XdmSequenceIterator childNodes = unescnode.axisIterator(Axis.CHILD);
            while (childNodes.hasNext()) {
                XdmNode child = (XdmNode)childNodes.next();
                this.remapDefaultNamespace(tree, child);
            }
            tree.addEndElement();
        } else {
            tree.addSubtree(unescnode);
        }
    }

    private String extractText(XdmNode doc) {
        String content = "";
        XdmSequenceIterator iter = doc.axisIterator(Axis.CHILD);
        while (iter.hasNext()) {
            XdmNode child = (XdmNode)iter.next();
            if (child.getNodeKind() != XdmNodeKind.ELEMENT && child.getNodeKind() != XdmNodeKind.TEXT) continue;
            content = content + child.getStringValue();
        }
        return content;
    }

    private String decodeBase64(XdmNode doc, String charset) {
        String content = this.extractText(doc);
        byte[] decoded = Base64.decode(content);
        try {
            return new String(decoded, charset);
        }
        catch (UnsupportedEncodingException uee) {
            throw XProcException.stepError(10, uee);
        }
    }

    private XdmNode tagSoup(String text) {
        StringReader inputStream = new StringReader(text);
        InputSource source = new InputSource(inputStream);
        Parser parser = new Parser();
        parser.setEntityResolver((EntityResolver)this.runtime.getResolver());
        SAXSource saxSource = new SAXSource((XMLReader)parser, source);
        DocumentBuilder builder = this.runtime.getProcessor().newDocumentBuilder();
        try {
            XdmNode doc = builder.build((Source)saxSource);
            return doc;
        }
        catch (Exception e) {
            throw new XProcException(e);
        }
    }

    private XdmNode parseHTML(String text) {
        HtmlDocumentBuilder htmlBuilder = new HtmlDocumentBuilder(XmlViolationPolicy.ALTER_INFOSET);
        htmlBuilder.setEntityResolver((EntityResolver)this.runtime.getResolver());
        try {
            InputSource src = new InputSource(new StringReader(text));
            Document html = htmlBuilder.parse(src);
            DocumentBuilder builder = this.runtime.getProcessor().newDocumentBuilder();
            XdmNode doc = builder.build((Source)new DOMSource(html));
            return doc;
        }
        catch (Exception e) {
            throw new XProcException(e);
        }
    }
}

