/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.http.signing.internal.PEMFileRSAPrivateKeySupplier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class FixedContentKeySupplier
implements SessionKeySupplier {
    private final KeyPair keyPair;

    public FixedContentKeySupplier(String privateKeyContents, char[] passphrase) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(privateKeyContents.getBytes());){
            RSAPrivateKey privateKey = new PEMFileRSAPrivateKeySupplier(inputStream, passphrase).supplyKey("unused").orElse(null);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPrivateCrtKeySpec keySpec = keyFactory.getKeySpec(keyFactory.translateKey(privateKey), RSAPrivateCrtKeySpec.class);
            RSAPublicKey publicKey = (RSAPublicKey)keyFactory.generatePublic(new RSAPublicKeySpec(keySpec.getModulus(), keySpec.getPublicExponent()));
            this.keyPair = new KeyPair(publicKey, privateKey);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException("problem handling private key", e);
        }
    }

    @Override
    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    @Override
    public void refreshKeys() {
    }
}

