/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.regex.Pattern;

@StatelessCheck
public class LineLengthCheck
extends AbstractCheck {
    public static final String MSG_KEY = "maxLineLen";
    private static final int DEFAULT_MAX_COLUMNS = 80;
    private static final Pattern IGNORE_PATTERN = Pattern.compile("^(package|import) .*");
    private int max = 80;
    private Pattern ignorePattern = Pattern.compile("^$");

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        String[] lines = this.getLines();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int realLength = CommonUtil.lengthExpandedTabs(line, line.length(), this.getTabWidth());
            if (realLength <= this.max || IGNORE_PATTERN.matcher(line).find() || this.ignorePattern.matcher(line).find()) continue;
            this.log(i + 1, MSG_KEY, this.max, realLength);
        }
    }

    public void setMax(int length) {
        this.max = length;
    }

    public final void setIgnorePattern(Pattern pattern) {
        this.ignorePattern = pattern;
    }
}

