/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractNameCheck;

public class LambdaParameterNameCheck
extends AbstractNameCheck {
    public LambdaParameterNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{181};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST parametersNode = ast.findFirstToken(20);
        if (parametersNode == null) {
            super.visitToken(ast);
        } else {
            for (DetailAST parameterDef = parametersNode.getFirstChild(); parameterDef != null; parameterDef = parameterDef.getNextSibling()) {
                if (parameterDef.getType() != 21) continue;
                super.visitToken(parameterDef);
            }
        }
    }

    @Override
    protected boolean mustCheckName(DetailAST ast) {
        return true;
    }
}

