J2ObjC Tree Shaker

About:
The tree shaker project is an experimental tool in the J2ObjC family that lets 
users detect any unused code in their Java program. The purpose of the tool is 
to provide the translator with a list of unused elements in the code that it 
can remove to reduce the size of the translated project.

Usage:
The tree shaker can be used in two ways:

1. Manual Analysis: Using the tree shaker by itself on a package of source 
files, it will report a set of classes and methods that it detected as unused.
2. Dead Code Elimination in Translator: The tree-shaker-report output file, 
generated by the tree shaker, can be used as an input to the translator, using 
its Dead Code Elimination functionality (see the docs for translator). This 
will automatically remove the unused code reported by the tree shaker from the 
final translated source code.

Running Tree Shaker:
The tree shaker command takes in a few flags, as seen in the help message:

```
Usage: tree_shaker <options> <source files>
where possible options include:
  -sourcepath <path>           Specify where to find input source files.
  -classpath <path>            Specify where to find user class files.
  --tree-shaker-roots          Specify a file that lists the public root classes and methods.
  -s, --sourcefilelist <file>  Specify a file that lists the source files to be analyzed.
  -encoding <encoding>         Specify character encoding used by source files
  -Xbootclasspath:<path>       Boot path used to compile the input sources. (not the tool itself)
  -version                     Version information
  -Werror                      Treats all warning as errors.
  -h, --help                   Print this message.
```

All elements in the input source files that can be reached from the public 
roots will be kept, and the others marked as unused. The input file formatting 
for classes is the full packageName.className for the class, one class per line:

```
# These are the root classes for this library:
foo.bar.Mumble
itsy.bitsy.Spider

# Inner-classes work, too:
twisty.little.Passage.Direction
```

When indicating a class as a public root, the tree shaker will take all public 
methods inside that class and add them to the public root set, for convenience.
To add specific methods to the public root set, add their enclosing class's 
packageName.className, followed by a colon, and all of the root set methods 
inside that class on the following lines, one on each line, preceded by 4 
spaces. For example, this tells `tree_shaker` to only mark the `main` method as
used, which allows other methods to potentially be reported as dead:

```
my.little.Pony:
    main(java.lang.String[])
```

Ending Note:
The tree shaker tool is an experimental project, used at the user's own risk. 
The manual analysis use case is completely safe, and is the recommended way to 
analyze source code for unused elements while the tree shaker is still in 
testing. More adventurous users are encouraged to experiment with dead code 
elimination, find and/or fix bugs, and submit pull requests.
