# This R script generates the Python file fisher_exact_results_from_r.py.
# To run this script, use
# $ Rscript generate_fisher_exact_results_from_r.R

sink("fisher_exact_results_from_r.py")

options(digits=15)

# Note that when converted to a matrix, `byrow=TRUE` is used, so
# the first two values of each data set become the first row of
# the contingency  table.  E.g.
# > matrix(c(100, 2, 1000, 5), nrow=2, ncol=2, byrow=TRUE)
#      [,1] [,2]
# [1,]  100    2
# [2,] 1000    5
# 
table_data = list(
    c(100, 2, 1000, 5),
    c(2, 7, 8, 2),
    c(5, 1, 10, 10),
    c(5, 15, 20, 20),
    c(5, 16, 16, 25),
    c(10, 5, 10, 1),
    c(10, 5, 10, 0),
    c(5, 0, 1, 4),
    c(0, 5, 1, 4),
    c(5, 1, 0, 4),
    c(0, 1, 3, 2),
    c(200, 7, 8, 300),
    c(28, 21, 6, 1957),
    c(190, 800, 200, 900)
)
confidence.levels = c(0.95, 0.99)
alternatives = c("two.sided", "less", "greater")

cat("# DO NOT EDIT THIS FILE!", fill=TRUE)
cat("# This file was generated by the R script", fill=TRUE)
cat("#     generate_fisher_exact_results_from_r.R", fill=TRUE)
cat("# The script was run with", R.version.string, "at ")
s = sprintf("%s", Sys.time())
cat(s, fill=TRUE)
cat("", fill=TRUE)
cat("", fill=TRUE)
cat("from collections import namedtuple", fill=TRUE)
cat("import numpy as np", fill=TRUE)
cat("", fill=TRUE)
cat("", fill=TRUE)
cat("Inf = np.inf", fill=TRUE)
cat("", fill=TRUE)
cat("Parameters = namedtuple('Parameters',", fill=TRUE)
cat("                        ['table', 'confidence_level', 'alternative'])", fill=TRUE)
cat("RResults = namedtuple('RResults',", fill=TRUE)
cat("                      ['pvalue', 'conditional_odds_ratio',", fill=TRUE)
cat("                       'conditional_odds_ratio_ci'])", fill=TRUE)
cat("data = [", fill=TRUE)
for (alternative in alternatives) {
    for (conf.level in confidence.levels) {
        for (data in table_data) {
            table = matrix(data, nrow=2, ncol=2, byrow=TRUE)
            #result = fisher.test(table, alternative=alternative, conf.level=conf.level)
            result = fisher.test(table, alternative=alternative, conf.level=conf.level)
            cat("    (")
            cat("Parameters(table=")
            s = sprintf("[[%.16g, %.16g], [%.16g, %.16g]],", table[1, 1], table[1, 2], table[2, 1], table[2, 2])
            cat(s, fill=TRUE)
            s = sprintf("                confidence_level=%.16g,", conf.level)
            cat(s, fill=TRUE)
            s = sprintf("                alternative='%s'),", alternative)
            cat(s, fill=TRUE)
            cat("     RResults(")
            s = sprintf("pvalue=%.16g,", result$p.value)
            cat(s, fill=TRUE)
            s = sprintf("              conditional_odds_ratio=%.16g,", result$estimate)
            cat(s, fill=TRUE)
            s = sprintf("              conditional_odds_ratio_ci=(%.16g,", result$conf.int[1])
            cat(s, fill=TRUE)
            s = sprintf("                                         %.16g))),", result$conf.int[2])
            cat(s, fill=TRUE)
        }
    }
}
cat("]", fill=TRUE)

sink()
