/*
 * The MIT License (MIT)
 *
 * Copyright © 2015-2016 Franklin "Snaipe" Mathieu <http://snai.pe/>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "internal.h"

size_t get_processor_count(void)
{
#ifdef _WIN32
    SYSTEM_INFO sysinfo;
    GetSystemInfo(&sysinfo);

    return (size_t) sysinfo.dwNumberOfProcessors;
#elif defined (BSD)
    int mib[2] = { CTL_HW, HW_NCPU };
# ifdef __APPLE__
    size_t miblen = 2;
    sysctlnametomib("hw.logicalcpu", mib, &miblen);
# endif

    long long count = 0;
    size_t len = sizeof (count);

    int res = sysctl(mib, 2, &count, &len, NULL, 0);

    if (count < 1 || res == -1)
        count = 1;
    return (size_t) count;
#elif defined (__linux__)
    long count = sysconf(_SC_NPROCESSORS_ONLN);
    return count < 1 ? 1 : (size_t) count;
#else
# error System not supported
#endif
}
