/* SPDX-License-Identifier: BSD-3-Clause */

#ifndef PLL_H
#define PLL_H

#include "mt8195.h"

/* for MTCMOS bus protection */
//TODO
#define INFRA_TOPAXI_PROTECTEN			(INFRACFG_AO_BASE + 0x0220)
#define INFRA_TOPAXI_PROTECTEN_SET		(INFRACFG_AO_BASE + 0x02A0)
#define INFRA_TOPAXI_PROTECTEN_CLR		(INFRACFG_AO_BASE + 0x02A4)
#define INFRA_TOPAXI_PROTECTEN_STA0		(INFRACFG_AO_BASE + 0x0224)
#define INFRA_TOPAXI_PROTECTEN_STA1		(INFRACFG_AO_BASE + 0x0228)

#define INFRA_TOPAXI_PROTECTEN_1		(INFRACFG_AO_BASE + 0x0250)
#define INFRA_TOPAXI_PROTECTEN_1_SET		(INFRACFG_AO_BASE + 0x02A8)
#define INFRA_TOPAXI_PROTECTEN_1_CLR		(INFRACFG_AO_BASE + 0x02AC)
#define INFRA_TOPAXI_PROTECTEN_STA0_1		(INFRACFG_AO_BASE + 0x0254)
#define INFRA_TOPAXI_PROTECTEN_STA1_1		(INFRACFG_AO_BASE + 0x0258)

#define INFRA_TOPAXI_PROTECTEN_MCU		(INFRACFG_AO_BASE + 0x02C0)
#define INFRA_TOPAXI_PROTECTEN_MCU_STA0		(INFRACFG_AO_BASE + 0x02E0)
#define INFRA_TOPAXI_PROTECTEN_MCU_STA1		(INFRACFG_AO_BASE + 0x02E4)
#define INFRA_TOPAXI_PROTECTEN_MCU_SET		(INFRACFG_AO_BASE + 0x02C4)
#define INFRA_TOPAXI_PROTECTEN_MCU_CLR		(INFRACFG_AO_BASE + 0x02C8)

#define INFRA_TOPAXI_PROTECTEN_MM		(INFRACFG_AO_BASE + 0x02D0)
#define INFRA_TOPAXI_PROTECTEN_MM_SET		(INFRACFG_AO_BASE + 0x02D4)
#define INFRA_TOPAXI_PROTECTEN_MM_CLR		(INFRACFG_AO_BASE + 0x02D8)
#define INFRA_TOPAXI_PROTECTEN_MM_STA0		(INFRACFG_AO_BASE + 0x02E8)
#define INFRA_TOPAXI_PROTECTEN_MM_STA1		(INFRACFG_AO_BASE + 0x02EC)

#define INFRA_TOPAXI_PROTECTEN_2		(INFRACFG_AO_BASE + 0x0710)
#define INFRA_TOPAXI_PROTECTEN_2_SET		(INFRACFG_AO_BASE + 0x0714)
#define INFRA_TOPAXI_PROTECTEN_2_CLR		(INFRACFG_AO_BASE + 0x0718)
#define INFRA_TOPAXI_PROTECTEN_STA0_2		(INFRACFG_AO_BASE + 0x0720)
#define INFRA_TOPAXI_PROTECTEN_STA1_2		(INFRACFG_AO_BASE + 0x0724)

#define INFRA_TOPAXI_PROTECTEN_MM_2		(INFRACFG_AO_BASE + 0x0DC8)
#define INFRA_TOPAXI_PROTECTEN_MM_2_SET		(INFRACFG_AO_BASE + 0x0DCC)
#define INFRA_TOPAXI_PROTECTEN_MM_2_CLR		(INFRACFG_AO_BASE + 0x0DD0)
#define INFRA_TOPAXI_PROTECTEN_MM_2_STA0	(INFRACFG_AO_BASE + 0x0DD4)
#define INFRA_TOPAXI_PROTECTEN_MM_2_STA1	(INFRACFG_AO_BASE + 0x0DD8)

#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR		(INFRACFG_AO_BASE + 0x0B80)
#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_SET		(INFRACFG_AO_BASE + 0x0B84)
#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_CLR		(INFRACFG_AO_BASE + 0x0B88)
#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_STA0		(INFRACFG_AO_BASE + 0x0B8c)
#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_STA1		(INFRACFG_AO_BASE + 0x0B90)

#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_1		(INFRACFG_AO_BASE + 0x0BA0)
#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_1_SET		(INFRACFG_AO_BASE + 0x0BA4)
#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_1_CLR		(INFRACFG_AO_BASE + 0x0BA8)
#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_1_STA0	(INFRACFG_AO_BASE + 0x0BAc)
#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_1_STA1	(INFRACFG_AO_BASE + 0x0BB0)

#define INFRA_TOPAXI_PROTECTEN_SUB_INFRA_VDNR		(INFRACFG_AO_BASE + 0x0BB4)
#define INFRA_TOPAXI_PROTECTEN_SUB_INFRA_VDNR_SET	(INFRACFG_AO_BASE + 0x0BB8)
#define INFRA_TOPAXI_PROTECTEN_SUB_INFRA_VDNR_CLR	(INFRACFG_AO_BASE + 0x0BBC)
#define INFRA_TOPAXI_PROTECTEN_SUB_INFRA_VDNR_STA0	(INFRACFG_AO_BASE + 0x0BC0)
#define INFRA_TOPAXI_PROTECTEN_SUB_INFRA_VDNR_STA1	(INFRACFG_AO_BASE + 0x0BC4)

/* MCUCFG Register */
#define CPU_PLLDIV_CFG0		(MCUCFG_BASE + 0xA2A0)
#define CPU_PLLDIV_CFG1		(MCUCFG_BASE + 0xA2A4)
#define BUS_PLLDIV_CFG		(MCUCFG_BASE + 0xA2E0)

/* APMIXEDSYS Register */
#define AP_PLL_CON0             (APMIXED_BASE + 0x0000)

#define PLLON_CON0		(APMIXED_BASE + 0x0050)
#define PLLON_CON1		(APMIXED_BASE + 0x0054)
#define PLLON_CON2		(APMIXED_BASE + 0x0058)
#define PLLON_CON3		(APMIXED_BASE + 0x005C)

#define ARMPLL_LL_CON0		(APMIXED_BASE + 0x0020)
#define ARMPLL_LL_CON1          (APMIXED_BASE + 0x0024)
#define ARMPLL_LL_CON2          (APMIXED_BASE + 0x0028)
#define ARMPLL_LL_CON3          (APMIXED_BASE + 0x002C)
#define ARMPLL_LL_CON4          (APMIXED_BASE + 0X0600)

#define ARMPLL_BL_CON0          (APMIXED_BASE + 0X0070)
#define ARMPLL_BL_CON1          (APMIXED_BASE + 0X0074)
#define ARMPLL_BL_CON2          (APMIXED_BASE + 0X0078)
#define ARMPLL_BL_CON3          (APMIXED_BASE + 0X007C)
#define ARMPLL_BL_CON4          (APMIXED_BASE + 0X0080)

#define CCIPLL_CON0             (APMIXED_BASE + 0X0030)
#define CCIPLL_CON1             (APMIXED_BASE + 0X0634)
#define CCIPLL_CON2             (APMIXED_BASE + 0X0638)
#define CCIPLL_CON3             (APMIXED_BASE + 0X063C)
#define CCIPLL_CON4             (APMIXED_BASE + 0X0640)

#define NNAPLL_CON0             (APMIXED_BASE + 0X0390)
#define NNAPLL_CON1             (APMIXED_BASE + 0X0394)
#define NNAPLL_CON2             (APMIXED_BASE + 0X0398)
#define NNAPLL_CON3             (APMIXED_BASE + 0X039C)
#define NNAPLL_CON4             (APMIXED_BASE + 0X03A0)

#define RESPLL_CON0             (APMIXED_BASE + 0X0190)
#define RESPLL_CON1             (APMIXED_BASE + 0X0194)
#define RESPLL_CON2             (APMIXED_BASE + 0X0198)
#define RESPLL_CON3             (APMIXED_BASE + 0X019C)
#define RESPLL_CON4             (APMIXED_BASE + 0X0320)

#define ETHPLL_CON0             (APMIXED_BASE + 0X0360)
#define ETHPLL_CON1             (APMIXED_BASE + 0X0364)
#define ETHPLL_CON2             (APMIXED_BASE + 0X0368)
#define ETHPLL_CON3             (APMIXED_BASE + 0X036C)
#define ETHPLL_CON4             (APMIXED_BASE + 0X0370)

#define MSDCPLL_CON0            (APMIXED_BASE + 0X0710)
#define MSDCPLL_CON1            (APMIXED_BASE + 0X0714)
#define MSDCPLL_CON2            (APMIXED_BASE + 0X0718)
#define MSDCPLL_CON3            (APMIXED_BASE + 0X071C)
#define MSDCPLL_CON4            (APMIXED_BASE + 0X0720)

#define TVDPLL1_CON0            (APMIXED_BASE + 0X00A0)
#define TVDPLL1_CON1            (APMIXED_BASE + 0X00A4)
#define TVDPLL1_CON2            (APMIXED_BASE + 0X00A8)
#define TVDPLL1_CON3            (APMIXED_BASE + 0X00AC)
#define TVDPLL1_CON4            (APMIXED_BASE + 0X00B0)

#define TVDPLL2_CON0            (APMIXED_BASE + 0X00C0)
#define TVDPLL2_CON1            (APMIXED_BASE + 0X00C4)
#define TVDPLL2_CON2            (APMIXED_BASE + 0X00C8)
#define TVDPLL2_CON3            (APMIXED_BASE + 0X00CC)
#define TVDPLL2_CON4            (APMIXED_BASE + 0X00D0)

#define MPLL_CON0		(APMIXED_BASE + 0X0800)
#define MPLL_CON1		(APMIXED_BASE + 0X0804)
#define MPLL_CON2		(APMIXED_BASE + 0X0808)
#define MPLL_CON3		(APMIXED_BASE + 0X080C)
#define MPLL_CON4		(APMIXED_BASE + 0X0810)

#define MMPLL_CON0              (APMIXED_BASE + 0X00E0)
#define MMPLL_CON1              (APMIXED_BASE + 0X00E4)
#define MMPLL_CON2              (APMIXED_BASE + 0X00E8)
#define MMPLL_CON3              (APMIXED_BASE + 0X00EC)
#define MMPLL_CON4              (APMIXED_BASE + 0X00F0)

#define MAINPLL_CON0            (APMIXED_BASE + 0X01D0)
#define MAINPLL_CON1            (APMIXED_BASE + 0X01D4)
#define MAINPLL_CON2            (APMIXED_BASE + 0X01D8)
#define MAINPLL_CON3            (APMIXED_BASE + 0X01DC)
#define MAINPLL_CON4            (APMIXED_BASE + 0X01E0)

#define VDECPLL_CON0            (APMIXED_BASE + 0X0890)
#define VDECPLL_CON1            (APMIXED_BASE + 0X0894)
#define VDECPLL_CON2            (APMIXED_BASE + 0X0898)
#define VDECPLL_CON3            (APMIXED_BASE + 0X089C)
#define VDECPLL_CON4            (APMIXED_BASE + 0X08A0)

#define IMGPLL_CON0             (APMIXED_BASE + 0X0100)
#define IMGPLL_CON1             (APMIXED_BASE + 0X0104)
#define IMGPLL_CON2             (APMIXED_BASE + 0X0108)
#define IMGPLL_CON3             (APMIXED_BASE + 0X010C)
#define IMGPLL_CON4             (APMIXED_BASE + 0X0110)

#define UNIVPLL_CON0	        (APMIXED_BASE + 0X01F0)
#define UNIVPLL_CON1            (APMIXED_BASE + 0X01F4)
#define UNIVPLL_CON2            (APMIXED_BASE + 0X01F8)
#define UNIVPLL_CON3            (APMIXED_BASE + 0X01FC)
#define UNIVPLL_CON4            (APMIXED_BASE + 0X0700)

#define HDMIPLL1_CON0           (APMIXED_BASE + 0X08C0)
#define HDMIPLL1_CON1           (APMIXED_BASE + 0X08C4)
#define HDMIPLL1_CON2           (APMIXED_BASE + 0X08C8)
#define HDMIPLL1_CON3           (APMIXED_BASE + 0X08CC)
#define HDMIPLL1_CON4           (APMIXED_BASE + 0X08D0)

#define HDMIPLL2_CON0           (APMIXED_BASE + 0X0870)
#define HDMIPLL2_CON1           (APMIXED_BASE + 0X0874)
#define HDMIPLL2_CON2           (APMIXED_BASE + 0X0878)
#define HDMIPLL2_CON3           (APMIXED_BASE + 0X087C)
#define HDMIPLL2_CON4           (APMIXED_BASE + 0X0880)

#define HDMIRX_APLL_CON0        (APMIXED_BASE + 0X08E0)
#define HDMIRX_APLL_CON1        (APMIXED_BASE + 0X08E4)
#define HDMIRX_APLL_CON2        (APMIXED_BASE + 0X08E8)
#define HDMIRX_APLL_CON3        (APMIXED_BASE + 0X08EC)
#define HDMIRX_APLL_CON4        (APMIXED_BASE + 0X08F0)
#define HDMIRX_APLL_CON5        (APMIXED_BASE + 0X0DD4)

#define USB1PLL_CON0            (APMIXED_BASE + 0X01A0)
#define USB1PLL_CON1            (APMIXED_BASE + 0X01A4)
#define USB1PLL_CON2            (APMIXED_BASE + 0X01A8)
#define USB1PLL_CON3            (APMIXED_BASE + 0X01AC)
#define USB1PLL_CON4            (APMIXED_BASE + 0X01B0)

#define ADSPPLL_CON0            (APMIXED_BASE + 0X07E0)
#define ADSPPLL_CON1            (APMIXED_BASE + 0X07E4)
#define ADSPPLL_CON2            (APMIXED_BASE + 0X07E8)
#define ADSPPLL_CON3            (APMIXED_BASE + 0X07EC)
#define ADSPPLL_CON4            (APMIXED_BASE + 0X07F0)

#define APLL1_CON0              (APMIXED_BASE + 0X07C0)
#define APLL1_CON1              (APMIXED_BASE + 0X07C4)
#define APLL1_CON2              (APMIXED_BASE + 0X07C8)
#define APLL1_CON3              (APMIXED_BASE + 0X07CC)
#define APLL1_CON4              (APMIXED_BASE + 0X07D0)
#define APLL1_CON5              (APMIXED_BASE + 0X0DC0)

#define APLL2_CON0              (APMIXED_BASE + 0X0780)
#define APLL2_CON1              (APMIXED_BASE + 0X0784)
#define APLL2_CON2              (APMIXED_BASE + 0X0788)
#define APLL2_CON3              (APMIXED_BASE + 0X078C)
#define APLL2_CON4              (APMIXED_BASE + 0X0790)
#define APLL2_CON5              (APMIXED_BASE + 0X0DC4)

#define APLL3_CON0              (APMIXED_BASE + 0X0760)
#define APLL3_CON1              (APMIXED_BASE + 0X0764)
#define APLL3_CON2              (APMIXED_BASE + 0X0768)
#define APLL3_CON3              (APMIXED_BASE + 0X076C)
#define APLL3_CON4              (APMIXED_BASE + 0X0770)
#define APLL3_CON5              (APMIXED_BASE + 0X0DC8)

#define APLL4_CON0              (APMIXED_BASE + 0X0740)
#define APLL4_CON1              (APMIXED_BASE + 0X0744)
#define APLL4_CON2              (APMIXED_BASE + 0X0748)
#define APLL4_CON3              (APMIXED_BASE + 0X074C)
#define APLL4_CON4              (APMIXED_BASE + 0X0750)
#define APLL4_CON5              (APMIXED_BASE + 0X0DCC)

#define APLL5_CON0              (APMIXED_BASE + 0X07A0)
#define APLL5_CON1              (APMIXED_BASE + 0X07A4)
#define APLL5_CON2              (APMIXED_BASE + 0X07A8)
#define APLL5_CON3              (APMIXED_BASE + 0X07AC)
#define APLL5_CON4              (APMIXED_BASE + 0X07B0)
#define APLL5_CON5              (APMIXED_BASE + 0X0DD0)

#define MFGPLL_CON0             (APMIXED_BASE + 0X0340)
#define MFGPLL_CON1             (APMIXED_BASE + 0X0344)
#define MFGPLL_CON2             (APMIXED_BASE + 0X0348)
#define MFGPLL_CON3             (APMIXED_BASE + 0X034C)
#define MFGPLL_CON4             (APMIXED_BASE + 0X0350)

#define DGIPLL_CON0             (APMIXED_BASE + 0X0150)
#define DGIPLL_CON1             (APMIXED_BASE + 0X0154)
#define DGIPLL_CON2             (APMIXED_BASE + 0X0158)
#define DGIPLL_CON3             (APMIXED_BASE + 0X015C)
#define DGIPLL_CON4             (APMIXED_BASE + 0X0160)

#define APLL1_TUNER_CON0        (APMIXED_BASE + 0x0470)
#define APLL2_TUNER_CON0        (APMIXED_BASE + 0x0474)
#define APLL3_TUNER_CON0        (APMIXED_BASE + 0x0478)
#define APLL4_TUNER_CON0        (APMIXED_BASE + 0x047C)
#define APLL5_TUNER_CON0        (APMIXED_BASE + 0x0480)

/* TOPCKGEN Register */
#define CLK_CFG_UPDATE          (TOPCKGEN_BASE + 0x004)
#define CLK_CFG_UPDATE1         (TOPCKGEN_BASE + 0x008)
#define CLK_CFG_UPDATE2         (TOPCKGEN_BASE + 0x00C)
#define CLK_CFG_UPDATE3		(TOPCKGEN_BASE + 0x010)
#define CLK_CFG_UPDATE4		(TOPCKGEN_BASE + 0x014)

#define CLK_CFG_0_SET		(TOPCKGEN_BASE + 0x024)
#define CLK_CFG_0_CLR		(TOPCKGEN_BASE + 0x028)
#define CLK_CFG_1_SET		(TOPCKGEN_BASE + 0x030)
#define CLK_CFG_1_CLR		(TOPCKGEN_BASE + 0x034)
#define CLK_CFG_2_SET		(TOPCKGEN_BASE + 0x03C)
#define CLK_CFG_2_CLR		(TOPCKGEN_BASE + 0x040)
#define CLK_CFG_3_SET		(TOPCKGEN_BASE + 0x048)
#define CLK_CFG_3_CLR		(TOPCKGEN_BASE + 0x04C)
#define CLK_CFG_4_SET		(TOPCKGEN_BASE + 0x054)
#define CLK_CFG_4_CLR		(TOPCKGEN_BASE + 0x058)
#define CLK_CFG_5_SET		(TOPCKGEN_BASE + 0x060)
#define CLK_CFG_5_CLR		(TOPCKGEN_BASE + 0x064)
#define CLK_CFG_6_SET		(TOPCKGEN_BASE + 0x06C)
#define CLK_CFG_6_CLR		(TOPCKGEN_BASE + 0x070)
#define CLK_CFG_7_SET		(TOPCKGEN_BASE + 0x078)
#define CLK_CFG_7_CLR		(TOPCKGEN_BASE + 0x07C)
#define CLK_CFG_8_SET		(TOPCKGEN_BASE + 0x084)
#define CLK_CFG_8_CLR		(TOPCKGEN_BASE + 0x088)
#define CLK_CFG_9_SET		(TOPCKGEN_BASE + 0x090)
#define CLK_CFG_9_CLR		(TOPCKGEN_BASE + 0x094)
#define CLK_CFG_10_SET		(TOPCKGEN_BASE + 0x09C)
#define CLK_CFG_10_CLR		(TOPCKGEN_BASE + 0x0A0)
#define CLK_CFG_11_SET		(TOPCKGEN_BASE + 0x0A8)
#define CLK_CFG_11_CLR		(TOPCKGEN_BASE + 0x0AC)
#define CLK_CFG_12_SET		(TOPCKGEN_BASE + 0x0B4)
#define CLK_CFG_12_CLR		(TOPCKGEN_BASE + 0x0B8)
#define CLK_CFG_13_SET		(TOPCKGEN_BASE + 0x0C0)
#define CLK_CFG_13_CLR		(TOPCKGEN_BASE + 0x0C4)
#define CLK_CFG_14_SET		(TOPCKGEN_BASE + 0x0CC)
#define CLK_CFG_14_CLR		(TOPCKGEN_BASE + 0x0D0)
#define CLK_CFG_15_SET		(TOPCKGEN_BASE + 0x0D8)
#define CLK_CFG_15_CLR		(TOPCKGEN_BASE + 0x0DC)
#define CLK_CFG_16_SET		(TOPCKGEN_BASE + 0x0E4)
#define CLK_CFG_16_CLR		(TOPCKGEN_BASE + 0x0E8)
#define CLK_CFG_17_SET		(TOPCKGEN_BASE + 0x0F0)
#define CLK_CFG_17_CLR		(TOPCKGEN_BASE + 0x0F4)
#define CLK_CFG_18_SET		(TOPCKGEN_BASE + 0x0FC)
#define CLK_CFG_18_CLR		(TOPCKGEN_BASE + 0x0100)
#define CLK_CFG_19_SET		(TOPCKGEN_BASE + 0x0108)
#define CLK_CFG_19_CLR		(TOPCKGEN_BASE + 0x010C)
#define CLK_CFG_20_SET		(TOPCKGEN_BASE + 0x0114)
#define CLK_CFG_20_CLR		(TOPCKGEN_BASE + 0x0118)
#define CLK_CFG_21_SET		(TOPCKGEN_BASE + 0x0120)
#define CLK_CFG_21_CLR		(TOPCKGEN_BASE + 0x0124)
#define CLK_CFG_22_SET		(TOPCKGEN_BASE + 0x012C)
#define CLK_CFG_22_CLR		(TOPCKGEN_BASE + 0x0130)
#define CLK_CFG_23_SET		(TOPCKGEN_BASE + 0x0138)
#define CLK_CFG_23_CLR		(TOPCKGEN_BASE + 0x013C)
#define CLK_CFG_24_SET		(TOPCKGEN_BASE + 0x0144)
#define CLK_CFG_24_CLR		(TOPCKGEN_BASE + 0x0148)
#define CLK_CFG_25_SET		(TOPCKGEN_BASE + 0x0150)
#define CLK_CFG_25_CLR		(TOPCKGEN_BASE + 0x0154)
#define CLK_CFG_26_SET		(TOPCKGEN_BASE + 0x015C)
#define CLK_CFG_26_CLR		(TOPCKGEN_BASE + 0x0160)
#define CLK_CFG_27_SET		(TOPCKGEN_BASE + 0x0168)
#define CLK_CFG_27_CLR		(TOPCKGEN_BASE + 0x016C)
#define CLK_CFG_28_SET		(TOPCKGEN_BASE + 0x0174)
#define CLK_CFG_28_CLR		(TOPCKGEN_BASE + 0x0178)
#define CLK_CFG_29_SET		(TOPCKGEN_BASE + 0x0180)
#define CLK_CFG_29_CLR		(TOPCKGEN_BASE + 0x0184)
#define CLK_CFG_30_SET		(TOPCKGEN_BASE + 0x018C)
#define CLK_CFG_30_CLR		(TOPCKGEN_BASE + 0x0190)
#define CLK_CFG_31_SET		(TOPCKGEN_BASE + 0x0198)
#define CLK_CFG_31_CLR		(TOPCKGEN_BASE + 0x019C)
#define CLK_CFG_32_SET		(TOPCKGEN_BASE + 0x01A4)
#define CLK_CFG_32_CLR		(TOPCKGEN_BASE + 0x01A8)
#define CLK_CFG_33_SET		(TOPCKGEN_BASE + 0x01B0)
#define CLK_CFG_33_CLR		(TOPCKGEN_BASE + 0x01B4)
#define CLK_CFG_34_SET		(TOPCKGEN_BASE + 0x01BC)
#define CLK_CFG_34_CLR		(TOPCKGEN_BASE + 0x01C0)
#define CLK_CFG_35_SET		(TOPCKGEN_BASE + 0x01C8)
#define CLK_CFG_35_CLR		(TOPCKGEN_BASE + 0x01CC)
#define CLK_CFG_36_SET		(TOPCKGEN_BASE + 0x01D4)
#define CLK_CFG_36_CLR		(TOPCKGEN_BASE + 0x01D8)
#define CLK_CFG_37_SET		(TOPCKGEN_BASE + 0x01E0)
#define CLK_CFG_37_CLR		(TOPCKGEN_BASE + 0x01E4)
#define CLK_MISC_CFG_3		(TOPCKGEN_BASE + 0x0250)

#define CLK_DBG_CFG		(TOPCKGEN_BASE + 0x020C)
#define CLK26CALI_0		(TOPCKGEN_BASE + 0x0218)
#define CLK26CALI_1		(TOPCKGEN_BASE + 0x021C)
#define CLK_MISC_CFG_0		(TOPCKGEN_BASE + 0x022C)
#define CLK_SCP_CFG_0		(TOPCKGEN_BASE + 0x0264)

#define INFRA_BUS_DCM_CTRL		(INFRACFG_AO_BASE + 0x70)
#define VDNR_DCM_TOP_INFRA_CTRL0	(INFRA_AO_BCRM_BASE + 0x034)

#define TOPCKGEN_CLK_MISC_CFG_1		(TOPCKGEN_BASE + 0x238)
#define TOPCKGEN_CLK_MISC_CFG_3		(TOPCKGEN_BASE + 0x250)
#define INFRACFG_AO_MODULE_SW_CG_0_CLR	(INFRACFG_AO_BASE + 0x84)
#define INFRACFG_AO_MODULE_SW_CG_1_CLR	(INFRACFG_AO_BASE + 0x8c)
#define INFRACFG_AO_MODULE_SW_CG_2_CLR	(INFRACFG_AO_BASE + 0xa8)
#define INFRACFG_AO_MODULE_SW_CG_3_CLR	(INFRACFG_AO_BASE + 0xc4)
#define INFRACFG_AO_MODULE_SW_CG_4_CLR	(INFRACFG_AO_BASE + 0xe4)
#define APMIXEDSYS_AP_PLL_CON2		(APMIXED_BASE + 0x8)
#define IPNNA_F26M_CK_CG		(IPNNA_BASE + 0x104)
#define IPNNA_AXI_CK_CG			(IPNNA_BASE + 0x110)
#define IPNNA_NNA0_CG_EN		(IPNNA_BASE + 0x90)
#define IPNNA_NNA1_CG_EN		(IPNNA_BASE + 0x94)
#define IPNNA_NNA0_EMI_CG_EN		(IPNNA_BASE + 0x98)
#define IPNNA_NNA1_EMI_CG_EN		(IPNNA_BASE + 0x9c)
#define IPNNA_NNA0_AXI_CG_EN		(IPNNA_BASE + 0xa0)
#define IPNNA_NNA1_AXI_CG_EN		(IPNNA_BASE + 0xa4)
#define SCP_PAR_TOP_AUDIODSP_CK_CG	(SCP_PAR_TOP_BASE + 0x180)
#define AUDIO_AUDIO_TOP_0		(AUDIO_BASE + 0x0)
#define AUDIO_AUDIO_TOP_4		(AUDIO_BASE + 0x10)
#define AUDIO_AUDIO_TOP_5		(AUDIO_BASE + 0x14)
#define AUDIO_AUDIO_TOP_6		(AUDIO_BASE + 0x18)
#define AUDIO_AUDIO_TOP_1		(AUDIO_BASE + 0x4)
#define AUDIO_AUDIO_TOP_3		(AUDIO_BASE + 0xc)
#define AUDIO_SRC_MEM_ASRC_TOP_1	(AUDIO_SRC_BASE + 0x1004)
#define PERICFG_AO_PERI_MODULE_SW_CG_0_SET	(PERICFG_AO_BASE + 0x10)
#define PERICFG_AO_PERI_MODULE_SW_CG_0_CLR	(PERICFG_AO_BASE + 0x14)
#define MFGCFG_MFG_CG_CLR		(MFGCFG_BASE + 0x8)
#define VPP0_REG_VPPSYS0_CG0_CLR	(VPP0_REG_BASE + 0x28)
#define VPP0_REG_VPPSYS0_CG1_CLR	(VPP0_REG_BASE + 0x34)
#define VPP0_REG_VPPSYS0_CG2_CLR	(VPP0_REG_BASE + 0x40)
#define WPESYS_TOP_REG_WPESYS_RG_000	(WPESYS_TOP_REG_BASE + 0x0)
#define WPE_VPP0_CTL_WPE_DCM_DIS	(WPE_VPP0_BASE + 0x58)
#define WPE_VPP0_CTL_DMA_DCM_DIS	(WPE_VPP0_BASE + 0x5c)
#define WPE_VPP1_CTL_WPE_DCM_DIS	(WPE_VPP1_BASE + 0x58)
#define WPE_VPP1_CTL_DMA_DCM_DIS	(WPE_VPP1_BASE + 0x5c)
#define VPPSYS1_CONFIG_VPPSYS1_CG_0_CLR	(VPPSYS1_CONFIG_BASE + 0x108)
#define VPPSYS1_CONFIG_VPPSYS1_CG_1_CLR	(VPPSYS1_CONFIG_BASE + 0x118)
#define IMGSYS_MAIN_IMG_MAIN_CG_CLR	(IMGSYS_MAIN_BASE + 0x8)
#define IMGSYS1_DIP_TOP_MACRO_CG_CLR	(IMGSYS1_DIP_TOP_BASE + 0x8)
#define IMGSYS1_DIP_NR_MACRO_CG_CLR	(IMGSYS1_DIP_NR_BASE + 0x8)
#define IMGSYS1_WPE_MACRO_CG_CLR	(IMGSYS1_WPE_BASE + 0x8)
#define IPESYS_MACRO_CG			(IPESYS_BASE + 0x0)
#define CAMSYS_MAIN_CAMSYS_CG_CLR	(CAMSYS_MAIN_BASE + 0x8)
#define CAMSYS_RAWA_CAMSYS_CG_CLR	(CAMSYS_RAWA_BASE + 0x8)
#define CAMSYS_YUVA_CAMSYS_CG_CLR	(CAMSYS_YUVA_BASE + 0x8)
#define CAMSYS_RAWB_CAMSYS_CG_CLR	(CAMSYS_RAWB_BASE + 0x8)
#define CAMSYS_YUVB_CAMSYS_CG_CLR	(CAMSYS_YUVB_BASE + 0x8)
#define CAMSYS_MRAW_CAMSYS_CG_CLR	(CAMSYS_MRAW_BASE + 0x8)
#define CCU_MAIN_CCUSYS_CG_CLR		(CCU_MAIN_BASE + 0x8)
#define VDEC_SOC_GCON_VDEC_CKEN		(VDEC_SOC_GCON_BASE + 0x0)
#define VDEC_SOC_GCON_LAT_CKEN		(VDEC_SOC_GCON_BASE + 0x200)
#define VDEC_SOC_GCON_LARB_CKEN_CON	(VDEC_SOC_GCON_BASE + 0x8)
#define VDEC_GCON_VDEC_CKEN		(VDEC_GCON_BASE + 0x0)
#define VDEC_GCON_LAT_CKEN		(VDEC_GCON_BASE + 0x200)
#define VDEC_GCON_LARB_CKEN_CON		(VDEC_GCON_BASE + 0x8)
#define VDEC_CORE1_GCON_VDEC_CKEN	(VDEC_CORE1_GCON_BASE + 0x0)
#define VDEC_CORE1_GCON_LAT_CKEN	(VDEC_CORE1_GCON_BASE + 0x200)
#define VDEC_CORE1_GCON_LARB_CKEN_CON	(VDEC_CORE1_GCON_BASE + 0x8)
#define VENC_GCON_VENCSYS_CG_SET	(VENC_GCON_BASE + 0x4)
#define VENC_CORE1_GCON_VENCSYS_CG_SET	(VENC_CORE1_GCON_BASE + 0x4)
#define VDOSYS0_CONFIG_GLOBAL0_CG_0_CLR	(VDOSYS0_CONFIG_BASE + 0x108)
#define VDOSYS0_CONFIG_GLOBAL0_CG_1_CLR	(VDOSYS0_CONFIG_BASE + 0x118)
#define VDOSYS0_CONFIG_GLOBAL0_CG_2_CLR	(VDOSYS0_CONFIG_BASE + 0x128)
#define VDOSYS0_CONFIG_GLOBAL1_CG_0_CLR	(VDOSYS0_CONFIG_BASE + 0x308)
#define VDOSYS0_CONFIG_GLOBAL1_CG_1_CLR	(VDOSYS0_CONFIG_BASE + 0x318)
#define VDOSYS0_CONFIG_GLOBAL1_CG_2_CLR	(VDOSYS0_CONFIG_BASE + 0x328)
#define VDOSYS1_CONFIG_VDOSYS1_CG_0_CLR	(VDOSYS1_CONFIG_BASE + 0x108)
#define VDOSYS1_CONFIG_VDOSYS1_CG_1_CLR	(VDOSYS1_CONFIG_BASE + 0x128)
#define VDOSYS1_CONFIG_VDOSYS1_CG_2_CLR	(VDOSYS1_CONFIG_BASE + 0x138)
#define VDOSYS1_CONFIG_VDOSYS1_CG_3_CLR	(VDOSYS1_CONFIG_BASE + 0x148)

#define AP_MDSRC_REQ			(SPM_BASE + 0x43C)

/*  CPU Freq Boost*/
enum cpu_opp {
    CPU_OPP0 = 0,
    CPU_OPP1,
    CPU_OPP2,
    CPU_OPP3,
    CPU_OPP4,
    CPU_OPP5,
    CPU_OPP_NUM,
};

/*
 * EXTERN FUNCTIONS
 */
extern unsigned int mt_get_abist_freq(unsigned int ID);
extern unsigned int mt_get_cpu_freq(void);
extern void set_armpll_ll_rate(enum cpu_opp opp);
extern void mt_set_topck_default(void);

#endif
