/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __MAINBOARD_GOOGLE_CORSOLA_GPIO_H__
#define __MAINBOARD_GOOGLE_CORSOLA_GPIO_H__

#include <soc/gpio.h>

#define GPIO_SAR_INT_ODL	GPIO(EINT5)
#define GPIO_BT_WAKE_AP_ODL	GPIO(EINT6)
#define GPIO_WIFI_INT_ODL	GPIO(EINT7)
#define GPIO_DPBRDG_INT_ODL	GPIO(EINT8)
#define GPIO_EC_AP_HPD_OD	GPIO(EINT10)
#define GPIO_TCHPAD_INT_ODL	GPIO(EINT11)
#define GPIO_TCHSCR_INT_1V8_ODL	GPIO(EINT12)
#define GPIO_EC_AP_INT_ODL	GPIO(EINT13)
#define GPIO_EC_IN_RW_ODL	GPIO(EINT14)
#define GPIO_GSC_AP_INT_ODL	GPIO(EINT15)
#define GPIO_AP_WP_ODL		GPIO(EINT16)
#define GPIO_HP_INT_ODL		GPIO(EINT17)
#define GPIO_PEN_EJECT_OD	GPIO(EINT18)
#define GPIO_UCAM_DET_ODL	GPIO(CAM_CLK2)

#define GPIO_RESET		GPIO(PERIPHERAL_EN0)
#define GPIO_XHCI_DONE		GPIO(PERIPHERAL_EN1)
#define GPIO_USB3_HUB_RST_L	GPIO(PERIPHERAL_EN2)
#define GPIO_EN_SPK		GPIO(PERIPHERAL_EN3)
#define GPIO_BEEP_ON		GPIO(PERIPHERAL_EN4)

/* GPIOs for SD card */
#define GPIO_EN_PP3300_SDBRDG_X	GPIO(PERIPHERAL_EN7)

/* GPIOs for display */
#define GPIO_AP_EDP_BKLTEN		GPIO(PERIPHERAL_EN5)
#define GPIO_BL_PWM_1V8			GPIO(DISP_PWM)
#define GPIO_EN_PP3300_DISP_X		GPIO(PERIPHERAL_EN6)
#define GPIO_EDPBRDG_RST_L		GPIO(LCM_RST)
#define GPIO_EN_PP1000_EDPBRDG		GPIO(ANT_SEL0)
#define GPIO_EN_PP1800_EDPBRDG		GPIO(ANT_SEL1)
#define GPIO_EN_PP3300_EDPBRDG		GPIO(ANT_SEL2)
#define GPIO_EDPBRDG_INT_ODL		GPIO(EINT9)
#define GPIO_EDPBRDG_PWREN		GPIO(DSI_TE)

void setup_chromeos_gpios(void);

#endif
