/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public final class Channels {
    public static InputStream newInputStream(ReadableByteChannel readableByteChannel) {
        return null;
    }

    public static OutputStream newOutputStream(WritableByteChannel writableByteChannel) {
        return null;
    }

    public static InputStream newInputStream(AsynchronousByteChannel asynchronousByteChannel) {
        return null;
    }

    public static OutputStream newOutputStream(AsynchronousByteChannel asynchronousByteChannel) {
        return null;
    }

    public static ReadableByteChannel newChannel(InputStream inputStream) {
        return null;
    }

    public static WritableByteChannel newChannel(OutputStream outputStream) {
        return null;
    }

    public static Reader newReader(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n) {
        return null;
    }

    public static Reader newReader(ReadableByteChannel readableByteChannel, String string) {
        return null;
    }

    public static Writer newWriter(WritableByteChannel writableByteChannel, CharsetEncoder charsetEncoder, int n) {
        return null;
    }

    public static Writer newWriter(WritableByteChannel writableByteChannel, String string) {
        return null;
    }

    private static class WritableByteChannelImpl
    extends AbstractInterruptibleChannel
    implements WritableByteChannel {
        private final OutputStream out;
        private static final int TRANSFER_SIZE = 8192;
        private byte[] buf = new byte[0];
        private final Object writeLock = new Object();

        WritableByteChannelImpl(OutputStream out) {
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer src) throws IOException {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            int len = src.remaining();
            Object object = this.writeLock;
            synchronized (object) {
                int totalWritten;
                int bytesToWrite;
                for (totalWritten = 0; totalWritten < len; totalWritten += bytesToWrite) {
                    bytesToWrite = Math.min(len - totalWritten, 8192);
                    if (this.buf.length < bytesToWrite) {
                        this.buf = new byte[bytesToWrite];
                    }
                    src.get(this.buf, 0, bytesToWrite);
                    try {
                        this.begin();
                        this.out.write(this.buf, 0, bytesToWrite);
                        this.end(bytesToWrite > 0);
                    }
                    catch (Throwable throwable) {
                        this.end(bytesToWrite > 0);
                        throw throwable;
                    }
                }
                return totalWritten;
            }
        }

        @Override
        protected void implCloseChannel() throws IOException {
            this.out.close();
        }
    }

    private static class ReadableByteChannelImpl
    extends AbstractInterruptibleChannel
    implements ReadableByteChannel {
        private final InputStream in;
        private static final int TRANSFER_SIZE = 8192;
        private byte[] buf = new byte[0];
        private final Object readLock = new Object();

        ReadableByteChannelImpl(InputStream in) {
            this.in = in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer dst) throws IOException {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (dst.isReadOnly()) {
                throw new IllegalArgumentException();
            }
            int len = dst.remaining();
            int bytesRead = 0;
            Object object = this.readLock;
            synchronized (object) {
                int totalRead;
                for (totalRead = 0; totalRead < len; totalRead += bytesRead) {
                    int bytesToRead = Math.min(len - totalRead, 8192);
                    if (this.buf.length < bytesToRead) {
                        this.buf = new byte[bytesToRead];
                    }
                    if (totalRead > 0 && this.in.available() <= 0) break;
                    try {
                        this.begin();
                        bytesRead = this.in.read(this.buf, 0, bytesToRead);
                        this.end(bytesRead > 0);
                    }
                    catch (Throwable throwable) {
                        this.end(bytesRead > 0);
                        throw throwable;
                    }
                    if (bytesRead < 0) break;
                    dst.put(this.buf, 0, bytesRead);
                }
                if (bytesRead < 0 && totalRead == 0) {
                    return -1;
                }
                return totalRead;
            }
        }

        @Override
        protected void implCloseChannel() throws IOException {
            this.in.close();
        }
    }
}

