/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpStatistics;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.message.MessageResource;
import org.apache.ftpserver.util.DateUtils;

public class FtpReplyTranslator {
    public static final String CLIENT_ACCESS_TIME = "client.access.time";
    public static final String CLIENT_CON_TIME = "client.con.time";
    public static final String CLIENT_DIR = "client.dir";
    public static final String CLIENT_HOME = "client.home";
    public static final String CLIENT_IP = "client.ip";
    public static final String CLIENT_LOGIN_NAME = "client.login.name";
    public static final String CLIENT_LOGIN_TIME = "client.login.time";
    public static final String OUTPUT_CODE = "output.code";
    public static final String OUTPUT_MSG = "output.msg";
    public static final String REQUEST_ARG = "request.arg";
    public static final String REQUEST_CMD = "request.cmd";
    public static final String REQUEST_LINE = "request.line";
    public static final String SERVER_IP = "server.ip";
    public static final String SERVER_PORT = "server.port";
    public static final String STAT_CON_CURR = "stat.con.curr";
    public static final String STAT_CON_TOTAL = "stat.con.total";
    public static final String STAT_DIR_CREATE_COUNT = "stat.dir.create.count";
    public static final String STAT_DIR_DELETE_COUNT = "stat.dir.delete.count";
    public static final String STAT_FILE_DELETE_COUNT = "stat.file.delete.count";
    public static final String STAT_FILE_DOWNLOAD_BYTES = "stat.file.download.bytes";
    public static final String STAT_FILE_DOWNLOAD_COUNT = "stat.file.download.count";
    public static final String STAT_FILE_UPLOAD_BYTES = "stat.file.upload.bytes";
    public static final String STAT_FILE_UPLOAD_COUNT = "stat.file.upload.count";
    public static final String STAT_LOGIN_ANON_CURR = "stat.login.anon.curr";
    public static final String STAT_LOGIN_ANON_TOTAL = "stat.login.anon.total";
    public static final String STAT_LOGIN_CURR = "stat.login.curr";
    public static final String STAT_LOGIN_TOTAL = "stat.login.total";
    public static final String STAT_START_TIME = "stat.start.time";

    private FtpReplyTranslator() {
    }

    public static String translateMessage(FtpIoSession session, FtpRequest request, FtpServerContext context, int code, String subId, String basicMsg) {
        MessageResource resource = context.getMessageResource();
        String lang = session.getLanguage();
        String msg = null;
        if (resource != null) {
            msg = resource.getMessage(code, subId, lang);
        }
        if (msg == null) {
            msg = "";
        }
        msg = FtpReplyTranslator.replaceVariables(session, request, context, code, basicMsg, msg);
        return msg;
    }

    private static String replaceVariables(FtpIoSession session, FtpRequest request, FtpServerContext context, int code, String basicMsg, String str) {
        int startIndex = 0;
        int openIndex = str.indexOf(123, startIndex);
        if (openIndex == -1) {
            return str;
        }
        int closeIndex = str.indexOf(125, startIndex);
        if (closeIndex == -1 || openIndex > closeIndex) {
            return str;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append(str.substring(startIndex, openIndex));
        while (true) {
            String varName = str.substring(openIndex + 1, closeIndex);
            sb.append(FtpReplyTranslator.getVariableValue(session, request, context, code, basicMsg, varName));
            startIndex = closeIndex + 1;
            openIndex = str.indexOf(123, startIndex);
            if (openIndex == -1) {
                sb.append(str.substring(startIndex));
                break;
            }
            closeIndex = str.indexOf(125, startIndex);
            if (closeIndex == -1 || openIndex > closeIndex) {
                sb.append(str.substring(startIndex));
                break;
            }
            sb.append(str.substring(startIndex, openIndex));
        }
        return sb.toString();
    }

    private static String getVariableValue(FtpIoSession session, FtpRequest request, FtpServerContext context, int code, String basicMsg, String varName) {
        String varVal = null;
        if (varName.startsWith("output.")) {
            varVal = FtpReplyTranslator.getOutputVariableValue(session, code, basicMsg, varName);
        } else if (varName.startsWith("server.")) {
            varVal = FtpReplyTranslator.getServerVariableValue(session, varName);
        } else if (varName.startsWith("request.")) {
            varVal = FtpReplyTranslator.getRequestVariableValue(session, request, varName);
        } else if (varName.startsWith("stat.")) {
            varVal = FtpReplyTranslator.getStatisticalVariableValue(session, context, varName);
        } else if (varName.startsWith("client.")) {
            varVal = FtpReplyTranslator.getClientVariableValue(session, varName);
        }
        if (varVal == null) {
            varVal = "";
        }
        return varVal;
    }

    private static String getClientVariableValue(FtpIoSession session, String varName) {
        switch (varName) {
            case "client.ip": {
                if (session.getRemoteAddress() instanceof InetSocketAddress) {
                    InetSocketAddress remoteSocketAddress = (InetSocketAddress)session.getRemoteAddress();
                    return remoteSocketAddress.getAddress().getHostAddress();
                }
                return null;
            }
            case "client.con.time": {
                return DateUtils.getISO8601Date(session.getCreationTime());
            }
            case "client.login.name": {
                return session.getUser().getName();
            }
            case "client.login.time": {
                return DateUtils.getISO8601Date(session.getLoginTime().getTime());
            }
            case "client.access.time": {
                return DateUtils.getISO8601Date(session.getLastAccessTime().getTime());
            }
            case "client.home": {
                return session.getUser().getHomeDirectory();
            }
            case "client.dir": {
                FileSystemView fsView = session.getFileSystemView();
                if (fsView == null) break;
                try {
                    return fsView.getWorkingDirectory().getAbsolutePath();
                }
                catch (Exception ex) {
                    return "";
                }
            }
        }
        return null;
    }

    private static String getOutputVariableValue(FtpIoSession session, int code, String basicMsg, String varName) {
        switch (varName) {
            case "output.code": {
                return String.valueOf(code);
            }
            case "output.msg": {
                return basicMsg;
            }
        }
        return null;
    }

    private static String getRequestVariableValue(FtpIoSession session, FtpRequest request, String varName) {
        if (request == null) {
            return "";
        }
        switch (varName) {
            case "request.line": {
                return request.getRequestLine();
            }
            case "request.cmd": {
                return request.getCommand();
            }
            case "request.arg": {
                return request.getArgument();
            }
        }
        return null;
    }

    private static String getServerVariableValue(FtpIoSession session, String varName) {
        SocketAddress localSocketAddress = session.getLocalAddress();
        if (localSocketAddress instanceof InetSocketAddress) {
            InetSocketAddress localInetSocketAddress = (InetSocketAddress)localSocketAddress;
            switch (varName) {
                case "server.ip": {
                    InetAddress addr = localInetSocketAddress.getAddress();
                    if (addr != null) {
                        return addr.getHostAddress();
                    }
                    return null;
                }
                case "server.port": {
                    return String.valueOf(localInetSocketAddress.getPort());
                }
            }
            return null;
        }
        return null;
    }

    private static String getStatisticalConnectionVariableValue(FtpIoSession session, FtpServerContext context, String varName) {
        FtpStatistics stat = context.getFtpStatistics();
        switch (varName) {
            case "stat.con.total": {
                return String.valueOf(stat.getTotalConnectionNumber());
            }
            case "stat.con.curr": {
                return String.valueOf(stat.getCurrentConnectionNumber());
            }
        }
        return null;
    }

    private static String getStatisticalDirectoryVariableValue(FtpIoSession session, FtpServerContext context, String varName) {
        FtpStatistics stat = context.getFtpStatistics();
        switch (varName) {
            case "stat.dir.create.count": {
                return String.valueOf(stat.getTotalDirectoryCreated());
            }
            case "stat.dir.delete.count": {
                return String.valueOf(stat.getTotalDirectoryRemoved());
            }
        }
        return null;
    }

    private static String getStatisticalFileVariableValue(FtpIoSession session, FtpServerContext context, String varName) {
        FtpStatistics stat = context.getFtpStatistics();
        switch (varName) {
            case "stat.file.upload.count": {
                return String.valueOf(stat.getTotalUploadNumber());
            }
            case "stat.file.upload.bytes": {
                return String.valueOf(stat.getTotalUploadSize());
            }
            case "stat.file.download.count": {
                return String.valueOf(stat.getTotalDownloadNumber());
            }
            case "stat.file.download.bytes": {
                return String.valueOf(stat.getTotalDownloadSize());
            }
            case "stat.file.delete.count": {
                return String.valueOf(stat.getTotalDeleteNumber());
            }
        }
        return null;
    }

    private static String getStatisticalLoginVariableValue(FtpIoSession session, FtpServerContext context, String varName) {
        FtpStatistics stat = context.getFtpStatistics();
        switch (varName) {
            case "stat.login.total": {
                return String.valueOf(stat.getTotalLoginNumber());
            }
            case "stat.login.curr": {
                return String.valueOf(stat.getCurrentLoginNumber());
            }
            case "stat.login.anon.total": {
                return String.valueOf(stat.getTotalAnonymousLoginNumber());
            }
            case "stat.login.anon.curr": {
                return String.valueOf(stat.getCurrentAnonymousLoginNumber());
            }
        }
        return null;
    }

    private static String getStatisticalVariableValue(FtpIoSession session, FtpServerContext context, String varName) {
        FtpStatistics stat = context.getFtpStatistics();
        String varVal = null;
        if (varName.equals(STAT_START_TIME)) {
            varVal = DateUtils.getISO8601Date(stat.getStartTime().getTime());
        } else if (varName.startsWith("stat.con")) {
            varVal = FtpReplyTranslator.getStatisticalConnectionVariableValue(session, context, varName);
        } else if (varName.startsWith("stat.login.")) {
            varVal = FtpReplyTranslator.getStatisticalLoginVariableValue(session, context, varName);
        } else if (varName.startsWith("stat.file")) {
            varVal = FtpReplyTranslator.getStatisticalFileVariableValue(session, context, varName);
        } else if (varName.startsWith("stat.dir.")) {
            varVal = FtpReplyTranslator.getStatisticalDirectoryVariableValue(session, context, varName);
        }
        return varVal;
    }
}

