/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// VerifyJWTWithClassicKey struct for VerifyJWTWithClassicKey
type VerifyJWTWithClassicKey struct {
	// The name of the key to use in the verify JWT process
	DisplayId string `json:"display-id"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// JWT
	Jwt string `json:"jwt"`
	// RequiredClaims
	RequiredClaims string `json:"required-claims"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// classic key version
	Version int32 `json:"version"`
}

// NewVerifyJWTWithClassicKey instantiates a new VerifyJWTWithClassicKey object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewVerifyJWTWithClassicKey(displayId string, jwt string, requiredClaims string, version int32, ) *VerifyJWTWithClassicKey {
	this := VerifyJWTWithClassicKey{}
	this.DisplayId = displayId
	var json bool = false
	this.Json = &json
	this.Jwt = jwt
	this.RequiredClaims = requiredClaims
	this.Version = version
	return &this
}

// NewVerifyJWTWithClassicKeyWithDefaults instantiates a new VerifyJWTWithClassicKey object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewVerifyJWTWithClassicKeyWithDefaults() *VerifyJWTWithClassicKey {
	this := VerifyJWTWithClassicKey{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetDisplayId returns the DisplayId field value
func (o *VerifyJWTWithClassicKey) GetDisplayId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.DisplayId
}

// GetDisplayIdOk returns a tuple with the DisplayId field value
// and a boolean to check if the value has been set.
func (o *VerifyJWTWithClassicKey) GetDisplayIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.DisplayId, true
}

// SetDisplayId sets field value
func (o *VerifyJWTWithClassicKey) SetDisplayId(v string) {
	o.DisplayId = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *VerifyJWTWithClassicKey) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VerifyJWTWithClassicKey) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *VerifyJWTWithClassicKey) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *VerifyJWTWithClassicKey) SetJson(v bool) {
	o.Json = &v
}

// GetJwt returns the Jwt field value
func (o *VerifyJWTWithClassicKey) GetJwt() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Jwt
}

// GetJwtOk returns a tuple with the Jwt field value
// and a boolean to check if the value has been set.
func (o *VerifyJWTWithClassicKey) GetJwtOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Jwt, true
}

// SetJwt sets field value
func (o *VerifyJWTWithClassicKey) SetJwt(v string) {
	o.Jwt = v
}

// GetRequiredClaims returns the RequiredClaims field value
func (o *VerifyJWTWithClassicKey) GetRequiredClaims() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.RequiredClaims
}

// GetRequiredClaimsOk returns a tuple with the RequiredClaims field value
// and a boolean to check if the value has been set.
func (o *VerifyJWTWithClassicKey) GetRequiredClaimsOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.RequiredClaims, true
}

// SetRequiredClaims sets field value
func (o *VerifyJWTWithClassicKey) SetRequiredClaims(v string) {
	o.RequiredClaims = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *VerifyJWTWithClassicKey) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VerifyJWTWithClassicKey) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *VerifyJWTWithClassicKey) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *VerifyJWTWithClassicKey) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *VerifyJWTWithClassicKey) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VerifyJWTWithClassicKey) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *VerifyJWTWithClassicKey) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *VerifyJWTWithClassicKey) SetUidToken(v string) {
	o.UidToken = &v
}

// GetVersion returns the Version field value
func (o *VerifyJWTWithClassicKey) GetVersion() int32 {
	if o == nil  {
		var ret int32
		return ret
	}

	return o.Version
}

// GetVersionOk returns a tuple with the Version field value
// and a boolean to check if the value has been set.
func (o *VerifyJWTWithClassicKey) GetVersionOk() (*int32, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Version, true
}

// SetVersion sets field value
func (o *VerifyJWTWithClassicKey) SetVersion(v int32) {
	o.Version = v
}

func (o VerifyJWTWithClassicKey) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["display-id"] = o.DisplayId
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["jwt"] = o.Jwt
	}
	if true {
		toSerialize["required-claims"] = o.RequiredClaims
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if true {
		toSerialize["version"] = o.Version
	}
	return json.Marshal(toSerialize)
}

type NullableVerifyJWTWithClassicKey struct {
	value *VerifyJWTWithClassicKey
	isSet bool
}

func (v NullableVerifyJWTWithClassicKey) Get() *VerifyJWTWithClassicKey {
	return v.value
}

func (v *NullableVerifyJWTWithClassicKey) Set(val *VerifyJWTWithClassicKey) {
	v.value = val
	v.isSet = true
}

func (v NullableVerifyJWTWithClassicKey) IsSet() bool {
	return v.isSet
}

func (v *NullableVerifyJWTWithClassicKey) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableVerifyJWTWithClassicKey(val *VerifyJWTWithClassicKey) *NullableVerifyJWTWithClassicKey {
	return &NullableVerifyJWTWithClassicKey{value: val, isSet: true}
}

func (v NullableVerifyJWTWithClassicKey) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableVerifyJWTWithClassicKey) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


