/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// UscGet uscGet is a command that gets the value and internal details of a secret from a Universal Secrets Connector
type UscGet struct {
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The namespace (relevant for Hashi vault target)
	Namespace *string `json:"namespace,omitempty"`
	// The secret id (or name, for AWS, Azure, K8s or Hashi vault targets) to get from the Universal Secrets Connector
	SecretId string `json:"secret-id"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Name of the Universal Secrets Connector item
	UscName string `json:"usc-name"`
	// The version id (if not specified, will retrieve the last version)
	VersionId *string `json:"version-id,omitempty"`
}

// NewUscGet instantiates a new UscGet object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUscGet(secretId string, uscName string, ) *UscGet {
	this := UscGet{}
	var json bool = false
	this.Json = &json
	this.SecretId = secretId
	this.UscName = uscName
	return &this
}

// NewUscGetWithDefaults instantiates a new UscGet object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUscGetWithDefaults() *UscGet {
	this := UscGet{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *UscGet) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UscGet) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *UscGet) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *UscGet) SetJson(v bool) {
	o.Json = &v
}

// GetNamespace returns the Namespace field value if set, zero value otherwise.
func (o *UscGet) GetNamespace() string {
	if o == nil || o.Namespace == nil {
		var ret string
		return ret
	}
	return *o.Namespace
}

// GetNamespaceOk returns a tuple with the Namespace field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UscGet) GetNamespaceOk() (*string, bool) {
	if o == nil || o.Namespace == nil {
		return nil, false
	}
	return o.Namespace, true
}

// HasNamespace returns a boolean if a field has been set.
func (o *UscGet) HasNamespace() bool {
	if o != nil && o.Namespace != nil {
		return true
	}

	return false
}

// SetNamespace gets a reference to the given string and assigns it to the Namespace field.
func (o *UscGet) SetNamespace(v string) {
	o.Namespace = &v
}

// GetSecretId returns the SecretId field value
func (o *UscGet) GetSecretId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.SecretId
}

// GetSecretIdOk returns a tuple with the SecretId field value
// and a boolean to check if the value has been set.
func (o *UscGet) GetSecretIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.SecretId, true
}

// SetSecretId sets field value
func (o *UscGet) SetSecretId(v string) {
	o.SecretId = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *UscGet) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UscGet) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *UscGet) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *UscGet) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *UscGet) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UscGet) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *UscGet) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *UscGet) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUscName returns the UscName field value
func (o *UscGet) GetUscName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.UscName
}

// GetUscNameOk returns a tuple with the UscName field value
// and a boolean to check if the value has been set.
func (o *UscGet) GetUscNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.UscName, true
}

// SetUscName sets field value
func (o *UscGet) SetUscName(v string) {
	o.UscName = v
}

// GetVersionId returns the VersionId field value if set, zero value otherwise.
func (o *UscGet) GetVersionId() string {
	if o == nil || o.VersionId == nil {
		var ret string
		return ret
	}
	return *o.VersionId
}

// GetVersionIdOk returns a tuple with the VersionId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UscGet) GetVersionIdOk() (*string, bool) {
	if o == nil || o.VersionId == nil {
		return nil, false
	}
	return o.VersionId, true
}

// HasVersionId returns a boolean if a field has been set.
func (o *UscGet) HasVersionId() bool {
	if o != nil && o.VersionId != nil {
		return true
	}

	return false
}

// SetVersionId gets a reference to the given string and assigns it to the VersionId field.
func (o *UscGet) SetVersionId(v string) {
	o.VersionId = &v
}

func (o UscGet) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Namespace != nil {
		toSerialize["namespace"] = o.Namespace
	}
	if true {
		toSerialize["secret-id"] = o.SecretId
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if true {
		toSerialize["usc-name"] = o.UscName
	}
	if o.VersionId != nil {
		toSerialize["version-id"] = o.VersionId
	}
	return json.Marshal(toSerialize)
}

type NullableUscGet struct {
	value *UscGet
	isSet bool
}

func (v NullableUscGet) Get() *UscGet {
	return v.value
}

func (v *NullableUscGet) Set(val *UscGet) {
	v.value = val
	v.isSet = true
}

func (v NullableUscGet) IsSet() bool {
	return v.isSet
}

func (v *NullableUscGet) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUscGet(val *UscGet) *NullableUscGet {
	return &NullableUscGet{value: val, isSet: true}
}

func (v NullableUscGet) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUscGet) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


