/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// UpdateOutput struct for UpdateOutput
type UpdateOutput struct {
	Changelog *string `json:"changelog,omitempty"`
	Latest *string `json:"latest,omitempty"`
	Updated *bool `json:"updated,omitempty"`
}

// NewUpdateOutput instantiates a new UpdateOutput object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpdateOutput() *UpdateOutput {
	this := UpdateOutput{}
	return &this
}

// NewUpdateOutputWithDefaults instantiates a new UpdateOutput object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpdateOutputWithDefaults() *UpdateOutput {
	this := UpdateOutput{}
	return &this
}

// GetChangelog returns the Changelog field value if set, zero value otherwise.
func (o *UpdateOutput) GetChangelog() string {
	if o == nil || o.Changelog == nil {
		var ret string
		return ret
	}
	return *o.Changelog
}

// GetChangelogOk returns a tuple with the Changelog field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateOutput) GetChangelogOk() (*string, bool) {
	if o == nil || o.Changelog == nil {
		return nil, false
	}
	return o.Changelog, true
}

// HasChangelog returns a boolean if a field has been set.
func (o *UpdateOutput) HasChangelog() bool {
	if o != nil && o.Changelog != nil {
		return true
	}

	return false
}

// SetChangelog gets a reference to the given string and assigns it to the Changelog field.
func (o *UpdateOutput) SetChangelog(v string) {
	o.Changelog = &v
}

// GetLatest returns the Latest field value if set, zero value otherwise.
func (o *UpdateOutput) GetLatest() string {
	if o == nil || o.Latest == nil {
		var ret string
		return ret
	}
	return *o.Latest
}

// GetLatestOk returns a tuple with the Latest field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateOutput) GetLatestOk() (*string, bool) {
	if o == nil || o.Latest == nil {
		return nil, false
	}
	return o.Latest, true
}

// HasLatest returns a boolean if a field has been set.
func (o *UpdateOutput) HasLatest() bool {
	if o != nil && o.Latest != nil {
		return true
	}

	return false
}

// SetLatest gets a reference to the given string and assigns it to the Latest field.
func (o *UpdateOutput) SetLatest(v string) {
	o.Latest = &v
}

// GetUpdated returns the Updated field value if set, zero value otherwise.
func (o *UpdateOutput) GetUpdated() bool {
	if o == nil || o.Updated == nil {
		var ret bool
		return ret
	}
	return *o.Updated
}

// GetUpdatedOk returns a tuple with the Updated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateOutput) GetUpdatedOk() (*bool, bool) {
	if o == nil || o.Updated == nil {
		return nil, false
	}
	return o.Updated, true
}

// HasUpdated returns a boolean if a field has been set.
func (o *UpdateOutput) HasUpdated() bool {
	if o != nil && o.Updated != nil {
		return true
	}

	return false
}

// SetUpdated gets a reference to the given bool and assigns it to the Updated field.
func (o *UpdateOutput) SetUpdated(v bool) {
	o.Updated = &v
}

func (o UpdateOutput) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Changelog != nil {
		toSerialize["changelog"] = o.Changelog
	}
	if o.Latest != nil {
		toSerialize["latest"] = o.Latest
	}
	if o.Updated != nil {
		toSerialize["updated"] = o.Updated
	}
	return json.Marshal(toSerialize)
}

type NullableUpdateOutput struct {
	value *UpdateOutput
	isSet bool
}

func (v NullableUpdateOutput) Get() *UpdateOutput {
	return v.value
}

func (v *NullableUpdateOutput) Set(val *UpdateOutput) {
	v.value = val
	v.isSet = true
}

func (v NullableUpdateOutput) IsSet() bool {
	return v.isSet
}

func (v *NullableUpdateOutput) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpdateOutput(val *UpdateOutput) *NullableUpdateOutput {
	return &NullableUpdateOutput{value: val, isSet: true}
}

func (v NullableUpdateOutput) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpdateOutput) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


