/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
	"time"
)

// SecretInfo struct for SecretInfo
type SecretInfo struct {
	Created *time.Time `json:"created,omitempty"`
	Description *string `json:"description,omitempty"`
	Expiration *time.Time `json:"expiration,omitempty"`
	LastRetrieved *time.Time `json:"last_retrieved,omitempty"`
	Location *map[string]interface{} `json:"location,omitempty"`
	Name *string `json:"name,omitempty"`
	SecretId *string `json:"secret_id,omitempty"`
	Status *bool `json:"status,omitempty"`
	Tags *map[string]string `json:"tags,omitempty"`
	Type *string `json:"type,omitempty"`
	Version *int64 `json:"version,omitempty"`
}

// NewSecretInfo instantiates a new SecretInfo object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSecretInfo() *SecretInfo {
	this := SecretInfo{}
	return &this
}

// NewSecretInfoWithDefaults instantiates a new SecretInfo object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSecretInfoWithDefaults() *SecretInfo {
	this := SecretInfo{}
	return &this
}

// GetCreated returns the Created field value if set, zero value otherwise.
func (o *SecretInfo) GetCreated() time.Time {
	if o == nil || o.Created == nil {
		var ret time.Time
		return ret
	}
	return *o.Created
}

// GetCreatedOk returns a tuple with the Created field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SecretInfo) GetCreatedOk() (*time.Time, bool) {
	if o == nil || o.Created == nil {
		return nil, false
	}
	return o.Created, true
}

// HasCreated returns a boolean if a field has been set.
func (o *SecretInfo) HasCreated() bool {
	if o != nil && o.Created != nil {
		return true
	}

	return false
}

// SetCreated gets a reference to the given time.Time and assigns it to the Created field.
func (o *SecretInfo) SetCreated(v time.Time) {
	o.Created = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *SecretInfo) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SecretInfo) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *SecretInfo) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *SecretInfo) SetDescription(v string) {
	o.Description = &v
}

// GetExpiration returns the Expiration field value if set, zero value otherwise.
func (o *SecretInfo) GetExpiration() time.Time {
	if o == nil || o.Expiration == nil {
		var ret time.Time
		return ret
	}
	return *o.Expiration
}

// GetExpirationOk returns a tuple with the Expiration field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SecretInfo) GetExpirationOk() (*time.Time, bool) {
	if o == nil || o.Expiration == nil {
		return nil, false
	}
	return o.Expiration, true
}

// HasExpiration returns a boolean if a field has been set.
func (o *SecretInfo) HasExpiration() bool {
	if o != nil && o.Expiration != nil {
		return true
	}

	return false
}

// SetExpiration gets a reference to the given time.Time and assigns it to the Expiration field.
func (o *SecretInfo) SetExpiration(v time.Time) {
	o.Expiration = &v
}

// GetLastRetrieved returns the LastRetrieved field value if set, zero value otherwise.
func (o *SecretInfo) GetLastRetrieved() time.Time {
	if o == nil || o.LastRetrieved == nil {
		var ret time.Time
		return ret
	}
	return *o.LastRetrieved
}

// GetLastRetrievedOk returns a tuple with the LastRetrieved field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SecretInfo) GetLastRetrievedOk() (*time.Time, bool) {
	if o == nil || o.LastRetrieved == nil {
		return nil, false
	}
	return o.LastRetrieved, true
}

// HasLastRetrieved returns a boolean if a field has been set.
func (o *SecretInfo) HasLastRetrieved() bool {
	if o != nil && o.LastRetrieved != nil {
		return true
	}

	return false
}

// SetLastRetrieved gets a reference to the given time.Time and assigns it to the LastRetrieved field.
func (o *SecretInfo) SetLastRetrieved(v time.Time) {
	o.LastRetrieved = &v
}

// GetLocation returns the Location field value if set, zero value otherwise.
func (o *SecretInfo) GetLocation() map[string]interface{} {
	if o == nil || o.Location == nil {
		var ret map[string]interface{}
		return ret
	}
	return *o.Location
}

// GetLocationOk returns a tuple with the Location field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SecretInfo) GetLocationOk() (*map[string]interface{}, bool) {
	if o == nil || o.Location == nil {
		return nil, false
	}
	return o.Location, true
}

// HasLocation returns a boolean if a field has been set.
func (o *SecretInfo) HasLocation() bool {
	if o != nil && o.Location != nil {
		return true
	}

	return false
}

// SetLocation gets a reference to the given map[string]interface{} and assigns it to the Location field.
func (o *SecretInfo) SetLocation(v map[string]interface{}) {
	o.Location = &v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *SecretInfo) GetName() string {
	if o == nil || o.Name == nil {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SecretInfo) GetNameOk() (*string, bool) {
	if o == nil || o.Name == nil {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *SecretInfo) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *SecretInfo) SetName(v string) {
	o.Name = &v
}

// GetSecretId returns the SecretId field value if set, zero value otherwise.
func (o *SecretInfo) GetSecretId() string {
	if o == nil || o.SecretId == nil {
		var ret string
		return ret
	}
	return *o.SecretId
}

// GetSecretIdOk returns a tuple with the SecretId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SecretInfo) GetSecretIdOk() (*string, bool) {
	if o == nil || o.SecretId == nil {
		return nil, false
	}
	return o.SecretId, true
}

// HasSecretId returns a boolean if a field has been set.
func (o *SecretInfo) HasSecretId() bool {
	if o != nil && o.SecretId != nil {
		return true
	}

	return false
}

// SetSecretId gets a reference to the given string and assigns it to the SecretId field.
func (o *SecretInfo) SetSecretId(v string) {
	o.SecretId = &v
}

// GetStatus returns the Status field value if set, zero value otherwise.
func (o *SecretInfo) GetStatus() bool {
	if o == nil || o.Status == nil {
		var ret bool
		return ret
	}
	return *o.Status
}

// GetStatusOk returns a tuple with the Status field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SecretInfo) GetStatusOk() (*bool, bool) {
	if o == nil || o.Status == nil {
		return nil, false
	}
	return o.Status, true
}

// HasStatus returns a boolean if a field has been set.
func (o *SecretInfo) HasStatus() bool {
	if o != nil && o.Status != nil {
		return true
	}

	return false
}

// SetStatus gets a reference to the given bool and assigns it to the Status field.
func (o *SecretInfo) SetStatus(v bool) {
	o.Status = &v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *SecretInfo) GetTags() map[string]string {
	if o == nil || o.Tags == nil {
		var ret map[string]string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SecretInfo) GetTagsOk() (*map[string]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *SecretInfo) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given map[string]string and assigns it to the Tags field.
func (o *SecretInfo) SetTags(v map[string]string) {
	o.Tags = &v
}

// GetType returns the Type field value if set, zero value otherwise.
func (o *SecretInfo) GetType() string {
	if o == nil || o.Type == nil {
		var ret string
		return ret
	}
	return *o.Type
}

// GetTypeOk returns a tuple with the Type field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SecretInfo) GetTypeOk() (*string, bool) {
	if o == nil || o.Type == nil {
		return nil, false
	}
	return o.Type, true
}

// HasType returns a boolean if a field has been set.
func (o *SecretInfo) HasType() bool {
	if o != nil && o.Type != nil {
		return true
	}

	return false
}

// SetType gets a reference to the given string and assigns it to the Type field.
func (o *SecretInfo) SetType(v string) {
	o.Type = &v
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *SecretInfo) GetVersion() int64 {
	if o == nil || o.Version == nil {
		var ret int64
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SecretInfo) GetVersionOk() (*int64, bool) {
	if o == nil || o.Version == nil {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *SecretInfo) HasVersion() bool {
	if o != nil && o.Version != nil {
		return true
	}

	return false
}

// SetVersion gets a reference to the given int64 and assigns it to the Version field.
func (o *SecretInfo) SetVersion(v int64) {
	o.Version = &v
}

func (o SecretInfo) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Created != nil {
		toSerialize["created"] = o.Created
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Expiration != nil {
		toSerialize["expiration"] = o.Expiration
	}
	if o.LastRetrieved != nil {
		toSerialize["last_retrieved"] = o.LastRetrieved
	}
	if o.Location != nil {
		toSerialize["location"] = o.Location
	}
	if o.Name != nil {
		toSerialize["name"] = o.Name
	}
	if o.SecretId != nil {
		toSerialize["secret_id"] = o.SecretId
	}
	if o.Status != nil {
		toSerialize["status"] = o.Status
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.Type != nil {
		toSerialize["type"] = o.Type
	}
	if o.Version != nil {
		toSerialize["version"] = o.Version
	}
	return json.Marshal(toSerialize)
}

type NullableSecretInfo struct {
	value *SecretInfo
	isSet bool
}

func (v NullableSecretInfo) Get() *SecretInfo {
	return v.value
}

func (v *NullableSecretInfo) Set(val *SecretInfo) {
	v.value = val
	v.isSet = true
}

func (v NullableSecretInfo) IsSet() bool {
	return v.isSet
}

func (v *NullableSecretInfo) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSecretInfo(val *SecretInfo) *NullableSecretInfo {
	return &NullableSecretInfo{value: val, isSet: true}
}

func (v NullableSecretInfo) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSecretInfo) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


