/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// RoleAuthMethodAssociation RoleAuthMethodAssociation includes details of an association between a role and an auth method.
type RoleAuthMethodAssociation struct {
	AssocId *string `json:"assoc_id,omitempty"`
	AuthMethodAccessId *string `json:"auth_method_access_id,omitempty"`
	AuthMethodName *string `json:"auth_method_name,omitempty"`
	AuthMethodSubClaims *map[string][]string `json:"auth_method_sub_claims,omitempty"`
	IsSubclaimsWithOperator *bool `json:"is_subclaims_with_operator,omitempty"`
	SubClaimsCaseSensitive *bool `json:"sub_claims_case_sensitive,omitempty"`
}

// NewRoleAuthMethodAssociation instantiates a new RoleAuthMethodAssociation object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRoleAuthMethodAssociation() *RoleAuthMethodAssociation {
	this := RoleAuthMethodAssociation{}
	return &this
}

// NewRoleAuthMethodAssociationWithDefaults instantiates a new RoleAuthMethodAssociation object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRoleAuthMethodAssociationWithDefaults() *RoleAuthMethodAssociation {
	this := RoleAuthMethodAssociation{}
	return &this
}

// GetAssocId returns the AssocId field value if set, zero value otherwise.
func (o *RoleAuthMethodAssociation) GetAssocId() string {
	if o == nil || o.AssocId == nil {
		var ret string
		return ret
	}
	return *o.AssocId
}

// GetAssocIdOk returns a tuple with the AssocId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RoleAuthMethodAssociation) GetAssocIdOk() (*string, bool) {
	if o == nil || o.AssocId == nil {
		return nil, false
	}
	return o.AssocId, true
}

// HasAssocId returns a boolean if a field has been set.
func (o *RoleAuthMethodAssociation) HasAssocId() bool {
	if o != nil && o.AssocId != nil {
		return true
	}

	return false
}

// SetAssocId gets a reference to the given string and assigns it to the AssocId field.
func (o *RoleAuthMethodAssociation) SetAssocId(v string) {
	o.AssocId = &v
}

// GetAuthMethodAccessId returns the AuthMethodAccessId field value if set, zero value otherwise.
func (o *RoleAuthMethodAssociation) GetAuthMethodAccessId() string {
	if o == nil || o.AuthMethodAccessId == nil {
		var ret string
		return ret
	}
	return *o.AuthMethodAccessId
}

// GetAuthMethodAccessIdOk returns a tuple with the AuthMethodAccessId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RoleAuthMethodAssociation) GetAuthMethodAccessIdOk() (*string, bool) {
	if o == nil || o.AuthMethodAccessId == nil {
		return nil, false
	}
	return o.AuthMethodAccessId, true
}

// HasAuthMethodAccessId returns a boolean if a field has been set.
func (o *RoleAuthMethodAssociation) HasAuthMethodAccessId() bool {
	if o != nil && o.AuthMethodAccessId != nil {
		return true
	}

	return false
}

// SetAuthMethodAccessId gets a reference to the given string and assigns it to the AuthMethodAccessId field.
func (o *RoleAuthMethodAssociation) SetAuthMethodAccessId(v string) {
	o.AuthMethodAccessId = &v
}

// GetAuthMethodName returns the AuthMethodName field value if set, zero value otherwise.
func (o *RoleAuthMethodAssociation) GetAuthMethodName() string {
	if o == nil || o.AuthMethodName == nil {
		var ret string
		return ret
	}
	return *o.AuthMethodName
}

// GetAuthMethodNameOk returns a tuple with the AuthMethodName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RoleAuthMethodAssociation) GetAuthMethodNameOk() (*string, bool) {
	if o == nil || o.AuthMethodName == nil {
		return nil, false
	}
	return o.AuthMethodName, true
}

// HasAuthMethodName returns a boolean if a field has been set.
func (o *RoleAuthMethodAssociation) HasAuthMethodName() bool {
	if o != nil && o.AuthMethodName != nil {
		return true
	}

	return false
}

// SetAuthMethodName gets a reference to the given string and assigns it to the AuthMethodName field.
func (o *RoleAuthMethodAssociation) SetAuthMethodName(v string) {
	o.AuthMethodName = &v
}

// GetAuthMethodSubClaims returns the AuthMethodSubClaims field value if set, zero value otherwise.
func (o *RoleAuthMethodAssociation) GetAuthMethodSubClaims() map[string][]string {
	if o == nil || o.AuthMethodSubClaims == nil {
		var ret map[string][]string
		return ret
	}
	return *o.AuthMethodSubClaims
}

// GetAuthMethodSubClaimsOk returns a tuple with the AuthMethodSubClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RoleAuthMethodAssociation) GetAuthMethodSubClaimsOk() (*map[string][]string, bool) {
	if o == nil || o.AuthMethodSubClaims == nil {
		return nil, false
	}
	return o.AuthMethodSubClaims, true
}

// HasAuthMethodSubClaims returns a boolean if a field has been set.
func (o *RoleAuthMethodAssociation) HasAuthMethodSubClaims() bool {
	if o != nil && o.AuthMethodSubClaims != nil {
		return true
	}

	return false
}

// SetAuthMethodSubClaims gets a reference to the given map[string][]string and assigns it to the AuthMethodSubClaims field.
func (o *RoleAuthMethodAssociation) SetAuthMethodSubClaims(v map[string][]string) {
	o.AuthMethodSubClaims = &v
}

// GetIsSubclaimsWithOperator returns the IsSubclaimsWithOperator field value if set, zero value otherwise.
func (o *RoleAuthMethodAssociation) GetIsSubclaimsWithOperator() bool {
	if o == nil || o.IsSubclaimsWithOperator == nil {
		var ret bool
		return ret
	}
	return *o.IsSubclaimsWithOperator
}

// GetIsSubclaimsWithOperatorOk returns a tuple with the IsSubclaimsWithOperator field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RoleAuthMethodAssociation) GetIsSubclaimsWithOperatorOk() (*bool, bool) {
	if o == nil || o.IsSubclaimsWithOperator == nil {
		return nil, false
	}
	return o.IsSubclaimsWithOperator, true
}

// HasIsSubclaimsWithOperator returns a boolean if a field has been set.
func (o *RoleAuthMethodAssociation) HasIsSubclaimsWithOperator() bool {
	if o != nil && o.IsSubclaimsWithOperator != nil {
		return true
	}

	return false
}

// SetIsSubclaimsWithOperator gets a reference to the given bool and assigns it to the IsSubclaimsWithOperator field.
func (o *RoleAuthMethodAssociation) SetIsSubclaimsWithOperator(v bool) {
	o.IsSubclaimsWithOperator = &v
}

// GetSubClaimsCaseSensitive returns the SubClaimsCaseSensitive field value if set, zero value otherwise.
func (o *RoleAuthMethodAssociation) GetSubClaimsCaseSensitive() bool {
	if o == nil || o.SubClaimsCaseSensitive == nil {
		var ret bool
		return ret
	}
	return *o.SubClaimsCaseSensitive
}

// GetSubClaimsCaseSensitiveOk returns a tuple with the SubClaimsCaseSensitive field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RoleAuthMethodAssociation) GetSubClaimsCaseSensitiveOk() (*bool, bool) {
	if o == nil || o.SubClaimsCaseSensitive == nil {
		return nil, false
	}
	return o.SubClaimsCaseSensitive, true
}

// HasSubClaimsCaseSensitive returns a boolean if a field has been set.
func (o *RoleAuthMethodAssociation) HasSubClaimsCaseSensitive() bool {
	if o != nil && o.SubClaimsCaseSensitive != nil {
		return true
	}

	return false
}

// SetSubClaimsCaseSensitive gets a reference to the given bool and assigns it to the SubClaimsCaseSensitive field.
func (o *RoleAuthMethodAssociation) SetSubClaimsCaseSensitive(v bool) {
	o.SubClaimsCaseSensitive = &v
}

func (o RoleAuthMethodAssociation) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AssocId != nil {
		toSerialize["assoc_id"] = o.AssocId
	}
	if o.AuthMethodAccessId != nil {
		toSerialize["auth_method_access_id"] = o.AuthMethodAccessId
	}
	if o.AuthMethodName != nil {
		toSerialize["auth_method_name"] = o.AuthMethodName
	}
	if o.AuthMethodSubClaims != nil {
		toSerialize["auth_method_sub_claims"] = o.AuthMethodSubClaims
	}
	if o.IsSubclaimsWithOperator != nil {
		toSerialize["is_subclaims_with_operator"] = o.IsSubclaimsWithOperator
	}
	if o.SubClaimsCaseSensitive != nil {
		toSerialize["sub_claims_case_sensitive"] = o.SubClaimsCaseSensitive
	}
	return json.Marshal(toSerialize)
}

type NullableRoleAuthMethodAssociation struct {
	value *RoleAuthMethodAssociation
	isSet bool
}

func (v NullableRoleAuthMethodAssociation) Get() *RoleAuthMethodAssociation {
	return v.value
}

func (v *NullableRoleAuthMethodAssociation) Set(val *RoleAuthMethodAssociation) {
	v.value = val
	v.isSet = true
}

func (v NullableRoleAuthMethodAssociation) IsSet() bool {
	return v.isSet
}

func (v *NullableRoleAuthMethodAssociation) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRoleAuthMethodAssociation(val *RoleAuthMethodAssociation) *NullableRoleAuthMethodAssociation {
	return &NullableRoleAuthMethodAssociation{value: val, isSet: true}
}

func (v NullableRoleAuthMethodAssociation) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRoleAuthMethodAssociation) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


