/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// ListSRASessions listSRASessions is a command that returns sra sessions of the given user
type ListSRASessions struct {
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// session resource type. In case it is empty, all resources type will be returned. options: [mysql, k8s, ssh, mongodb, mssql, postgres, aws, eks, gke, rdp]
	ResourceType *[]string `json:"resource-type,omitempty"`
	// session status type. In case it is empty, only active sessions will be returned. options: [connecting, connected, failed, completed, terminated]
	StatusType *[]string `json:"status-type,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewListSRASessions instantiates a new ListSRASessions object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewListSRASessions() *ListSRASessions {
	this := ListSRASessions{}
	var json bool = false
	this.Json = &json
	return &this
}

// NewListSRASessionsWithDefaults instantiates a new ListSRASessions object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewListSRASessionsWithDefaults() *ListSRASessions {
	this := ListSRASessions{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *ListSRASessions) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListSRASessions) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *ListSRASessions) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *ListSRASessions) SetJson(v bool) {
	o.Json = &v
}

// GetResourceType returns the ResourceType field value if set, zero value otherwise.
func (o *ListSRASessions) GetResourceType() []string {
	if o == nil || o.ResourceType == nil {
		var ret []string
		return ret
	}
	return *o.ResourceType
}

// GetResourceTypeOk returns a tuple with the ResourceType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListSRASessions) GetResourceTypeOk() (*[]string, bool) {
	if o == nil || o.ResourceType == nil {
		return nil, false
	}
	return o.ResourceType, true
}

// HasResourceType returns a boolean if a field has been set.
func (o *ListSRASessions) HasResourceType() bool {
	if o != nil && o.ResourceType != nil {
		return true
	}

	return false
}

// SetResourceType gets a reference to the given []string and assigns it to the ResourceType field.
func (o *ListSRASessions) SetResourceType(v []string) {
	o.ResourceType = &v
}

// GetStatusType returns the StatusType field value if set, zero value otherwise.
func (o *ListSRASessions) GetStatusType() []string {
	if o == nil || o.StatusType == nil {
		var ret []string
		return ret
	}
	return *o.StatusType
}

// GetStatusTypeOk returns a tuple with the StatusType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListSRASessions) GetStatusTypeOk() (*[]string, bool) {
	if o == nil || o.StatusType == nil {
		return nil, false
	}
	return o.StatusType, true
}

// HasStatusType returns a boolean if a field has been set.
func (o *ListSRASessions) HasStatusType() bool {
	if o != nil && o.StatusType != nil {
		return true
	}

	return false
}

// SetStatusType gets a reference to the given []string and assigns it to the StatusType field.
func (o *ListSRASessions) SetStatusType(v []string) {
	o.StatusType = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *ListSRASessions) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListSRASessions) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *ListSRASessions) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *ListSRASessions) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *ListSRASessions) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListSRASessions) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *ListSRASessions) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *ListSRASessions) SetUidToken(v string) {
	o.UidToken = &v
}

func (o ListSRASessions) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.ResourceType != nil {
		toSerialize["resource-type"] = o.ResourceType
	}
	if o.StatusType != nil {
		toSerialize["status-type"] = o.StatusType
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableListSRASessions struct {
	value *ListSRASessions
	isSet bool
}

func (v NullableListSRASessions) Get() *ListSRASessions {
	return v.value
}

func (v *NullableListSRASessions) Set(val *ListSRASessions) {
	v.value = val
	v.isSet = true
}

func (v NullableListSRASessions) IsSet() bool {
	return v.isSet
}

func (v *NullableListSRASessions) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableListSRASessions(val *ListSRASessions) *NullableListSRASessions {
	return &NullableListSRASessions{value: val, isSet: true}
}

func (v NullableListSRASessions) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableListSRASessions) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


