/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// KmipCreateClient struct for KmipCreateClient
type KmipCreateClient struct {
	// If set to 'true', newly created keys on the client will be set to an 'active' state
	ActivateKeysOnCreation *string `json:"activate-keys-on-creation,omitempty"`
	// Client certificate TTL in days
	CertificateTtl *int64 `json:"certificate-ttl,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Client name
	Name string `json:"name"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewKmipCreateClient instantiates a new KmipCreateClient object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewKmipCreateClient(name string, ) *KmipCreateClient {
	this := KmipCreateClient{}
	var activateKeysOnCreation string = "false"
	this.ActivateKeysOnCreation = &activateKeysOnCreation
	var certificateTtl int64 = 90
	this.CertificateTtl = &certificateTtl
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewKmipCreateClientWithDefaults instantiates a new KmipCreateClient object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewKmipCreateClientWithDefaults() *KmipCreateClient {
	this := KmipCreateClient{}
	var activateKeysOnCreation string = "false"
	this.ActivateKeysOnCreation = &activateKeysOnCreation
	var certificateTtl int64 = 90
	this.CertificateTtl = &certificateTtl
	var json bool = false
	this.Json = &json
	return &this
}

// GetActivateKeysOnCreation returns the ActivateKeysOnCreation field value if set, zero value otherwise.
func (o *KmipCreateClient) GetActivateKeysOnCreation() string {
	if o == nil || o.ActivateKeysOnCreation == nil {
		var ret string
		return ret
	}
	return *o.ActivateKeysOnCreation
}

// GetActivateKeysOnCreationOk returns a tuple with the ActivateKeysOnCreation field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipCreateClient) GetActivateKeysOnCreationOk() (*string, bool) {
	if o == nil || o.ActivateKeysOnCreation == nil {
		return nil, false
	}
	return o.ActivateKeysOnCreation, true
}

// HasActivateKeysOnCreation returns a boolean if a field has been set.
func (o *KmipCreateClient) HasActivateKeysOnCreation() bool {
	if o != nil && o.ActivateKeysOnCreation != nil {
		return true
	}

	return false
}

// SetActivateKeysOnCreation gets a reference to the given string and assigns it to the ActivateKeysOnCreation field.
func (o *KmipCreateClient) SetActivateKeysOnCreation(v string) {
	o.ActivateKeysOnCreation = &v
}

// GetCertificateTtl returns the CertificateTtl field value if set, zero value otherwise.
func (o *KmipCreateClient) GetCertificateTtl() int64 {
	if o == nil || o.CertificateTtl == nil {
		var ret int64
		return ret
	}
	return *o.CertificateTtl
}

// GetCertificateTtlOk returns a tuple with the CertificateTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipCreateClient) GetCertificateTtlOk() (*int64, bool) {
	if o == nil || o.CertificateTtl == nil {
		return nil, false
	}
	return o.CertificateTtl, true
}

// HasCertificateTtl returns a boolean if a field has been set.
func (o *KmipCreateClient) HasCertificateTtl() bool {
	if o != nil && o.CertificateTtl != nil {
		return true
	}

	return false
}

// SetCertificateTtl gets a reference to the given int64 and assigns it to the CertificateTtl field.
func (o *KmipCreateClient) SetCertificateTtl(v int64) {
	o.CertificateTtl = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *KmipCreateClient) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipCreateClient) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *KmipCreateClient) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *KmipCreateClient) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *KmipCreateClient) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *KmipCreateClient) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *KmipCreateClient) SetName(v string) {
	o.Name = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *KmipCreateClient) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipCreateClient) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *KmipCreateClient) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *KmipCreateClient) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *KmipCreateClient) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipCreateClient) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *KmipCreateClient) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *KmipCreateClient) SetUidToken(v string) {
	o.UidToken = &v
}

func (o KmipCreateClient) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.ActivateKeysOnCreation != nil {
		toSerialize["activate-keys-on-creation"] = o.ActivateKeysOnCreation
	}
	if o.CertificateTtl != nil {
		toSerialize["certificate-ttl"] = o.CertificateTtl
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableKmipCreateClient struct {
	value *KmipCreateClient
	isSet bool
}

func (v NullableKmipCreateClient) Get() *KmipCreateClient {
	return v.value
}

func (v *NullableKmipCreateClient) Set(val *KmipCreateClient) {
	v.value = val
	v.isSet = true
}

func (v NullableKmipCreateClient) IsSet() bool {
	return v.isSet
}

func (v *NullableKmipCreateClient) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableKmipCreateClient(val *KmipCreateClient) *NullableKmipCreateClient {
	return &NullableKmipCreateClient{value: val, isSet: true}
}

func (v NullableKmipCreateClient) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableKmipCreateClient) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


