/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GetTarget getTarget is a command that returns target. [Deprecated: Use target-get command]
type GetTarget struct {
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Target name
	Name string `json:"name"`
	// Include all target versions in reply
	ShowVersions *bool `json:"show-versions,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewGetTarget instantiates a new GetTarget object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGetTarget(name string, ) *GetTarget {
	this := GetTarget{}
	var json bool = false
	this.Json = &json
	this.Name = name
	var showVersions bool = false
	this.ShowVersions = &showVersions
	return &this
}

// NewGetTargetWithDefaults instantiates a new GetTarget object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGetTargetWithDefaults() *GetTarget {
	this := GetTarget{}
	var json bool = false
	this.Json = &json
	var showVersions bool = false
	this.ShowVersions = &showVersions
	return &this
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GetTarget) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetTarget) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GetTarget) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GetTarget) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *GetTarget) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *GetTarget) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *GetTarget) SetName(v string) {
	o.Name = v
}

// GetShowVersions returns the ShowVersions field value if set, zero value otherwise.
func (o *GetTarget) GetShowVersions() bool {
	if o == nil || o.ShowVersions == nil {
		var ret bool
		return ret
	}
	return *o.ShowVersions
}

// GetShowVersionsOk returns a tuple with the ShowVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetTarget) GetShowVersionsOk() (*bool, bool) {
	if o == nil || o.ShowVersions == nil {
		return nil, false
	}
	return o.ShowVersions, true
}

// HasShowVersions returns a boolean if a field has been set.
func (o *GetTarget) HasShowVersions() bool {
	if o != nil && o.ShowVersions != nil {
		return true
	}

	return false
}

// SetShowVersions gets a reference to the given bool and assigns it to the ShowVersions field.
func (o *GetTarget) SetShowVersions(v bool) {
	o.ShowVersions = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GetTarget) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetTarget) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GetTarget) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GetTarget) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GetTarget) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetTarget) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GetTarget) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GetTarget) SetUidToken(v string) {
	o.UidToken = &v
}

func (o GetTarget) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.ShowVersions != nil {
		toSerialize["show-versions"] = o.ShowVersions
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableGetTarget struct {
	value *GetTarget
	isSet bool
}

func (v NullableGetTarget) Get() *GetTarget {
	return v.value
}

func (v *NullableGetTarget) Set(val *GetTarget) {
	v.value = val
	v.isSet = true
}

func (v NullableGetTarget) IsSet() bool {
	return v.isSet
}

func (v *NullableGetTarget) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGetTarget(val *GetTarget) *NullableGetTarget {
	return &NullableGetTarget{value: val, isSet: true}
}

func (v NullableGetTarget) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGetTarget) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


